/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.base;

import jakarta.ws.rs.core.MultivaluedMap;
import lombok.Generated;

public class Pagination {
    int page = 1;
    int perPage = 10;
    Integer numPages;
    Integer numTotalItems;
    boolean hasNext;
    boolean hasPrevious;

    public static Pagination fromMap(MultivaluedMap<String, String> map) {
        Pagination p = new Pagination();
        p.setPage(map);
        p.setPerPage(map);
        return p;
    }

    public void setPage(MultivaluedMap<String, String> map) {
        String p = (String)map.getFirst((Object)"page");
        try {
            this.page = Integer.parseUnsignedInt(p);
        }
        catch (Exception e) {
            this.page = 1;
        }
    }

    public void setPerPage(MultivaluedMap<String, String> map) {
        String pp = (String)map.getFirst((Object)"perPage");
        try {
            this.perPage = Integer.parseUnsignedInt(pp);
        }
        catch (Exception e) {
            this.perPage = 10;
        }
    }

    public void calculateFields() {
        boolean bl = this.hasPrevious = this.page > 1;
        if (this.numTotalItems != null) {
            this.numPages = this.numTotalItems / this.perPage;
            if (this.numTotalItems == 0 || this.numTotalItems % this.perPage != 0) {
                this.numPages = this.numPages + 1;
            }
            this.hasNext = this.page != this.numPages;
        }
    }

    @Generated
    public Pagination() {
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public int getPerPage() {
        return this.perPage;
    }

    @Generated
    public Integer getNumPages() {
        return this.numPages;
    }

    @Generated
    public Integer getNumTotalItems() {
        return this.numTotalItems;
    }

    @Generated
    public boolean isHasNext() {
        return this.hasNext;
    }

    @Generated
    public boolean isHasPrevious() {
        return this.hasPrevious;
    }

    @Generated
    public void setNumPages(Integer numPages) {
        this.numPages = numPages;
    }

    @Generated
    public void setNumTotalItems(Integer numTotalItems) {
        this.numTotalItems = numTotalItems;
    }

    @Generated
    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    @Generated
    public void setHasPrevious(boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getPerPage() != other.getPerPage()) {
            return false;
        }
        if (this.isHasNext() != other.isHasNext()) {
            return false;
        }
        if (this.isHasPrevious() != other.isHasPrevious()) {
            return false;
        }
        Integer this$numPages = this.getNumPages();
        Integer other$numPages = other.getNumPages();
        if (this$numPages == null ? other$numPages != null : !((Object)this$numPages).equals(other$numPages)) {
            return false;
        }
        Integer this$numTotalItems = this.getNumTotalItems();
        Integer other$numTotalItems = other.getNumTotalItems();
        return !(this$numTotalItems == null ? other$numTotalItems != null : !((Object)this$numTotalItems).equals(other$numTotalItems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPerPage();
        result = result * 59 + (this.isHasNext() ? 79 : 97);
        result = result * 59 + (this.isHasPrevious() ? 79 : 97);
        Integer $numPages = this.getNumPages();
        result = result * 59 + ($numPages == null ? 43 : ((Object)$numPages).hashCode());
        Integer $numTotalItems = this.getNumTotalItems();
        result = result * 59 + ($numTotalItems == null ? 43 : ((Object)$numTotalItems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Pagination(page=" + this.getPage() + ", perPage=" + this.getPerPage() + ", numPages=" + this.getNumPages() + ", numTotalItems=" + this.getNumTotalItems() + ", hasNext=" + this.isHasNext() + ", hasPrevious=" + this.isHasPrevious() + ")";
    }
}

