/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.dmp.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.damap.base.enums.EAgreement;
import org.damap.base.enums.EComplianceType;
import org.damap.base.enums.EDataKind;
import org.damap.base.enums.EDataQualityType;
import org.damap.base.enums.ESecurityMeasure;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.CostDO;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.ExternalStorageDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.dmp.domain.RepositoryDO;
import org.damap.base.rest.dmp.domain.StorageDO;

@Valid
@JsonIgnoreProperties(ignoreUnknown=true)
public class DmpDO {
    private Long id;
    @Size(max=255)
    private @Size(max=255) String title;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date created;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date modified;
    private String description;
    private ProjectDO project;
    private EDataKind dataKind;
    private EDataKind reusedDataKind;
    private List<ContributorDO> contributors = new ArrayList<ContributorDO>();
    @Size(max=4000)
    private @Size(max=4000) String noDataExplanation;
    @Size(max=4000)
    private @Size(max=4000) String metadata;
    @Size(max=4000)
    private @Size(max=4000) String dataGeneration;
    @Size(max=4000)
    private @Size(max=4000) String structure;
    private List<EDataQualityType> dataQuality = new ArrayList<EDataQualityType>();
    @Size(max=4000)
    private @Size(max=4000) String otherDataQuality;
    @Size(max=4000)
    private @Size(max=4000) String targetAudience;
    @Size(max=4000)
    private @Size(max=4000) String tools;
    @Size(max=4000)
    private @Size(max=4000) String restrictedDataAccess;
    private Boolean personalData;
    private Boolean personalDataCris;
    private List<EComplianceType> personalDataCompliance = new ArrayList<EComplianceType>();
    @Size(max=4000)
    private @Size(max=4000) String otherPersonalDataCompliance;
    private Boolean sensitiveData;
    private Boolean sensitiveDataCris;
    private List<ESecurityMeasure> sensitiveDataSecurity = new ArrayList<ESecurityMeasure>();
    @Size(max=4000)
    private @Size(max=4000) String otherDataSecurityMeasures;
    @Size(max=4000)
    private @Size(max=4000) String sensitiveDataAccess;
    private Boolean legalRestrictions;
    private Boolean legalRestrictionsCris;
    private List<EAgreement> legalRestrictionsDocuments = new ArrayList<EAgreement>();
    @Size(max=4000)
    private @Size(max=4000) String otherLegalRestrictionsDocument;
    @Size(max=4000)
    private @Size(max=4000) String legalRestrictionsComment;
    @Size(max=4000)
    private @Size(max=4000) String dataRightsAndAccessControl;
    private Boolean humanParticipants;
    private Boolean humanParticipantsCris;
    private Boolean ethicalIssuesExist;
    private Boolean ethicalIssuesExistCris;
    private Boolean committeeReviewed;
    private Boolean committeeReviewedCris;
    @Size(max=255)
    private @Size(max=255) String ethicalIssuesReport;
    private List<DatasetDO> datasets = new ArrayList<DatasetDO>();
    private List<RepositoryDO> repositories = new ArrayList<RepositoryDO>();
    private List<StorageDO> storage = new ArrayList<StorageDO>();
    private List<ExternalStorageDO> externalStorage = new ArrayList<ExternalStorageDO>();
    @Size(max=4000)
    private @Size(max=4000) String externalStorageInfo;
    @Size(max=4000)
    private @Size(max=4000) String restrictedAccessInfo;
    @Size(max=4000)
    private @Size(max=4000) String closedAccessInfo;
    private Boolean costsExist;
    private Boolean costsExistCris;
    private List<CostDO> costs = new ArrayList<CostDO>();
    @Size(max=4000)
    private @Size(max=4000) String documentation;

    public ContributorDO getContact() {
        Optional<ContributorDO> contact = this.contributors.stream().filter(ContributorDO::isContact).findFirst();
        return contact.orElse(null);
    }

    @Generated
    public DmpDO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getModified() {
        return this.modified;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ProjectDO getProject() {
        return this.project;
    }

    @Generated
    public EDataKind getDataKind() {
        return this.dataKind;
    }

    @Generated
    public EDataKind getReusedDataKind() {
        return this.reusedDataKind;
    }

    @Generated
    public List<ContributorDO> getContributors() {
        return this.contributors;
    }

    @Generated
    public String getNoDataExplanation() {
        return this.noDataExplanation;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getDataGeneration() {
        return this.dataGeneration;
    }

    @Generated
    public String getStructure() {
        return this.structure;
    }

    @Generated
    public List<EDataQualityType> getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public String getOtherDataQuality() {
        return this.otherDataQuality;
    }

    @Generated
    public String getTargetAudience() {
        return this.targetAudience;
    }

    @Generated
    public String getTools() {
        return this.tools;
    }

    @Generated
    public String getRestrictedDataAccess() {
        return this.restrictedDataAccess;
    }

    @Generated
    public Boolean getPersonalData() {
        return this.personalData;
    }

    @Generated
    public Boolean getPersonalDataCris() {
        return this.personalDataCris;
    }

    @Generated
    public List<EComplianceType> getPersonalDataCompliance() {
        return this.personalDataCompliance;
    }

    @Generated
    public String getOtherPersonalDataCompliance() {
        return this.otherPersonalDataCompliance;
    }

    @Generated
    public Boolean getSensitiveData() {
        return this.sensitiveData;
    }

    @Generated
    public Boolean getSensitiveDataCris() {
        return this.sensitiveDataCris;
    }

    @Generated
    public List<ESecurityMeasure> getSensitiveDataSecurity() {
        return this.sensitiveDataSecurity;
    }

    @Generated
    public String getOtherDataSecurityMeasures() {
        return this.otherDataSecurityMeasures;
    }

    @Generated
    public String getSensitiveDataAccess() {
        return this.sensitiveDataAccess;
    }

    @Generated
    public Boolean getLegalRestrictions() {
        return this.legalRestrictions;
    }

    @Generated
    public Boolean getLegalRestrictionsCris() {
        return this.legalRestrictionsCris;
    }

    @Generated
    public List<EAgreement> getLegalRestrictionsDocuments() {
        return this.legalRestrictionsDocuments;
    }

    @Generated
    public String getOtherLegalRestrictionsDocument() {
        return this.otherLegalRestrictionsDocument;
    }

    @Generated
    public String getLegalRestrictionsComment() {
        return this.legalRestrictionsComment;
    }

    @Generated
    public String getDataRightsAndAccessControl() {
        return this.dataRightsAndAccessControl;
    }

    @Generated
    public Boolean getHumanParticipants() {
        return this.humanParticipants;
    }

    @Generated
    public Boolean getHumanParticipantsCris() {
        return this.humanParticipantsCris;
    }

    @Generated
    public Boolean getEthicalIssuesExist() {
        return this.ethicalIssuesExist;
    }

    @Generated
    public Boolean getEthicalIssuesExistCris() {
        return this.ethicalIssuesExistCris;
    }

    @Generated
    public Boolean getCommitteeReviewed() {
        return this.committeeReviewed;
    }

    @Generated
    public Boolean getCommitteeReviewedCris() {
        return this.committeeReviewedCris;
    }

    @Generated
    public String getEthicalIssuesReport() {
        return this.ethicalIssuesReport;
    }

    @Generated
    public List<DatasetDO> getDatasets() {
        return this.datasets;
    }

    @Generated
    public List<RepositoryDO> getRepositories() {
        return this.repositories;
    }

    @Generated
    public List<StorageDO> getStorage() {
        return this.storage;
    }

    @Generated
    public List<ExternalStorageDO> getExternalStorage() {
        return this.externalStorage;
    }

    @Generated
    public String getExternalStorageInfo() {
        return this.externalStorageInfo;
    }

    @Generated
    public String getRestrictedAccessInfo() {
        return this.restrictedAccessInfo;
    }

    @Generated
    public String getClosedAccessInfo() {
        return this.closedAccessInfo;
    }

    @Generated
    public Boolean getCostsExist() {
        return this.costsExist;
    }

    @Generated
    public Boolean getCostsExistCris() {
        return this.costsExistCris;
    }

    @Generated
    public List<CostDO> getCosts() {
        return this.costs;
    }

    @Generated
    public String getDocumentation() {
        return this.documentation;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Generated
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProject(ProjectDO project) {
        this.project = project;
    }

    @Generated
    public void setDataKind(EDataKind dataKind) {
        this.dataKind = dataKind;
    }

    @Generated
    public void setReusedDataKind(EDataKind reusedDataKind) {
        this.reusedDataKind = reusedDataKind;
    }

    @Generated
    public void setContributors(List<ContributorDO> contributors) {
        this.contributors = contributors;
    }

    @Generated
    public void setNoDataExplanation(String noDataExplanation) {
        this.noDataExplanation = noDataExplanation;
    }

    @Generated
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setDataGeneration(String dataGeneration) {
        this.dataGeneration = dataGeneration;
    }

    @Generated
    public void setStructure(String structure) {
        this.structure = structure;
    }

    @Generated
    public void setDataQuality(List<EDataQualityType> dataQuality) {
        this.dataQuality = dataQuality;
    }

    @Generated
    public void setOtherDataQuality(String otherDataQuality) {
        this.otherDataQuality = otherDataQuality;
    }

    @Generated
    public void setTargetAudience(String targetAudience) {
        this.targetAudience = targetAudience;
    }

    @Generated
    public void setTools(String tools) {
        this.tools = tools;
    }

    @Generated
    public void setRestrictedDataAccess(String restrictedDataAccess) {
        this.restrictedDataAccess = restrictedDataAccess;
    }

    @Generated
    public void setPersonalData(Boolean personalData) {
        this.personalData = personalData;
    }

    @Generated
    public void setPersonalDataCris(Boolean personalDataCris) {
        this.personalDataCris = personalDataCris;
    }

    @Generated
    public void setPersonalDataCompliance(List<EComplianceType> personalDataCompliance) {
        this.personalDataCompliance = personalDataCompliance;
    }

    @Generated
    public void setOtherPersonalDataCompliance(String otherPersonalDataCompliance) {
        this.otherPersonalDataCompliance = otherPersonalDataCompliance;
    }

    @Generated
    public void setSensitiveData(Boolean sensitiveData) {
        this.sensitiveData = sensitiveData;
    }

    @Generated
    public void setSensitiveDataCris(Boolean sensitiveDataCris) {
        this.sensitiveDataCris = sensitiveDataCris;
    }

    @Generated
    public void setSensitiveDataSecurity(List<ESecurityMeasure> sensitiveDataSecurity) {
        this.sensitiveDataSecurity = sensitiveDataSecurity;
    }

    @Generated
    public void setOtherDataSecurityMeasures(String otherDataSecurityMeasures) {
        this.otherDataSecurityMeasures = otherDataSecurityMeasures;
    }

    @Generated
    public void setSensitiveDataAccess(String sensitiveDataAccess) {
        this.sensitiveDataAccess = sensitiveDataAccess;
    }

    @Generated
    public void setLegalRestrictions(Boolean legalRestrictions) {
        this.legalRestrictions = legalRestrictions;
    }

    @Generated
    public void setLegalRestrictionsCris(Boolean legalRestrictionsCris) {
        this.legalRestrictionsCris = legalRestrictionsCris;
    }

    @Generated
    public void setLegalRestrictionsDocuments(List<EAgreement> legalRestrictionsDocuments) {
        this.legalRestrictionsDocuments = legalRestrictionsDocuments;
    }

    @Generated
    public void setOtherLegalRestrictionsDocument(String otherLegalRestrictionsDocument) {
        this.otherLegalRestrictionsDocument = otherLegalRestrictionsDocument;
    }

    @Generated
    public void setLegalRestrictionsComment(String legalRestrictionsComment) {
        this.legalRestrictionsComment = legalRestrictionsComment;
    }

    @Generated
    public void setDataRightsAndAccessControl(String dataRightsAndAccessControl) {
        this.dataRightsAndAccessControl = dataRightsAndAccessControl;
    }

    @Generated
    public void setHumanParticipants(Boolean humanParticipants) {
        this.humanParticipants = humanParticipants;
    }

    @Generated
    public void setHumanParticipantsCris(Boolean humanParticipantsCris) {
        this.humanParticipantsCris = humanParticipantsCris;
    }

    @Generated
    public void setEthicalIssuesExist(Boolean ethicalIssuesExist) {
        this.ethicalIssuesExist = ethicalIssuesExist;
    }

    @Generated
    public void setEthicalIssuesExistCris(Boolean ethicalIssuesExistCris) {
        this.ethicalIssuesExistCris = ethicalIssuesExistCris;
    }

    @Generated
    public void setCommitteeReviewed(Boolean committeeReviewed) {
        this.committeeReviewed = committeeReviewed;
    }

    @Generated
    public void setCommitteeReviewedCris(Boolean committeeReviewedCris) {
        this.committeeReviewedCris = committeeReviewedCris;
    }

    @Generated
    public void setEthicalIssuesReport(String ethicalIssuesReport) {
        this.ethicalIssuesReport = ethicalIssuesReport;
    }

    @Generated
    public void setDatasets(List<DatasetDO> datasets) {
        this.datasets = datasets;
    }

    @Generated
    public void setRepositories(List<RepositoryDO> repositories) {
        this.repositories = repositories;
    }

    @Generated
    public void setStorage(List<StorageDO> storage) {
        this.storage = storage;
    }

    @Generated
    public void setExternalStorage(List<ExternalStorageDO> externalStorage) {
        this.externalStorage = externalStorage;
    }

    @Generated
    public void setExternalStorageInfo(String externalStorageInfo) {
        this.externalStorageInfo = externalStorageInfo;
    }

    @Generated
    public void setRestrictedAccessInfo(String restrictedAccessInfo) {
        this.restrictedAccessInfo = restrictedAccessInfo;
    }

    @Generated
    public void setClosedAccessInfo(String closedAccessInfo) {
        this.closedAccessInfo = closedAccessInfo;
    }

    @Generated
    public void setCostsExist(Boolean costsExist) {
        this.costsExist = costsExist;
    }

    @Generated
    public void setCostsExistCris(Boolean costsExistCris) {
        this.costsExistCris = costsExistCris;
    }

    @Generated
    public void setCosts(List<CostDO> costs) {
        this.costs = costs;
    }

    @Generated
    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DmpDO)) {
            return false;
        }
        DmpDO other = (DmpDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$personalData = this.getPersonalData();
        Boolean other$personalData = other.getPersonalData();
        if (this$personalData == null ? other$personalData != null : !((Object)this$personalData).equals(other$personalData)) {
            return false;
        }
        Boolean this$personalDataCris = this.getPersonalDataCris();
        Boolean other$personalDataCris = other.getPersonalDataCris();
        if (this$personalDataCris == null ? other$personalDataCris != null : !((Object)this$personalDataCris).equals(other$personalDataCris)) {
            return false;
        }
        Boolean this$sensitiveData = this.getSensitiveData();
        Boolean other$sensitiveData = other.getSensitiveData();
        if (this$sensitiveData == null ? other$sensitiveData != null : !((Object)this$sensitiveData).equals(other$sensitiveData)) {
            return false;
        }
        Boolean this$sensitiveDataCris = this.getSensitiveDataCris();
        Boolean other$sensitiveDataCris = other.getSensitiveDataCris();
        if (this$sensitiveDataCris == null ? other$sensitiveDataCris != null : !((Object)this$sensitiveDataCris).equals(other$sensitiveDataCris)) {
            return false;
        }
        Boolean this$legalRestrictions = this.getLegalRestrictions();
        Boolean other$legalRestrictions = other.getLegalRestrictions();
        if (this$legalRestrictions == null ? other$legalRestrictions != null : !((Object)this$legalRestrictions).equals(other$legalRestrictions)) {
            return false;
        }
        Boolean this$legalRestrictionsCris = this.getLegalRestrictionsCris();
        Boolean other$legalRestrictionsCris = other.getLegalRestrictionsCris();
        if (this$legalRestrictionsCris == null ? other$legalRestrictionsCris != null : !((Object)this$legalRestrictionsCris).equals(other$legalRestrictionsCris)) {
            return false;
        }
        Boolean this$humanParticipants = this.getHumanParticipants();
        Boolean other$humanParticipants = other.getHumanParticipants();
        if (this$humanParticipants == null ? other$humanParticipants != null : !((Object)this$humanParticipants).equals(other$humanParticipants)) {
            return false;
        }
        Boolean this$humanParticipantsCris = this.getHumanParticipantsCris();
        Boolean other$humanParticipantsCris = other.getHumanParticipantsCris();
        if (this$humanParticipantsCris == null ? other$humanParticipantsCris != null : !((Object)this$humanParticipantsCris).equals(other$humanParticipantsCris)) {
            return false;
        }
        Boolean this$ethicalIssuesExist = this.getEthicalIssuesExist();
        Boolean other$ethicalIssuesExist = other.getEthicalIssuesExist();
        if (this$ethicalIssuesExist == null ? other$ethicalIssuesExist != null : !((Object)this$ethicalIssuesExist).equals(other$ethicalIssuesExist)) {
            return false;
        }
        Boolean this$ethicalIssuesExistCris = this.getEthicalIssuesExistCris();
        Boolean other$ethicalIssuesExistCris = other.getEthicalIssuesExistCris();
        if (this$ethicalIssuesExistCris == null ? other$ethicalIssuesExistCris != null : !((Object)this$ethicalIssuesExistCris).equals(other$ethicalIssuesExistCris)) {
            return false;
        }
        Boolean this$committeeReviewed = this.getCommitteeReviewed();
        Boolean other$committeeReviewed = other.getCommitteeReviewed();
        if (this$committeeReviewed == null ? other$committeeReviewed != null : !((Object)this$committeeReviewed).equals(other$committeeReviewed)) {
            return false;
        }
        Boolean this$committeeReviewedCris = this.getCommitteeReviewedCris();
        Boolean other$committeeReviewedCris = other.getCommitteeReviewedCris();
        if (this$committeeReviewedCris == null ? other$committeeReviewedCris != null : !((Object)this$committeeReviewedCris).equals(other$committeeReviewedCris)) {
            return false;
        }
        Boolean this$costsExist = this.getCostsExist();
        Boolean other$costsExist = other.getCostsExist();
        if (this$costsExist == null ? other$costsExist != null : !((Object)this$costsExist).equals(other$costsExist)) {
            return false;
        }
        Boolean this$costsExistCris = this.getCostsExistCris();
        Boolean other$costsExistCris = other.getCostsExistCris();
        if (this$costsExistCris == null ? other$costsExistCris != null : !((Object)this$costsExistCris).equals(other$costsExistCris)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Date this$modified = this.getModified();
        Date other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ProjectDO this$project = this.getProject();
        ProjectDO other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        EDataKind this$dataKind = this.getDataKind();
        EDataKind other$dataKind = other.getDataKind();
        if (this$dataKind == null ? other$dataKind != null : !((Object)((Object)this$dataKind)).equals((Object)other$dataKind)) {
            return false;
        }
        EDataKind this$reusedDataKind = this.getReusedDataKind();
        EDataKind other$reusedDataKind = other.getReusedDataKind();
        if (this$reusedDataKind == null ? other$reusedDataKind != null : !((Object)((Object)this$reusedDataKind)).equals((Object)other$reusedDataKind)) {
            return false;
        }
        List<ContributorDO> this$contributors = this.getContributors();
        List<ContributorDO> other$contributors = other.getContributors();
        if (this$contributors == null ? other$contributors != null : !((Object)this$contributors).equals(other$contributors)) {
            return false;
        }
        String this$noDataExplanation = this.getNoDataExplanation();
        String other$noDataExplanation = other.getNoDataExplanation();
        if (this$noDataExplanation == null ? other$noDataExplanation != null : !this$noDataExplanation.equals(other$noDataExplanation)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$dataGeneration = this.getDataGeneration();
        String other$dataGeneration = other.getDataGeneration();
        if (this$dataGeneration == null ? other$dataGeneration != null : !this$dataGeneration.equals(other$dataGeneration)) {
            return false;
        }
        String this$structure = this.getStructure();
        String other$structure = other.getStructure();
        if (this$structure == null ? other$structure != null : !this$structure.equals(other$structure)) {
            return false;
        }
        List<EDataQualityType> this$dataQuality = this.getDataQuality();
        List<EDataQualityType> other$dataQuality = other.getDataQuality();
        if (this$dataQuality == null ? other$dataQuality != null : !((Object)this$dataQuality).equals(other$dataQuality)) {
            return false;
        }
        String this$otherDataQuality = this.getOtherDataQuality();
        String other$otherDataQuality = other.getOtherDataQuality();
        if (this$otherDataQuality == null ? other$otherDataQuality != null : !this$otherDataQuality.equals(other$otherDataQuality)) {
            return false;
        }
        String this$targetAudience = this.getTargetAudience();
        String other$targetAudience = other.getTargetAudience();
        if (this$targetAudience == null ? other$targetAudience != null : !this$targetAudience.equals(other$targetAudience)) {
            return false;
        }
        String this$tools = this.getTools();
        String other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !this$tools.equals(other$tools)) {
            return false;
        }
        String this$restrictedDataAccess = this.getRestrictedDataAccess();
        String other$restrictedDataAccess = other.getRestrictedDataAccess();
        if (this$restrictedDataAccess == null ? other$restrictedDataAccess != null : !this$restrictedDataAccess.equals(other$restrictedDataAccess)) {
            return false;
        }
        List<EComplianceType> this$personalDataCompliance = this.getPersonalDataCompliance();
        List<EComplianceType> other$personalDataCompliance = other.getPersonalDataCompliance();
        if (this$personalDataCompliance == null ? other$personalDataCompliance != null : !((Object)this$personalDataCompliance).equals(other$personalDataCompliance)) {
            return false;
        }
        String this$otherPersonalDataCompliance = this.getOtherPersonalDataCompliance();
        String other$otherPersonalDataCompliance = other.getOtherPersonalDataCompliance();
        if (this$otherPersonalDataCompliance == null ? other$otherPersonalDataCompliance != null : !this$otherPersonalDataCompliance.equals(other$otherPersonalDataCompliance)) {
            return false;
        }
        List<ESecurityMeasure> this$sensitiveDataSecurity = this.getSensitiveDataSecurity();
        List<ESecurityMeasure> other$sensitiveDataSecurity = other.getSensitiveDataSecurity();
        if (this$sensitiveDataSecurity == null ? other$sensitiveDataSecurity != null : !((Object)this$sensitiveDataSecurity).equals(other$sensitiveDataSecurity)) {
            return false;
        }
        String this$otherDataSecurityMeasures = this.getOtherDataSecurityMeasures();
        String other$otherDataSecurityMeasures = other.getOtherDataSecurityMeasures();
        if (this$otherDataSecurityMeasures == null ? other$otherDataSecurityMeasures != null : !this$otherDataSecurityMeasures.equals(other$otherDataSecurityMeasures)) {
            return false;
        }
        String this$sensitiveDataAccess = this.getSensitiveDataAccess();
        String other$sensitiveDataAccess = other.getSensitiveDataAccess();
        if (this$sensitiveDataAccess == null ? other$sensitiveDataAccess != null : !this$sensitiveDataAccess.equals(other$sensitiveDataAccess)) {
            return false;
        }
        List<EAgreement> this$legalRestrictionsDocuments = this.getLegalRestrictionsDocuments();
        List<EAgreement> other$legalRestrictionsDocuments = other.getLegalRestrictionsDocuments();
        if (this$legalRestrictionsDocuments == null ? other$legalRestrictionsDocuments != null : !((Object)this$legalRestrictionsDocuments).equals(other$legalRestrictionsDocuments)) {
            return false;
        }
        String this$otherLegalRestrictionsDocument = this.getOtherLegalRestrictionsDocument();
        String other$otherLegalRestrictionsDocument = other.getOtherLegalRestrictionsDocument();
        if (this$otherLegalRestrictionsDocument == null ? other$otherLegalRestrictionsDocument != null : !this$otherLegalRestrictionsDocument.equals(other$otherLegalRestrictionsDocument)) {
            return false;
        }
        String this$legalRestrictionsComment = this.getLegalRestrictionsComment();
        String other$legalRestrictionsComment = other.getLegalRestrictionsComment();
        if (this$legalRestrictionsComment == null ? other$legalRestrictionsComment != null : !this$legalRestrictionsComment.equals(other$legalRestrictionsComment)) {
            return false;
        }
        String this$dataRightsAndAccessControl = this.getDataRightsAndAccessControl();
        String other$dataRightsAndAccessControl = other.getDataRightsAndAccessControl();
        if (this$dataRightsAndAccessControl == null ? other$dataRightsAndAccessControl != null : !this$dataRightsAndAccessControl.equals(other$dataRightsAndAccessControl)) {
            return false;
        }
        String this$ethicalIssuesReport = this.getEthicalIssuesReport();
        String other$ethicalIssuesReport = other.getEthicalIssuesReport();
        if (this$ethicalIssuesReport == null ? other$ethicalIssuesReport != null : !this$ethicalIssuesReport.equals(other$ethicalIssuesReport)) {
            return false;
        }
        List<DatasetDO> this$datasets = this.getDatasets();
        List<DatasetDO> other$datasets = other.getDatasets();
        if (this$datasets == null ? other$datasets != null : !((Object)this$datasets).equals(other$datasets)) {
            return false;
        }
        List<RepositoryDO> this$repositories = this.getRepositories();
        List<RepositoryDO> other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !((Object)this$repositories).equals(other$repositories)) {
            return false;
        }
        List<StorageDO> this$storage = this.getStorage();
        List<StorageDO> other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        List<ExternalStorageDO> this$externalStorage = this.getExternalStorage();
        List<ExternalStorageDO> other$externalStorage = other.getExternalStorage();
        if (this$externalStorage == null ? other$externalStorage != null : !((Object)this$externalStorage).equals(other$externalStorage)) {
            return false;
        }
        String this$externalStorageInfo = this.getExternalStorageInfo();
        String other$externalStorageInfo = other.getExternalStorageInfo();
        if (this$externalStorageInfo == null ? other$externalStorageInfo != null : !this$externalStorageInfo.equals(other$externalStorageInfo)) {
            return false;
        }
        String this$restrictedAccessInfo = this.getRestrictedAccessInfo();
        String other$restrictedAccessInfo = other.getRestrictedAccessInfo();
        if (this$restrictedAccessInfo == null ? other$restrictedAccessInfo != null : !this$restrictedAccessInfo.equals(other$restrictedAccessInfo)) {
            return false;
        }
        String this$closedAccessInfo = this.getClosedAccessInfo();
        String other$closedAccessInfo = other.getClosedAccessInfo();
        if (this$closedAccessInfo == null ? other$closedAccessInfo != null : !this$closedAccessInfo.equals(other$closedAccessInfo)) {
            return false;
        }
        List<CostDO> this$costs = this.getCosts();
        List<CostDO> other$costs = other.getCosts();
        if (this$costs == null ? other$costs != null : !((Object)this$costs).equals(other$costs)) {
            return false;
        }
        String this$documentation = this.getDocumentation();
        String other$documentation = other.getDocumentation();
        return !(this$documentation == null ? other$documentation != null : !this$documentation.equals(other$documentation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DmpDO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $personalData = this.getPersonalData();
        result = result * 59 + ($personalData == null ? 43 : ((Object)$personalData).hashCode());
        Boolean $personalDataCris = this.getPersonalDataCris();
        result = result * 59 + ($personalDataCris == null ? 43 : ((Object)$personalDataCris).hashCode());
        Boolean $sensitiveData = this.getSensitiveData();
        result = result * 59 + ($sensitiveData == null ? 43 : ((Object)$sensitiveData).hashCode());
        Boolean $sensitiveDataCris = this.getSensitiveDataCris();
        result = result * 59 + ($sensitiveDataCris == null ? 43 : ((Object)$sensitiveDataCris).hashCode());
        Boolean $legalRestrictions = this.getLegalRestrictions();
        result = result * 59 + ($legalRestrictions == null ? 43 : ((Object)$legalRestrictions).hashCode());
        Boolean $legalRestrictionsCris = this.getLegalRestrictionsCris();
        result = result * 59 + ($legalRestrictionsCris == null ? 43 : ((Object)$legalRestrictionsCris).hashCode());
        Boolean $humanParticipants = this.getHumanParticipants();
        result = result * 59 + ($humanParticipants == null ? 43 : ((Object)$humanParticipants).hashCode());
        Boolean $humanParticipantsCris = this.getHumanParticipantsCris();
        result = result * 59 + ($humanParticipantsCris == null ? 43 : ((Object)$humanParticipantsCris).hashCode());
        Boolean $ethicalIssuesExist = this.getEthicalIssuesExist();
        result = result * 59 + ($ethicalIssuesExist == null ? 43 : ((Object)$ethicalIssuesExist).hashCode());
        Boolean $ethicalIssuesExistCris = this.getEthicalIssuesExistCris();
        result = result * 59 + ($ethicalIssuesExistCris == null ? 43 : ((Object)$ethicalIssuesExistCris).hashCode());
        Boolean $committeeReviewed = this.getCommitteeReviewed();
        result = result * 59 + ($committeeReviewed == null ? 43 : ((Object)$committeeReviewed).hashCode());
        Boolean $committeeReviewedCris = this.getCommitteeReviewedCris();
        result = result * 59 + ($committeeReviewedCris == null ? 43 : ((Object)$committeeReviewedCris).hashCode());
        Boolean $costsExist = this.getCostsExist();
        result = result * 59 + ($costsExist == null ? 43 : ((Object)$costsExist).hashCode());
        Boolean $costsExistCris = this.getCostsExistCris();
        result = result * 59 + ($costsExistCris == null ? 43 : ((Object)$costsExistCris).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Date $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ProjectDO $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        EDataKind $dataKind = this.getDataKind();
        result = result * 59 + ($dataKind == null ? 43 : ((Object)((Object)$dataKind)).hashCode());
        EDataKind $reusedDataKind = this.getReusedDataKind();
        result = result * 59 + ($reusedDataKind == null ? 43 : ((Object)((Object)$reusedDataKind)).hashCode());
        List<ContributorDO> $contributors = this.getContributors();
        result = result * 59 + ($contributors == null ? 43 : ((Object)$contributors).hashCode());
        String $noDataExplanation = this.getNoDataExplanation();
        result = result * 59 + ($noDataExplanation == null ? 43 : $noDataExplanation.hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $dataGeneration = this.getDataGeneration();
        result = result * 59 + ($dataGeneration == null ? 43 : $dataGeneration.hashCode());
        String $structure = this.getStructure();
        result = result * 59 + ($structure == null ? 43 : $structure.hashCode());
        List<EDataQualityType> $dataQuality = this.getDataQuality();
        result = result * 59 + ($dataQuality == null ? 43 : ((Object)$dataQuality).hashCode());
        String $otherDataQuality = this.getOtherDataQuality();
        result = result * 59 + ($otherDataQuality == null ? 43 : $otherDataQuality.hashCode());
        String $targetAudience = this.getTargetAudience();
        result = result * 59 + ($targetAudience == null ? 43 : $targetAudience.hashCode());
        String $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : $tools.hashCode());
        String $restrictedDataAccess = this.getRestrictedDataAccess();
        result = result * 59 + ($restrictedDataAccess == null ? 43 : $restrictedDataAccess.hashCode());
        List<EComplianceType> $personalDataCompliance = this.getPersonalDataCompliance();
        result = result * 59 + ($personalDataCompliance == null ? 43 : ((Object)$personalDataCompliance).hashCode());
        String $otherPersonalDataCompliance = this.getOtherPersonalDataCompliance();
        result = result * 59 + ($otherPersonalDataCompliance == null ? 43 : $otherPersonalDataCompliance.hashCode());
        List<ESecurityMeasure> $sensitiveDataSecurity = this.getSensitiveDataSecurity();
        result = result * 59 + ($sensitiveDataSecurity == null ? 43 : ((Object)$sensitiveDataSecurity).hashCode());
        String $otherDataSecurityMeasures = this.getOtherDataSecurityMeasures();
        result = result * 59 + ($otherDataSecurityMeasures == null ? 43 : $otherDataSecurityMeasures.hashCode());
        String $sensitiveDataAccess = this.getSensitiveDataAccess();
        result = result * 59 + ($sensitiveDataAccess == null ? 43 : $sensitiveDataAccess.hashCode());
        List<EAgreement> $legalRestrictionsDocuments = this.getLegalRestrictionsDocuments();
        result = result * 59 + ($legalRestrictionsDocuments == null ? 43 : ((Object)$legalRestrictionsDocuments).hashCode());
        String $otherLegalRestrictionsDocument = this.getOtherLegalRestrictionsDocument();
        result = result * 59 + ($otherLegalRestrictionsDocument == null ? 43 : $otherLegalRestrictionsDocument.hashCode());
        String $legalRestrictionsComment = this.getLegalRestrictionsComment();
        result = result * 59 + ($legalRestrictionsComment == null ? 43 : $legalRestrictionsComment.hashCode());
        String $dataRightsAndAccessControl = this.getDataRightsAndAccessControl();
        result = result * 59 + ($dataRightsAndAccessControl == null ? 43 : $dataRightsAndAccessControl.hashCode());
        String $ethicalIssuesReport = this.getEthicalIssuesReport();
        result = result * 59 + ($ethicalIssuesReport == null ? 43 : $ethicalIssuesReport.hashCode());
        List<DatasetDO> $datasets = this.getDatasets();
        result = result * 59 + ($datasets == null ? 43 : ((Object)$datasets).hashCode());
        List<RepositoryDO> $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : ((Object)$repositories).hashCode());
        List<StorageDO> $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        List<ExternalStorageDO> $externalStorage = this.getExternalStorage();
        result = result * 59 + ($externalStorage == null ? 43 : ((Object)$externalStorage).hashCode());
        String $externalStorageInfo = this.getExternalStorageInfo();
        result = result * 59 + ($externalStorageInfo == null ? 43 : $externalStorageInfo.hashCode());
        String $restrictedAccessInfo = this.getRestrictedAccessInfo();
        result = result * 59 + ($restrictedAccessInfo == null ? 43 : $restrictedAccessInfo.hashCode());
        String $closedAccessInfo = this.getClosedAccessInfo();
        result = result * 59 + ($closedAccessInfo == null ? 43 : $closedAccessInfo.hashCode());
        List<CostDO> $costs = this.getCosts();
        result = result * 59 + ($costs == null ? 43 : ((Object)$costs).hashCode());
        String $documentation = this.getDocumentation();
        result = result * 59 + ($documentation == null ? 43 : $documentation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DmpDO(id=" + this.getId() + ", title=" + this.getTitle() + ", created=" + String.valueOf(this.getCreated()) + ", modified=" + String.valueOf(this.getModified()) + ", description=" + this.getDescription() + ", project=" + String.valueOf(this.getProject()) + ", dataKind=" + String.valueOf((Object)this.getDataKind()) + ", reusedDataKind=" + String.valueOf((Object)this.getReusedDataKind()) + ", contributors=" + String.valueOf(this.getContributors()) + ", noDataExplanation=" + this.getNoDataExplanation() + ", metadata=" + this.getMetadata() + ", dataGeneration=" + this.getDataGeneration() + ", structure=" + this.getStructure() + ", dataQuality=" + String.valueOf(this.getDataQuality()) + ", otherDataQuality=" + this.getOtherDataQuality() + ", targetAudience=" + this.getTargetAudience() + ", tools=" + this.getTools() + ", restrictedDataAccess=" + this.getRestrictedDataAccess() + ", personalData=" + this.getPersonalData() + ", personalDataCris=" + this.getPersonalDataCris() + ", personalDataCompliance=" + String.valueOf(this.getPersonalDataCompliance()) + ", otherPersonalDataCompliance=" + this.getOtherPersonalDataCompliance() + ", sensitiveData=" + this.getSensitiveData() + ", sensitiveDataCris=" + this.getSensitiveDataCris() + ", sensitiveDataSecurity=" + String.valueOf(this.getSensitiveDataSecurity()) + ", otherDataSecurityMeasures=" + this.getOtherDataSecurityMeasures() + ", sensitiveDataAccess=" + this.getSensitiveDataAccess() + ", legalRestrictions=" + this.getLegalRestrictions() + ", legalRestrictionsCris=" + this.getLegalRestrictionsCris() + ", legalRestrictionsDocuments=" + String.valueOf(this.getLegalRestrictionsDocuments()) + ", otherLegalRestrictionsDocument=" + this.getOtherLegalRestrictionsDocument() + ", legalRestrictionsComment=" + this.getLegalRestrictionsComment() + ", dataRightsAndAccessControl=" + this.getDataRightsAndAccessControl() + ", humanParticipants=" + this.getHumanParticipants() + ", humanParticipantsCris=" + this.getHumanParticipantsCris() + ", ethicalIssuesExist=" + this.getEthicalIssuesExist() + ", ethicalIssuesExistCris=" + this.getEthicalIssuesExistCris() + ", committeeReviewed=" + this.getCommitteeReviewed() + ", committeeReviewedCris=" + this.getCommitteeReviewedCris() + ", ethicalIssuesReport=" + this.getEthicalIssuesReport() + ", datasets=" + String.valueOf(this.getDatasets()) + ", repositories=" + String.valueOf(this.getRepositories()) + ", storage=" + String.valueOf(this.getStorage()) + ", externalStorage=" + String.valueOf(this.getExternalStorage()) + ", externalStorageInfo=" + this.getExternalStorageInfo() + ", restrictedAccessInfo=" + this.getRestrictedAccessInfo() + ", closedAccessInfo=" + this.getClosedAccessInfo() + ", costsExist=" + this.getCostsExist() + ", costsExistCris=" + this.getCostsExistCris() + ", costs=" + String.valueOf(this.getCosts()) + ", documentation=" + this.getDocumentation() + ")";
    }
}

