/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.dmp.service;

import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.Host;
import org.damap.base.domain.InternalStorage;
import org.damap.base.domain.Storage;
import org.damap.base.enums.EAgreement;
import org.damap.base.enums.EComplianceType;
import org.damap.base.enums.EDataAccessType;
import org.damap.base.enums.EDataKind;
import org.damap.base.enums.EDataQualityType;
import org.damap.base.enums.EDataSource;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.enums.ESecurityMeasure;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.ExternalStorageDO;
import org.damap.base.rest.dmp.domain.HostDO;
import org.damap.base.rest.dmp.domain.RepositoryDO;
import org.damap.base.rest.dmp.domain.StorageDO;
import org.damap.base.rest.storage.InternalStorageService;
import org.jboss.logging.Logger;

public final class DmpConsistencyUtility {
    @Generated
    private static final Logger log = Logger.getLogger(DmpConsistencyUtility.class);
    private static final String STORAGE_NOT_ACTIVE = "Storage is not active";

    public static void enforceDmpConsistency(DmpDO dmpDO) {
        if (dmpDO.getDataKind() != EDataKind.SPECIFY) {
            DmpConsistencyUtility.removeDatasetsBySource(dmpDO, EDataSource.NEW);
        }
        if (dmpDO.getReusedDataKind() != EDataKind.SPECIFY) {
            DmpConsistencyUtility.removeDatasetsBySource(dmpDO, EDataSource.REUSED);
        }
        if (dmpDO.getDataKind() != EDataKind.SPECIFY && dmpDO.getReusedDataKind() != EDataKind.SPECIFY) {
            DmpConsistencyUtility.removeDatasetRelatedInfo(dmpDO);
        }
        if (dmpDO.getDataKind() != EDataKind.NONE || dmpDO.getReusedDataKind() != EDataKind.NONE) {
            dmpDO.setNoDataExplanation(null);
        }
        DmpConsistencyUtility.setConditionalDmpInfo(dmpDO);
        DmpConsistencyUtility.enforceDatasetConsistency(dmpDO);
    }

    public static void enforceActiveStorage(DmpDO newDmp, Dmp oldDmp, InternalStorageService internalStorageService) throws ValidationException {
        PanacheEntity storage;
        ArrayList<Long> newDmpStorageIds = new ArrayList<Long>();
        for (StorageDO storageDO : newDmp.getStorage()) {
            newDmpStorageIds.add(storageDO.getInternalStorageId());
        }
        ArrayList<Long> oldDmpStorageIds = new ArrayList<Long>();
        if (oldDmp != null) {
            for (Host host : oldDmp.getHostList()) {
                InternalStorage internalStorage;
                if (!(host instanceof Storage) || (internalStorage = (storage = (Storage)host).getInternalStorageId()) == null) continue;
                oldDmpStorageIds.add(internalStorage.id);
            }
        }
        newDmpStorageIds.removeAll(oldDmpStorageIds);
        newDmpStorageIds.removeIf(Objects::isNull);
        for (Long id : newDmpStorageIds) {
            storage = (InternalStorage)InternalStorage.findById((Object)id);
            if (storage.isActive()) continue;
            throw new ValidationException(STORAGE_NOT_ACTIVE);
        }
    }

    private static void removeDatasetsBySource(DmpDO dmpDO, EDataSource source) {
        List<DatasetDO> datasets = dmpDO.getDatasets();
        for (DatasetDO datasetDO : datasets) {
            if (datasetDO.getSource() != source) continue;
            DmpConsistencyUtility.removeDatasetFromHost(datasetDO, dmpDO.getStorage());
            DmpConsistencyUtility.removeDatasetFromHost(datasetDO, dmpDO.getExternalStorage());
            DmpConsistencyUtility.removeDatasetFromHost(datasetDO, dmpDO.getRepositories());
        }
        dmpDO.setDatasets(datasets.stream().filter(dataset -> dataset.getSource() != source).collect(Collectors.toList()));
    }

    private static void removeDatasetRelatedInfo(DmpDO dmpDO) {
        dmpDO.setDatasets(new ArrayList<DatasetDO>());
        dmpDO.setDataGeneration(null);
        dmpDO.setDataRightsAndAccessControl(null);
        DmpConsistencyUtility.resetDocumentation(dmpDO);
        DmpConsistencyUtility.resetReuse(dmpDO);
        dmpDO.setRepositories(new ArrayList<RepositoryDO>());
        dmpDO.setStorage(new ArrayList<StorageDO>());
        dmpDO.setExternalStorage(new ArrayList<ExternalStorageDO>());
        dmpDO.setCostsExist(false);
    }

    private static void resetDocumentation(DmpDO dmpDO) {
        dmpDO.setMetadata(null);
        dmpDO.setStructure(null);
        dmpDO.setDocumentation(null);
        dmpDO.setDataQuality(new ArrayList<EDataQualityType>());
    }

    private static void resetReuse(DmpDO dmpDO) {
        dmpDO.setTargetAudience(null);
        dmpDO.setTools(null);
    }

    private static void removeDatasetFromHost(DatasetDO datasetDO, List<? extends HostDO> hosts) {
        for (HostDO hostDO : hosts) {
            if (hostDO.getDatasets() == null) continue;
            hostDO.setDatasets(hostDO.getDatasets().stream().filter(hash -> !hash.equals(datasetDO.getReferenceHash())).collect(Collectors.toList()));
        }
    }

    private static void enforceDatasetConsistency(DmpDO dmpDO) {
        if (!DmpConsistencyUtility.hasDatasetsOfAccessType(dmpDO.getDatasets(), EDataAccessType.RESTRICTED)) {
            dmpDO.setRestrictedAccessInfo(null);
            dmpDO.setRestrictedDataAccess(null);
        }
        if (!DmpConsistencyUtility.hasDatasetsOfAccessType(dmpDO.getDatasets(), EDataAccessType.CLOSED)) {
            dmpDO.setClosedAccessInfo(null);
        }
        if (!Boolean.TRUE.equals(dmpDO.getSensitiveData())) {
            dmpDO.getDatasets().forEach(dataset -> dataset.setSensitiveData(false));
        }
        if (!Boolean.TRUE.equals(dmpDO.getPersonalData())) {
            dmpDO.getDatasets().forEach(dataset -> dataset.setPersonalData(false));
        }
        if (!Boolean.TRUE.equals(dmpDO.getLegalRestrictions())) {
            dmpDO.getDatasets().forEach(dataset -> dataset.setLegalRestrictions(false));
        }
        for (DatasetDO datasetDO : dmpDO.getDatasets()) {
            if (datasetDO.getDataAccess() != EDataAccessType.CLOSED) {
                datasetDO.setDelete(false);
            }
            if (Boolean.TRUE.equals(datasetDO.getDelete())) continue;
            datasetDO.setDeletionPerson(null);
            datasetDO.setReasonForDeletion(null);
            datasetDO.setDateOfDeletion(null);
        }
        HashSet<String> seenDatasetDOI = new HashSet<String>();
        ArrayList<DatasetDO> uniqueDatasets = new ArrayList<DatasetDO>();
        for (DatasetDO datasetDO : dmpDO.getDatasets()) {
            if (datasetDO.getSource() == EDataSource.REUSED) {
                if (datasetDO.getDatasetId() != null && datasetDO.getDatasetId().getType() == EIdentifierType.DOI) {
                    String datasetDOI = datasetDO.getDatasetId().getIdentifier();
                    if (seenDatasetDOI.contains(datasetDOI)) continue;
                    uniqueDatasets.add(datasetDO);
                    seenDatasetDOI.add(datasetDOI);
                    continue;
                }
                uniqueDatasets.add(datasetDO);
                continue;
            }
            uniqueDatasets.add(datasetDO);
        }
        dmpDO.setDatasets(uniqueDatasets);
    }

    private static void setConditionalDmpInfo(DmpDO dmpDO) {
        DmpConsistencyUtility.unsetOtherIfNotSpecified(dmpDO.getDataQuality(), EDataQualityType.OTHERS, dmpDO::setOtherDataQuality);
        boolean hasDatasets = dmpDO.getDatasets() != null && !dmpDO.getDatasets().isEmpty();
        DmpConsistencyUtility.unsetListIfFalseOrNull(dmpDO.getSensitiveData(), hasDatasets, dmpDO::setSensitiveDataSecurity);
        DmpConsistencyUtility.unsetOtherIfNotSpecified(dmpDO.getSensitiveDataSecurity(), ESecurityMeasure.OTHER, dmpDO::setOtherDataSecurityMeasures);
        if (!Boolean.TRUE.equals(dmpDO.getSensitiveData()) || !hasDatasets) {
            dmpDO.setSensitiveDataAccess(null);
        }
        DmpConsistencyUtility.unsetListIfFalseOrNull(dmpDO.getPersonalData(), hasDatasets, dmpDO::setPersonalDataCompliance);
        DmpConsistencyUtility.unsetOtherIfNotSpecified(dmpDO.getPersonalDataCompliance(), EComplianceType.OTHER, dmpDO::setOtherPersonalDataCompliance);
        DmpConsistencyUtility.unsetListIfFalseOrNull(dmpDO.getLegalRestrictions(), hasDatasets, dmpDO::setLegalRestrictionsDocuments);
        DmpConsistencyUtility.unsetOtherIfNotSpecified(dmpDO.getLegalRestrictionsDocuments(), EAgreement.OTHER, dmpDO::setOtherLegalRestrictionsDocument);
        if (!Boolean.TRUE.equals(dmpDO.getLegalRestrictions()) || !hasDatasets) {
            dmpDO.setLegalRestrictionsComment(null);
        }
        if (dmpDO.getExternalStorage().isEmpty()) {
            dmpDO.setExternalStorageInfo(null);
        }
        DmpConsistencyUtility.unsetListIfFalseOrNull(dmpDO.getCostsExist(), hasDatasets, dmpDO::setCosts);
    }

    private static boolean hasDatasetsOfAccessType(List<DatasetDO> datasetDOList, EDataAccessType accessType) {
        return datasetDOList.stream().anyMatch(datasetDO -> datasetDO.getDataAccess() == accessType);
    }

    private static <R> void unsetListIfFalseOrNull(Boolean condition1, Boolean condition2, Consumer<List<R>> consumer) {
        if (!Boolean.TRUE.equals(condition1) || !Boolean.TRUE.equals(condition2)) {
            consumer.accept(new ArrayList());
        }
    }

    private static <R extends Enum<R>> void unsetOtherIfNotSpecified(List<R> enumList, R other, Consumer<String> consumer) {
        if (enumList == null || !enumList.contains(other)) {
            consumer.accept(null);
        }
    }

    @Generated
    private DmpConsistencyUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

