/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.gdpr.service;

import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.damap.base.annotations.gdpr.GdprBase;
import org.damap.base.annotations.gdpr.GdprContext;
import org.damap.base.annotations.gdpr.GdprExtended;
import org.damap.base.annotations.gdpr.GdprKey;
import org.damap.base.rest.gdpr.domain.GdprQuery;
import org.damap.base.rest.gdpr.exceptions.MissingGdprKeyException;
import org.damap.base.rest.gdpr.exceptions.NoSuchContextPropertyException;
import org.jboss.logging.Logger;

public final class GdprQueryUtil {
    @Generated
    private static final Logger log = Logger.getLogger(GdprQueryUtil.class);

    public static GdprQuery buildQueryObject(Class<?> gdprClass) throws MissingGdprKeyException, NoSuchContextPropertyException {
        List<Field> gdprFields = GdprQueryUtil.getGdprFields(gdprClass.getDeclaredFields());
        GdprQuery query = new GdprQuery();
        query.setRoot(gdprClass);
        ArrayList<String> base = new ArrayList<String>();
        ArrayList<String> extended = new ArrayList<String>();
        ArrayList<String> context = new ArrayList<String>();
        ArrayList<GdprQuery> baseJoins = new ArrayList<GdprQuery>();
        ArrayList<GdprQuery> extendedJoins = new ArrayList<GdprQuery>();
        ArrayList<GdprQuery> contextJoins = new ArrayList<GdprQuery>();
        gdprFields.forEach(f -> {
            if (GdprQueryUtil.isPrimitiveOrEnum(f.getType())) {
                if (f.isAnnotationPresent(GdprKey.class)) {
                    query.setKey(GdprQueryUtil.getColumnName(f));
                } else if (f.isAnnotationPresent(GdprContext.class)) {
                    context.add(GdprQueryUtil.getColumnName(f));
                } else if (f.isAnnotationPresent(GdprBase.class)) {
                    base.add(GdprQueryUtil.getColumnName(f));
                } else if (f.isAnnotationPresent(GdprExtended.class)) {
                    extended.add(GdprQueryUtil.getColumnName(f));
                }
            } else {
                GdprQuery join = GdprQueryUtil.getJoinQuery(f);
                if (f.isAnnotationPresent(GdprContext.class)) {
                    String[] properties = f.getAnnotation(GdprContext.class).properties();
                    contextJoins.add(GdprQueryUtil.getContextJoinQuery(f, Arrays.asList(properties)));
                } else if (f.isAnnotationPresent(GdprBase.class)) {
                    baseJoins.add(join);
                } else if (f.isAnnotationPresent(GdprExtended.class)) {
                    extendedJoins.add(join);
                }
            }
        });
        query.setContext(context);
        query.setBase(base);
        query.setExtended(extended);
        query.setContextJoins(contextJoins);
        query.setBaseJoins(baseJoins);
        query.setExtendedJoins(extendedJoins);
        if (query.getKey() == null) {
            throw new MissingGdprKeyException("No @GdprKey found for entity " + query.getRoot().getSimpleName());
        }
        return query;
    }

    private static List<Field> getGdprFields(Field[] fields) {
        return Stream.of(fields).filter(f -> f.isAnnotationPresent(GdprKey.class) || f.isAnnotationPresent(GdprContext.class) || f.isAnnotationPresent(GdprBase.class) || f.isAnnotationPresent(GdprExtended.class)).collect(Collectors.toList());
    }

    private static GdprQuery getJoinQuery(Field field) {
        GdprQuery query = new GdprQuery();
        query.setFieldName(field.getName());
        query.setBase(new ArrayList<String>());
        for (Field f : field.getType().getDeclaredFields()) {
            if (f.isAnnotationPresent(Transient.class) || f.isAnnotationPresent(Version.class)) continue;
            query.getBase().add(GdprQueryUtil.getColumnName(f));
        }
        return query;
    }

    public static GdprQuery getContextJoinQuery(Field field, List<String> properties) throws NoSuchContextPropertyException {
        Field f;
        GdprQuery query = new GdprQuery();
        query.setFieldName(field.getName());
        Class<?> clazz = field.getType();
        query.setRoot(clazz);
        query.setBase(new ArrayList<String>());
        ArrayList<String> simpleProperties = new ArrayList<String>();
        HashMap nestedProperties = new HashMap();
        for (String string : properties) {
            String[] propertyParts = string.split("\\.", 2);
            if (propertyParts.length > 1) {
                if (nestedProperties.containsKey(propertyParts[0])) {
                    ((List)nestedProperties.get(propertyParts[0])).add(propertyParts[1]);
                    continue;
                }
                ArrayList<String> nestedProperty = new ArrayList<String>();
                nestedProperty.add(propertyParts[1]);
                nestedProperties.put(propertyParts[0], nestedProperty);
                continue;
            }
            simpleProperties.add(string);
        }
        for (String string : simpleProperties) {
            f = GdprQueryUtil.getField(clazz, string);
            if (!GdprQueryUtil.isPrimitiveOrEnum(f.getType())) continue;
            query.getBase().add(GdprQueryUtil.getColumnName(f));
        }
        query.setContextJoins(new ArrayList<GdprQuery>());
        for (Map.Entry entry : nestedProperties.entrySet()) {
            f = GdprQueryUtil.getField(clazz, (String)entry.getKey());
            query.getContextJoins().add(GdprQueryUtil.getContextJoinQuery(f, (List)entry.getValue()));
        }
        return query;
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchContextPropertyException {
        try {
            if (Objects.equals(fieldName, "id")) {
                return clazz.getField(fieldName);
            }
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchContextPropertyException(clazz, fieldName);
        }
    }

    private static String getColumnName(Field field) {
        return field.getName();
    }

    private static boolean isPrimitiveOrEnum(@NotNull Class<?> clazz) {
        return String.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.isEnum();
    }

    @Generated
    private GdprQueryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

