/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.invenio_damap;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.damap.base.enums.EAccessRight;
import org.damap.base.enums.EDataAccessType;
import org.damap.base.enums.EDataKind;
import org.damap.base.enums.EDataSource;
import org.damap.base.enums.EDataType;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.enums.ELicense;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.ExternalStorageDO;
import org.damap.base.rest.dmp.domain.IdentifierDO;
import org.damap.base.rest.madmp.dto.Dataset;
import org.damap.base.rest.madmp.dto.DatasetId;
import org.damap.base.rest.madmp.dto.Distribution;
import org.damap.base.rest.madmp.dto.Host;
import org.jboss.logging.Logger;

public final class InvenioDamapResourceMapper {
    @Generated
    private static final Logger log = Logger.getLogger(InvenioDamapResourceMapper.class);

    public static DatasetDO mapMaDMPDatasetToDatasetDO(Dataset madmpDataset, DatasetDO datasetDO, DmpDO dmpDO) {
        DatasetId datasetId = madmpDataset.getDatasetId();
        if (datasetId != null) {
            IdentifierDO newId = new IdentifierDO();
            newId.setIdentifier(datasetId.getIdentifier());
            newId.setType(EIdentifierType.valueOf(datasetId.getType().name().toUpperCase()));
            datasetDO.setDatasetId(newId);
        }
        if (datasetDO.getReferenceHash() != null) {
            datasetDO.setReferenceHash("invenio" + String.valueOf(new Date()));
        }
        datasetDO.setDateOfDeletion(null);
        datasetDO.setDelete(false);
        datasetDO.setDeletionPerson(null);
        if (madmpDataset.getDescription() != null && !madmpDataset.getDescription().isEmpty()) {
            datasetDO.setDescription(madmpDataset.getDescription());
        }
        InvenioDamapResourceMapper.mapDistribution(madmpDataset, datasetDO, dmpDO);
        if (datasetDO.getOtherProjectMembersAccess() == null) {
            datasetDO.setOtherProjectMembersAccess(EAccessRight.READ);
        }
        if (madmpDataset.getPersonalData() != null || datasetDO.getPersonalData() == null) {
            Boolean personalData = switch (Objects.requireNonNullElse(madmpDataset.getPersonalData(), Dataset.PersonalData.UNKNOWN)) {
                case Dataset.PersonalData.NO -> false;
                default -> true;
            };
            datasetDO.setPersonalData(personalData);
            dmpDO.setPersonalData(dmpDO.getPersonalData() != false || personalData != false);
        }
        if (datasetDO.getPublicAccess() == null) {
            datasetDO.setPublicAccess(EAccessRight.READ);
        }
        if (datasetDO.getSelectedProjectMembersAccess() == null) {
            datasetDO.setSelectedProjectMembersAccess(EAccessRight.READ);
        }
        if (madmpDataset.getSensitiveData() != null || datasetDO.getSensitiveData() == null) {
            Boolean sensitiveData = switch (Objects.requireNonNullElse(madmpDataset.getSensitiveData(), Dataset.SensitiveData.UNKNOWN)) {
                case Dataset.SensitiveData.NO -> false;
                default -> true;
            };
            datasetDO.setSensitiveData(sensitiveData);
            dmpDO.setSensitiveData(dmpDO.getSensitiveData() != false || sensitiveData != false);
        }
        if (datasetDO.getSource() == null) {
            datasetDO.setSource(EDataSource.NEW);
            dmpDO.setDataKind(EDataKind.SPECIFY);
            dmpDO.setReusedDataKind(EDataKind.SPECIFY);
        }
        if (madmpDataset.getTitle() != null) {
            datasetDO.setTitle(madmpDataset.getTitle());
        }
        if (madmpDataset.getType() != null) {
            EDataType type = EDataType.getByValue(madmpDataset.getType());
            if (type == null) {
                log.info((Object)("Could not infer EDataType from provided value: " + madmpDataset.getType()));
            } else {
                List types = Objects.requireNonNullElse(datasetDO.getType(), new ArrayList());
                if (!types.contains((Object)type)) {
                    types.add(type);
                }
                datasetDO.setType(types);
            }
        }
        return datasetDO;
    }

    private static void mapDistribution(Dataset madmpDataset, DatasetDO datasetDO, DmpDO dmpDO) {
        if (madmpDataset.getDistribution() == null) {
            return;
        }
        HashSet<String> licenses = new HashSet<String>();
        for (Distribution d : madmpDataset.getDistribution()) {
            List<String> datasetHashes;
            EDataAccessType dataAccess;
            if (d.getDataAccess() != null && (dataAccess = EDataAccessType.getByValue(d.getDataAccess().value())) != null && dataAccess.compare(datasetDO.getDataAccess()) == 1) {
                datasetDO.setDataAccess(dataAccess);
            }
            licenses.addAll(d.getLicense().stream().map(l -> l.getLicenseRef().toString()).toList());
            if (d.getByteSize() != null && (long)d.getByteSize().intValue() > Objects.requireNonNullElse(datasetDO.getSize(), 0L)) {
                datasetDO.setSize(d.getByteSize().longValue());
            }
            if (d.getHost() == null) continue;
            Host host = d.getHost();
            String hostPath = host.getUrl() == null ? null : host.getUrl().getPath();
            List<ExternalStorageDO> externalStorages = dmpDO.getExternalStorage();
            ExternalStorageDO externalStorageDO = externalStorages.stream().filter(s -> s.getUrl() != null && s.getUrl().equals(hostPath)).findFirst().orElse(null);
            if (externalStorageDO == null) {
                externalStorageDO = new ExternalStorageDO();
                externalStorageDO.setBackupFrequency(host.getBackupFrequency());
                externalStorageDO.setStorageLocation(host.getGeoLocation() != null ? host.getGeoLocation().toString() : null);
                externalStorageDO.setTitle(host.getTitle());
                externalStorageDO.setUrl(hostPath);
                externalStorages.add(externalStorageDO);
            }
            if (!(datasetHashes = externalStorageDO.getDatasets()).contains(datasetDO.getReferenceHash())) continue;
            datasetHashes.add(datasetDO.getReferenceHash());
        }
        block1: for (String license : licenses) {
            for (ELicense eLicense : ELicense.values()) {
                if (!license.equals(eLicense.getUrl())) continue;
                datasetDO.setLicense(eLicense);
                continue block1;
            }
        }
    }

    @Generated
    private InvenioDamapResourceMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

