/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.damap.base.rest.madmp.dto.Contact;
import org.damap.base.rest.madmp.dto.Contributor;
import org.damap.base.rest.madmp.dto.Cost;
import org.damap.base.rest.madmp.dto.Dataset;
import org.damap.base.rest.madmp.dto.DmpId;
import org.damap.base.rest.madmp.dto.Project;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"contact", "contributor", "cost", "created", "dataset", "description", "dmp_id", "ethical_issues_description", "ethical_issues_exist", "ethical_issues_report", "language", "modified", "project", "title"})
public class Dmp {
    @JsonProperty(value="contact")
    private Contact contact;
    @JsonProperty(value="contributor")
    private List<Contributor> contributor = new ArrayList<Contributor>();
    @JsonProperty(value="cost")
    private List<Cost> cost = new ArrayList<Cost>();
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="Date and time of the first version of a DMP. Must not be changed in subsequent DMPs. Encoded using the relevant ISO 8601 Date and Time compliant string")
    private Date created;
    @JsonProperty(value="dataset")
    private List<Dataset> dataset = new ArrayList<Dataset>();
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="To provide any free-form text information on a DMP")
    private String description;
    @JsonProperty(value="dmp_id")
    @JsonPropertyDescription(value="Identifier for the DMP itself")
    private DmpId dmpId;
    @JsonProperty(value="ethical_issues_description")
    @JsonPropertyDescription(value="To describe ethical issues directly in a DMP")
    private String ethicalIssuesDescription;
    @JsonProperty(value="ethical_issues_exist")
    @JsonPropertyDescription(value="To indicate whether there are ethical issues related to data that this DMP describes. Allowed values: yes, no, unknown")
    private EthicalIssuesExist ethicalIssuesExist;
    @JsonProperty(value="ethical_issues_report")
    @JsonPropertyDescription(value="To indicate where a protocol from a meeting with an ethical commitee can be found")
    private URI ethicalIssuesReport;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="Language of the DMP expressed using ISO 639-3.")
    private Language language;
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="Must be set each time DMP is modified. Indicates DMP version. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private Date modified;
    @JsonProperty(value="project")
    @JsonPropertyDescription(value="Project related to a DMP")
    private List<Project> project = new ArrayList<Project>();
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="Title of a DMP")
    private String title;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="contact")
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @JsonProperty(value="contributor")
    public List<Contributor> getContributor() {
        return this.contributor;
    }

    @JsonProperty(value="contributor")
    public void setContributor(List<Contributor> contributor) {
        this.contributor = contributor;
    }

    @JsonProperty(value="cost")
    public List<Cost> getCost() {
        return this.cost;
    }

    @JsonProperty(value="cost")
    public void setCost(List<Cost> cost) {
        this.cost = cost;
    }

    @JsonProperty(value="created")
    public Date getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(Date created) {
        this.created = created;
    }

    @JsonProperty(value="dataset")
    public List<Dataset> getDataset() {
        return this.dataset;
    }

    @JsonProperty(value="dataset")
    public void setDataset(List<Dataset> dataset) {
        this.dataset = dataset;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="dmp_id")
    public DmpId getDmpId() {
        return this.dmpId;
    }

    @JsonProperty(value="dmp_id")
    public void setDmpId(DmpId dmpId) {
        this.dmpId = dmpId;
    }

    @JsonProperty(value="ethical_issues_description")
    public String getEthicalIssuesDescription() {
        return this.ethicalIssuesDescription;
    }

    @JsonProperty(value="ethical_issues_description")
    public void setEthicalIssuesDescription(String ethicalIssuesDescription) {
        this.ethicalIssuesDescription = ethicalIssuesDescription;
    }

    @JsonProperty(value="ethical_issues_exist")
    public EthicalIssuesExist getEthicalIssuesExist() {
        return this.ethicalIssuesExist;
    }

    @JsonProperty(value="ethical_issues_exist")
    public void setEthicalIssuesExist(EthicalIssuesExist ethicalIssuesExist) {
        this.ethicalIssuesExist = ethicalIssuesExist;
    }

    @JsonProperty(value="ethical_issues_report")
    public URI getEthicalIssuesReport() {
        return this.ethicalIssuesReport;
    }

    @JsonProperty(value="ethical_issues_report")
    public void setEthicalIssuesReport(URI ethicalIssuesReport) {
        this.ethicalIssuesReport = ethicalIssuesReport;
    }

    @JsonProperty(value="language")
    public Language getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(Language language) {
        this.language = language;
    }

    @JsonProperty(value="modified")
    public Date getModified() {
        return this.modified;
    }

    @JsonProperty(value="modified")
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @JsonProperty(value="project")
    public List<Project> getProject() {
        return this.project;
    }

    @JsonProperty(value="project")
    public void setProject(List<Project> project) {
        this.project = project;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dmp.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contact");
        sb.append('=');
        sb.append(this.contact == null ? "<null>" : this.contact);
        sb.append(',');
        sb.append("contributor");
        sb.append('=');
        sb.append(this.contributor == null ? "<null>" : this.contributor);
        sb.append(',');
        sb.append("cost");
        sb.append('=');
        sb.append(this.cost == null ? "<null>" : this.cost);
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(this.created == null ? "<null>" : this.created);
        sb.append(',');
        sb.append("dataset");
        sb.append('=');
        sb.append(this.dataset == null ? "<null>" : this.dataset);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("dmpId");
        sb.append('=');
        sb.append(this.dmpId == null ? "<null>" : this.dmpId);
        sb.append(',');
        sb.append("ethicalIssuesDescription");
        sb.append('=');
        sb.append(this.ethicalIssuesDescription == null ? "<null>" : this.ethicalIssuesDescription);
        sb.append(',');
        sb.append("ethicalIssuesExist");
        sb.append('=');
        sb.append(this.ethicalIssuesExist == null ? "<null>" : this.ethicalIssuesExist);
        sb.append(',');
        sb.append("ethicalIssuesReport");
        sb.append('=');
        sb.append(this.ethicalIssuesReport == null ? "<null>" : this.ethicalIssuesReport);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("modified");
        sb.append('=');
        sb.append(this.modified == null ? "<null>" : this.modified);
        sb.append(',');
        sb.append("project");
        sb.append('=');
        sb.append(this.project == null ? "<null>" : this.project);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.cost == null ? 0 : this.cost.hashCode());
        result = result * 31 + (this.created == null ? 0 : this.created.hashCode());
        result = result * 31 + (this.ethicalIssuesExist == null ? 0 : this.ethicalIssuesExist.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.project == null ? 0 : this.project.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.contributor == null ? 0 : this.contributor.hashCode());
        result = result * 31 + (this.dmpId == null ? 0 : this.dmpId.hashCode());
        result = result * 31 + (this.contact == null ? 0 : this.contact.hashCode());
        result = result * 31 + (this.modified == null ? 0 : this.modified.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.dataset == null ? 0 : this.dataset.hashCode());
        result = result * 31 + (this.ethicalIssuesReport == null ? 0 : this.ethicalIssuesReport.hashCode());
        result = result * 31 + (this.ethicalIssuesDescription == null ? 0 : this.ethicalIssuesDescription.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Dmp)) {
            return false;
        }
        Dmp rhs = (Dmp)other;
        return (this.cost == rhs.cost || this.cost != null && this.cost.equals(rhs.cost)) && (this.created == rhs.created || this.created != null && this.created.equals(rhs.created)) && (this.ethicalIssuesExist == rhs.ethicalIssuesExist || this.ethicalIssuesExist != null && this.ethicalIssuesExist.equals((Object)rhs.ethicalIssuesExist)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.project == rhs.project || this.project != null && this.project.equals(rhs.project)) && (this.language == rhs.language || this.language != null && this.language.equals((Object)rhs.language)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.contributor == rhs.contributor || this.contributor != null && this.contributor.equals(rhs.contributor)) && (this.dmpId == rhs.dmpId || this.dmpId != null && this.dmpId.equals(rhs.dmpId)) && (this.contact == rhs.contact || this.contact != null && this.contact.equals(rhs.contact)) && (this.modified == rhs.modified || this.modified != null && this.modified.equals(rhs.modified)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.dataset == rhs.dataset || this.dataset != null && this.dataset.equals(rhs.dataset)) && (this.ethicalIssuesReport == rhs.ethicalIssuesReport || this.ethicalIssuesReport != null && this.ethicalIssuesReport.equals(rhs.ethicalIssuesReport)) && (this.ethicalIssuesDescription == rhs.ethicalIssuesDescription || this.ethicalIssuesDescription != null && this.ethicalIssuesDescription.equals(rhs.ethicalIssuesDescription));
    }

    public static enum EthicalIssuesExist {
        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");

        private final String value;
        private static final Map<String, EthicalIssuesExist> CONSTANTS;

        private EthicalIssuesExist(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EthicalIssuesExist fromValue(String value) {
            EthicalIssuesExist constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, EthicalIssuesExist>();
            for (EthicalIssuesExist c : EthicalIssuesExist.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Language {
        AAR("aar"),
        ABK("abk"),
        AFR("afr"),
        AKA("aka"),
        AMH("amh"),
        ARA("ara"),
        ARG("arg"),
        ASM("asm"),
        AVA("ava"),
        AVE("ave"),
        AYM("aym"),
        AZE("aze"),
        BAK("bak"),
        BAM("bam"),
        BEL("bel"),
        BEN("ben"),
        BIH("bih"),
        BIS("bis"),
        BOD("bod"),
        BOS("bos"),
        BRE("bre"),
        BUL("bul"),
        CAT("cat"),
        CES("ces"),
        CHA("cha"),
        CHE("che"),
        CHU("chu"),
        CHV("chv"),
        COR("cor"),
        COS("cos"),
        CRE("cre"),
        CYM("cym"),
        DAN("dan"),
        DEU("deu"),
        DIV("div"),
        DZO("dzo"),
        ELL("ell"),
        ENG("eng"),
        EPO("epo"),
        EST("est"),
        EUS("eus"),
        EWE("ewe"),
        FAO("fao"),
        FAS("fas"),
        FIJ("fij"),
        FIN("fin"),
        FRA("fra"),
        FRY("fry"),
        FUL("ful"),
        GLA("gla"),
        GLE("gle"),
        GLG("glg"),
        GLV("glv"),
        GRN("grn"),
        GUJ("guj"),
        HAT("hat"),
        HAU("hau"),
        HBS("hbs"),
        HEB("heb"),
        HER("her"),
        HIN("hin"),
        HMO("hmo"),
        HRV("hrv"),
        HUN("hun"),
        HYE("hye"),
        IBO("ibo"),
        IDO("ido"),
        III("iii"),
        IKU("iku"),
        ILE("ile"),
        INA("ina"),
        IND("ind"),
        IPK("ipk"),
        ISL("isl"),
        ITA("ita"),
        JAV("jav"),
        JPN("jpn"),
        KAL("kal"),
        KAN("kan"),
        KAS("kas"),
        KAT("kat"),
        KAU("kau"),
        KAZ("kaz"),
        KHM("khm"),
        KIK("kik"),
        KIN("kin"),
        KIR("kir"),
        KOM("kom"),
        KON("kon"),
        KOR("kor"),
        KUA("kua"),
        KUR("kur"),
        LAO("lao"),
        LAT("lat"),
        LAV("lav"),
        LIM("lim"),
        LIN("lin"),
        LIT("lit"),
        LTZ("ltz"),
        LUB("lub"),
        LUG("lug"),
        MAH("mah"),
        MAL("mal"),
        MAR("mar"),
        MKD("mkd"),
        MLG("mlg"),
        MLT("mlt"),
        MON("mon"),
        MRI("mri"),
        MSA("msa"),
        MYA("mya"),
        NAU("nau"),
        NAV("nav"),
        NBL("nbl"),
        NDE("nde"),
        NDO("ndo"),
        NEP("nep"),
        NLD("nld"),
        NNO("nno"),
        NOB("nob"),
        NOR("nor"),
        NYA("nya"),
        OCI("oci"),
        OJI("oji"),
        ORI("ori"),
        ORM("orm"),
        OSS("oss"),
        PAN("pan"),
        PLI("pli"),
        POL("pol"),
        POR("por"),
        PUS("pus"),
        QUE("que"),
        ROH("roh"),
        RON("ron"),
        RUN("run"),
        RUS("rus"),
        SAG("sag"),
        SAN("san"),
        SIN("sin"),
        SLK("slk"),
        SLV("slv"),
        SME("sme"),
        SMO("smo"),
        SNA("sna"),
        SND("snd"),
        SOM("som"),
        SOT("sot"),
        SPA("spa"),
        SQI("sqi"),
        SRD("srd"),
        SRP("srp"),
        SSW("ssw"),
        SUN("sun"),
        SWA("swa"),
        SWE("swe"),
        TAH("tah"),
        TAM("tam"),
        TAT("tat"),
        TEL("tel"),
        TGK("tgk"),
        TGL("tgl"),
        THA("tha"),
        TIR("tir"),
        TON("ton"),
        TSN("tsn"),
        TSO("tso"),
        TUK("tuk"),
        TUR("tur"),
        TWI("twi"),
        UIG("uig"),
        UKR("ukr"),
        URD("urd"),
        UZB("uzb"),
        VEN("ven"),
        VIE("vie"),
        VOL("vol"),
        WLN("wln"),
        WOL("wol"),
        XHO("xho"),
        YID("yid"),
        YOR("yor"),
        ZHA("zha"),
        ZHO("zho"),
        ZUL("zul");

        private final String value;
        private static final Map<String, Language> CONSTANTS;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Language fromValue(String value) {
            Language constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Language>();
            for (Language c : Language.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

