/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.damap.base.rest.madmp.dto.FunderId;
import org.damap.base.rest.madmp.dto.GrantId;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"funder_id", "funding_status", "grant_id"})
public class Funding {
    @JsonProperty(value="funder_id")
    @JsonPropertyDescription(value="Funder ID of the associated project")
    private FunderId funderId;
    @JsonProperty(value="funding_status")
    @JsonPropertyDescription(value="To express different phases of project lifecycle. Allowed values: planned, applied, granted, rejected")
    private FundingStatus fundingStatus;
    @JsonProperty(value="grant_id")
    @JsonPropertyDescription(value="Grant ID of the associated project")
    private GrantId grantId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="funder_id")
    public FunderId getFunderId() {
        return this.funderId;
    }

    @JsonProperty(value="funder_id")
    public void setFunderId(FunderId funderId) {
        this.funderId = funderId;
    }

    @JsonProperty(value="funding_status")
    public FundingStatus getFundingStatus() {
        return this.fundingStatus;
    }

    @JsonProperty(value="funding_status")
    public void setFundingStatus(FundingStatus fundingStatus) {
        this.fundingStatus = fundingStatus;
    }

    @JsonProperty(value="grant_id")
    public GrantId getGrantId() {
        return this.grantId;
    }

    @JsonProperty(value="grant_id")
    public void setGrantId(GrantId grantId) {
        this.grantId = grantId;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Funding.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("funderId");
        sb.append('=');
        sb.append(this.funderId == null ? "<null>" : this.funderId);
        sb.append(',');
        sb.append("fundingStatus");
        sb.append('=');
        sb.append(this.fundingStatus == null ? "<null>" : this.fundingStatus);
        sb.append(',');
        sb.append("grantId");
        sb.append('=');
        sb.append(this.grantId == null ? "<null>" : this.grantId);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.funderId == null ? 0 : this.funderId.hashCode());
        result = result * 31 + (this.grantId == null ? 0 : this.grantId.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.fundingStatus == null ? 0 : this.fundingStatus.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Funding)) {
            return false;
        }
        Funding rhs = (Funding)other;
        return (this.funderId == rhs.funderId || this.funderId != null && this.funderId.equals(rhs.funderId)) && (this.grantId == rhs.grantId || this.grantId != null && this.grantId.equals(rhs.grantId)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.fundingStatus == rhs.fundingStatus || this.fundingStatus != null && this.fundingStatus.equals((Object)rhs.fundingStatus));
    }

    public static enum FundingStatus {
        PLANNED("planned"),
        APPLIED("applied"),
        GRANTED("granted"),
        REJECTED("rejected");

        private final String value;
        private static final Map<String, FundingStatus> CONSTANTS;

        private FundingStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FundingStatus fromValue(String value) {
            FundingStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FundingStatus>();
            for (FundingStatus c : FundingStatus.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

