/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.damap.base.rest.madmp.dto.PidSystem;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"availability", "backup_frequency", "backup_type", "certified_with", "description", "geo_location", "pid_system", "storage_type", "support_versioning", "title", "url"})
public class Host {
    @JsonProperty(value="availability")
    @JsonPropertyDescription(value="Availability")
    private String availability;
    @JsonProperty(value="backup_frequency")
    @JsonPropertyDescription(value="Backup Frequency")
    private String backupFrequency;
    @JsonProperty(value="backup_type")
    @JsonPropertyDescription(value="Backup Type")
    private String backupType;
    @JsonProperty(value="certified_with")
    @JsonPropertyDescription(value="Repository certified to a recognised standard. Allowed values: din31644, dini-zertifikat, dsa, iso16363, iso16919, trac, wds, coretrustseal")
    private CertifiedWith certifiedWith;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description")
    private String description;
    @JsonProperty(value="geo_location")
    @JsonPropertyDescription(value="Physical location of the data expressed using ISO 3166-1 country code.")
    private GeoLocation geoLocation;
    @JsonProperty(value="pid_system")
    @JsonPropertyDescription(value="PID system(s). Allowed values: ark, arxiv, bibcode, doi, ean13, eissn, handle, igsn, isbn, issn, istc, lissn, lsid, pmid, purl, upc, url, urn, other")
    private List<PidSystem> pidSystem = new ArrayList<PidSystem>();
    @JsonProperty(value="storage_type")
    @JsonPropertyDescription(value="The type of storage required")
    private String storageType;
    @JsonProperty(value="support_versioning")
    @JsonPropertyDescription(value="If host supports versioning. Allowed values: yes, no, unknown")
    private SupportVersioning supportVersioning;
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="Title")
    private String title;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the system hosting a distribution of a dataset")
    private URI url;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="availability")
    public String getAvailability() {
        return this.availability;
    }

    @JsonProperty(value="availability")
    public void setAvailability(String availability) {
        this.availability = availability;
    }

    @JsonProperty(value="backup_frequency")
    public String getBackupFrequency() {
        return this.backupFrequency;
    }

    @JsonProperty(value="backup_frequency")
    public void setBackupFrequency(String backupFrequency) {
        this.backupFrequency = backupFrequency;
    }

    @JsonProperty(value="backup_type")
    public String getBackupType() {
        return this.backupType;
    }

    @JsonProperty(value="backup_type")
    public void setBackupType(String backupType) {
        this.backupType = backupType;
    }

    @JsonProperty(value="certified_with")
    public CertifiedWith getCertifiedWith() {
        return this.certifiedWith;
    }

    @JsonProperty(value="certified_with")
    public void setCertifiedWith(CertifiedWith certifiedWith) {
        this.certifiedWith = certifiedWith;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="geo_location")
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @JsonProperty(value="geo_location")
    public void setGeoLocation(GeoLocation geoLocation) {
        this.geoLocation = geoLocation;
    }

    @JsonProperty(value="pid_system")
    public List<PidSystem> getPidSystem() {
        return this.pidSystem;
    }

    @JsonProperty(value="pid_system")
    public void setPidSystem(List<PidSystem> pidSystem) {
        this.pidSystem = pidSystem;
    }

    @JsonProperty(value="storage_type")
    public String getStorageType() {
        return this.storageType;
    }

    @JsonProperty(value="storage_type")
    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @JsonProperty(value="support_versioning")
    public SupportVersioning getSupportVersioning() {
        return this.supportVersioning;
    }

    @JsonProperty(value="support_versioning")
    public void setSupportVersioning(SupportVersioning supportVersioning) {
        this.supportVersioning = supportVersioning;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Host.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("availability");
        sb.append('=');
        sb.append(this.availability == null ? "<null>" : this.availability);
        sb.append(',');
        sb.append("backupFrequency");
        sb.append('=');
        sb.append(this.backupFrequency == null ? "<null>" : this.backupFrequency);
        sb.append(',');
        sb.append("backupType");
        sb.append('=');
        sb.append(this.backupType == null ? "<null>" : this.backupType);
        sb.append(',');
        sb.append("certifiedWith");
        sb.append('=');
        sb.append(this.certifiedWith == null ? "<null>" : this.certifiedWith);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("geoLocation");
        sb.append('=');
        sb.append(this.geoLocation == null ? "<null>" : this.geoLocation);
        sb.append(',');
        sb.append("pidSystem");
        sb.append('=');
        sb.append(this.pidSystem == null ? "<null>" : this.pidSystem);
        sb.append(',');
        sb.append("storageType");
        sb.append('=');
        sb.append(this.storageType == null ? "<null>" : this.storageType);
        sb.append(',');
        sb.append("supportVersioning");
        sb.append('=');
        sb.append(this.supportVersioning == null ? "<null>" : this.supportVersioning);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.pidSystem == null ? 0 : this.pidSystem.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.availability == null ? 0 : this.availability.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.backupType == null ? 0 : this.backupType.hashCode());
        result = result * 31 + (this.certifiedWith == null ? 0 : this.certifiedWith.hashCode());
        result = result * 31 + (this.geoLocation == null ? 0 : this.geoLocation.hashCode());
        result = result * 31 + (this.storageType == null ? 0 : this.storageType.hashCode());
        result = result * 31 + (this.backupFrequency == null ? 0 : this.backupFrequency.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.supportVersioning == null ? 0 : this.supportVersioning.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Host)) {
            return false;
        }
        Host rhs = (Host)other;
        return (this.pidSystem == rhs.pidSystem || this.pidSystem != null && this.pidSystem.equals(rhs.pidSystem)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.availability == rhs.availability || this.availability != null && this.availability.equals(rhs.availability)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.backupType == rhs.backupType || this.backupType != null && this.backupType.equals(rhs.backupType)) && (this.certifiedWith == rhs.certifiedWith || this.certifiedWith != null && this.certifiedWith.equals((Object)rhs.certifiedWith)) && (this.geoLocation == rhs.geoLocation || this.geoLocation != null && this.geoLocation.equals((Object)rhs.geoLocation)) && (this.storageType == rhs.storageType || this.storageType != null && this.storageType.equals(rhs.storageType)) && (this.backupFrequency == rhs.backupFrequency || this.backupFrequency != null && this.backupFrequency.equals(rhs.backupFrequency)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.supportVersioning == rhs.supportVersioning || this.supportVersioning != null && this.supportVersioning.equals((Object)rhs.supportVersioning));
    }

    public static enum CertifiedWith {
        DIN_31644("din31644"),
        DINI_ZERTIFIKAT("dini-zertifikat"),
        DSA("dsa"),
        ISO_16363("iso16363"),
        ISO_16919("iso16919"),
        TRAC("trac"),
        WDS("wds"),
        CORETRUSTSEAL("coretrustseal");

        private final String value;
        private static final Map<String, CertifiedWith> CONSTANTS;

        private CertifiedWith(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CertifiedWith fromValue(String value) {
            CertifiedWith constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CertifiedWith>();
            for (CertifiedWith c : CertifiedWith.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum GeoLocation {
        AD("AD"),
        AE("AE"),
        AF("AF"),
        AG("AG"),
        AI("AI"),
        AL("AL"),
        AM("AM"),
        AO("AO"),
        AQ("AQ"),
        AR("AR"),
        AS("AS"),
        AT("AT"),
        AU("AU"),
        AW("AW"),
        AX("AX"),
        AZ("AZ"),
        BA("BA"),
        BB("BB"),
        BD("BD"),
        BE("BE"),
        BF("BF"),
        BG("BG"),
        BH("BH"),
        BI("BI"),
        BJ("BJ"),
        BL("BL"),
        BM("BM"),
        BN("BN"),
        BO("BO"),
        BQ("BQ"),
        BR("BR"),
        BS("BS"),
        BT("BT"),
        BV("BV"),
        BW("BW"),
        BY("BY"),
        BZ("BZ"),
        CA("CA"),
        CC("CC"),
        CD("CD"),
        CF("CF"),
        CG("CG"),
        CH("CH"),
        CI("CI"),
        CK("CK"),
        CL("CL"),
        CM("CM"),
        CN("CN"),
        CO("CO"),
        CR("CR"),
        CU("CU"),
        CV("CV"),
        CW("CW"),
        CX("CX"),
        CY("CY"),
        CZ("CZ"),
        DE("DE"),
        DJ("DJ"),
        DK("DK"),
        DM("DM"),
        DO("DO"),
        DZ("DZ"),
        EC("EC"),
        EE("EE"),
        EG("EG"),
        EH("EH"),
        ER("ER"),
        ES("ES"),
        ET("ET"),
        FI("FI"),
        FJ("FJ"),
        FK("FK"),
        FM("FM"),
        FO("FO"),
        FR("FR"),
        GA("GA"),
        GB("GB"),
        GD("GD"),
        GE("GE"),
        GF("GF"),
        GG("GG"),
        GH("GH"),
        GI("GI"),
        GL("GL"),
        GM("GM"),
        GN("GN"),
        GP("GP"),
        GQ("GQ"),
        GR("GR"),
        GS("GS"),
        GT("GT"),
        GU("GU"),
        GW("GW"),
        GY("GY"),
        HK("HK"),
        HM("HM"),
        HN("HN"),
        HR("HR"),
        HT("HT"),
        HU("HU"),
        ID("ID"),
        IE("IE"),
        IL("IL"),
        IM("IM"),
        IN("IN"),
        IO("IO"),
        IQ("IQ"),
        IR("IR"),
        IS("IS"),
        IT("IT"),
        JE("JE"),
        JM("JM"),
        JO("JO"),
        JP("JP"),
        KE("KE"),
        KG("KG"),
        KH("KH"),
        KI("KI"),
        KM("KM"),
        KN("KN"),
        KP("KP"),
        KR("KR"),
        KW("KW"),
        KY("KY"),
        KZ("KZ"),
        LA("LA"),
        LB("LB"),
        LC("LC"),
        LI("LI"),
        LK("LK"),
        LR("LR"),
        LS("LS"),
        LT("LT"),
        LU("LU"),
        LV("LV"),
        LY("LY"),
        MA("MA"),
        MC("MC"),
        MD("MD"),
        ME("ME"),
        MF("MF"),
        MG("MG"),
        MH("MH"),
        MK("MK"),
        ML("ML"),
        MM("MM"),
        MN("MN"),
        MO("MO"),
        MP("MP"),
        MQ("MQ"),
        MR("MR"),
        MS("MS"),
        MT("MT"),
        MU("MU"),
        MV("MV"),
        MW("MW"),
        MX("MX"),
        MY("MY"),
        MZ("MZ"),
        NA("NA"),
        NC("NC"),
        NE("NE"),
        NF("NF"),
        NG("NG"),
        NI("NI"),
        NL("NL"),
        NO("NO"),
        NP("NP"),
        NR("NR"),
        NU("NU"),
        NZ("NZ"),
        OM("OM"),
        PA("PA"),
        PE("PE"),
        PF("PF"),
        PG("PG"),
        PH("PH"),
        PK("PK"),
        PL("PL"),
        PM("PM"),
        PN("PN"),
        PR("PR"),
        PS("PS"),
        PT("PT"),
        PW("PW"),
        PY("PY"),
        QA("QA"),
        RE("RE"),
        RO("RO"),
        RS("RS"),
        RU("RU"),
        RW("RW"),
        SA("SA"),
        SB("SB"),
        SC("SC"),
        SD("SD"),
        SE("SE"),
        SG("SG"),
        SH("SH"),
        SI("SI"),
        SJ("SJ"),
        SK("SK"),
        SL("SL"),
        SM("SM"),
        SN("SN"),
        SO("SO"),
        SR("SR"),
        SS("SS"),
        ST("ST"),
        SV("SV"),
        SX("SX"),
        SY("SY"),
        SZ("SZ"),
        TC("TC"),
        TD("TD"),
        TF("TF"),
        TG("TG"),
        TH("TH"),
        TJ("TJ"),
        TK("TK"),
        TL("TL"),
        TM("TM"),
        TN("TN"),
        TO("TO"),
        TR("TR"),
        TT("TT"),
        TV("TV"),
        TW("TW"),
        TZ("TZ"),
        UA("UA"),
        UG("UG"),
        UM("UM"),
        US("US"),
        UY("UY"),
        UZ("UZ"),
        VA("VA"),
        VC("VC"),
        VE("VE"),
        VG("VG"),
        VI("VI"),
        VN("VN"),
        VU("VU"),
        WF("WF"),
        WS("WS"),
        YE("YE"),
        YT("YT"),
        ZA("ZA"),
        ZM("ZM"),
        ZW("ZW");

        private final String value;
        private static final Map<String, GeoLocation> CONSTANTS;

        private GeoLocation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GeoLocation fromValue(String value) {
            GeoLocation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, GeoLocation>();
            for (GeoLocation c : GeoLocation.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SupportVersioning {
        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");

        private final String value;
        private static final Map<String, SupportVersioning> CONSTANTS;

        private SupportVersioning(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SupportVersioning fromValue(String value) {
            SupportVersioning constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SupportVersioning>();
            for (SupportVersioning c : SupportVersioning.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

