/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.projects;

import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.Search;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.persons.MockPersonRestService;
import org.damap.base.rest.projects.MockProjectRestService;
import org.damap.base.rest.projects.ProjectService;
import org.damap.base.rest.projects.ProjectSupplementDO;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@ApplicationScoped
@DefaultBean
public class MockProjectServiceImpl
implements ProjectService {
    @Inject
    @RestClient
    MockPersonRestService mockPersonRestService;
    @Inject
    @RestClient
    MockProjectRestService mockProjectRestService;

    @Override
    public List<ContributorDO> getProjectStaff(String projectId) {
        return this.mockPersonRestService.getContributorSearchResult();
    }

    @Override
    public ProjectSupplementDO getProjectSupplement(String projectId) {
        try {
            return this.mockProjectRestService.getProjectSupplement();
        }
        catch (ProcessingException pe) {
            return null;
        }
    }

    @Override
    public ContributorDO getProjectLeader(String projectId) {
        List<ContributorDO> response = this.mockPersonRestService.getContributorSearchResult();
        if (response.isEmpty()) {
            return null;
        }
        return response.get(0);
    }

    @Override
    public ResultList<ProjectDO> search(MultivaluedMap<String, String> queryParams) {
        Search search = Search.fromMap(queryParams);
        List<ProjectDO> items = this.mockProjectRestService.getProjectList(search.getQuery());
        return ResultList.fromItemsAndSearch(items, search);
    }

    @Override
    public ProjectDO read(String id, MultivaluedMap<String, String> queryParams) {
        List<ProjectDO> response = this.mockProjectRestService.getProjectDetails(id);
        if (response.isEmpty()) {
            return null;
        }
        return response.get(0);
    }

    @Override
    public ResultList<ProjectDO> getRecommended(MultivaluedMap<String, String> queryParams) {
        Search search = Search.fromMap(queryParams);
        List<ProjectDO> items = this.mockProjectRestService.getRecommended("recommend");
        return ResultList.fromItemsAndSearch(items, search);
    }
}

