/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.storage;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.damap.base.domain.InternalStorage;
import org.damap.base.repo.InternalStorageRepo;
import org.damap.base.rest.storage.InternalStorageDO;
import org.jboss.logging.Logger;

public final class InternalStorageValidator {
    @Generated
    private static final Logger log = Logger.getLogger(InternalStorageValidator.class);

    public static void validateForCreation(InternalStorageDO internalStorageDO) {
        try {
            URI.create(internalStorageDO.getUrl());
        }
        catch (IllegalArgumentException e) {
            throw new ClientErrorException("Invalid URL format", Response.Status.BAD_REQUEST);
        }
        if (internalStorageDO.getTranslations() == null || internalStorageDO.getTranslations().isEmpty()) {
            throw new ClientErrorException("Translations list cannot be null or empty, at least one translation needed", Response.Status.BAD_REQUEST);
        }
    }

    public static void validateForUpdate(String id, InternalStorageRepo internalStorageRepo, InternalStorageDO internalStorageDO) throws NotFoundException {
        try {
            URI.create(internalStorageDO.getUrl());
        }
        catch (IllegalArgumentException e) {
            throw new ClientErrorException("Invalid URL format", Response.Status.BAD_REQUEST);
        }
        InternalStorage internalStorage = (InternalStorage)((Object)internalStorageRepo.findById(Long.parseLong(id)));
        if (internalStorage == null) {
            throw new NotFoundException("No internal storage with ID " + id + " found");
        }
    }

    public static boolean storageIdExists(Long storageId) {
        return InternalStorage.findById((Object)storageId) != null;
    }

    public static MultivaluedMap<String, String> validateSearchParameters(MultivaluedMap<String, String> queryParams) {
        List<String> allowedParams = Arrays.asList("id", "url", "active", "storageLocation", "backupLocation");
        MultivaluedHashMap queryParamsChecked = new MultivaluedHashMap();
        queryParamsChecked.putAll(queryParams);
        queryParamsChecked.keySet().removeIf(key -> !allowedParams.contains(key));
        queryParamsChecked.values().removeIf(List::isEmpty);
        return queryParamsChecked;
    }

    @Generated
    private InternalStorageValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

