/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.security;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.Unremovable;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.HttpHeaders;
import java.security.Principal;
import lombok.Generated;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@Unremovable
@ApplicationScoped
@DefaultBean
public class SecurityService {
    @Generated
    private static final Logger log = Logger.getLogger(SecurityService.class);
    @Inject
    SecurityIdentity securityIdentity;
    @ConfigProperty(name="damap.auth.user")
    String authUser;
    @ConfigProperty(name="invenio.shared-secret")
    String sharedSecret;
    @Inject
    JWTParser parser;

    public String getUserId() {
        Principal principal = this.securityIdentity.getPrincipal();
        if (!(principal instanceof OidcJwtCallerPrincipal)) {
            return null;
        }
        return ((OidcJwtCallerPrincipal)principal).getClaims().getClaimValue(this.authUser).toString();
    }

    public String getUserName() {
        Principal principal = this.securityIdentity.getPrincipal();
        if (!(principal instanceof OidcJwtCallerPrincipal)) {
            return null;
        }
        return ((OidcJwtCallerPrincipal)principal).getName();
    }

    public String getDisplayName() {
        Principal principal = this.securityIdentity.getPrincipal();
        if (!(principal instanceof OidcJwtCallerPrincipal)) {
            return null;
        }
        OidcJwtCallerPrincipal oidcPrincipal = (OidcJwtCallerPrincipal)principal;
        String name = this.getClaimValueAsString(oidcPrincipal, "name");
        if (name != null) {
            return name;
        }
        String firstName = this.getClaimValueAsString(oidcPrincipal, "given_name");
        String lastName = this.getClaimValueAsString(oidcPrincipal, "family_name");
        if (firstName != null && lastName != null) {
            return firstName + " " + lastName;
        }
        return this.getClaimValueAsString(oidcPrincipal, "email");
    }

    private String getClaimValueAsString(OidcJwtCallerPrincipal oidcPrincipal, String claimKey) {
        Object claimValue = oidcPrincipal.getClaims().getClaimValue(claimKey);
        return claimValue != null ? claimValue.toString() : null;
    }

    public boolean isAdmin() {
        return this.securityIdentity.hasRole("Damap Admin");
    }

    public JsonWebToken validateAuthHeader(HttpHeaders headers) {
        String jwtToken = headers.getHeaderString("X-Auth");
        if (jwtToken != null && !jwtToken.isEmpty()) {
            try {
                JsonWebToken jwt = this.parser.verify(jwtToken, this.sharedSecret);
                long exp = jwt.getExpirationTime();
                long currentTime = System.currentTimeMillis() / 1000L;
                if (currentTime >= exp) {
                    throw new UnauthorizedException("Token expired.");
                }
                return jwt;
            }
            catch (ParseException e) {
                log.error((Object)"Failed to parse JWT: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public JsonWebToken checkIfUserIsAuthorized(HttpHeaders headers) {
        JsonWebToken jwt = this.validateAuthHeader(headers);
        if (jwt == null) {
            throw new UnauthorizedException("User unauthorized.");
        }
        return jwt;
    }
}

