/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.validation;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.damap.base.domain.Access;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Dmp;
import org.damap.base.enums.EFunctionRole;
import org.damap.base.repo.AccessRepo;
import org.damap.base.repo.DmpRepo;
import org.damap.base.rest.access.domain.AccessDO;
import org.damap.base.security.SecurityService;

@ApplicationScoped
public class AccessValidator {
    @Inject
    AccessRepo accessRepo;
    @Inject
    DmpRepo dmpRepo;
    @Inject
    SecurityService securityService;

    public boolean canViewDmp(long dmpId, String personId) {
        if (this.securityService.isAdmin()) {
            return true;
        }
        List<Access> accessList = this.accessRepo.getAllDmpByUniversityId(personId);
        Optional<Access> dmpAccess = accessList.stream().filter(access -> access.getDmp().id.equals(dmpId)).findAny();
        return dmpAccess.isPresent();
    }

    public boolean canEditDmp(long dmpId, String personId) {
        if (this.securityService.isAdmin()) {
            return true;
        }
        List<Access> accessList = this.accessRepo.getAllDmpByUniversityId(personId);
        Optional<Access> dmpAccess = accessList.stream().filter(access -> access.getDmp().id.equals(dmpId) && (access.getRole().equals((Object)EFunctionRole.EDITOR) || access.getRole().equals((Object)EFunctionRole.OWNER))).findAny();
        return dmpAccess.isPresent();
    }

    public boolean canExportDmp(long dmpId, String personId) {
        return this.canViewDmp(dmpId, personId);
    }

    public boolean canDeleteDmp(long dmpId, String personId) {
        if (this.securityService.isAdmin()) {
            return true;
        }
        List<Access> accessList = this.accessRepo.getAllDmpByUniversityId(personId);
        Optional<Access> dmpAccess = accessList.stream().filter(access -> access.getDmp().id.equals(dmpId) && access.getRole().equals((Object)EFunctionRole.OWNER)).findAny();
        return dmpAccess.isPresent();
    }

    public boolean canViewAccess(long dmpId) {
        if (this.securityService.isAdmin()) {
            return true;
        }
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(dmpId));
        if (dmp == null) {
            return false;
        }
        List<Access> accessList = this.accessRepo.getAccessByDmp(dmp);
        Optional<Access> dmpAccess = accessList.stream().filter(access -> access.getUniversityId().equals(this.securityService.getUserId()) && (access.getRole().equals((Object)EFunctionRole.EDITOR) || access.getRole().equals((Object)EFunctionRole.OWNER))).findAny();
        return dmpAccess.isPresent();
    }

    public boolean canCreateAccess(AccessDO accessDO) {
        if (accessDO.getAccess().equals((Object)EFunctionRole.OWNER)) {
            return false;
        }
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(accessDO.getDmpId()));
        if (dmp == null) {
            return false;
        }
        boolean hasPermission = this.securityService.isAdmin();
        if (!hasPermission) {
            List<Access> accessList = this.accessRepo.getAccessByDmp(dmp);
            Optional<Access> dmpAccess = accessList.stream().filter(access -> access.getUniversityId().equals(this.securityService.getUserId()) && (access.getRole().equals((Object)EFunctionRole.EDITOR) || access.getRole().equals((Object)EFunctionRole.OWNER))).findAny();
            hasPermission = dmpAccess.isPresent();
        }
        return this.canGetAccess(accessDO) && hasPermission;
    }

    public boolean canDeleteAccess(long id) {
        Access access = (Access)((Object)this.accessRepo.findById(id));
        if (access == null) {
            return true;
        }
        if (access.getRole().equals((Object)EFunctionRole.OWNER)) {
            return false;
        }
        if (this.securityService.isAdmin()) {
            return true;
        }
        List<Access> accessList = this.accessRepo.getAllDmpByUniversityId(this.securityService.getUserId());
        Optional<Access> dmpAccess = accessList.stream().filter(a -> a.getDmp().id.equals(access.getDmp().id) && (a.getRole().equals((Object)EFunctionRole.EDITOR) || a.getRole().equals((Object)EFunctionRole.OWNER))).findAny();
        return dmpAccess.isPresent();
    }

    public boolean canGetAccess(AccessDO accessDO) {
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(accessDO.getDmpId()));
        List<Object> contributors = dmp == null ? new ArrayList() : dmp.getContributorList();
        Optional<Contributor> contributor = contributors.stream().filter(c -> c.getUniversityId() != null && c.getUniversityId().equals(accessDO.getUniversityId())).findAny();
        return contributor.isPresent();
    }
}

