package org.danielnixon.saferdom.implicits.interop

import org.scalajs.dom.raw._
import org.danielnixon.saferdom.{raw => saferdom}

import scala.language.implicitConversions

/**
  * Implicit conversions from Scala.js DOM types to their equivalent Safer DOM types.
  */
package object fromscalajsdom {
  // lib
  implicit def xPathResult(value: XPathResult): saferdom.XPathResult = value.asInstanceOf[saferdom.XPathResult]
  implicit def xPathNSResolver(value: XPathNSResolver): saferdom.XPathNSResolver = value.asInstanceOf[saferdom.XPathNSResolver]
  implicit def positionOptions(value: PositionOptions): saferdom.PositionOptions = value.asInstanceOf[saferdom.PositionOptions]
  implicit def navigatorID(value: NavigatorID): saferdom.NavigatorID = value.asInstanceOf[saferdom.NavigatorID]
  implicit def treeWalker(value: TreeWalker): saferdom.TreeWalker = value.asInstanceOf[saferdom.TreeWalker]
  implicit def performance(value: Performance): saferdom.Performance = value.asInstanceOf[saferdom.Performance]
  implicit def compositionEvent(value: CompositionEvent): saferdom.CompositionEvent = value.asInstanceOf[saferdom.CompositionEvent]
  implicit def windowTimers(value: WindowTimers): saferdom.WindowTimers = value.asInstanceOf[saferdom.WindowTimers]
  implicit def navigator(value: Navigator): saferdom.Navigator = value.asInstanceOf[saferdom.Navigator]
  implicit def nodeSelector(value: NodeSelector): saferdom.NodeSelector = value.asInstanceOf[saferdom.NodeSelector]
  implicit def clientRect(value: ClientRect): saferdom.ClientRect = value.asInstanceOf[saferdom.ClientRect]
  implicit def domImplementation(value: DOMImplementation): saferdom.DOMImplementation = value.asInstanceOf[saferdom.DOMImplementation]
  implicit def parentNode(value: ParentNode): saferdom.ParentNode = value.asInstanceOf[saferdom.ParentNode]
  implicit def nonDocumentTypeChildNode(value: NonDocumentTypeChildNode): saferdom.NonDocumentTypeChildNode = value.asInstanceOf[saferdom.NonDocumentTypeChildNode]
  implicit def element(value: Element): saferdom.Element = value.asInstanceOf[saferdom.Element]
  implicit def node(value: Node): saferdom.Node = value.asInstanceOf[saferdom.Node]
  implicit def modifierKeyEvent(value: ModifierKeyEvent): saferdom.ModifierKeyEvent = value.asInstanceOf[saferdom.ModifierKeyEvent]
  implicit def hashChangeEvent(value: HashChangeEvent): saferdom.HashChangeEvent = value.asInstanceOf[saferdom.HashChangeEvent]
  implicit def mouseEvent(value: MouseEvent): saferdom.MouseEvent = value.asInstanceOf[saferdom.MouseEvent]
  implicit def textMetrics(value: TextMetrics): saferdom.TextMetrics = value.asInstanceOf[saferdom.TextMetrics]
  implicit def documentEvent(value: DocumentEvent): saferdom.DocumentEvent = value.asInstanceOf[saferdom.DocumentEvent]
  implicit def cDATASection(value: CDATASection): saferdom.CDATASection = value.asInstanceOf[saferdom.CDATASection]
  implicit def styleMedia(value: StyleMedia): saferdom.StyleMedia = value.asInstanceOf[saferdom.StyleMedia]
  implicit def selection(value: Selection): saferdom.Selection = value.asInstanceOf[saferdom.Selection]
  implicit def nodeIterator(value: NodeIterator): saferdom.NodeIterator = value.asInstanceOf[saferdom.NodeIterator]
  implicit def windowSessionStorage(value: WindowSessionStorage): saferdom.WindowSessionStorage = value.asInstanceOf[saferdom.WindowSessionStorage]
  implicit def window(value: Window): saferdom.Window = value.asInstanceOf[saferdom.Window]
  implicit def eventTarget(value: EventTarget): saferdom.EventTarget = value.asInstanceOf[saferdom.EventTarget]
  implicit def canvasGradient(value: CanvasGradient): saferdom.CanvasGradient = value.asInstanceOf[saferdom.CanvasGradient]
  implicit def touchEvent(value: TouchEvent): saferdom.TouchEvent = value.asInstanceOf[saferdom.TouchEvent]
  implicit def touchList(value: TouchList): saferdom.TouchList = value.asInstanceOf[saferdom.TouchList]
  implicit def touch(value: Touch): saferdom.Touch = value.asInstanceOf[saferdom.Touch]
  implicit def keyboardEvent(value: KeyboardEvent): saferdom.KeyboardEvent = value.asInstanceOf[saferdom.KeyboardEvent]
  implicit def document(value: Document): saferdom.Document = value.asInstanceOf[saferdom.Document]
  implicit def messageEvent(value: MessageEvent): saferdom.MessageEvent = value.asInstanceOf[saferdom.MessageEvent]
  implicit def canvasRenderingContext2D(value: CanvasRenderingContext2D): saferdom.CanvasRenderingContext2D = value.asInstanceOf[saferdom.CanvasRenderingContext2D]
  implicit def xmlHttpRequest(value: XMLHttpRequest): saferdom.XMLHttpRequest = value.asInstanceOf[saferdom.XMLHttpRequest]
  implicit def screen(value: Screen): saferdom.Screen = value.asInstanceOf[saferdom.Screen]
  implicit def coordinates(value: Coordinates): saferdom.Coordinates = value.asInstanceOf[saferdom.Coordinates]
  implicit def navigatorGeolocation(value: NavigatorGeolocation): saferdom.NavigatorGeolocation = value.asInstanceOf[saferdom.NavigatorGeolocation]
  implicit def navigatorContentUtils(value: NavigatorContentUtils): saferdom.NavigatorContentUtils = value.asInstanceOf[saferdom.NavigatorContentUtils]
  implicit def dataTransfer(value: DataTransfer): saferdom.DataTransfer = value.asInstanceOf[saferdom.DataTransfer]
  implicit def clipboardEventInit(value: ClipboardEventInit): saferdom.ClipboardEventInit = value.asInstanceOf[saferdom.ClipboardEventInit]
  implicit def clipboardEvent(value: ClipboardEvent): saferdom.ClipboardEvent = value.asInstanceOf[saferdom.ClipboardEvent]
  implicit def focusEvent(value: FocusEvent): saferdom.FocusEvent = value.asInstanceOf[saferdom.FocusEvent]
  implicit def range(value: Range): saferdom.Range = value.asInstanceOf[saferdom.Range]
  implicit def storage(value: Storage): saferdom.Storage = value.asInstanceOf[saferdom.Storage]
  implicit def documentType(value: DocumentType): saferdom.DocumentType = value.asInstanceOf[saferdom.DocumentType]
  implicit def mutationObserver(value: MutationObserver): saferdom.MutationObserver = value.asInstanceOf[saferdom.MutationObserver]
  implicit def mutationObserverInit(value: MutationObserverInit): saferdom.MutationObserverInit = value.asInstanceOf[saferdom.MutationObserverInit]
  implicit def mutationRecord(value: MutationRecord): saferdom.MutationRecord = value.asInstanceOf[saferdom.MutationRecord]
  implicit def dragEvent(value: DragEvent): saferdom.DragEvent = value.asInstanceOf[saferdom.DragEvent]
  implicit def performanceTiming(value: PerformanceTiming): saferdom.PerformanceTiming = value.asInstanceOf[saferdom.PerformanceTiming]
  implicit def eventException(value: EventException): saferdom.EventException = value.asInstanceOf[saferdom.EventException]
  implicit def navigatorOnLine(value: NavigatorOnLine): saferdom.NavigatorOnLine = value.asInstanceOf[saferdom.NavigatorOnLine]
  implicit def navigatorLanguage(value: NavigatorLanguage): saferdom.NavigatorLanguage = value.asInstanceOf[saferdom.NavigatorLanguage]
  implicit def windowLocalStorage(value: WindowLocalStorage): saferdom.WindowLocalStorage = value.asInstanceOf[saferdom.WindowLocalStorage]
  implicit def navigatorStorageUtils(value: NavigatorStorageUtils): saferdom.NavigatorStorageUtils = value.asInstanceOf[saferdom.NavigatorStorageUtils]
  implicit def location(value: Location): saferdom.Location = value.asInstanceOf[saferdom.Location]
  implicit def performanceEntry(value: PerformanceEntry): saferdom.PerformanceEntry = value.asInstanceOf[saferdom.PerformanceEntry]
  implicit def uiEvent(value: UIEvent): saferdom.UIEvent = value.asInstanceOf[saferdom.UIEvent]
  implicit def wheelEvent(value: WheelEvent): saferdom.WheelEvent = value.asInstanceOf[saferdom.WheelEvent]
  implicit def text(value: Text): saferdom.Text = value.asInstanceOf[saferdom.Text]
  implicit def positionError(value: PositionError): saferdom.PositionError = value.asInstanceOf[saferdom.PositionError]
  implicit def styleSheetList(value: StyleSheetList): saferdom.StyleSheetList = value.asInstanceOf[saferdom.StyleSheetList]
  implicit def customEvent(value: CustomEvent): saferdom.CustomEvent = value.asInstanceOf[saferdom.CustomEvent]
  implicit def geolocation(value: Geolocation): saferdom.Geolocation = value.asInstanceOf[saferdom.Geolocation]
  implicit def history(value: History): saferdom.History = value.asInstanceOf[saferdom.History]
  implicit def timeRanges(value: TimeRanges): saferdom.TimeRanges = value.asInstanceOf[saferdom.TimeRanges]
  implicit def beforeUnloadEvent(value: BeforeUnloadEvent): saferdom.BeforeUnloadEvent = value.asInstanceOf[saferdom.BeforeUnloadEvent]
  implicit def event(value: Event): saferdom.Event = value.asInstanceOf[saferdom.Event]
  implicit def imageData(value: ImageData): saferdom.ImageData = value.asInstanceOf[saferdom.ImageData]
  implicit def namedNodeMap(value: NamedNodeMap): saferdom.NamedNodeMap = value.asInstanceOf[saferdom.NamedNodeMap]
  implicit def mediaList(value: MediaList): saferdom.MediaList = value.asInstanceOf[saferdom.MediaList]
  implicit def processingInstruction(value: ProcessingInstruction): saferdom.ProcessingInstruction = value.asInstanceOf[saferdom.ProcessingInstruction]
  implicit def textEvent(value: TextEvent): saferdom.TextEvent = value.asInstanceOf[saferdom.TextEvent]
  implicit def documentFragment(value: DocumentFragment): saferdom.DocumentFragment = value.asInstanceOf[saferdom.DocumentFragment]
  implicit def position(value: Position): saferdom.Position = value.asInstanceOf[saferdom.Position]
  implicit def performanceMark(value: PerformanceMark): saferdom.PerformanceMark = value.asInstanceOf[saferdom.PerformanceMark]
  implicit def domParser(value: DOMParser): saferdom.DOMParser = value.asInstanceOf[saferdom.DOMParser]
  implicit def styleSheet(value: StyleSheet): saferdom.StyleSheet = value.asInstanceOf[saferdom.StyleSheet]
  implicit def domList[TSource, TDest](value: DOMList[TSource])(implicit ev: TSource => TDest): saferdom.DOMList[TDest] = value.asInstanceOf[saferdom.DOMList[TDest]]
  implicit def nodeList(value: NodeList): saferdom.NodeList = value.asInstanceOf[saferdom.NodeList]
  implicit def nodeListOf[TSourceNode <: Node, TDestNode <: saferdom.Node](value: NodeListOf[TSourceNode])(implicit ev: TSourceNode => TDestNode): saferdom.NodeListOf[TDestNode] = value.asInstanceOf[saferdom.NodeListOf[TDestNode]]
  implicit def xmlSerializer(value: XMLSerializer): saferdom.XMLSerializer = value.asInstanceOf[saferdom.XMLSerializer]
  implicit def performanceMeasure(value: PerformanceMeasure): saferdom.PerformanceMeasure = value.asInstanceOf[saferdom.PerformanceMeasure]
  implicit def nodeFilter(value: NodeFilter): saferdom.NodeFilter = value.asInstanceOf[saferdom.NodeFilter]
  implicit def mediaError(value: MediaError): saferdom.MediaError = value.asInstanceOf[saferdom.MediaError]
  implicit def comment(value: Comment): saferdom.Comment = value.asInstanceOf[saferdom.Comment]
  implicit def performanceResourceTiming(value: PerformanceResourceTiming): saferdom.PerformanceResourceTiming = value.asInstanceOf[saferdom.PerformanceResourceTiming]
  implicit def canvasPattern(value: CanvasPattern): saferdom.CanvasPattern = value.asInstanceOf[saferdom.CanvasPattern]
  implicit def storageEvent(value: StorageEvent): saferdom.StorageEvent = value.asInstanceOf[saferdom.StorageEvent]
  implicit def characterData(value: CharacterData): saferdom.CharacterData = value.asInstanceOf[saferdom.CharacterData]
  implicit def domException(value: DOMException): saferdom.DOMException = value.asInstanceOf[saferdom.DOMException]
  implicit def attr(value: Attr): saferdom.Attr = value.asInstanceOf[saferdom.Attr]
  implicit def performanceNavigation(value: PerformanceNavigation): saferdom.PerformanceNavigation = value.asInstanceOf[saferdom.PerformanceNavigation]
  implicit def linkStyle(value: LinkStyle): saferdom.LinkStyle = value.asInstanceOf[saferdom.LinkStyle]
  implicit def clientRectList(value: ClientRectList): saferdom.ClientRectList = value.asInstanceOf[saferdom.ClientRectList]
  implicit def external(value: External): saferdom.External = value.asInstanceOf[saferdom.External]
  implicit def errorEvent(value: ErrorEvent): saferdom.ErrorEvent = value.asInstanceOf[saferdom.ErrorEvent]
  implicit def trackEvent(value: TrackEvent): saferdom.TrackEvent = value.asInstanceOf[saferdom.TrackEvent]
  implicit def textTrackCue(value: TextTrackCue): saferdom.TextTrackCue = value.asInstanceOf[saferdom.TextTrackCue]
  implicit def domTokenList(value: DOMTokenList): saferdom.DOMTokenList = value.asInstanceOf[saferdom.DOMTokenList]
  implicit def messageChannel(value: MessageChannel): saferdom.MessageChannel = value.asInstanceOf[saferdom.MessageChannel]
  implicit def transitionEvent(value: TransitionEvent): saferdom.TransitionEvent = value.asInstanceOf[saferdom.TransitionEvent]
  implicit def mediaQueryList(value: MediaQueryList): saferdom.MediaQueryList = value.asInstanceOf[saferdom.MediaQueryList]
  implicit def domError(value: DOMError): saferdom.DOMError = value.asInstanceOf[saferdom.DOMError]
  implicit def closeEvent(value: CloseEvent): saferdom.CloseEvent = value.asInstanceOf[saferdom.CloseEvent]
  implicit def webSocket(value: WebSocket): saferdom.WebSocket = value.asInstanceOf[saferdom.WebSocket]
  implicit def eventSource(value: EventSource): saferdom.EventSource = value.asInstanceOf[saferdom.EventSource]
  implicit def progressEvent(value: ProgressEvent): saferdom.ProgressEvent = value.asInstanceOf[saferdom.ProgressEvent]
  implicit def fileList(value: FileList): saferdom.FileList = value.asInstanceOf[saferdom.FileList]
  implicit def file(value: File): saferdom.File = value.asInstanceOf[saferdom.File]
  implicit def xmlHttpRequestEventTarget(value: XMLHttpRequestEventTarget): saferdom.XMLHttpRequestEventTarget = value.asInstanceOf[saferdom.XMLHttpRequestEventTarget]
  implicit def audioTrackList(value: AudioTrackList): saferdom.AudioTrackList = value.asInstanceOf[saferdom.AudioTrackList]
  implicit def animationEvent(value: AnimationEvent): saferdom.AnimationEvent = value.asInstanceOf[saferdom.AnimationEvent]
  implicit def windowConsole(value: WindowConsole): saferdom.WindowConsole = value.asInstanceOf[saferdom.WindowConsole]
  implicit def audioTrack(value: AudioTrack): saferdom.AudioTrack = value.asInstanceOf[saferdom.AudioTrack]
  implicit def textTrackCueList(value: TextTrackCueList): saferdom.TextTrackCueList = value.asInstanceOf[saferdom.TextTrackCueList]
  implicit def textTrackList(value: TextTrackList): saferdom.TextTrackList = value.asInstanceOf[saferdom.TextTrackList]
  implicit def console(value: Console): saferdom.Console = value.asInstanceOf[saferdom.Console]
  implicit def windowBase64(value: WindowBase64): saferdom.WindowBase64 = value.asInstanceOf[saferdom.WindowBase64]
  implicit def domStringList(value: DOMStringList): saferdom.DOMStringList = value.asInstanceOf[saferdom.DOMStringList]
  implicit def textTrack(value: TextTrack): saferdom.TextTrack = value.asInstanceOf[saferdom.TextTrack]
  implicit def mediaQueryListListener(value: MediaQueryListListener): saferdom.MediaQueryListListener = value.asInstanceOf[saferdom.MediaQueryListListener]
  implicit def messagePort(value: MessagePort): saferdom.MessagePort = value.asInstanceOf[saferdom.MessagePort]
  implicit def fileReader(value: FileReader): saferdom.FileReader = value.asInstanceOf[saferdom.FileReader]
  implicit def blobPropertyBag(value: BlobPropertyBag): saferdom.BlobPropertyBag = value.asInstanceOf[saferdom.BlobPropertyBag]
  implicit def blob(value: Blob): saferdom.Blob = value.asInstanceOf[saferdom.Blob]
  implicit def applicationCache(value: ApplicationCache): saferdom.ApplicationCache = value.asInstanceOf[saferdom.ApplicationCache]
  implicit def popStateEvent(value: PopStateEvent): saferdom.PopStateEvent = value.asInstanceOf[saferdom.PopStateEvent]
  implicit def domSettableTokenList(value: DOMSettableTokenList): saferdom.DOMSettableTokenList = value.asInstanceOf[saferdom.DOMSettableTokenList]
  implicit def formData(value: FormData): saferdom.FormData = value.asInstanceOf[saferdom.FormData]
  implicit def validityState(value: ValidityState): saferdom.ValidityState = value.asInstanceOf[saferdom.ValidityState]
  implicit def pageVisibility(value: PageVisibility): saferdom.PageVisibility = value.asInstanceOf[saferdom.PageVisibility]
  implicit def visibilityState(value: VisibilityState): saferdom.VisibilityState = value.asInstanceOf[saferdom.VisibilityState]

  // html
  implicit def htmlDocument(value: HTMLDocument): saferdom.HTMLDocument = value.asInstanceOf[saferdom.HTMLDocument]
  implicit def htmlTableElement(value: HTMLTableElement): saferdom.HTMLTableElement = value.asInstanceOf[saferdom.HTMLTableElement]
  implicit def htmlTableDataCellElement(value: HTMLTableDataCellElement): saferdom.HTMLTableDataCellElement = value.asInstanceOf[saferdom.HTMLTableDataCellElement]
  implicit def htmlBaseElement(value: HTMLBaseElement): saferdom.HTMLBaseElement = value.asInstanceOf[saferdom.HTMLBaseElement]
  implicit def htmlParagraphElement(value: HTMLParagraphElement): saferdom.HTMLParagraphElement = value.asInstanceOf[saferdom.HTMLParagraphElement]
  implicit def htmlAreasCollection(value: HTMLAreasCollection): saferdom.HTMLAreasCollection = value.asInstanceOf[saferdom.HTMLAreasCollection]
  implicit def htmlOListElement(value: HTMLOListElement): saferdom.HTMLOListElement = value.asInstanceOf[saferdom.HTMLOListElement]
  implicit def htmlSelectElement(value: HTMLSelectElement): saferdom.HTMLSelectElement = value.asInstanceOf[saferdom.HTMLSelectElement]
  implicit def htmlBlockElement(value: HTMLBlockElement): saferdom.HTMLBlockElement = value.asInstanceOf[saferdom.HTMLBlockElement]
  implicit def htmlMetaElement(value: HTMLMetaElement): saferdom.HTMLMetaElement = value.asInstanceOf[saferdom.HTMLMetaElement]
  implicit def htmlDDElement(value: HTMLDDElement): saferdom.HTMLDDElement = value.asInstanceOf[saferdom.HTMLDDElement]
  implicit def htmlLinkElement(value: HTMLLinkElement): saferdom.HTMLLinkElement = value.asInstanceOf[saferdom.HTMLLinkElement]
  implicit def htmlTableCaptionElement(value: HTMLTableCaptionElement): saferdom.HTMLTableCaptionElement = value.asInstanceOf[saferdom.HTMLTableCaptionElement]
  implicit def htmlOptionElement(value: HTMLOptionElement): saferdom.HTMLOptionElement = value.asInstanceOf[saferdom.HTMLOptionElement]
  implicit def htmlMapElement(value: HTMLMapElement): saferdom.HTMLMapElement = value.asInstanceOf[saferdom.HTMLMapElement]
  implicit def htmlMenuElement(value: HTMLMenuElement): saferdom.HTMLMenuElement = value.asInstanceOf[saferdom.HTMLMenuElement]
  implicit def htmlCollection(value: HTMLCollection): saferdom.HTMLCollection = value.asInstanceOf[saferdom.HTMLCollection]
  implicit def htmlImageElement(value: HTMLImageElement): saferdom.HTMLImageElement = value.asInstanceOf[saferdom.HTMLImageElement]
  implicit def htmlAreaElement(value: HTMLAreaElement): saferdom.HTMLAreaElement = value.asInstanceOf[saferdom.HTMLAreaElement]
  implicit def htmlButtonElement(value: HTMLButtonElement): saferdom.HTMLButtonElement = value.asInstanceOf[saferdom.HTMLButtonElement]
  implicit def htmlSourceElement(value: HTMLSourceElement): saferdom.HTMLSourceElement = value.asInstanceOf[saferdom.HTMLSourceElement]
  implicit def htmlScriptElement(value: HTMLScriptElement): saferdom.HTMLScriptElement = value.asInstanceOf[saferdom.HTMLScriptElement]
  implicit def htmlTableRowElement(value: HTMLTableRowElement): saferdom.HTMLTableRowElement = value.asInstanceOf[saferdom.HTMLTableRowElement]
  implicit def htmlHtmlElement(value: HTMLHtmlElement): saferdom.HTMLHtmlElement = value.asInstanceOf[saferdom.HTMLHtmlElement]
  implicit def htmlQuoteElement(value: HTMLQuoteElement): saferdom.HTMLQuoteElement = value.asInstanceOf[saferdom.HTMLQuoteElement]
  implicit def htmlTableHeaderCellElement(value: HTMLTableHeaderCellElement): saferdom.HTMLTableHeaderCellElement = value.asInstanceOf[saferdom.HTMLTableHeaderCellElement]
  implicit def htmlDListElement(value: HTMLDListElement): saferdom.HTMLDListElement = value.asInstanceOf[saferdom.HTMLDListElement]
  implicit def htmlLabelElement(value: HTMLLabelElement): saferdom.HTMLLabelElement = value.asInstanceOf[saferdom.HTMLLabelElement]
  implicit def htmlLegendElement(value: HTMLLegendElement): saferdom.HTMLLegendElement = value.asInstanceOf[saferdom.HTMLLegendElement]
  implicit def htmlLIElement(value: HTMLLIElement): saferdom.HTMLLIElement = value.asInstanceOf[saferdom.HTMLLIElement]
  implicit def htmlIFrameElement(value: HTMLIFrameElement): saferdom.HTMLIFrameElement = value.asInstanceOf[saferdom.HTMLIFrameElement]
  implicit def htmlBodyElement(value: HTMLBodyElement): saferdom.HTMLBodyElement = value.asInstanceOf[saferdom.HTMLBodyElement]
  implicit def htmlTableSectionElement(value: HTMLTableSectionElement): saferdom.HTMLTableSectionElement = value.asInstanceOf[saferdom.HTMLTableSectionElement]
  implicit def htmlInputElement(value: HTMLInputElement): saferdom.HTMLInputElement = value.asInstanceOf[saferdom.HTMLInputElement]
  implicit def htmlAnchorElement(value: HTMLAnchorElement): saferdom.HTMLAnchorElement = value.asInstanceOf[saferdom.HTMLAnchorElement]
  implicit def htmlParamElement(value: HTMLParamElement): saferdom.HTMLParamElement = value.asInstanceOf[saferdom.HTMLParamElement]
  implicit def htmlPreElement(value: HTMLPreElement): saferdom.HTMLPreElement = value.asInstanceOf[saferdom.HTMLPreElement]
  implicit def htmlPhraseElement(value: HTMLPhraseElement): saferdom.HTMLPhraseElement = value.asInstanceOf[saferdom.HTMLPhraseElement]
  implicit def htmlCanvasElement(value: HTMLCanvasElement): saferdom.HTMLCanvasElement = value.asInstanceOf[saferdom.HTMLCanvasElement]
  implicit def htmlTitleElement(value: HTMLTitleElement): saferdom.HTMLTitleElement = value.asInstanceOf[saferdom.HTMLTitleElement]
  implicit def htmlStyleElement(value: HTMLStyleElement): saferdom.HTMLStyleElement = value.asInstanceOf[saferdom.HTMLStyleElement]
  implicit def htmlUnknownElement(value: HTMLUnknownElement): saferdom.HTMLUnknownElement = value.asInstanceOf[saferdom.HTMLUnknownElement]
  implicit def htmlAudioElement(value: HTMLAudioElement): saferdom.HTMLAudioElement = value.asInstanceOf[saferdom.HTMLAudioElement]
  implicit def htmlTableCellElement(value: HTMLTableCellElement): saferdom.HTMLTableCellElement = value.asInstanceOf[saferdom.HTMLTableCellElement]
  implicit def htmlTextAreaElement(value: HTMLTextAreaElement): saferdom.HTMLTextAreaElement = value.asInstanceOf[saferdom.HTMLTextAreaElement]
  implicit def htmlModElement(value: HTMLModElement): saferdom.HTMLModElement = value.asInstanceOf[saferdom.HTMLModElement]
  implicit def htmlTableColElement(value: HTMLTableColElement): saferdom.HTMLTableColElement = value.asInstanceOf[saferdom.HTMLTableColElement]
  implicit def htmlUListElement(value: HTMLUListElement): saferdom.HTMLUListElement = value.asInstanceOf[saferdom.HTMLUListElement]
  implicit def htmlDivElement(value: HTMLDivElement): saferdom.HTMLDivElement = value.asInstanceOf[saferdom.HTMLDivElement]
  implicit def htmlBRElement(value: HTMLBRElement): saferdom.HTMLBRElement = value.asInstanceOf[saferdom.HTMLBRElement]
  implicit def htmlMediaElement(value: HTMLMediaElement): saferdom.HTMLMediaElement = value.asInstanceOf[saferdom.HTMLMediaElement]
  implicit def htmlDTElement(value: HTMLDTElement): saferdom.HTMLDTElement = value.asInstanceOf[saferdom.HTMLDTElement]
  implicit def htmlFieldSetElement(value: HTMLFieldSetElement): saferdom.HTMLFieldSetElement = value.asInstanceOf[saferdom.HTMLFieldSetElement]
  implicit def htmlElement(value: HTMLElement): saferdom.HTMLElement = value.asInstanceOf[saferdom.HTMLElement]
  implicit def htmlHRElement(value: HTMLHRElement): saferdom.HTMLHRElement = value.asInstanceOf[saferdom.HTMLHRElement]
  implicit def htmlObjectElement(value: HTMLObjectElement): saferdom.HTMLObjectElement = value.asInstanceOf[saferdom.HTMLObjectElement]
  implicit def htmlEmbedElement(value: HTMLEmbedElement): saferdom.HTMLEmbedElement = value.asInstanceOf[saferdom.HTMLEmbedElement]
  implicit def htmlOptGroupElement(value: HTMLOptGroupElement): saferdom.HTMLOptGroupElement = value.asInstanceOf[saferdom.HTMLOptGroupElement]
  implicit def htmlVideoElement(value: HTMLVideoElement): saferdom.HTMLVideoElement = value.asInstanceOf[saferdom.HTMLVideoElement]
  implicit def htmlProgressElement(value: HTMLProgressElement): saferdom.HTMLProgressElement = value.asInstanceOf[saferdom.HTMLProgressElement]
  implicit def htmlDataListElement(value: HTMLDataListElement): saferdom.HTMLDataListElement = value.asInstanceOf[saferdom.HTMLDataListElement]
  implicit def htmlTrackElement(value: HTMLTrackElement): saferdom.HTMLTrackElement = value.asInstanceOf[saferdom.HTMLTrackElement]
  implicit def htmlSpanElement(value: HTMLSpanElement): saferdom.HTMLSpanElement = value.asInstanceOf[saferdom.HTMLSpanElement]
  implicit def htmlHeadElement(value: HTMLHeadElement): saferdom.HTMLHeadElement = value.asInstanceOf[saferdom.HTMLHeadElement]
  implicit def htmlHeadingElement(value: HTMLHeadingElement): saferdom.HTMLHeadingElement = value.asInstanceOf[saferdom.HTMLHeadingElement]
  implicit def htmlFormElement(value: HTMLFormElement): saferdom.HTMLFormElement = value.asInstanceOf[saferdom.HTMLFormElement]

  // css
  implicit def cssStyleDeclaration(value: CSSStyleDeclaration): saferdom.CSSStyleDeclaration = value.asInstanceOf[saferdom.CSSStyleDeclaration]
  implicit def cssStyleSheet(value: CSSStyleSheet): saferdom.CSSStyleSheet = value.asInstanceOf[saferdom.CSSStyleSheet]
  implicit def cssStyleRule(value: CSSStyleRule): saferdom.CSSStyleRule = value.asInstanceOf[saferdom.CSSStyleRule]
  implicit def cssMediaRule(value: CSSMediaRule): saferdom.CSSMediaRule = value.asInstanceOf[saferdom.CSSMediaRule]
  implicit def cssNamespaceRule(value: CSSNamespaceRule): saferdom.CSSNamespaceRule = value.asInstanceOf[saferdom.CSSNamespaceRule]
  implicit def cssImportRule(value: CSSImportRule): saferdom.CSSImportRule = value.asInstanceOf[saferdom.CSSImportRule]
  implicit def cssRule(value: CSSRule): saferdom.CSSRule = value.asInstanceOf[saferdom.CSSRule]
  implicit def cssFontFaceRule(value: CSSFontFaceRule): saferdom.CSSFontFaceRule = value.asInstanceOf[saferdom.CSSFontFaceRule]
  implicit def cssPageRule(value: CSSPageRule): saferdom.CSSPageRule = value.asInstanceOf[saferdom.CSSPageRule]
  implicit def cssRuleList(value: CSSRuleList): saferdom.CSSRuleList = value.asInstanceOf[saferdom.CSSRuleList]
  implicit def cssKeyframesRule(value: CSSKeyframesRule): saferdom.CSSKeyframesRule = value.asInstanceOf[saferdom.CSSKeyframesRule]
  implicit def cssKeyframeRule(value: CSSKeyframeRule): saferdom.CSSKeyframeRule = value.asInstanceOf[saferdom.CSSKeyframeRule]

  // TODO: idb, svg, webgl, webworkers, etc
}
