package org.danielnixon.saferdom.implicits.interop

import org.danielnixon.saferdom.raw._
import org.scalajs.dom.{raw => scalajsdom}

import scala.language.implicitConversions

/**
  * Implicit conversions from Safer DOM types to their equivalent Scala.js DOM types.
  */
package object toscalajsdom {
  // lib
  implicit def xPathResult(value: XPathResult): scalajsdom.XPathResult = value.asInstanceOf[scalajsdom.XPathResult]
  implicit def xPathNSResolver(value: XPathNSResolver): scalajsdom.XPathNSResolver = value.asInstanceOf[scalajsdom.XPathNSResolver]
  implicit def positionOptions(value: PositionOptions): scalajsdom.PositionOptions = value.asInstanceOf[scalajsdom.PositionOptions]
  implicit def navigatorID(value: NavigatorID): scalajsdom.NavigatorID = value.asInstanceOf[scalajsdom.NavigatorID]
  implicit def treeWalker(value: TreeWalker): scalajsdom.TreeWalker = value.asInstanceOf[scalajsdom.TreeWalker]
  implicit def performance(value: Performance): scalajsdom.Performance = value.asInstanceOf[scalajsdom.Performance]
  implicit def compositionEvent(value: CompositionEvent): scalajsdom.CompositionEvent = value.asInstanceOf[scalajsdom.CompositionEvent]
  implicit def windowTimers(value: WindowTimers): scalajsdom.WindowTimers = value.asInstanceOf[scalajsdom.WindowTimers]
  implicit def navigator(value: Navigator): scalajsdom.Navigator = value.asInstanceOf[scalajsdom.Navigator]
  implicit def nodeSelector(value: NodeSelector): scalajsdom.NodeSelector = value.asInstanceOf[scalajsdom.NodeSelector]
  implicit def clientRect(value: ClientRect): scalajsdom.ClientRect = value.asInstanceOf[scalajsdom.ClientRect]
  implicit def domImplementation(value: DOMImplementation): scalajsdom.DOMImplementation = value.asInstanceOf[scalajsdom.DOMImplementation]
  implicit def parentNode(value: ParentNode): scalajsdom.ParentNode = value.asInstanceOf[scalajsdom.ParentNode]
  implicit def nonDocumentTypeChildNode(value: NonDocumentTypeChildNode): scalajsdom.NonDocumentTypeChildNode = value.asInstanceOf[scalajsdom.NonDocumentTypeChildNode]
  implicit def element(value: Element): scalajsdom.Element = value.asInstanceOf[scalajsdom.Element]
  implicit def node(value: Node): scalajsdom.Node = value.asInstanceOf[scalajsdom.Node]
  implicit def modifierKeyEvent(value: ModifierKeyEvent): scalajsdom.ModifierKeyEvent = value.asInstanceOf[scalajsdom.ModifierKeyEvent]
  implicit def hashChangeEvent(value: HashChangeEvent): scalajsdom.HashChangeEvent = value.asInstanceOf[scalajsdom.HashChangeEvent]
  implicit def mouseEvent(value: MouseEvent): scalajsdom.MouseEvent = value.asInstanceOf[scalajsdom.MouseEvent]
  implicit def textMetrics(value: TextMetrics): scalajsdom.TextMetrics = value.asInstanceOf[scalajsdom.TextMetrics]
  implicit def documentEvent(value: DocumentEvent): scalajsdom.DocumentEvent = value.asInstanceOf[scalajsdom.DocumentEvent]
  implicit def cDATASection(value: CDATASection): scalajsdom.CDATASection = value.asInstanceOf[scalajsdom.CDATASection]
  implicit def styleMedia(value: StyleMedia): scalajsdom.StyleMedia = value.asInstanceOf[scalajsdom.StyleMedia]
  implicit def selection(value: Selection): scalajsdom.Selection = value.asInstanceOf[scalajsdom.Selection]
  implicit def nodeIterator(value: NodeIterator): scalajsdom.NodeIterator = value.asInstanceOf[scalajsdom.NodeIterator]
  implicit def windowSessionStorage(value: WindowSessionStorage): scalajsdom.WindowSessionStorage = value.asInstanceOf[scalajsdom.WindowSessionStorage]
  implicit def window(value: Window): scalajsdom.Window = value.asInstanceOf[scalajsdom.Window]
  implicit def eventTarget(value: EventTarget): scalajsdom.EventTarget = value.asInstanceOf[scalajsdom.EventTarget]
  implicit def canvasGradient(value: CanvasGradient): scalajsdom.CanvasGradient = value.asInstanceOf[scalajsdom.CanvasGradient]
  implicit def touchEvent(value: TouchEvent): scalajsdom.TouchEvent = value.asInstanceOf[scalajsdom.TouchEvent]
  implicit def touchList(value: TouchList): scalajsdom.TouchList = value.asInstanceOf[scalajsdom.TouchList]
  implicit def touch(value: Touch): scalajsdom.Touch = value.asInstanceOf[scalajsdom.Touch]
  implicit def keyboardEvent(value: KeyboardEvent): scalajsdom.KeyboardEvent = value.asInstanceOf[scalajsdom.KeyboardEvent]
  implicit def document(value: Document): scalajsdom.Document = value.asInstanceOf[scalajsdom.Document]
  implicit def messageEvent(value: MessageEvent): scalajsdom.MessageEvent = value.asInstanceOf[scalajsdom.MessageEvent]
  implicit def canvasRenderingContext2D(value: CanvasRenderingContext2D): scalajsdom.CanvasRenderingContext2D = value.asInstanceOf[scalajsdom.CanvasRenderingContext2D]
  implicit def xmlHttpRequest(value: XMLHttpRequest): scalajsdom.XMLHttpRequest = value.asInstanceOf[scalajsdom.XMLHttpRequest]
  implicit def screen(value: Screen): scalajsdom.Screen = value.asInstanceOf[scalajsdom.Screen]
  implicit def coordinates(value: Coordinates): scalajsdom.Coordinates = value.asInstanceOf[scalajsdom.Coordinates]
  implicit def navigatorGeolocation(value: NavigatorGeolocation): scalajsdom.NavigatorGeolocation = value.asInstanceOf[scalajsdom.NavigatorGeolocation]
  implicit def navigatorContentUtils(value: NavigatorContentUtils): scalajsdom.NavigatorContentUtils = value.asInstanceOf[scalajsdom.NavigatorContentUtils]
  implicit def dataTransfer(value: DataTransfer): scalajsdom.DataTransfer = value.asInstanceOf[scalajsdom.DataTransfer]
  implicit def clipboardEventInit(value: ClipboardEventInit): scalajsdom.ClipboardEventInit = value.asInstanceOf[scalajsdom.ClipboardEventInit]
  implicit def clipboardEvent(value: ClipboardEvent): scalajsdom.ClipboardEvent = value.asInstanceOf[scalajsdom.ClipboardEvent]
  implicit def focusEvent(value: FocusEvent): scalajsdom.FocusEvent = value.asInstanceOf[scalajsdom.FocusEvent]
  implicit def range(value: Range): scalajsdom.Range = value.asInstanceOf[scalajsdom.Range]
  implicit def storage(value: Storage): scalajsdom.Storage = value.asInstanceOf[scalajsdom.Storage]
  implicit def documentType(value: DocumentType): scalajsdom.DocumentType = value.asInstanceOf[scalajsdom.DocumentType]
  implicit def mutationObserver(value: MutationObserver): scalajsdom.MutationObserver = value.asInstanceOf[scalajsdom.MutationObserver]
  implicit def mutationObserverInit(value: MutationObserverInit): scalajsdom.MutationObserverInit = value.asInstanceOf[scalajsdom.MutationObserverInit]
  implicit def mutationRecord(value: MutationRecord): scalajsdom.MutationRecord = value.asInstanceOf[scalajsdom.MutationRecord]
  implicit def dragEvent(value: DragEvent): scalajsdom.DragEvent = value.asInstanceOf[scalajsdom.DragEvent]
  implicit def performanceTiming(value: PerformanceTiming): scalajsdom.PerformanceTiming = value.asInstanceOf[scalajsdom.PerformanceTiming]
  implicit def eventException(value: EventException): scalajsdom.EventException = value.asInstanceOf[scalajsdom.EventException]
  implicit def navigatorOnLine(value: NavigatorOnLine): scalajsdom.NavigatorOnLine = value.asInstanceOf[scalajsdom.NavigatorOnLine]
  implicit def navigatorLanguage(value: NavigatorLanguage): scalajsdom.NavigatorLanguage = value.asInstanceOf[scalajsdom.NavigatorLanguage]
  implicit def windowLocalStorage(value: WindowLocalStorage): scalajsdom.WindowLocalStorage = value.asInstanceOf[scalajsdom.WindowLocalStorage]
  implicit def navigatorStorageUtils(value: NavigatorStorageUtils): scalajsdom.NavigatorStorageUtils = value.asInstanceOf[scalajsdom.NavigatorStorageUtils]
  implicit def location(value: Location): scalajsdom.Location = value.asInstanceOf[scalajsdom.Location]
  implicit def performanceEntry(value: PerformanceEntry): scalajsdom.PerformanceEntry = value.asInstanceOf[scalajsdom.PerformanceEntry]
  implicit def uiEvent(value: UIEvent): scalajsdom.UIEvent = value.asInstanceOf[scalajsdom.UIEvent]
  implicit def wheelEvent(value: WheelEvent): scalajsdom.WheelEvent = value.asInstanceOf[scalajsdom.WheelEvent]
  implicit def text(value: Text): scalajsdom.Text = value.asInstanceOf[scalajsdom.Text]
  implicit def positionError(value: PositionError): scalajsdom.PositionError = value.asInstanceOf[scalajsdom.PositionError]
  implicit def styleSheetList(value: StyleSheetList): scalajsdom.StyleSheetList = value.asInstanceOf[scalajsdom.StyleSheetList]
  implicit def customEvent(value: CustomEvent): scalajsdom.CustomEvent = value.asInstanceOf[scalajsdom.CustomEvent]
  implicit def geolocation(value: Geolocation): scalajsdom.Geolocation = value.asInstanceOf[scalajsdom.Geolocation]
  implicit def history(value: History): scalajsdom.History = value.asInstanceOf[scalajsdom.History]
  implicit def timeRanges(value: TimeRanges): scalajsdom.TimeRanges = value.asInstanceOf[scalajsdom.TimeRanges]
  implicit def beforeUnloadEvent(value: BeforeUnloadEvent): scalajsdom.BeforeUnloadEvent = value.asInstanceOf[scalajsdom.BeforeUnloadEvent]
  implicit def event(value: Event): scalajsdom.Event = value.asInstanceOf[scalajsdom.Event]
  implicit def imageData(value: ImageData): scalajsdom.ImageData = value.asInstanceOf[scalajsdom.ImageData]
  implicit def namedNodeMap(value: NamedNodeMap): scalajsdom.NamedNodeMap = value.asInstanceOf[scalajsdom.NamedNodeMap]
  implicit def mediaList(value: MediaList): scalajsdom.MediaList = value.asInstanceOf[scalajsdom.MediaList]
  implicit def processingInstruction(value: ProcessingInstruction): scalajsdom.ProcessingInstruction = value.asInstanceOf[scalajsdom.ProcessingInstruction]
  implicit def textEvent(value: TextEvent): scalajsdom.TextEvent = value.asInstanceOf[scalajsdom.TextEvent]
  implicit def documentFragment(value: DocumentFragment): scalajsdom.DocumentFragment = value.asInstanceOf[scalajsdom.DocumentFragment]
  implicit def position(value: Position): scalajsdom.Position = value.asInstanceOf[scalajsdom.Position]
  implicit def performanceMark(value: PerformanceMark): scalajsdom.PerformanceMark = value.asInstanceOf[scalajsdom.PerformanceMark]
  implicit def domParser(value: DOMParser): scalajsdom.DOMParser = value.asInstanceOf[scalajsdom.DOMParser]
  implicit def styleSheet(value: StyleSheet): scalajsdom.StyleSheet = value.asInstanceOf[scalajsdom.StyleSheet]
  implicit def domList[TSource, TDest](value: DOMList[TSource])(implicit ev: TSource => TDest): scalajsdom.DOMList[TDest] = value.asInstanceOf[scalajsdom.DOMList[TDest]]
  implicit def nodeList(value: NodeList): scalajsdom.NodeList = value.asInstanceOf[scalajsdom.NodeList]
  implicit def nodeListOf[TSourceNode <: Node, TDestNode <: scalajsdom.Node](value: NodeListOf[TSourceNode])(implicit ev: TSourceNode => TDestNode): scalajsdom.NodeListOf[TDestNode] = value.asInstanceOf[scalajsdom.NodeListOf[TDestNode]]
  implicit def xmlSerializer(value: XMLSerializer): scalajsdom.XMLSerializer = value.asInstanceOf[scalajsdom.XMLSerializer]
  implicit def performanceMeasure(value: PerformanceMeasure): scalajsdom.PerformanceMeasure = value.asInstanceOf[scalajsdom.PerformanceMeasure]
  implicit def nodeFilter(value: NodeFilter): scalajsdom.NodeFilter = value.asInstanceOf[scalajsdom.NodeFilter]
  implicit def mediaError(value: MediaError): scalajsdom.MediaError = value.asInstanceOf[scalajsdom.MediaError]
  implicit def comment(value: Comment): scalajsdom.Comment = value.asInstanceOf[scalajsdom.Comment]
  implicit def performanceResourceTiming(value: PerformanceResourceTiming): scalajsdom.PerformanceResourceTiming = value.asInstanceOf[scalajsdom.PerformanceResourceTiming]
  implicit def canvasPattern(value: CanvasPattern): scalajsdom.CanvasPattern = value.asInstanceOf[scalajsdom.CanvasPattern]
  implicit def storageEvent(value: StorageEvent): scalajsdom.StorageEvent = value.asInstanceOf[scalajsdom.StorageEvent]
  implicit def characterData(value: CharacterData): scalajsdom.CharacterData = value.asInstanceOf[scalajsdom.CharacterData]
  implicit def domException(value: DOMException): scalajsdom.DOMException = value.asInstanceOf[scalajsdom.DOMException]
  implicit def attr(value: Attr): scalajsdom.Attr = value.asInstanceOf[scalajsdom.Attr]
  implicit def performanceNavigation(value: PerformanceNavigation): scalajsdom.PerformanceNavigation = value.asInstanceOf[scalajsdom.PerformanceNavigation]
  implicit def linkStyle(value: LinkStyle): scalajsdom.LinkStyle = value.asInstanceOf[scalajsdom.LinkStyle]
  implicit def clientRectList(value: ClientRectList): scalajsdom.ClientRectList = value.asInstanceOf[scalajsdom.ClientRectList]
  implicit def external(value: External): scalajsdom.External = value.asInstanceOf[scalajsdom.External]
  implicit def errorEvent(value: ErrorEvent): scalajsdom.ErrorEvent = value.asInstanceOf[scalajsdom.ErrorEvent]
  implicit def trackEvent(value: TrackEvent): scalajsdom.TrackEvent = value.asInstanceOf[scalajsdom.TrackEvent]
  implicit def textTrackCue(value: TextTrackCue): scalajsdom.TextTrackCue = value.asInstanceOf[scalajsdom.TextTrackCue]
  implicit def domTokenList(value: DOMTokenList): scalajsdom.DOMTokenList = value.asInstanceOf[scalajsdom.DOMTokenList]
  implicit def messageChannel(value: MessageChannel): scalajsdom.MessageChannel = value.asInstanceOf[scalajsdom.MessageChannel]
  implicit def transitionEvent(value: TransitionEvent): scalajsdom.TransitionEvent = value.asInstanceOf[scalajsdom.TransitionEvent]
  implicit def mediaQueryList(value: MediaQueryList): scalajsdom.MediaQueryList = value.asInstanceOf[scalajsdom.MediaQueryList]
  implicit def domError(value: DOMError): scalajsdom.DOMError = value.asInstanceOf[scalajsdom.DOMError]
  implicit def closeEvent(value: CloseEvent): scalajsdom.CloseEvent = value.asInstanceOf[scalajsdom.CloseEvent]
  implicit def webSocket(value: WebSocket): scalajsdom.WebSocket = value.asInstanceOf[scalajsdom.WebSocket]
  implicit def eventSource(value: EventSource): scalajsdom.EventSource = value.asInstanceOf[scalajsdom.EventSource]
  implicit def progressEvent(value: ProgressEvent): scalajsdom.ProgressEvent = value.asInstanceOf[scalajsdom.ProgressEvent]
  implicit def fileList(value: FileList): scalajsdom.FileList = value.asInstanceOf[scalajsdom.FileList]
  implicit def file(value: File): scalajsdom.File = value.asInstanceOf[scalajsdom.File]
  implicit def xmlHttpRequestEventTarget(value: XMLHttpRequestEventTarget): scalajsdom.XMLHttpRequestEventTarget = value.asInstanceOf[scalajsdom.XMLHttpRequestEventTarget]
  implicit def audioTrackList(value: AudioTrackList): scalajsdom.AudioTrackList = value.asInstanceOf[scalajsdom.AudioTrackList]
  implicit def animationEvent(value: AnimationEvent): scalajsdom.AnimationEvent = value.asInstanceOf[scalajsdom.AnimationEvent]
  implicit def windowConsole(value: WindowConsole): scalajsdom.WindowConsole = value.asInstanceOf[scalajsdom.WindowConsole]
  implicit def audioTrack(value: AudioTrack): scalajsdom.AudioTrack = value.asInstanceOf[scalajsdom.AudioTrack]
  implicit def textTrackCueList(value: TextTrackCueList): scalajsdom.TextTrackCueList = value.asInstanceOf[scalajsdom.TextTrackCueList]
  implicit def textTrackList(value: TextTrackList): scalajsdom.TextTrackList = value.asInstanceOf[scalajsdom.TextTrackList]
  implicit def console(value: Console): scalajsdom.Console = value.asInstanceOf[scalajsdom.Console]
  implicit def windowBase64(value: WindowBase64): scalajsdom.WindowBase64 = value.asInstanceOf[scalajsdom.WindowBase64]
  implicit def domStringList(value: DOMStringList): scalajsdom.DOMStringList = value.asInstanceOf[scalajsdom.DOMStringList]
  implicit def textTrack(value: TextTrack): scalajsdom.TextTrack = value.asInstanceOf[scalajsdom.TextTrack]
  implicit def mediaQueryListListener(value: MediaQueryListListener): scalajsdom.MediaQueryListListener = value.asInstanceOf[scalajsdom.MediaQueryListListener]
  implicit def messagePort(value: MessagePort): scalajsdom.MessagePort = value.asInstanceOf[scalajsdom.MessagePort]
  implicit def fileReader(value: FileReader): scalajsdom.FileReader = value.asInstanceOf[scalajsdom.FileReader]
  implicit def blobPropertyBag(value: BlobPropertyBag): scalajsdom.BlobPropertyBag = value.asInstanceOf[scalajsdom.BlobPropertyBag]
  implicit def blob(value: Blob): scalajsdom.Blob = value.asInstanceOf[scalajsdom.Blob]
  implicit def applicationCache(value: ApplicationCache): scalajsdom.ApplicationCache = value.asInstanceOf[scalajsdom.ApplicationCache]
  implicit def popStateEvent(value: PopStateEvent): scalajsdom.PopStateEvent = value.asInstanceOf[scalajsdom.PopStateEvent]
  implicit def domSettableTokenList(value: DOMSettableTokenList): scalajsdom.DOMSettableTokenList = value.asInstanceOf[scalajsdom.DOMSettableTokenList]
  implicit def formData(value: FormData): scalajsdom.FormData = value.asInstanceOf[scalajsdom.FormData]
  implicit def validityState(value: ValidityState): scalajsdom.ValidityState = value.asInstanceOf[scalajsdom.ValidityState]
  implicit def pageVisibility(value: PageVisibility): scalajsdom.PageVisibility = value.asInstanceOf[scalajsdom.PageVisibility]
  implicit def visibilityState(value: VisibilityState): scalajsdom.VisibilityState = value.asInstanceOf[scalajsdom.VisibilityState]

  // html
  implicit def htmlDocument(value: HTMLDocument): scalajsdom.HTMLDocument = value.asInstanceOf[scalajsdom.HTMLDocument]
  implicit def htmlTableElement(value: HTMLTableElement): scalajsdom.HTMLTableElement = value.asInstanceOf[scalajsdom.HTMLTableElement]
  implicit def htmlTableDataCellElement(value: HTMLTableDataCellElement): scalajsdom.HTMLTableDataCellElement = value.asInstanceOf[scalajsdom.HTMLTableDataCellElement]
  implicit def htmlBaseElement(value: HTMLBaseElement): scalajsdom.HTMLBaseElement = value.asInstanceOf[scalajsdom.HTMLBaseElement]
  implicit def htmlParagraphElement(value: HTMLParagraphElement): scalajsdom.HTMLParagraphElement = value.asInstanceOf[scalajsdom.HTMLParagraphElement]
  implicit def htmlAreasCollection(value: HTMLAreasCollection): scalajsdom.HTMLAreasCollection = value.asInstanceOf[scalajsdom.HTMLAreasCollection]
  implicit def htmlOListElement(value: HTMLOListElement): scalajsdom.HTMLOListElement = value.asInstanceOf[scalajsdom.HTMLOListElement]
  implicit def htmlSelectElement(value: HTMLSelectElement): scalajsdom.HTMLSelectElement = value.asInstanceOf[scalajsdom.HTMLSelectElement]
  implicit def htmlBlockElement(value: HTMLBlockElement): scalajsdom.HTMLBlockElement = value.asInstanceOf[scalajsdom.HTMLBlockElement]
  implicit def htmlMetaElement(value: HTMLMetaElement): scalajsdom.HTMLMetaElement = value.asInstanceOf[scalajsdom.HTMLMetaElement]
  implicit def htmlDDElement(value: HTMLDDElement): scalajsdom.HTMLDDElement = value.asInstanceOf[scalajsdom.HTMLDDElement]
  implicit def htmlLinkElement(value: HTMLLinkElement): scalajsdom.HTMLLinkElement = value.asInstanceOf[scalajsdom.HTMLLinkElement]
  implicit def htmlTableCaptionElement(value: HTMLTableCaptionElement): scalajsdom.HTMLTableCaptionElement = value.asInstanceOf[scalajsdom.HTMLTableCaptionElement]
  implicit def htmlOptionElement(value: HTMLOptionElement): scalajsdom.HTMLOptionElement = value.asInstanceOf[scalajsdom.HTMLOptionElement]
  implicit def htmlMapElement(value: HTMLMapElement): scalajsdom.HTMLMapElement = value.asInstanceOf[scalajsdom.HTMLMapElement]
  implicit def htmlMenuElement(value: HTMLMenuElement): scalajsdom.HTMLMenuElement = value.asInstanceOf[scalajsdom.HTMLMenuElement]
  implicit def htmlCollection(value: HTMLCollection): scalajsdom.HTMLCollection = value.asInstanceOf[scalajsdom.HTMLCollection]
  implicit def htmlImageElement(value: HTMLImageElement): scalajsdom.HTMLImageElement = value.asInstanceOf[scalajsdom.HTMLImageElement]
  implicit def htmlAreaElement(value: HTMLAreaElement): scalajsdom.HTMLAreaElement = value.asInstanceOf[scalajsdom.HTMLAreaElement]
  implicit def htmlButtonElement(value: HTMLButtonElement): scalajsdom.HTMLButtonElement = value.asInstanceOf[scalajsdom.HTMLButtonElement]
  implicit def htmlSourceElement(value: HTMLSourceElement): scalajsdom.HTMLSourceElement = value.asInstanceOf[scalajsdom.HTMLSourceElement]
  implicit def htmlScriptElement(value: HTMLScriptElement): scalajsdom.HTMLScriptElement = value.asInstanceOf[scalajsdom.HTMLScriptElement]
  implicit def htmlTableRowElement(value: HTMLTableRowElement): scalajsdom.HTMLTableRowElement = value.asInstanceOf[scalajsdom.HTMLTableRowElement]
  implicit def htmlHtmlElement(value: HTMLHtmlElement): scalajsdom.HTMLHtmlElement = value.asInstanceOf[scalajsdom.HTMLHtmlElement]
  implicit def htmlQuoteElement(value: HTMLQuoteElement): scalajsdom.HTMLQuoteElement = value.asInstanceOf[scalajsdom.HTMLQuoteElement]
  implicit def htmlTableHeaderCellElement(value: HTMLTableHeaderCellElement): scalajsdom.HTMLTableHeaderCellElement = value.asInstanceOf[scalajsdom.HTMLTableHeaderCellElement]
  implicit def htmlDListElement(value: HTMLDListElement): scalajsdom.HTMLDListElement = value.asInstanceOf[scalajsdom.HTMLDListElement]
  implicit def htmlLabelElement(value: HTMLLabelElement): scalajsdom.HTMLLabelElement = value.asInstanceOf[scalajsdom.HTMLLabelElement]
  implicit def htmlLegendElement(value: HTMLLegendElement): scalajsdom.HTMLLegendElement = value.asInstanceOf[scalajsdom.HTMLLegendElement]
  implicit def htmlLIElement(value: HTMLLIElement): scalajsdom.HTMLLIElement = value.asInstanceOf[scalajsdom.HTMLLIElement]
  implicit def htmlIFrameElement(value: HTMLIFrameElement): scalajsdom.HTMLIFrameElement = value.asInstanceOf[scalajsdom.HTMLIFrameElement]
  implicit def htmlBodyElement(value: HTMLBodyElement): scalajsdom.HTMLBodyElement = value.asInstanceOf[scalajsdom.HTMLBodyElement]
  implicit def htmlTableSectionElement(value: HTMLTableSectionElement): scalajsdom.HTMLTableSectionElement = value.asInstanceOf[scalajsdom.HTMLTableSectionElement]
  implicit def htmlInputElement(value: HTMLInputElement): scalajsdom.HTMLInputElement = value.asInstanceOf[scalajsdom.HTMLInputElement]
  implicit def htmlAnchorElement(value: HTMLAnchorElement): scalajsdom.HTMLAnchorElement = value.asInstanceOf[scalajsdom.HTMLAnchorElement]
  implicit def htmlParamElement(value: HTMLParamElement): scalajsdom.HTMLParamElement = value.asInstanceOf[scalajsdom.HTMLParamElement]
  implicit def htmlPreElement(value: HTMLPreElement): scalajsdom.HTMLPreElement = value.asInstanceOf[scalajsdom.HTMLPreElement]
  implicit def htmlPhraseElement(value: HTMLPhraseElement): scalajsdom.HTMLPhraseElement = value.asInstanceOf[scalajsdom.HTMLPhraseElement]
  implicit def htmlCanvasElement(value: HTMLCanvasElement): scalajsdom.HTMLCanvasElement = value.asInstanceOf[scalajsdom.HTMLCanvasElement]
  implicit def htmlTitleElement(value: HTMLTitleElement): scalajsdom.HTMLTitleElement = value.asInstanceOf[scalajsdom.HTMLTitleElement]
  implicit def htmlStyleElement(value: HTMLStyleElement): scalajsdom.HTMLStyleElement = value.asInstanceOf[scalajsdom.HTMLStyleElement]
  implicit def htmlUnknownElement(value: HTMLUnknownElement): scalajsdom.HTMLUnknownElement = value.asInstanceOf[scalajsdom.HTMLUnknownElement]
  implicit def htmlAudioElement(value: HTMLAudioElement): scalajsdom.HTMLAudioElement = value.asInstanceOf[scalajsdom.HTMLAudioElement]
  implicit def htmlTableCellElement(value: HTMLTableCellElement): scalajsdom.HTMLTableCellElement = value.asInstanceOf[scalajsdom.HTMLTableCellElement]
  implicit def htmlTextAreaElement(value: HTMLTextAreaElement): scalajsdom.HTMLTextAreaElement = value.asInstanceOf[scalajsdom.HTMLTextAreaElement]
  implicit def htmlModElement(value: HTMLModElement): scalajsdom.HTMLModElement = value.asInstanceOf[scalajsdom.HTMLModElement]
  implicit def htmlTableColElement(value: HTMLTableColElement): scalajsdom.HTMLTableColElement = value.asInstanceOf[scalajsdom.HTMLTableColElement]
  implicit def htmlUListElement(value: HTMLUListElement): scalajsdom.HTMLUListElement = value.asInstanceOf[scalajsdom.HTMLUListElement]
  implicit def htmlDivElement(value: HTMLDivElement): scalajsdom.HTMLDivElement = value.asInstanceOf[scalajsdom.HTMLDivElement]
  implicit def htmlBRElement(value: HTMLBRElement): scalajsdom.HTMLBRElement = value.asInstanceOf[scalajsdom.HTMLBRElement]
  implicit def htmlMediaElement(value: HTMLMediaElement): scalajsdom.HTMLMediaElement = value.asInstanceOf[scalajsdom.HTMLMediaElement]
  implicit def htmlDTElement(value: HTMLDTElement): scalajsdom.HTMLDTElement = value.asInstanceOf[scalajsdom.HTMLDTElement]
  implicit def htmlFieldSetElement(value: HTMLFieldSetElement): scalajsdom.HTMLFieldSetElement = value.asInstanceOf[scalajsdom.HTMLFieldSetElement]
  implicit def htmlElement(value: HTMLElement): scalajsdom.HTMLElement = value.asInstanceOf[scalajsdom.HTMLElement]
  implicit def htmlHRElement(value: HTMLHRElement): scalajsdom.HTMLHRElement = value.asInstanceOf[scalajsdom.HTMLHRElement]
  implicit def htmlObjectElement(value: HTMLObjectElement): scalajsdom.HTMLObjectElement = value.asInstanceOf[scalajsdom.HTMLObjectElement]
  implicit def htmlEmbedElement(value: HTMLEmbedElement): scalajsdom.HTMLEmbedElement = value.asInstanceOf[scalajsdom.HTMLEmbedElement]
  implicit def htmlOptGroupElement(value: HTMLOptGroupElement): scalajsdom.HTMLOptGroupElement = value.asInstanceOf[scalajsdom.HTMLOptGroupElement]
  implicit def htmlVideoElement(value: HTMLVideoElement): scalajsdom.HTMLVideoElement = value.asInstanceOf[scalajsdom.HTMLVideoElement]
  implicit def htmlProgressElement(value: HTMLProgressElement): scalajsdom.HTMLProgressElement = value.asInstanceOf[scalajsdom.HTMLProgressElement]
  implicit def htmlDataListElement(value: HTMLDataListElement): scalajsdom.HTMLDataListElement = value.asInstanceOf[scalajsdom.HTMLDataListElement]
  implicit def htmlTrackElement(value: HTMLTrackElement): scalajsdom.HTMLTrackElement = value.asInstanceOf[scalajsdom.HTMLTrackElement]
  implicit def htmlSpanElement(value: HTMLSpanElement): scalajsdom.HTMLSpanElement = value.asInstanceOf[scalajsdom.HTMLSpanElement]
  implicit def htmlHeadElement(value: HTMLHeadElement): scalajsdom.HTMLHeadElement = value.asInstanceOf[scalajsdom.HTMLHeadElement]
  implicit def htmlHeadingElement(value: HTMLHeadingElement): scalajsdom.HTMLHeadingElement = value.asInstanceOf[scalajsdom.HTMLHeadingElement]
  implicit def htmlFormElement(value: HTMLFormElement): scalajsdom.HTMLFormElement = value.asInstanceOf[scalajsdom.HTMLFormElement]

  // css
  implicit def cssStyleDeclaration(value: CSSStyleDeclaration): scalajsdom.CSSStyleDeclaration = value.asInstanceOf[scalajsdom.CSSStyleDeclaration]
  implicit def cssStyleSheet(value: CSSStyleSheet): scalajsdom.CSSStyleSheet = value.asInstanceOf[scalajsdom.CSSStyleSheet]
  implicit def cssStyleRule(value: CSSStyleRule): scalajsdom.CSSStyleRule = value.asInstanceOf[scalajsdom.CSSStyleRule]
  implicit def cssMediaRule(value: CSSMediaRule): scalajsdom.CSSMediaRule = value.asInstanceOf[scalajsdom.CSSMediaRule]
  implicit def cssNamespaceRule(value: CSSNamespaceRule): scalajsdom.CSSNamespaceRule = value.asInstanceOf[scalajsdom.CSSNamespaceRule]
  implicit def cssImportRule(value: CSSImportRule): scalajsdom.CSSImportRule = value.asInstanceOf[scalajsdom.CSSImportRule]
  implicit def cssRule(value: CSSRule): scalajsdom.CSSRule = value.asInstanceOf[scalajsdom.CSSRule]
  implicit def cssFontFaceRule(value: CSSFontFaceRule): scalajsdom.CSSFontFaceRule = value.asInstanceOf[scalajsdom.CSSFontFaceRule]
  implicit def cssPageRule(value: CSSPageRule): scalajsdom.CSSPageRule = value.asInstanceOf[scalajsdom.CSSPageRule]
  implicit def cssRuleList(value: CSSRuleList): scalajsdom.CSSRuleList = value.asInstanceOf[scalajsdom.CSSRuleList]
  implicit def cssKeyframesRule(value: CSSKeyframesRule): scalajsdom.CSSKeyframesRule = value.asInstanceOf[scalajsdom.CSSKeyframesRule]
  implicit def cssKeyframeRule(value: CSSKeyframeRule): scalajsdom.CSSKeyframeRule = value.asInstanceOf[scalajsdom.CSSKeyframeRule]

  // TODO: idb, svg, webgl, webworkers, etc
}
