/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.danilopianini.util.InputStreamIterator;

public final class Hashes {
    private static final Charset CHARSET = StandardCharsets.UTF_16;
    private static final HashFunction MURMUR128 = Hashing.murmur3_128();
    private static final HashFunction MURMUR32 = Hashing.murmur3_32();

    private Hashes() {
    }

    public static byte[] hash128(Object ... data) {
        return Hashes.hashcode(data).asBytes();
    }

    public static int hash32(CharSequence data) {
        return MURMUR32.hashString(data, CHARSET).asInt();
    }

    public static int hash32(double data) {
        return MURMUR32.hashLong(Double.doubleToRawLongBits(data)).asInt();
    }

    public static int hash32(Double data) {
        return Hashes.hash32((double)data);
    }

    public static int hash32(float data) {
        return MURMUR32.hashInt(Float.floatToRawIntBits(data)).asInt();
    }

    public static int hash32(Float data) {
        return Hashes.hash32(data.floatValue());
    }

    public static int hash32(Integer data) {
        return data;
    }

    public static int hash32(long data) {
        return MURMUR32.hashLong(data).asInt();
    }

    public static int hash32(Long data) {
        return Hashes.hash32((long)data);
    }

    public static int hash32(Object ... data) {
        Hasher h = MURMUR32.newHasher();
        if (data.length == 1) {
            Hashes.populateHasher(data[0], h);
        } else {
            Hashes.populateHasher(data, h);
        }
        return h.hash().asInt();
    }

    public static long hash64(CharSequence data) {
        return MURMUR128.hashString(data, CHARSET).asLong();
    }

    public static long hash64(double data) {
        return MURMUR128.hashLong(Double.doubleToRawLongBits(data)).asLong();
    }

    public static long hash64(Double data) {
        return Hashes.hash64((double)data);
    }

    public static long hash64(float data) {
        return Hashes.hash32(data);
    }

    public static long hash64(Float data) {
        return Hashes.hash32(data);
    }

    public static long hash64(Integer data) {
        return data.intValue();
    }

    public static long hash64(long data) {
        return MURMUR128.hashLong(data).asLong();
    }

    public static long hash64(Long data) {
        return Hashes.hash64((long)data);
    }

    public static long hash64(Object ... data) {
        return Hashes.hashcode(data).asLong();
    }

    private static HashCode hashcode(Object ... data) {
        Hasher h = MURMUR128.newHasher();
        if (data.length == 1) {
            Hashes.populateHasher(data[0], h);
        } else {
            Hashes.populateHasher(data, h);
        }
        return h.hash();
    }

    public static HashCode hashResource(File in, Consumer<IOException> onFailure) {
        return Hashes.hashResource(in.toPath(), onFailure);
    }

    public static HashCode hashResource(Path in, Consumer<IOException> onFailure) {
        return Hashes.hashcode(new InputStreamIterator(in, onFailure));
    }

    public static HashCode hashResource(URL in, Consumer<IOException> onFailure) {
        return Hashes.hashcode(new InputStreamIterator(in, onFailure));
    }

    private static void populateHasher(Object data, Hasher h) {
        if (data != null) {
            if (data instanceof Number) {
                Number d = (Number)data;
                if (data instanceof Integer) {
                    h.putInt(d.intValue());
                } else if (data instanceof Double) {
                    h.putDouble(d.doubleValue());
                } else if (data instanceof Long) {
                    h.putLong(d.longValue());
                } else if (data instanceof Float) {
                    h.putFloat(d.floatValue());
                } else if (data instanceof Byte) {
                    h.putByte(d.byteValue());
                } else if (data instanceof Short) {
                    h.putShort(d.shortValue());
                } else {
                    h.putInt(data.hashCode());
                }
            } else if (data instanceof CharSequence) {
                h.putString((CharSequence)data, CHARSET);
            } else if (data.getClass().isArray()) {
                int size = Array.getLength(data);
                for (int i = 0; i < size; ++i) {
                    Hashes.populateHasher(Array.get(data, i), h);
                }
            } else if (data instanceof Iterable) {
                for (Object o : (Iterable)data) {
                    Hashes.populateHasher(o, h);
                }
            } else {
                h.putInt(data.hashCode());
            }
        }
    }
}

