/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.lang;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class HashString
implements Cloneable,
Serializable,
Comparable<CharSequence>,
CharSequence {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final byte ENCODING_BASE = 36;
    private static final HashFunction HASHF = Hashing.murmur3_128();
    private static final long serialVersionUID = 1L;
    private String base;
    private byte[] hash;
    private int hash32;
    private final String s;

    public HashString(HashString string) {
        this.s = string.s;
        this.hash = string.hash;
        this.hash32 = string.hash32;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public HashString(String string) {
        this.s = Objects.requireNonNull(string);
    }

    @Override
    public char charAt(int index) {
        return this.s.charAt(index);
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public HashString clone() {
        return this;
    }

    @Override
    public int compareTo(CharSequence o) {
        return this.s.compareTo(o.toString());
    }

    private void computeHashes() {
        HashCode hashCode = HASHF.hashBytes(this.s.getBytes(CHARSET));
        this.hash32 = hashCode.asInt();
        this.hash = hashCode.asBytes();
    }

    public boolean equals(HashString fs) {
        return this.hashCode() == fs.hashCode() && this.s.length() == fs.s.length() && Arrays.equals(this.hash, fs.hash);
    }

    public boolean equals(Object o) {
        return o instanceof HashString && this.equals((HashString)o);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.computeHashes();
        }
        return this.hash32;
    }

    public String hashToString() {
        if (this.base == null) {
            int h32 = this.hashCode() > 0 ? this.hash32 : -(this.hash32 + 1);
            this.base = Integer.toString(h32, 36);
        }
        return this.base;
    }

    @Override
    public int length() {
        return this.s.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.s.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.s;
    }
}

