/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.util.stream;

import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class SmallestN<T>
implements Collector<T, MinMaxPriorityQueue<T>, MinMaxPriorityQueue<T>> {
    private static final Set<Collector.Characteristics> CHARACT = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.IDENTITY_FINISH}));
    private final int max;
    private final Comparator<T> comparator;

    public SmallestN(int maxElements) {
        this(maxElements, (Comparator<T>)Ordering.natural());
    }

    public SmallestN(int maxElements, Comparator<T> comparator) {
        this.max = maxElements;
        this.comparator = comparator;
    }

    @Override
    public Supplier<MinMaxPriorityQueue<T>> supplier() {
        return () -> MinMaxPriorityQueue.orderedBy(this.comparator).maximumSize(this.max).create();
    }

    @Override
    public BiConsumer<MinMaxPriorityQueue<T>, T> accumulator() {
        return (queue, e) -> queue.add(e);
    }

    @Override
    public BinaryOperator<MinMaxPriorityQueue<T>> combiner() {
        return (a, b) -> {
            a.addAll((Collection)b);
            return a;
        };
    }

    @Override
    public Function<MinMaxPriorityQueue<T>, MinMaxPriorityQueue<T>> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return CHARACT;
    }
}

