/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.WeekFields;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0012\u0010\f\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0014"}, d2={"Lde/saring/util/Date310Utils;", "", "()V", "dateToLocalDate", "Ljava/time/LocalDate;", "date", "Ljava/util/Date;", "dateToLocalDateTime", "Ljava/time/LocalDateTime;", "getMilliseconds", "", "dateTime", "getNoonDateTimeForDate", "getWeekNumber", "", "weekStartsSunday", "", "localDateTimeToDate", "localDateTimeToUnixTime", "localDateToDate", "de.saring.st-util"})
public final class Date310Utils {
    public static final Date310Utils INSTANCE;

    @JvmStatic
    @NotNull
    public static final LocalDateTime dateToLocalDateTime(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Instant instant = Instant.ofEpochMilli(date.getTime());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.ofInstant(\u2026, ZoneId.systemDefault())");
        return localDateTime;
    }

    @JvmStatic
    @NotNull
    public static final Date localDateTimeToDate(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
        Instant instant = dateTime.atZone(ZoneId.systemDefault()).toInstant();
        Date date = Date.from(instant);
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"Date.from(instant)");
        return date;
    }

    @JvmStatic
    @NotNull
    public static final LocalDate dateToLocalDate(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        LocalDate localDate = Date310Utils.dateToLocalDateTime(date).toLocalDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"dateToLocalDateTime(date).toLocalDate()");
        return localDate;
    }

    @JvmStatic
    @NotNull
    public static final Date localDateToDate(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        LocalDateTime localDateTime = date.atStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"date.atStartOfDay()");
        return Date310Utils.localDateTimeToDate(localDateTime);
    }

    @JvmStatic
    public static final int getWeekNumber(@NotNull LocalDate date, boolean weekStartsSunday) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        WeekFields weekField = weekStartsSunday ? WeekFields.SUNDAY_START : WeekFields.ISO;
        return date.get(weekField.weekOfWeekBasedYear());
    }

    @JvmStatic
    public static final long getMilliseconds(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
        return Date310Utils.localDateTimeToDate(dateTime).getTime();
    }

    @JvmStatic
    @NotNull
    public static final LocalDateTime getNoonDateTimeForDate(@Nullable LocalDate date) {
        LocalDate localDate = date;
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        LocalDate tempDate = localDate;
        LocalDateTime localDateTime = LocalDateTime.of(tempDate, LocalTime.of(12, 0));
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.of(tempDate, LocalTime.of(12, 0))");
        return localDateTime;
    }

    @JvmStatic
    public static final long localDateTimeToUnixTime(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
        Instant instant = dateTime.toInstant(ZoneOffset.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"dateTime.toInstant(ZoneOffset.UTC)");
        return instant.getEpochSecond();
    }

    private Date310Utils() {
    }

    static {
        Date310Utils date310Utils;
        INSTANCE = date310Utils = new Date310Utils();
    }
}

