/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lde/saring/util/SemanticVersion;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "de.saring.st-util"})
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    public static final Companion Companion = new Companion(null);

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int majorCompare = Intrinsics.compare((int)this.major, (int)other.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Intrinsics.compare((int)this.minor, (int)other.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        return Intrinsics.compare((int)this.patch, (int)other.patch);
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    public SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final SemanticVersion copy(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch);
    }

    public static /* synthetic */ SemanticVersion copy$default(SemanticVersion semanticVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semanticVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semanticVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semanticVersion.patch;
        }
        return semanticVersion.copy(n, n2, n3);
    }

    public int hashCode() {
        return (this.major * 31 + this.minor) * 31 + this.patch;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SemanticVersion)) break block3;
                SemanticVersion semanticVersion = (SemanticVersion)object;
                if (this.major != semanticVersion.major || this.minor != semanticVersion.minor || this.patch != semanticVersion.patch) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lde/saring/util/SemanticVersion$Companion;", "", "()V", "parse", "Lde/saring/util/SemanticVersion;", "version", "", "de.saring.st-util"})
    public static final class Companion {
        @NotNull
        public final SemanticVersion parse(@NotNull String version) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            List versionParts = StringsKt.split$default((CharSequence)version, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
            if (versionParts.size() != 3) {
                throw (Throwable)new IllegalArgumentException("Invalid version number '" + version + "', needs to consist of 3 parts!");
            }
            try {
                int n;
                object = (String)versionParts.get(0);
                boolean bl = false;
                int n2 = Integer.parseInt((String)object);
                object = (String)versionParts.get(1);
                bl = false;
                int n3 = Integer.parseInt((String)object);
                object = (String)versionParts.get(2);
                bl = false;
                int n4 = n = Integer.parseInt((String)object);
                int n5 = n3;
                int n6 = n2;
                object = new SemanticVersion(n6, n5, n4);
            }
            catch (NumberFormatException nfe) {
                throw (Throwable)new IllegalArgumentException("Invalid version number '" + version + "', the parts are not valid numbers!");
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

