/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util;

import de.saring.util.unitcalc.SpeedToStringConverter;
import de.saring.util.unitcalc.TimeUtils;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\"\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\"\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\"\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\u0012"}, d2={"Lde/saring/util/ValidationUtils;", "", "()V", "isOptionalValueIntegerBetween", "", "value", "", "minValue", "", "maxValue", "isValueDoubleBetween", "", "isValueIntegerBetween", "isValueSpeed", "speedConverter", "Lde/saring/util/unitcalc/SpeedToStringConverter;", "required", "isValueTimeInSecondsBetween", "de.saring.st-util"})
public final class ValidationUtils {
    public static final ValidationUtils INSTANCE;

    @JvmStatic
    public static final boolean isValueIntegerBetween(@Nullable String value, int minValue, int maxValue) {
        boolean bl;
        try {
            int intValue = NumberFormat.getIntegerInstance().parse(value).intValue();
            int n = intValue;
            bl = minValue <= n && maxValue >= n;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isOptionalValueIntegerBetween(@Nullable String value, int minValue, int maxValue) {
        block3: {
            block2: {
                if (value == null) break block2;
                CharSequence charSequence = value;
                boolean bl = false;
                charSequence = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return true;
        }
        return ValidationUtils.isValueIntegerBetween(value, minValue, maxValue);
    }

    @JvmStatic
    public static final boolean isValueDoubleBetween(@Nullable String value, double minValue, double maxValue) {
        boolean bl;
        try {
            double doubleValue;
            double d = doubleValue = NumberFormat.getInstance().parse(value).doubleValue();
            bl = d >= minValue && d <= maxValue;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isValueTimeInSecondsBetween(@Nullable String value, int minValue, int maxValue) {
        int seconds = TimeUtils.timeString2TotalSeconds(value);
        int n = seconds;
        return minValue <= n && maxValue >= n;
    }

    @JvmStatic
    public static final boolean isValueSpeed(@Nullable String value, @NotNull SpeedToStringConverter speedConverter, boolean required) {
        Intrinsics.checkParameterIsNotNull((Object)speedConverter, (String)"speedConverter");
        Float fSpeedValue = speedConverter.stringSpeedToFloat(value);
        if (required) {
            return fSpeedValue != null && fSpeedValue.floatValue() > 0.0f;
        }
        return fSpeedValue != null && Intrinsics.areEqual((Float)fSpeedValue, (float)0.0f);
    }

    private ValidationUtils() {
    }

    static {
        ValidationUtils validationUtils;
        INSTANCE = validationUtils = new ValidationUtils();
    }
}

