/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;

public final class FxmlLoader {
    private FxmlLoader() {
    }

    public static Parent load(URL url, ResourceBundle resBundle, Object controller) throws IOException {
        Objects.requireNonNull(url);
        Objects.requireNonNull(controller);
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(url);
        loader.setResources(resBundle);
        loader.setControllerFactory(controllerClass -> {
            if (controllerClass != null && !controllerClass.isInstance(controller)) {
                throw new IllegalArgumentException("Invalid controller instance, expecting instance of class '" + controllerClass.getName() + "'!");
            }
            return controller;
        });
        return (Parent)loader.load();
    }
}

