/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class LocalDateCellFactory<T>
implements Callback<TableColumn<T, LocalDateTime>, TableCell<T, LocalDateTime>> {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    public TableCell<T, LocalDateTime> call(TableColumn<T, LocalDateTime> column) {
        return new TableCell<T, LocalDateTime>(){

            protected void updateItem(LocalDateTime value, boolean empty) {
                super.updateItem((Object)value, empty);
                this.setText(LocalDateCellFactory.this.getCellText(value, empty));
            }
        };
    }

    protected String getCellText(LocalDateTime value, boolean empty) {
        return empty || value == null ? null : value.toLocalDate().format(this.dateTimeFormatter);
    }
}

