/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx;

import java.text.NumberFormat;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class NumberCellFactory<T>
implements Callback<TableColumn<T, Number>, TableCell<T, Number>> {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();

    public TableCell<T, Number> call(TableColumn<T, Number> column) {
        return new TableCell<T, Number>(){

            protected void updateItem(Number value, boolean empty) {
                super.updateItem((Object)value, empty);
                this.setText(empty || value == null ? null : NUMBER_FORMAT.format(value));
            }
        };
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(3);
    }
}

