/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx;

import java.util.prefs.Preferences;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public final class WindowBoundsPersistence {
    private static final String PATH_PREFIX = "/de/saring/util/gui/javafx/WindowBoundsPersistence/";
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_HEIGHT = "height";

    private WindowBoundsPersistence() {
    }

    public static void addWindowBoundsPersistence(Window window, String identifier) {
        window.addEventHandler(WindowEvent.WINDOW_SHOWING, event -> WindowBoundsPersistence.restoreWindowBounds(window, identifier));
        window.addEventHandler(WindowEvent.WINDOW_HIDING, event -> WindowBoundsPersistence.storeWindowBounds(window, identifier));
    }

    private static void restoreWindowBounds(Window window, String identifier) {
        boolean validPreviousBounds;
        Preferences preferences = WindowBoundsPersistence.getPreferences(identifier);
        double previousX = preferences.getDouble(KEY_X, Double.MAX_VALUE);
        double previousY = preferences.getDouble(KEY_Y, Double.MAX_VALUE);
        double previousWidth = preferences.getDouble(KEY_WIDTH, Double.MAX_VALUE);
        double previousHeight = preferences.getDouble(KEY_HEIGHT, Double.MAX_VALUE);
        boolean bl = validPreviousBounds = previousX != Double.MAX_VALUE && previousY != Double.MAX_VALUE && previousWidth != Double.MAX_VALUE && previousHeight != Double.MAX_VALUE;
        if (validPreviousBounds) {
            Rectangle2D visualScreenBounds = Screen.getPrimary().getVisualBounds();
            window.setX(Math.max(0.0, Math.min(visualScreenBounds.getWidth() - 100.0, previousX)));
            window.setY(Math.max(0.0, Math.min(visualScreenBounds.getHeight() - 100.0, previousY)));
            window.setWidth(Math.min(visualScreenBounds.getWidth(), previousWidth));
            window.setHeight(Math.min(visualScreenBounds.getHeight(), previousHeight));
        }
    }

    private static void storeWindowBounds(Window window, String identifier) {
        Preferences preferences = WindowBoundsPersistence.getPreferences(identifier);
        preferences.putDouble(KEY_X, window.getX());
        preferences.putDouble(KEY_Y, window.getY());
        preferences.putDouble(KEY_WIDTH, window.getWidth());
        preferences.putDouble(KEY_HEIGHT, window.getHeight());
    }

    private static Preferences getPreferences(String identifier) {
        return Preferences.userRoot().node(PATH_PREFIX + identifier);
    }
}

