/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx.control.calendar;

import de.saring.util.data.IdObject;
import de.saring.util.gui.javafx.control.calendar.CalendarActionListener;
import de.saring.util.gui.javafx.control.calendar.CalendarDataProvider;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;

public class CalendarControl
extends Control {
    static final int GRIDS_COLUMN_COUNT = 8;
    static final int GRID_DAYS_ROW_COUNT = 6;
    private static final String[] DEFAULT_COLUMN_NAMES = new String[]{"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su", "Sum"};
    private String[] columnNames;
    private ObjectProperty<CalendarDate> displayedDate = new SimpleObjectProperty();
    private CalendarDataProvider calendarDataProvider;
    private ObjectProperty<CalendarActionListener> calendarActionListener = new SimpleObjectProperty();
    private ObjectProperty<IdObject> selectedEntry = new SimpleObjectProperty();
    private ObjectProperty<LocalDate> dateOfContextMenu = new SimpleObjectProperty();
    private CalendarSelector calendarSelector;

    public CalendarControl() {
        this.getStyleClass().add((Object)"calendar-control");
        LocalDate today = LocalDate.now();
        this.displayedDate.set((Object)new CalendarDate(today.getYear(), today.getMonthValue(), false));
    }

    public String[] getColumnNames() {
        return this.columnNames == null ? DEFAULT_COLUMN_NAMES : this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        if (columnNames != null && columnNames.length != 8) {
            throw new IllegalArgumentException("Array must contain names for 8 columns!");
        }
        this.columnNames = columnNames;
    }

    public ObjectProperty<CalendarDate> displayedDateProperty() {
        return this.displayedDate;
    }

    public CalendarDataProvider getCalendarDataProvider() {
        return this.calendarDataProvider;
    }

    public void setCalendarDataProvider(CalendarDataProvider calendarDataProvider) {
        this.calendarDataProvider = calendarDataProvider;
    }

    public void updateCalendar(int year, int month, boolean weekStartsSunday) {
        this.selectedEntry.set(null);
        this.displayedDate.set((Object)new CalendarDate(year, month, weekStartsSunday));
    }

    public void selectEntry(IdObject entry) {
        if (this.calendarSelector != null) {
            this.calendarSelector.selectEntry(entry);
        }
    }

    public void removeSelection() {
        if (this.calendarSelector != null) {
            this.calendarSelector.removeSelection();
        }
    }

    public ObjectProperty<IdObject> selectedEntryProperty() {
        return this.selectedEntry;
    }

    public ObjectProperty<CalendarActionListener> calendarActionListenerProperty() {
        return this.calendarActionListener;
    }

    public ObjectProperty<LocalDate> dateOfContextMenuProperty() {
        return this.dateOfContextMenu;
    }

    public LocalDate getFirstDisplayedDay() {
        LocalDate firstDayOfMonth = LocalDate.of(((CalendarDate)this.displayedDate.get()).getYear(), ((CalendarDate)this.displayedDate.get()).getMonth(), 1);
        return firstDayOfMonth.with(TemporalAdjusters.previousOrSame(((CalendarDate)this.displayedDate.get()).isWeekStartsSunday() ? DayOfWeek.SUNDAY : DayOfWeek.MONDAY));
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("CalendarControl.css").toExternalForm();
    }

    public void setCalendarSelector(CalendarSelector calendarSelector) {
        this.calendarSelector = calendarSelector;
    }

    static interface CalendarSelector {
        public void selectEntry(IdObject var1);

        public void removeSelection();
    }

    static class CalendarDate {
        private int year;
        private int month;
        private boolean weekStartsSunday;

        public CalendarDate(int year, int month, boolean weekStartsSunday) {
            this.year = year;
            this.month = month;
            this.weekStartsSunday = weekStartsSunday;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public boolean isWeekStartsSunday() {
            return this.weekStartsSunday;
        }
    }
}

