/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx.control.calendar;

import de.saring.util.Date310Utils;
import de.saring.util.data.IdObject;
import de.saring.util.gui.javafx.control.calendar.CalendarActionListener;
import de.saring.util.gui.javafx.control.calendar.CalendarControl;
import de.saring.util.gui.javafx.control.calendar.CalendarDataProvider;
import de.saring.util.gui.javafx.control.calendar.CalendarDayCell;
import de.saring.util.gui.javafx.control.calendar.CalendarEntry;
import de.saring.util.gui.javafx.control.calendar.CalendarHeaderCell;
import de.saring.util.gui.javafx.control.calendar.CalendarSummaryCell;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class CalendarControlSkin
extends SkinBase<CalendarControl>
implements CalendarControl.CalendarSelector {
    private VBox controlRoot;
    private GridPane gridHeaderCells;
    private GridPane gridDayCells;
    private CalendarHeaderCell[] headerCells = new CalendarHeaderCell[8];
    private CalendarDayCell[] dayCells = new CalendarDayCell[42];
    private CalendarSummaryCell[] summaryCells = new CalendarSummaryCell[6];

    public CalendarControlSkin(CalendarControl calendarControl) {
        super((Control)calendarControl);
        calendarControl.setCalendarSelector(this);
        this.setupLayout();
        this.setupListeners();
        this.updateContent();
    }

    @Override
    public void selectEntry(IdObject entry) {
        for (CalendarDayCell dayCell : this.dayCells) {
            if (dayCell.selectEntry(entry)) break;
        }
    }

    @Override
    public void removeSelection() {
        Stream.of(this.dayCells).forEach(dayCell -> dayCell.removeSelectionExcept(null));
    }

    private void setupLayout() {
        CalendarDayCell dayCell;
        int row;
        this.gridHeaderCells = new GridPane();
        this.gridDayCells = new GridPane();
        for (int column = 0; column < 8; ++column) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setPercentWidth(12.5);
            this.gridHeaderCells.getColumnConstraints().add((Object)columnConstraints);
            this.gridDayCells.getColumnConstraints().add((Object)columnConstraints);
        }
        RowConstraints headerRowConstraints = new RowConstraints();
        this.gridHeaderCells.getRowConstraints().add((Object)headerRowConstraints);
        for (row = 0; row < 6; ++row) {
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setValignment(VPos.TOP);
            rowConstraints.setPercentHeight(16.666666666666668);
            rowConstraints.setMinHeight(45.0);
            this.gridDayCells.getRowConstraints().add((Object)rowConstraints);
        }
        for (int i = 0; i < this.headerCells.length; ++i) {
            this.headerCells[i] = new CalendarHeaderCell();
            this.gridHeaderCells.add((Node)this.headerCells[i], i, 0);
        }
        for (row = 0; row < 6; ++row) {
            for (int column = 0; column < 7; ++column) {
                this.dayCells[row * 7 + column] = dayCell = new CalendarDayCell();
                this.gridDayCells.add((Node)dayCell, column, row);
            }
        }
        for (row = 0; row < 6; ++row) {
            for (int column = 0; column < 7; ++column) {
                this.dayCells[row * 7 + column] = dayCell = new CalendarDayCell();
                this.gridDayCells.add((Node)dayCell, column, row);
            }
        }
        for (row = 0; row < this.summaryCells.length; ++row) {
            CalendarSummaryCell summaryCell;
            this.summaryCells[row] = summaryCell = new CalendarSummaryCell();
            this.gridDayCells.add((Node)summaryCell, 7, row);
        }
        this.controlRoot = new VBox();
        this.getChildren().add((Object)this.controlRoot);
        VBox.setVgrow((Node)this.gridHeaderCells, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)this.gridDayCells, (Priority)Priority.ALWAYS);
        this.controlRoot.getChildren().addAll((Object[])new Node[]{this.gridHeaderCells, this.gridDayCells});
        Rectangle rootClip = new Rectangle();
        rootClip.widthProperty().bind((ObservableValue)this.controlRoot.widthProperty());
        rootClip.heightProperty().bind((ObservableValue)this.controlRoot.heightProperty());
        this.controlRoot.setClip((Node)rootClip);
    }

    private void setupListeners() {
        ((CalendarControl)this.getSkinnable()).displayedDateProperty().addListener((observable, oldValue, newValue) -> this.updateContent());
        this.setCalendarActionListenerInDayCells((CalendarActionListener)((CalendarControl)this.getSkinnable()).calendarActionListenerProperty().get());
        ((CalendarControl)this.getSkinnable()).calendarActionListenerProperty().addListener((observable, oldValue, newValue) -> this.setCalendarActionListenerInDayCells((CalendarActionListener)newValue));
        CalendarDayCell.CalendarEntrySelectionListener listener = (calendarEntry, selected) -> {
            if (selected) {
                Stream.of(this.dayCells).forEach(dayCell -> dayCell.removeSelectionExcept(calendarEntry));
            }
            ((CalendarControl)this.getSkinnable()).selectedEntryProperty().set((Object)(selected ? calendarEntry.getEntry() : null));
        };
        EventHandler dayCellPressedHandler = event -> this.removeSelection();
        Stream.of(this.dayCells).forEach(dayCell -> {
            dayCell.setCalendarEntrySelectionListener(listener);
            dayCell.addEventHandler(MouseEvent.MOUSE_PRESSED, dayCellPressedHandler);
        });
        ((CalendarControl)this.getSkinnable()).setOnContextMenuRequested(event -> {
            LocalDate dateOfContextMenu = this.getDateAtScreenPosition(event.getScreenX(), event.getScreenY());
            ((CalendarControl)this.getSkinnable()).dateOfContextMenuProperty().set((Object)dateOfContextMenu);
            this.selectCalendarEntryAtScreenPosition(event.getScreenX(), event.getScreenY());
            event.consume();
        });
    }

    private void setCalendarActionListenerInDayCells(CalendarActionListener calendarActionListener) {
        Stream.of(this.dayCells).forEach(dayCell -> dayCell.setCalendarActionListener(calendarActionListener));
    }

    private void updateContent() {
        this.updateHeaderCells();
        this.updateDayCells();
        this.updateSummaryCells();
    }

    private void updateHeaderCells() {
        boolean weekStartsSunday = ((CalendarControl.CalendarDate)((CalendarControl)this.getSkinnable()).displayedDateProperty().get()).isWeekStartsSunday();
        String[] columnNames = ((CalendarControl)this.getSkinnable()).getColumnNames();
        if (weekStartsSunday) {
            this.headerCells[0].setText(columnNames[6], false);
            for (int i = 1; i < 7; ++i) {
                this.headerCells[i].setText(columnNames[i - 1], false);
            }
            this.headerCells[7].setText(columnNames[7], true);
        } else {
            for (int i = 0; i < columnNames.length; ++i) {
                this.headerCells[i].setText(columnNames[i], i == columnNames.length - 1);
            }
        }
    }

    private void updateDayCells() {
        LocalDate currentCellDate = ((CalendarControl)this.getSkinnable()).getFirstDisplayedDay();
        int displayedMonth = ((CalendarControl.CalendarDate)((CalendarControl)this.getSkinnable()).displayedDateProperty().get()).getMonth();
        for (int i = 0; i < this.dayCells.length; ++i) {
            boolean dateOfDisplayedMonth = currentCellDate.getMonthValue() == displayedMonth;
            this.dayCells[i].setDate(currentCellDate, dateOfDisplayedMonth);
            CalendarDataProvider dataProvider = ((CalendarControl)this.getSkinnable()).getCalendarDataProvider();
            if (dataProvider != null) {
                List<CalendarEntry> entries = dataProvider.getCalendarEntriesForDate(currentCellDate);
                this.dayCells[i].setEntries(entries);
            }
            currentCellDate = currentCellDate.plus(1L, ChronoUnit.DAYS);
        }
    }

    private void updateSummaryCells() {
        for (int row = 0; row < this.summaryCells.length; ++row) {
            LocalDate dateWeekStart = this.dayCells[row * 7].getDate();
            LocalDate dateWeekEnd = this.dayCells[row * 7 + 6].getDate();
            int weekNr = Date310Utils.getWeekNumber(dateWeekStart, ((CalendarControl.CalendarDate)((CalendarControl)this.getSkinnable()).displayedDateProperty().get()).isWeekStartsSunday());
            this.summaryCells[row].setNumber(weekNr);
            CalendarDataProvider dataProvider = ((CalendarControl)this.getSkinnable()).getCalendarDataProvider();
            if (dataProvider == null) continue;
            List<String> summaryLines = dataProvider.getSummaryForDateRange(dateWeekStart, dateWeekEnd);
            this.summaryCells[row].setEntries(summaryLines);
        }
    }

    private LocalDate getDateAtScreenPosition(double screenX, double screenY) {
        for (CalendarDayCell dayCell : this.dayCells) {
            Point2D localPosition = dayCell.screenToLocal(screenX, screenY);
            if (!dayCell.getBoundsInLocal().contains(localPosition)) continue;
            return dayCell.getDate();
        }
        return null;
    }

    private void selectCalendarEntryAtScreenPosition(double screenX, double screenY) {
        this.removeSelection();
        for (CalendarDayCell dayCell : this.dayCells) {
            CalendarEntry entryAtScreenPosition = dayCell.getEntryAtScreenPosition(screenX, screenY);
            if (entryAtScreenPosition == null) continue;
            this.selectEntry(entryAtScreenPosition.getEntry());
            break;
        }
    }
}

