/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.javafx.control.calendar;

import de.saring.util.data.IdDateObject;
import de.saring.util.data.IdObject;
import de.saring.util.gui.javafx.control.calendar.AbstractCalendarCell;
import de.saring.util.gui.javafx.control.calendar.CalendarActionListener;
import de.saring.util.gui.javafx.control.calendar.CalendarEntry;
import java.io.File;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Paint;

class CalendarDayCell
extends AbstractCalendarCell {
    private static final PseudoClass PSEUDO_CLASS_SUNDAY = PseudoClass.getPseudoClass((String)"sunday");
    private static final PseudoClass PSEUDO_CLASS_TODAY = PseudoClass.getPseudoClass((String)"today");
    private static final PseudoClass PSEUDO_CLASS_OUTSIDE_MONTH = PseudoClass.getPseudoClass((String)"outside-month");
    private LocalDate date;
    private boolean displayedMonth;
    private List<CalendarEntryLabel> calendarEntryLabels = new ArrayList<CalendarEntryLabel>();
    private CalendarEntrySelectionListener calendarEntrySelectionListener;
    private CalendarActionListener calendarActionListener;

    public CalendarDayCell() {
        this.setupListeners();
        this.getStyleClass().add((Object)"calendar-control-day-cell");
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date, boolean displayedMonth) {
        this.date = date;
        this.displayedMonth = displayedMonth;
        this.updateDayLabel();
    }

    public void setEntries(List<CalendarEntry> entries) {
        this.calendarEntryLabels = entries.stream().map(entry -> new CalendarEntryLabel((CalendarEntry)entry, this.calendarEntrySelectionListener, this.calendarActionListener)).collect(Collectors.toList());
        this.updateEntryLabels(this.calendarEntryLabels);
    }

    public void setCalendarEntrySelectionListener(CalendarEntrySelectionListener selectionListener) {
        this.calendarEntrySelectionListener = selectionListener;
    }

    public void setCalendarActionListener(CalendarActionListener calendarActionListener) {
        this.calendarActionListener = calendarActionListener;
    }

    public void removeSelectionExcept(CalendarEntry calendarEntryExcept) {
        IdDateObject entryExcept = calendarEntryExcept == null ? null : calendarEntryExcept.getEntry();
        this.calendarEntryLabels.stream().filter(entryLabel -> entryLabel.selected.get() && (entryExcept == null || !entryExcept.equals(entryLabel.entry.getEntry()))).forEach(calendarEntryLabel -> calendarEntryLabel.selected.set(false));
    }

    public boolean selectEntry(IdObject entry) {
        for (CalendarEntryLabel calendarEntryLabel : this.calendarEntryLabels) {
            if (!calendarEntryLabel.entry.getEntry().equals(entry)) continue;
            calendarEntryLabel.selected.set(true);
            return true;
        }
        return false;
    }

    public CalendarEntry getEntryAtScreenPosition(double screenX, double screenY) {
        for (CalendarEntryLabel calendarEntryLabel : this.calendarEntryLabels) {
            Point2D localPosition = calendarEntryLabel.screenToLocal(screenX, screenY);
            if (!calendarEntryLabel.getBoundsInLocal().contains(localPosition)) continue;
            return calendarEntryLabel.entry;
        }
        return null;
    }

    private void setupListeners() {
        this.setOnMouseClicked(event -> {
            if (this.calendarActionListener != null && event.getClickCount() > 1) {
                this.calendarActionListener.onCalendarDayAction(this.date);
            }
        });
        this.setOnDragOver(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasFiles() && dragboard.getFiles().size() == 1 && ((File)dragboard.getFiles().get(0)).isFile()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            } else {
                event.consume();
            }
        });
        this.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            boolean success = false;
            if (dragboard.hasFiles() && this.calendarActionListener != null) {
                success = true;
                String filePath = ((File)dragboard.getFiles().get(0)).getAbsolutePath();
                CalendarEntry droppedOnEntry = this.getEntryAtScreenPosition(event.getScreenX(), event.getScreenY());
                if (droppedOnEntry == null) {
                    this.calendarActionListener.onDraggedFileDroppedOnCalendarDay(filePath);
                } else {
                    this.calendarActionListener.onDraggedFileDroppedOnCalendarEntry(droppedOnEntry.getEntry(), filePath);
                }
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    private void updateDayLabel() {
        this.setNumber(this.date.getDayOfMonth());
        boolean sunday = this.date.getDayOfWeek() == DayOfWeek.SUNDAY;
        boolean today = LocalDate.now().equals(this.date);
        this.getNumberLabel().pseudoClassStateChanged(PSEUDO_CLASS_SUNDAY, sunday);
        this.getNumberLabel().pseudoClassStateChanged(PSEUDO_CLASS_TODAY, today);
        this.getNumberLabel().pseudoClassStateChanged(PSEUDO_CLASS_OUTSIDE_MONTH, !this.displayedMonth);
    }

    private static class CalendarEntryLabel
    extends Label {
        private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
        private CalendarEntry entry;
        private BooleanProperty selected = new SimpleBooleanProperty(false);

        public CalendarEntryLabel(CalendarEntry entry, CalendarEntrySelectionListener selectionListener, CalendarActionListener actionListener) {
            this.entry = entry;
            this.setMaxWidth(Double.MAX_VALUE);
            this.setText(entry.getText());
            if (entry.getToolTipText() != null) {
                this.setTooltip(new Tooltip(entry.getToolTipText()));
            }
            if (entry.getColor() != null) {
                this.setTextFill((Paint)entry.getColor());
            }
            this.getStyleClass().add((Object)"calendar-control-entry");
            this.selected.addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, (boolean)newValue));
            this.setupListeners(selectionListener, actionListener);
        }

        private void setupListeners(CalendarEntrySelectionListener selectionListener, CalendarActionListener actionListener) {
            if (selectionListener != null) {
                this.selected.addListener((observable, oldValue, newValue) -> selectionListener.calendarEntrySelectionChanged(this.entry, (boolean)newValue));
            }
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                event.consume();
                if (!this.selected.get()) {
                    this.selected.set(true);
                }
            });
            if (actionListener != null) {
                this.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    event.consume();
                    if (event.getClickCount() > 1) {
                        actionListener.onCalendarEntryAction(this.entry);
                    }
                });
            }
        }
    }

    static interface CalendarEntrySelectionListener {
        public void calendarEntrySelectionChanged(CalendarEntry var1, boolean var2);
    }
}

