/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.jfreechart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import javafx.scene.control.Label;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;

public final class ChartUtils {
    private ChartUtils() {
    }

    public static void customizeChart(JFreeChart chart) {
        Color background = new Color(244, 244, 244);
        chart.setBackgroundPaint((Paint)background);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        javafx.scene.text.Font fxLabelFont = new Label().getFont();
        Font chartFont = new Font(fxLabelFont.getName(), 0, (int)fxLabelFont.getSize());
        plot.getDomainAxis().setTickLabelFont(chartFont);
        plot.getRangeAxis().setTickLabelFont(chartFont);
        plot.getDomainAxis().setLabelFont(chartFont);
        plot.getRangeAxis().setLabelFont(chartFont);
        if (chart.getLegend() != null) {
            chart.getLegend().setItemFont(chartFont);
            chart.getLegend().setBackgroundPaint((Paint)background);
        }
    }
}

