/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.unitcalc;

import de.saring.util.unitcalc.ConvertUtils;
import de.saring.util.unitcalc.SpeedMode;
import de.saring.util.unitcalc.TimeUtils;
import de.saring.util.unitcalc.UnitSystem;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\rJ\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\rJ\u001e\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010'\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\rJ\u0016\u0010.\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\rR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"Lde/saring/util/unitcalc/FormatUtils;", "", "unitSystem", "Lde/saring/util/unitcalc/UnitSystem;", "(Lde/saring/util/unitcalc/UnitSystem;)V", "numberFormat", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "getUnitSystem", "()Lde/saring/util/unitcalc/UnitSystem;", "cadenceToString", "", "cadence", "", "caloriesToString", "calories", "cyclesToString", "cycles", "", "distanceToString", "distance", "", "decimals", "distanceToStringWithoutUnitName", "getAltitudeUnitName", "getDistanceUnitName", "getSpeedUnitName", "speedMode", "Lde/saring/util/unitcalc/SpeedMode;", "getTemperatureUnitName", "getWeightUnitName", "heartRateToString", "heartRate", "heightToString", "height", "heightToStringWithoutUnitName", "speedToString", "speed", "", "speedToStringWithoutUnitName", "temperatureToString", "temperature", "", "weightToString", "weight", "maxFractionDigits", "weightToStringWithoutUnitName", "de.saring.st-util"})
public final class FormatUtils {
    private final NumberFormat numberFormat;
    @NotNull
    private final UnitSystem unitSystem;

    @NotNull
    public final String getDistanceUnitName() {
        return this.unitSystem == UnitSystem.ENGLISH ? "m" : "km";
    }

    @NotNull
    public final String getTemperatureUnitName() {
        return this.unitSystem == UnitSystem.ENGLISH ? "F" : "C";
    }

    @NotNull
    public final String getAltitudeUnitName() {
        return this.unitSystem == UnitSystem.ENGLISH ? "ft" : "m";
    }

    @NotNull
    public final String getWeightUnitName() {
        return this.unitSystem == UnitSystem.ENGLISH ? "lbs" : "kg";
    }

    @NotNull
    public final String getSpeedUnitName(@NotNull SpeedMode speedMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)speedMode), (String)"speedMode");
        return this.unitSystem == UnitSystem.ENGLISH ? (speedMode == SpeedMode.SPEED ? "mph" : "min/m") : (speedMode == SpeedMode.SPEED ? "km/h" : "min/km");
    }

    @NotNull
    public final String heartRateToString(int heartRate) {
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(0);
        return this.numberFormat.format((Object)heartRate) + " bpm";
    }

    @NotNull
    public final String temperatureToString(short temperature) {
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(0);
        return this.unitSystem == UnitSystem.ENGLISH ? this.numberFormat.format((Object)ConvertUtils.convertCelsius2Fahrenheit(temperature)) + ' ' + this.getTemperatureUnitName() : this.numberFormat.format((Object)temperature) + ' ' + this.getTemperatureUnitName();
    }

    @NotNull
    public final String distanceToStringWithoutUnitName(double distance, int decimals) {
        String string;
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(decimals);
        if (this.unitSystem == UnitSystem.ENGLISH) {
            String string2 = this.numberFormat.format(ConvertUtils.convertKilometer2Miles(distance, false));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"numberFormat.format(Conv\u2026r2Miles(distance, false))");
        } else {
            String string3 = this.numberFormat.format(distance);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"numberFormat.format(distance)");
        }
        return string;
    }

    @NotNull
    public final String distanceToString(double distance, int decimals) {
        return this.distanceToStringWithoutUnitName(distance, decimals) + ' ' + this.getDistanceUnitName();
    }

    @NotNull
    public final String speedToStringWithoutUnitName(float speed, int decimals, @NotNull SpeedMode speedMode) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)speedMode), (String)"speedMode");
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(decimals);
        if (this.unitSystem == UnitSystem.ENGLISH) {
            String string2 = speedMode == SpeedMode.PACE ? (speed == 0.0f ? "N/A" : TimeUtils.seconds2MinuteTimeString((int)((double)3600 / ConvertUtils.convertKilometer2Miles(speed, false)))) : this.numberFormat.format(ConvertUtils.convertKilometer2Miles(speed, false));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (speedMode == SpeedMo\u2026(), false))\n            }");
        } else {
            String string3 = speedMode == SpeedMode.PACE ? (speed == 0.0f ? "N/A" : TimeUtils.seconds2MinuteTimeString((int)((float)3600 / speed))) : this.numberFormat.format(speed);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"if (speedMode == SpeedMo\u2026toDouble())\n            }");
        }
        return string;
    }

    @NotNull
    public final String speedToString(float speed, int decimals, @NotNull SpeedMode speedMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)speedMode), (String)"speedMode");
        return speed == 0.0f ? this.speedToStringWithoutUnitName(speed, decimals, speedMode) : this.speedToStringWithoutUnitName(speed, decimals, speedMode) + " " + this.getSpeedUnitName(speedMode);
    }

    @NotNull
    public final String heightToStringWithoutUnitName(int height) {
        String string;
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(0);
        if (this.unitSystem == UnitSystem.ENGLISH) {
            String string2 = this.numberFormat.format((Object)ConvertUtils.convertMeter2Feet(height));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"numberFormat.format(Conv\u2026onvertMeter2Feet(height))");
        } else {
            String string3 = this.numberFormat.format((Object)height);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"numberFormat.format(height)");
        }
        return string;
    }

    @NotNull
    public final String heightToString(int height) {
        return this.heightToStringWithoutUnitName(height) + ' ' + this.getAltitudeUnitName();
    }

    @NotNull
    public final String cadenceToString(int cadence) {
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(0);
        return this.numberFormat.format(cadence) + " rpm / spm";
    }

    @NotNull
    public final String cyclesToString(long cycles) {
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(0);
        return this.numberFormat.format(cycles) + " rotations / steps";
    }

    @NotNull
    public final String caloriesToString(int calories) {
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(0);
        return this.numberFormat.format(calories) + " kCal";
    }

    @NotNull
    public final String weightToStringWithoutUnitName(float weight, int maxFractionDigits) {
        String string;
        NumberFormat numberFormat = this.numberFormat;
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"numberFormat");
        numberFormat.setMaximumFractionDigits(maxFractionDigits);
        if (this.unitSystem == UnitSystem.ENGLISH) {
            String string2 = this.numberFormat.format(ConvertUtils.convertKilogram2Lbs(weight));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"numberFormat.format(Conv\u2026m2Lbs(weight.toDouble()))");
        } else {
            String string3 = this.numberFormat.format(Float.valueOf(weight));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"numberFormat.format(weight)");
        }
        return string;
    }

    @NotNull
    public final String weightToString(float weight, int maxFractionDigits) {
        return this.weightToStringWithoutUnitName(weight, maxFractionDigits) + ' ' + this.getWeightUnitName();
    }

    @NotNull
    public final UnitSystem getUnitSystem() {
        return this.unitSystem;
    }

    public FormatUtils(@NotNull UnitSystem unitSystem) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unitSystem), (String)"unitSystem");
        this.unitSystem = unitSystem;
        this.numberFormat = NumberFormat.getInstance();
    }
}

