/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.unitcalc;

import de.saring.util.unitcalc.SpeedMode;
import de.saring.util.unitcalc.TimeUtils;
import java.text.NumberFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lde/saring/util/unitcalc/SpeedToStringConverter;", "", "speedMode", "Lde/saring/util/unitcalc/SpeedMode;", "(Lde/saring/util/unitcalc/SpeedMode;)V", "getSpeedMode", "()Lde/saring/util/unitcalc/SpeedMode;", "setSpeedMode", "floatSpeedtoString", "", "floatSpeed", "", "(Ljava/lang/Float;)Ljava/lang/String;", "stringSpeedToFloat", "strSpeed", "(Ljava/lang/String;)Ljava/lang/Float;", "Companion", "de.saring.st-util"})
public final class SpeedToStringConverter {
    @NotNull
    private SpeedMode speedMode;
    private static final String ZERO_SPEED_TIME = "00:00";
    private static final NumberFormat NUMBER_FORMAT;
    public static final Companion Companion;

    @Nullable
    public final String floatSpeedtoString(@Nullable Float floatSpeed) {
        if (floatSpeed == null) {
            return null;
        }
        return this.speedMode == SpeedMode.SPEED ? NUMBER_FORMAT.format(floatSpeed) : (Intrinsics.areEqual((Float)floatSpeed, (float)0.0f) ? ZERO_SPEED_TIME : TimeUtils.seconds2MinuteTimeString((int)((float)3600 / floatSpeed.floatValue())));
    }

    @Nullable
    public final Float stringSpeedToFloat(@Nullable String strSpeed) {
        Float f;
        if (strSpeed == null) {
            return null;
        }
        try {
            Float f2;
            String string = strSpeed;
            boolean bl = false;
            String strSpeedTrimmed = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (this.speedMode == SpeedMode.SPEED) {
                f2 = Float.valueOf(NumberFormat.getInstance().parse(strSpeed).floatValue());
            } else {
                float f3;
                if (Intrinsics.areEqual((Object)ZERO_SPEED_TIME, (Object)strSpeedTrimmed)) {
                    f3 = 0.0f;
                } else {
                    LocalTime time = LocalTime.parse("00:" + strSpeedTrimmed, DateTimeFormatter.ISO_LOCAL_TIME);
                    float f4 = 3600;
                    LocalTime localTime = time;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"time");
                    f3 = f4 / (float)(localTime.getMinute() * 60 + time.getSecond());
                }
                f2 = Float.valueOf(f3);
            }
            f = f2;
        }
        catch (Exception e) {
            f = null;
        }
        return f;
    }

    @NotNull
    public final SpeedMode getSpeedMode() {
        return this.speedMode;
    }

    public final void setSpeedMode(@NotNull SpeedMode speedMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)speedMode), (String)"<set-?>");
        this.speedMode = speedMode;
    }

    public SpeedToStringConverter(@NotNull SpeedMode speedMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)speedMode), (String)"speedMode");
        this.speedMode = speedMode;
    }

    static {
        Companion = new Companion(null);
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        NumberFormat $this$apply = numberFormat;
        boolean bl3 = false;
        $this$apply.setMaximumFractionDigits(3);
        NUMBER_FORMAT = numberFormat;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/saring/util/unitcalc/SpeedToStringConverter$Companion;", "", "()V", "NUMBER_FORMAT", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "ZERO_SPEED_TIME", "", "de.saring.st-util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

