/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.gradle.latex;

import java.io.File;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.danilopianini.gradle.latex.BibtexTask;
import org.danilopianini.gradle.latex.LatexTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lorg/danilopianini/gradle/latex/BibtexTask;", "Lorg/danilopianini/gradle/latex/LatexTask;", "()V", "bibTex", "", "getDescription", "", "inputFiles", "Lorg/gradle/api/file/FileCollection;", "gradle-latex"})
public class BibtexTask
extends LatexTask {
    @Override
    @InputFiles
    @NotNull
    public FileCollection inputFiles() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[]{this.getArtifact().getBib()});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(artifact.bib)");
        return (FileCollection)configurableFileCollection;
    }

    @NotNull
    public String getDescription() {
        return "Uses BibTex to compile " + this.getArtifact().getBib() + " into " + this.getArtifact().getName() + ".bbl";
    }

    @TaskAction
    public final void bibTex() {
        boolean bl = this.getArtifact().getBib() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            throw (Throwable)new GradleException("Bibtex task cannot run on artifacts without a bib configured such as " + this.getArtifact());
        }
        if (!this.getArtifact().getAux().exists()) {
            throw (Throwable)new GradleException(this.getArtifact().getAux().getAbsolutePath() + " does not exist, cannot invoke " + (String)this.getExtension().getBibTexCommand().get());
        }
        if (Files.lines(this.getArtifact().getAux().toPath()).anyMatch(bibTex.2.INSTANCE)) {
            File bib;
            File file = this.getArtifact().getBib();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (!(bib = file).exists()) {
                throw (Throwable)new GradleException(bib.getAbsolutePath() + " does not exist, cannot invoke " + (String)this.getExtension().getBibTexCommand().get());
            }
            LatexTask.runScript$default(this, (String)this.getExtension().getBibTexCommand().get() + ' ' + this.getArtifact().getAux().getName(), null, null, 0L, null, null, 31, null);
        }
    }
}

