/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.gradle.latex;

import java.io.File;
import java.nio.file.Files;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.danilopianini.gradle.latex.BibtexTask;
import org.danilopianini.gradle.latex.Latex;
import org.danilopianini.gradle.latex.LatexArtifact;
import org.danilopianini.gradle.latex.LatexTask;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0017R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/danilopianini/gradle/latex/BibtexTask;", "Lorg/danilopianini/gradle/latex/LatexTask;", "artifact", "Lorg/danilopianini/gradle/latex/LatexArtifact;", "(Lorg/danilopianini/gradle/latex/LatexArtifact;)V", "aux", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getAux", "()Ljava/io/File;", "bbl", "getBbl", "bibTex", "", "getDescription", "", "gradle-latex"})
public class BibtexTask
extends LatexTask {
    @InputFile
    public final File getAux() {
        return this.getProject().file((Object)this.getArtifact().getAux());
    }

    @OutputFile
    public final File getBbl() {
        return this.getProject().file((Object)this.getArtifact().getBbl());
    }

    @Console
    @NotNull
    public String getDescription() {
        return "Uses BibTex to compile " + this.getArtifact().getAux() + " into " + this.getArtifact().getName() + ".bbl";
    }

    @TaskAction
    public final void bibTex() {
        if (this.getArtifact().getAux().exists()) {
            if (Files.lines(this.getArtifact().getAux().toPath()).anyMatch(bibTex.1.INSTANCE)) {
                LatexTask.runScript$default(this, (String)this.getExtension().getBibTexCommand().get() + " \"" + this.getArtifact().getAux().getName() + '\"', null, null, 0L, null, null, 31, null);
            } else {
                Latex.Companion.getLOG().warn("No citation in \"" + this.getArtifact().getAux().getAbsolutePath() + "\", bibtex not invoked.");
            }
        } else {
            Latex.Companion.getLOG().warn(this.getArtifact().getAux().getAbsolutePath() + " does not exist," + " cannot invoke " + (String)this.getExtension().getBibTexCommand().get());
        }
    }

    @Inject
    public BibtexTask(@NotNull LatexArtifact artifact) {
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        super(artifact);
    }
}

