/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.gradle.latex;

import java.io.File;
import java.nio.file.Files;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.jvm.internal.Intrinsics;
import org.danilopianini.gradle.latex.BibtexTask;
import org.danilopianini.gradle.latex.LatexArtifact;
import org.danilopianini.gradle.latex.LatexTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0006H\u0017R\u0011\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/danilopianini/gradle/latex/BibtexTask;", "Lorg/danilopianini/gradle/latex/LatexTask;", "artifact", "Lorg/danilopianini/gradle/latex/LatexArtifact;", "(Lorg/danilopianini/gradle/latex/LatexArtifact;)V", "auxContent", "", "getAuxContent", "()Ljava/lang/String;", "bbl", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getBbl", "()Ljava/io/File;", "bibTex", "", "getDescription", "gradle-latex"})
public class BibtexTask
extends LatexTask {
    @Input
    @NotNull
    public final String getAuxContent() {
        return FilesKt.readText$default((File)this.getArtifact().getAux(), null, (int)1, null);
    }

    @OutputFile
    public final File getBbl() {
        return this.getProject().file((Object)this.getArtifact().getBbl());
    }

    @Console
    @NotNull
    public String getDescription() {
        return "Uses BibTex to compile " + this.getArtifact().getAux() + " into " + this.getArtifact().getName() + ".bbl";
    }

    @TaskAction
    @ExperimentalPathApi
    public final void bibTex() {
        if (this.getArtifact().getAux().exists()) {
            if (Files.lines(this.getArtifact().getAux().toPath()).anyMatch(bibTex.1.INSTANCE)) {
                LatexTask.runScript$default(this, (String)this.getExtension().getBibTexCommand().get() + " \"" + this.getArtifact().getAux().getName() + '\"', null, null, 0L, null, null, 31, null);
            } else {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                project.getLogger().warn("No citation in \"" + this.getArtifact().getAux().getAbsolutePath() + "\", bibtex not invoked.");
            }
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            project.getLogger().warn(this.getArtifact().getAux().getAbsolutePath() + " does not exist, cannot invoke " + (String)this.getExtension().getBibTexCommand().get());
        }
    }

    @Inject
    public BibtexTask(@NotNull LatexArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        super(artifact);
    }
}

