/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.upgradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.danilopianini.upgradle.api.Change;
import org.danilopianini.upgradle.api.Credentials;
import org.danilopianini.upgradle.api.OnFile;
import org.danilopianini.upgradle.api.Operation;
import org.danilopianini.upgradle.api.Pattern;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\"\u0010\t\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u001a.\u0010\u0010\u001a\n \u0002*\u0004\u0018\u00010\u00110\u0011*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0013\u001a2\u0010\u0016\u001a\n \u0002*\u0004\u0018\u00010\u00170\u0017*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u001f"}, d2={"add", "Lorg/eclipse/jgit/dircache/DirCache;", "kotlin.jvm.PlatformType", "Lorg/eclipse/jgit/api/Git;", "location", "Ljava/io/File;", "changes", "", "Lorg/danilopianini/upgradle/api/Change;", "clone", "Lorg/eclipse/egit/github/core/Repository;", "branch", "Lorg/eclipse/egit/github/core/RepositoryBranch;", "destination", "credentials", "Lorg/danilopianini/upgradle/api/Credentials;", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "message", "", "author", "email", "createPullRequest", "Lorg/eclipse/egit/github/core/PullRequest;", "update", "Lorg/danilopianini/upgradle/api/Operation;", "head", "base", "pushTo", "", "Lorg/eclipse/jgit/transport/RemoteRefUpdate;", "upgradle"})
public final class GitKt {
    @NotNull
    public static final Git clone(@NotNull Repository $this$clone, @NotNull RepositoryBranch branch, @NotNull File destination, @NotNull Credentials credentials2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$clone, (String)"$this$clone");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        Git git = ((CloneCommand)Credentials.Companion.authenticated((TransportCommand)Git.cloneRepository(), credentials2)).setURI($this$clone.getHtmlUrl()).setBranch(branch.getName()).setDirectory(destination).call();
        Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git\n        .cloneReposi\u2026tination)\n        .call()");
        return git;
    }

    public static final DirCache add(@NotNull Git $this$add, @NotNull File location, @NotNull Iterable<? extends Change> changes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$add, (String)"$this$add");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        AddCommand addCommand = $this$add.add();
        boolean bl = false;
        boolean bl2 = false;
        AddCommand $this$apply = addCommand;
        boolean bl3 = false;
        Iterable<? extends Change> $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator<? extends Change> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Change element$iv;
            Change it = element$iv = iterator.next();
            boolean bl4 = false;
            Change change = it;
            if (change instanceof OnFile) {
                string = FilesKt.relativeTo((File)((OnFile)it).getFile(), (File)location).getPath();
            } else if (change instanceof Pattern) {
                String string2 = ((Pattern)it).getPattern();
                String string3 = location.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"location.absolutePath");
                string = StringsKt.replace$default((String)string2, (String)string3, (String)"", (boolean)false, (int)4, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$apply.addFilepattern(string);
        }
        return addCommand.call();
    }

    public static final RevCommit commit(@NotNull Git $this$commit, @NotNull String message, @NotNull String author, @NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)$this$commit, (String)"$this$commit");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        return $this$commit.commit().setMessage(message).setAuthor(new PersonIdent(author, email)).call();
    }

    public static /* synthetic */ RevCommit commit$default(Git git, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UpGradle [Bot]";
        }
        if ((n & 4) != 0) {
            string3 = "danilo.pianini@gmail.com";
        }
        return GitKt.commit(git, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RemoteRefUpdate> pushTo(@NotNull Git $this$pushTo, @NotNull String branch, @NotNull Credentials credentials2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$pushTo, (String)"$this$pushTo");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        Iterable iterable = ((PushCommand)Credentials.Companion.authenticated((TransportCommand)$this$pushTo.push(), credentials2)).setForce(false).setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(branch)}).call();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"push()\n    .authenticate\u2026Spec(branch))\n    .call()");
        Iterable $this$flatMap$iv = iterable;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PushResult it = (PushResult)element$iv$iv;
            boolean bl = false;
            PushResult pushResult = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)pushResult, (String)"it");
            Iterable list$iv$iv = pushResult.getRemoteUpdates();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final PullRequest createPullRequest(@NotNull Repository $this$createPullRequest, @NotNull Operation update, @NotNull String head, @NotNull String base, @NotNull Credentials credentials2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createPullRequest, (String)"$this$createPullRequest");
        Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
        Intrinsics.checkParameterIsNotNull((Object)head, (String)"head");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        return ((PullRequestService)Credentials.Companion.authenticated((GitHubService)new PullRequestService(), credentials2)).createPullRequest((IRepositoryIdProvider)$this$createPullRequest, new PullRequest().setBase(new PullRequestMarker().setRef(base).setLabel(base)).setHead(new PullRequestMarker().setRef(head).setLabel(head)).setTitle(update.getPullRequestTitle()).setBody(update.getPullRequestMessage()).setBodyText(update.getPullRequestMessage()));
    }
}

