/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.upgradle.modules;

import arrow.core.extensions.sequence.foldable.SequenceKFoldableKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.danilopianini.upgradle.api.Change;
import org.danilopianini.upgradle.api.OnFile;
import org.danilopianini.upgradle.api.Operation;
import org.danilopianini.upgradle.api.SimpleOperation;
import org.danilopianini.upgradle.modules.GradleRootModule;
import org.danilopianini.upgradle.modules.RefreshVersions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/danilopianini/upgradle/modules/RefreshVersions;", "Lorg/danilopianini/upgradle/modules/GradleRootModule;", "()V", "operationsInProjectRoot", "", "Lorg/danilopianini/upgradle/api/Operation;", "projectRoot", "Ljava/io/File;", "projectId", "", "prepareUpdates", "versionsFile", "originalVersions", "Companion", "ProcessOutcome", "upgradle"})
public final class RefreshVersions
extends GradleRootModule {
    private static final String versionFileName = "versions.properties";
    private static final String taskName = "refreshVersions";
    private static final String pluginPrefix = "plugin.";
    private static final String versionPrefix = "version.";
    private static final String extractor = "\\s*((?:version|plugin)\\.(?:.*\\.)?([a-zA-Z].*))=(\\S*)\\s*##\\s*# available=(\\S*)";
    @NotNull
    private static final Regex updateExtractionRegex;
    private static final Logger logger;
    private static final boolean isWindows;
    private static final String executable;
    private static final String gradleCommand;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<Operation> operationsInProjectRoot(@NotNull File projectRoot, @NotNull String projectId) {
        File versionsFile;
        Object v4;
        List filesInRoot;
        block11: {
            List list;
            Iterable destination$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)projectRoot, (String)"projectRoot");
            Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
            File[] fileArray = projectRoot.listFiles();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv;
                int n = ((void)iterator).length;
                for (int i = 0; i < n; ++i) {
                    Iterator element$iv$iv;
                    Iterator it = element$iv$iv = iterator[i];
                    boolean bl = false;
                    Iterator iterator2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(iterator2, (String)"it");
                    if (!((File)((Object)iterator2)).isFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            filesInRoot = list;
            Iterable $i$f$filter = filesInRoot;
            boolean $this$filterTo$iv$iv = false;
            destination$iv$iv = $i$f$filter;
            boolean bl = false;
            for (Object e : destination$iv$iv) {
                File it = (File)e;
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                if (!Intrinsics.areEqual((Object)file.getName(), (Object)versionFileName)) continue;
                v4 = e;
                break block11;
            }
            v4 = null;
        }
        File file = versionsFile = (File)v4;
        if (file != null) {
            if (file.exists()) {
                File execFile;
                Object v7;
                block12: {
                    Iterable $this$filterTo$iv$iv = filesInRoot;
                    boolean destination$iv$iv = false;
                    Iterable iterable = $this$filterTo$iv$iv;
                    boolean bl = false;
                    for (Object t : iterable) {
                        File it = (File)t;
                        boolean bl3 = false;
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        if (!Intrinsics.areEqual((Object)file2.getName(), (Object)executable)) continue;
                        v7 = t;
                        break block12;
                    }
                    v7 = null;
                }
                File file3 = execFile = (File)v7;
                if (file3 != null) {
                    if (file3.exists()) {
                        List list;
                        String originalVersions = FilesKt.readText$default((File)versionsFile, null, (int)1, null);
                        logger.info("Running refreshVersions");
                        ProcessOutcome refresh = RefreshVersions.Companion.runRefresh(projectRoot);
                        if (refresh instanceof ProcessOutcome.Error) {
                            logger.error("Could not refresh versions, process ended with error " + ((ProcessOutcome.Error)refresh).getCode() + '.');
                            list = CollectionsKt.emptyList();
                            return list;
                        } else {
                            if (!(refresh instanceof ProcessOutcome.Ok)) throw new NoWhenBranchMatchedException();
                            list = this.prepareUpdates(projectId, versionsFile, originalVersions);
                        }
                        return list;
                    }
                }
                logger.warn("No {} file available in {}", (Object)execFile, (Object)projectRoot.getAbsolutePath());
                return CollectionsKt.emptyList();
            }
        }
        logger.warn("No {} file available in {}", (Object)versionFileName, (Object)projectRoot.getAbsolutePath());
        return CollectionsKt.emptyList();
    }

    private final List<Operation> prepareUpdates(String projectId, File versionsFile, String originalVersions) {
        logger.info("Version refresh successful. Extracting available updates");
        String versionsContent = FilesKt.readText$default((File)versionsFile, null, (int)1, null);
        Sequence matches = Regex.findAll$default((Regex)updateExtractionRegex, (CharSequence)versionsContent, (int)0, (int)2, null);
        if (SequenceKFoldableKt.isEmpty((Sequence)matches)) {
            logger.info("No updates available");
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)matches, (Function1)((Function1)new Function1<MatchResult, SimpleOperation>(projectId, originalVersions, versionsFile){
            final /* synthetic */ String $projectId;
            final /* synthetic */ String $originalVersions;
            final /* synthetic */ File $versionsFile;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SimpleOperation invoke(@NotNull MatchResult match) {
                void descriptor;
                void old;
                void artifact;
                MatchResult.Destructured destructured;
                Intrinsics.checkParameterIsNotNull((Object)match, (String)"match");
                MatchResult.Destructured destructured2 = destructured = match.getDestructured();
                boolean bl = false;
                String string = (String)destructured2.getMatch().getGroupValues().get(1);
                destructured2 = destructured;
                bl = false;
                String string2 = (String)destructured2.getMatch().getGroupValues().get(2);
                destructured2 = destructured;
                bl = false;
                String string3 = (String)destructured2.getMatch().getGroupValues().get(3);
                destructured2 = destructured;
                bl = false;
                String string4 = (String)destructured2.getMatch().getGroupValues().get(4);
                RefreshVersions.access$getLogger$cp().info("Found update for {}: {} -> {}", new Object[]{artifact, old, string4});
                String message = "Upgrade " + (String)artifact + " from " + (String)old + " to " + string4 + GradleRootModule.Companion.inProject(this.$projectId);
                return new SimpleOperation("bump-" + (String)artifact + "-to-" + string4 + GradleRootModule.Companion.projectDescriptor(this.$projectId), message, message, "This update was prepared for you by UpGradle, at your service.", (Function0<? extends List<? extends Change>>)((Function0)new Function0<List<? extends OnFile>>(this, string4, (String)descriptor, (String)old){
                    final /* synthetic */ prepareUpdates.1 this$0;
                    final /* synthetic */ String $new;
                    final /* synthetic */ String $descriptor;
                    final /* synthetic */ String $old;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<OnFile> invoke() {
                        void $this$mapTo$iv$iv;
                        CharSequence $this$map$iv = this.$new;
                        boolean $i$f$map = false;
                        CharSequence charSequence = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length());
                        boolean $i$f$mapTo = false;
                        void var7_7 = $this$mapTo$iv$iv;
                        for (int i = 0; i < var7_7.length(); ++i) {
                            void it;
                            char item$iv$iv;
                            char c = item$iv$iv = var7_7.charAt(i);
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = StringsKt.contains$default((CharSequence)"\\^$,.|?*+()[]{}", (char)it, (boolean)false, (int)2, null) ? "" + '\\' + (char)it : String.valueOf((char)it);
                            collection.add(string);
                        }
                        String newVersionRegex = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                        Regex updateLineRegex = new Regex("##\\s*# available=" + newVersionRegex + "\\n");
                        charSequence = StringsKt.replace$default((String)this.this$0.$originalVersions, (String)(this.$descriptor + '=' + this.$old), (String)(this.$descriptor + '=' + this.$new), (boolean)false, (int)4, null);
                        String string = "";
                        boolean bl = false;
                        String updated = updateLineRegex.replace(charSequence, string);
                        RefreshVersions.access$getLogger$cp().info("Updating the version file");
                        FilesKt.writeText$default((File)this.this$0.$versionsFile, (String)updated, null, (int)2, null);
                        RefreshVersions.access$getLogger$cp().info("Version file updated");
                        return CollectionsKt.listOf((Object)new OnFile(this.this$0.$versionsFile));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$new = string;
                        this.$descriptor = string2;
                        this.$old = string3;
                        super(0);
                    }
                }));
            }
            {
                this.$projectId = string;
                this.$originalVersions = string2;
                this.$versionsFile = file;
                super(1);
            }
        })));
    }

    static {
        Companion = new Companion(null);
        updateExtractionRegex = new Regex(extractor);
        logger = LoggerFactory.getLogger(RefreshVersions.class);
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        isWindows = StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true);
        String string2 = ".bat";
        StringBuilder stringBuilder = new StringBuilder().append("gradlew");
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        String string3 = isWindows ? string2 : null;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        executable = stringBuilder.append(string4).toString();
        string2 = "./";
        stringBuilder = new StringBuilder();
        bl = false;
        bl2 = false;
        it = string2;
        boolean bl4 = false;
        string3 = !isWindows ? string2 : null;
        String string5 = string3;
        if (string5 == null) {
            string5 = "";
        }
        gradleCommand = stringBuilder.append(string5).append(executable).toString();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome;", "", "()V", "Error", "Ok", "Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome$Ok;", "Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome$Error;", "upgradle"})
    private static abstract class ProcessOutcome {
        private ProcessOutcome() {
        }

        public /* synthetic */ ProcessOutcome(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome$Ok;", "Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome;", "()V", "upgradle"})
        public static final class Ok
        extends ProcessOutcome {
            public static final Ok INSTANCE;

            private Ok() {
                super(null);
            }

            static {
                Ok ok;
                INSTANCE = ok = new Ok();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome$Error;", "Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome;", "code", "", "(I)V", "getCode", "()I", "upgradle"})
        public static final class Error
        extends ProcessOutcome {
            private final int code;

            public final int getCode() {
                return this.code;
            }

            public Error(int code) {
                super(null);
                this.code = code;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/danilopianini/upgradle/modules/RefreshVersions$Companion;", "", "()V", "executable", "", "extractor", "gradleCommand", "isWindows", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pluginPrefix", "taskName", "updateExtractionRegex", "Lkotlin/text/Regex;", "getUpdateExtractionRegex", "()Lkotlin/text/Regex;", "versionFileName", "versionPrefix", "runRefresh", "Lorg/danilopianini/upgradle/modules/RefreshVersions$ProcessOutcome;", "projectRoot", "Ljava/io/File;", "upgradle"})
    public static final class Companion {
        @NotNull
        public final Regex getUpdateExtractionRegex() {
            return updateExtractionRegex;
        }

        private final ProcessOutcome runRefresh(File projectRoot) {
            int n = new ProcessBuilder(CollectionsKt.listOf((Object[])new String[]{gradleCommand, RefreshVersions.taskName})).directory(projectRoot).redirectError(ProcessBuilder.Redirect.INHERIT).start().waitFor();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            return it == 0 ? (ProcessOutcome)ProcessOutcome.Ok.INSTANCE : (ProcessOutcome)new ProcessOutcome.Error(it);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

