/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.CFAbstractAnalysis;
import checkers.initialization.InitializationAnnotatedTypeFactory;
import checkers.nullness.CollectionToArrayHeuristics;
import checkers.nullness.MapGetHeuristics;
import checkers.nullness.NullnessAnalysis;
import checkers.nullness.NullnessStore;
import checkers.nullness.NullnessTransfer;
import checkers.nullness.NullnessValue;
import checkers.nullness.SystemGetPropertyHandler;
import checkers.nullness.quals.LazyNonNull;
import checkers.nullness.quals.MonotonicNonNull;
import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.Nullable;
import checkers.nullness.quals.PolyNull;
import checkers.quals.PolyAll;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.GeneralAnnotatedTypeFactory;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.util.DependentTypes;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import edu.umd.cs.findbugs.annotations.UnknownNullness;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.InternalUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javacutils.TypesUtils;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.validation.constraints.NotNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;

public class NullnessAnnotatedTypeFactory
extends InitializationAnnotatedTypeFactory<NullnessValue, NullnessStore, NullnessTransfer, NullnessAnalysis> {
    protected final AnnotationMirror NONNULL;
    protected final AnnotationMirror NULLABLE;
    protected final AnnotationMirror POLYNULL;
    protected final AnnotationMirror MONOTONIC_NONNULL;
    protected final DependentTypes dependentTypes;
    protected final MapGetHeuristics mapGetHeuristics;
    protected final SystemGetPropertyHandler systemGetPropertyHandler;
    protected final CollectionToArrayHeuristics collectionToArrayHeuristics;
    protected final GeneralAnnotatedTypeFactory generalFactory;
    protected final Set<Class<? extends Annotation>> nullnessAnnos;

    public NullnessAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFbc) {
        super(checker, useFbc);
        this.NONNULL = AnnotationUtils.fromClass(this.elements, NonNull.class);
        this.NULLABLE = AnnotationUtils.fromClass(this.elements, Nullable.class);
        this.POLYNULL = AnnotationUtils.fromClass(this.elements, PolyNull.class);
        this.MONOTONIC_NONNULL = AnnotationUtils.fromClass(this.elements, MonotonicNonNull.class);
        HashSet<Class<PolyAll>> tempNullnessAnnos = new HashSet<Class<PolyAll>>();
        tempNullnessAnnos.add(NonNull.class);
        tempNullnessAnnos.add(MonotonicNonNull.class);
        tempNullnessAnnos.add(Nullable.class);
        tempNullnessAnnos.add(PolyNull.class);
        tempNullnessAnnos.add(PolyAll.class);
        this.nullnessAnnos = Collections.unmodifiableSet(tempNullnessAnnos);
        this.addAliasedAnnotation(LazyNonNull.class, this.MONOTONIC_NONNULL);
        this.addAliasedAnnotation(com.sun.istack.NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(Nonnull.class, this.NONNULL);
        this.addAliasedAnnotation(NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.eclipse.jdt.annotation.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.jetbrains.annotations.NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.netbeans.api.annotations.common.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.jmlspecs.annotation.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(com.sun.istack.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(UnknownNullness.class, this.NULLABLE);
        this.addAliasedAnnotation(CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(javax.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.eclipse.jdt.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.jetbrains.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.netbeans.api.annotations.common.CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(NullAllowed.class, this.NULLABLE);
        this.addAliasedAnnotation(NullUnknown.class, this.NULLABLE);
        this.addAliasedAnnotation(org.jmlspecs.annotation.Nullable.class, this.NULLABLE);
        this.generalFactory = new GeneralAnnotatedTypeFactory(checker);
        this.mapGetHeuristics = new MapGetHeuristics(checker, this, this.generalFactory);
        this.dependentTypes = new DependentTypes(checker, this.generalFactory);
        this.systemGetPropertyHandler = new SystemGetPropertyHandler(this.processingEnv, this);
        this.postInit();
        this.collectionToArrayHeuristics = new CollectionToArrayHeuristics(this.processingEnv, this);
    }

    @Override
    public void setRoot(CompilationUnitTree root) {
        this.generalFactory.setRoot(root);
        super.setRoot(root);
    }

    @Override
    protected void annotateImplicit(Tree tree, AnnotatedTypeMirror type2, boolean useFlow) {
        super.annotateImplicit(tree, type2, useFlow);
        this.dependentTypes.handle(tree, type2);
    }

    @Override
    public AnnotatedTypeMirror getDefaultedAnnotatedType(Tree varTree, ExpressionTree valueTree) {
        AnnotatedTypeMirror result2 = super.getDefaultedAnnotatedType(varTree, valueTree);
        return this.handlePolyNull(result2, valueTree);
    }

    protected AnnotatedTypeMirror handlePolyNull(AnnotatedTypeMirror type2, Tree context) {
        NullnessValue inferred;
        if ((type2.hasAnnotation(PolyNull.class) || type2.hasAnnotation(PolyAll.class)) && (inferred = (NullnessValue)this.getInferredValueFor(context)) != null && inferred.isPolyNullNull) {
            type2.replaceAnnotation(this.NULLABLE);
        }
        return type2;
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> fromUse = super.constructorFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType constructor = (AnnotatedTypeMirror.AnnotatedExecutableType)fromUse.first;
        this.dependentTypes.handleConstructor(tree, this.generalFactory.getAnnotatedType(tree), constructor);
        return fromUse;
    }

    @Override
    public List<VariableTree> getUninitializedInvariantFields(NullnessStore store, TreePath path, boolean isStatic, List<? extends AnnotationMirror> receiverAnnotations) {
        List<VariableTree> candidates = super.getUninitializedInvariantFields(store, path, isStatic, receiverAnnotations);
        ArrayList<VariableTree> result2 = new ArrayList<VariableTree>();
        for (VariableTree c : candidates) {
            AnnotatedTypeMirror type2 = this.getAnnotatedType(c);
            boolean isPrimitive = TypesUtils.isPrimitive(type2.getUnderlyingType());
            if (isPrimitive) continue;
            result2.add(c);
        }
        return result2;
    }

    @Override
    protected NullnessAnalysis createFlowAnalysis(List<Pair<VariableElement, NullnessValue>> fieldValues) {
        return new NullnessAnalysis(this.checker, this, fieldValues);
    }

    @Override
    public NullnessTransfer createFlowTransferFunction(CFAbstractAnalysis<NullnessValue, NullnessStore, NullnessTransfer> analysis) {
        return new NullnessTransfer((NullnessAnalysis)analysis);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        TreePath path = this.getPath(tree);
        if (path != null) {
            this.mapGetHeuristics.handle(path, method);
        }
        this.systemGetPropertyHandler.handle(tree, method);
        this.collectionToArrayHeuristics.handle(tree, method);
        return mfuPair;
    }

    @Override
    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3, ReturnTree r) {
        return this.handlePolyNull(super.getMethodReturnType(m3, r), r);
    }

    protected AnnotatedTypeMirror getDeclaredAndDefaultedAnnotatedType(Tree tree) {
        this.HACK_DONT_CALL_POST_AS_MEMBER = true;
        this.shouldCache = false;
        AnnotatedTypeMirror type2 = this.getAnnotatedType(tree);
        this.shouldCache = true;
        this.HACK_DONT_CALL_POST_AS_MEMBER = false;
        return type2;
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new NullnessTypeAnnotator(this);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new NullnessTreeAnnotator(this);
    }

    private void annotateIfStatic(Element elt, AnnotatedTypeMirror type2) {
        if (elt == null) {
            return;
        }
        if (elt.getKind().isClass() || elt.getKind().isInterface() || NullnessAnnotatedTypeFactory.isSystemField(elt)) {
            type2.replaceAnnotation(this.NONNULL);
        }
    }

    private static boolean isSystemField(Element elt) {
        if (!elt.getKind().isField()) {
            return false;
        }
        if (!ElementUtils.isStatic(elt) || !ElementUtils.isFinal(elt)) {
            return false;
        }
        VariableElement var = (VariableElement)elt;
        boolean inJavaPackage = ElementUtils.getQualifiedClassName(var).toString().startsWith("java.");
        return var.getConstantValue() != null || var.getSimpleName().contentEquals("class") || inJavaPackage;
    }

    public Set<Class<? extends Annotation>> getNullnessAnnotations() {
        return this.nullnessAnnos;
    }

    @Override
    public Set<Class<? extends Annotation>> getInvalidConstructorReturnTypeAnnotations() {
        HashSet<Class<? extends Annotation>> l = new HashSet<Class<? extends Annotation>>(super.getInvalidConstructorReturnTypeAnnotations());
        l.addAll(this.getNullnessAnnotations());
        return l;
    }

    @Override
    public AnnotationMirror getFieldInvariantAnnotation() {
        Elements elements = this.processingEnv.getElementUtils();
        return AnnotationUtils.fromClass(elements, NonNull.class);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new NullnessQualifierHierarchy(factory, null);
    }

    protected class NullnessQualifierHierarchy
    extends InitializationAnnotatedTypeFactory.InitializationQualifierHierarchy {
        public NullnessQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, Object[] arg) {
            super(f, arg);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(rhs) || NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(lhs)) {
                return this.isSubtypeInitialization(rhs, lhs);
            }
            return super.isSubtype(rhs, lhs);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(a1) || NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(a2)) {
                return this.leastUpperBoundInitialization(a1, a2);
            }
            return super.leastUpperBound(a1, a2);
        }
    }

    protected class NullnessTypeAnnotator
    extends InitializationAnnotatedTypeFactory.CommitmentTypeAnnotator {
        public NullnessTypeAnnotator(InitializationAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory) {
            super(atypeFactory);
        }
    }

    protected class NullnessTreeAnnotator
    extends InitializationAnnotatedTypeFactory.CommitmentTreeAnnotator {
        public NullnessTreeAnnotator(NullnessAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror type2) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type2);
            return (Void)super.visitMemberSelect(node, type2);
        }

        @Override
        public Void visitVariable(VariableTree node, AnnotatedTypeMirror type2) {
            Element elt = InternalUtils.symbol(node);
            if (elt.getKind() == ElementKind.EXCEPTION_PARAMETER && !type2.isAnnotatedInHierarchy(NullnessAnnotatedTypeFactory.this.NONNULL)) {
                type2.addAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return (Void)super.visitVariable(node, type2);
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror type2) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type2);
            if (elt.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                type2.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return (Void)super.visitIdentifier(node, type2);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type2) {
            type2.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type2) {
            type2.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return super.visitCompoundAssignment(node, type2);
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type2) {
            type2.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror type2) {
            type2.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return super.visitNewClass(node, type2);
        }
    }
}

