/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.basetype.BaseTypeChecker;
import checkers.quals.FromByteCode;
import checkers.quals.FromStubFile;
import checkers.quals.PolymorphicQualifier;
import checkers.quals.StubFiles;
import checkers.quals.SubtypeOf;
import checkers.quals.TypeQualifiers;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeFromElement;
import checkers.types.TypeFromTree;
import checkers.types.TypeHierarchy;
import checkers.types.VisitorState;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.util.AnnotatedTypes;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import checkers.util.stub.StubParser;
import checkers.util.stub.StubResource;
import checkers.util.stub.StubUtil;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import dataflow.quals.SideEffectFree;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationProvider;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.ErrorReporter;
import javacutils.InternalUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javacutils.trees.DetachedVarSymbol;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jmlspecs.annotation.Pure;

public class AnnotatedTypeFactory
implements AnnotationProvider {
    protected final Trees trees;
    protected CompilationUnitTree root;
    protected final ProcessingEnvironment processingEnv;
    protected final Elements elements;
    protected final Types types;
    protected final VisitorState visitorState;
    protected QualifierHierarchy qualHierarchy;
    protected TypeHierarchy typeHierarchy;
    private final Set<Class<? extends Annotation>> supportedQuals;
    private Map<Element, AnnotatedTypeMirror> indexTypes;
    private Map<String, Set<AnnotationMirror>> indexDeclAnnos;
    protected final BaseTypeChecker checker;
    private final Map<String, AnnotationMirror> aliases = new HashMap<String, AnnotationMirror>();
    private final Map<String, Pair<AnnotationMirror, Set<String>>> declAliases = new HashMap<String, Pair<AnnotationMirror, Set<String>>>();
    private static int uidCounter = 0;
    public final int uid;
    private final AnnotationMirror fromByteCode;
    protected static boolean SHOULD_CACHE = true;
    public boolean shouldCache = SHOULD_CACHE;
    protected static boolean SHOULD_READ_CACHE = true;
    public boolean shouldReadCache = SHOULD_READ_CACHE;
    private static final int CACHE_SIZE = 300;
    private final Map<Tree, AnnotatedTypeMirror> treeCache = AnnotatedTypeFactory.createLRUCache(300);
    protected final Map<Tree, AnnotatedTypeMirror> fromTreeCache = AnnotatedTypeFactory.createLRUCache(300);
    private final Map<Element, AnnotatedTypeMirror> elementCache = AnnotatedTypeFactory.createLRUCache(300);
    private final Map<Element, Tree> elementToTreeCache = AnnotatedTypeFactory.createLRUCache(300);
    private final Map<Tree, Element> pathHack = new HashMap<Tree, Element>();

    public AnnotatedTypeFactory(BaseTypeChecker checker) {
        this.uid = ++uidCounter;
        this.processingEnv = checker.getProcessingEnvironment();
        this.checker = checker;
        this.trees = Trees.instance(this.processingEnv);
        this.elements = this.processingEnv.getElementUtils();
        this.types = this.processingEnv.getTypeUtils();
        this.visitorState = new VisitorState();
        this.supportedQuals = this.createSupportedTypeQualifiers();
        this.fromByteCode = AnnotationUtils.fromClass(this.elements, FromByteCode.class);
    }

    protected void postInit() {
        this.qualHierarchy = this.createQualifierHierarchy();
        if (this.qualHierarchy == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory with null qualifier hierarchy not supported.");
        }
        this.typeHierarchy = this.createTypeHierarchy();
        this.addAliasedDeclAnnotation(Pure.class, dataflow.quals.Pure.class, AnnotationUtils.fromClass(this.elements, dataflow.quals.Pure.class));
        if (this.getClass().equals(AnnotatedTypeFactory.class)) {
            this.buildIndexTypes();
        }
    }

    public void setRoot(CompilationUnitTree root) {
        this.root = root;
    }

    @SideEffectFree
    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.uid;
    }

    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new GraphQualifierHierarchy(factory, null);
    }

    protected QualifierHierarchy createQualifierHierarchy() {
        Set<Class<? extends Annotation>> supportedTypeQualifiers = this.getSupportedTypeQualifiers();
        MultiGraphQualifierHierarchy.MultiGraphFactory factory = this.createQualifierHierarchyFactory();
        return AnnotatedTypeFactory.createQualifierHierarchy(this.elements, supportedTypeQualifiers, factory);
    }

    protected static QualifierHierarchy createQualifierHierarchy(Elements elements, Set<Class<? extends Annotation>> supportedTypeQualifiers, MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        for (Class<? extends Annotation> typeQualifier : supportedTypeQualifiers) {
            Class<? extends Annotation>[] superQualifiers;
            AnnotationMirror typeQualifierAnno = AnnotationUtils.fromClass(elements, typeQualifier);
            assert (typeQualifierAnno != null) : "Loading annotation \"" + typeQualifier + "\" failed!";
            factory.addQualifier(typeQualifierAnno);
            if (typeQualifier.getAnnotation(PolymorphicQualifier.class) != null) {
                if (typeQualifier.getAnnotation(SubtypeOf.class) == null) continue;
                ErrorReporter.errorAbort("AnnotatedTypeFactory: " + typeQualifier + " is polymorphic and specifies super qualifiers. " + "Remove the @checkers.quals.SubtypeOf or @checkers.quals.PolymorphicQualifier annotation from it.");
                continue;
            }
            if (typeQualifier.getAnnotation(SubtypeOf.class) == null) {
                ErrorReporter.errorAbort("AnnotatedTypeFactory: " + typeQualifier + " does not specify its super qualifiers. " + "Add an @checkers.quals.SubtypeOf annotation to it.");
            }
            for (Class<? extends Annotation> superQualifier : superQualifiers = typeQualifier.getAnnotation(SubtypeOf.class).value()) {
                if (!supportedTypeQualifiers.contains(superQualifier)) continue;
                AnnotationMirror superAnno = null;
                superAnno = AnnotationUtils.fromClass(elements, superQualifier);
                factory.addSubtype(typeQualifierAnno, superAnno);
            }
        }
        QualifierHierarchy hierarchy = factory.build();
        if (!hierarchy.isValid()) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory: invalid qualifier hierarchy: " + hierarchy.getClass() + " " + hierarchy);
        }
        return hierarchy;
    }

    public final QualifierHierarchy getQualifierHierarchy() {
        return this.qualHierarchy;
    }

    protected TypeHierarchy createTypeHierarchy() {
        return new TypeHierarchy(this.checker, this.getQualifierHierarchy());
    }

    public final TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        Class<?> classType = this.getClass();
        TypeQualifiers typeQualifiersAnnotation = classType.getAnnotation(TypeQualifiers.class);
        if (typeQualifiersAnnotation == null) {
            classType = this.checker.getClass();
            typeQualifiersAnnotation = classType.getAnnotation(TypeQualifiers.class);
        }
        if (typeQualifiersAnnotation != null) {
            HashSet<Class<? extends Annotation>> typeQualifiers = new HashSet<Class<? extends Annotation>>();
            for (Class<? extends Annotation> qualifier : typeQualifiersAnnotation.value()) {
                typeQualifiers.add(qualifier);
            }
            return Collections.unmodifiableSet(typeQualifiers);
        }
        return Collections.emptySet();
    }

    public final Set<Class<? extends Annotation>> getSupportedTypeQualifiers() {
        return this.supportedQuals;
    }

    public AnnotatedTypeMirror getAnnotatedType(Element elt) {
        if (elt == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedType: null element");
            return null;
        }
        AnnotatedTypeMirror type2 = this.fromElement(elt);
        this.annotateInheritedFromClass(type2);
        this.annotateImplicit(elt, type2);
        return type2;
    }

    public AnnotatedTypeMirror getAnnotatedType(Tree tree) {
        AnnotatedTypeMirror type2;
        if (tree == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedType: null tree");
            return null;
        }
        if (this.treeCache.containsKey(tree) && this.shouldReadCache) {
            return AnnotatedTypes.deepCopy(this.treeCache.get(tree));
        }
        if (TreeUtils.isClassTree(tree)) {
            type2 = this.fromClass((ClassTree)tree);
        } else if (tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.VARIABLE) {
            type2 = this.fromMember(tree);
        } else if (TreeUtils.isExpressionTree(tree)) {
            tree = TreeUtils.skipParens((ExpressionTree)tree);
            type2 = this.fromExpression((ExpressionTree)tree);
        } else {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedType: query of annotated type for tree " + (Object)((Object)tree.getKind()));
            type2 = null;
        }
        this.annotateImplicit(tree, type2);
        if ((TreeUtils.isClassTree(tree) || tree.getKind() == Tree.Kind.METHOD) && this.shouldCache) {
            this.treeCache.put(tree, AnnotatedTypes.deepCopy(type2));
        }
        return type2;
    }

    public AnnotatedTypeMirror getAnnotatedTypeFromTypeTree(Tree tree) {
        if (tree == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getAnnotatedTypeFromTypeTree: null tree");
            return null;
        }
        AnnotatedTypeMirror type2 = this.fromTypeTree(tree);
        this.annotateImplicit(tree, type2);
        return type2;
    }

    public AnnotatedTypeMirror fromElement(Element elt) {
        AnnotatedTypeMirror type2;
        if (this.elementCache.containsKey(elt) && this.shouldReadCache) {
            return AnnotatedTypes.deepCopy(this.elementCache.get(elt));
        }
        if (elt.getKind() == ElementKind.PACKAGE) {
            return this.toAnnotatedType(elt.asType());
        }
        Tree decl = this.declarationFromElement(elt);
        this.addFromByteCode(elt);
        if (decl == null && this.indexTypes != null && this.indexTypes.containsKey(elt)) {
            type2 = AnnotatedTypes.deepCopy(this.indexTypes.get(elt));
        } else if (!(decl != null || this.indexTypes != null && this.indexTypes.containsKey(elt))) {
            type2 = this.toAnnotatedType(elt.asType());
            TypeFromElement.annotate(type2, elt);
            if (elt instanceof ExecutableElement || elt instanceof VariableElement) {
                this.annotateInheritedFromClass(type2);
            }
        } else if (decl instanceof ClassTree) {
            type2 = this.fromClass((ClassTree)decl);
        } else if (decl instanceof VariableTree) {
            type2 = this.fromMember(decl);
        } else if (decl instanceof MethodTree) {
            type2 = this.fromMember(decl);
        } else if (decl.getKind() == Tree.Kind.TYPE_PARAMETER) {
            type2 = this.fromTypeTree(decl);
        } else {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.fromElement: cannot be here! decl: " + (Object)((Object)decl.getKind()) + " elt: " + elt, null);
            type2 = null;
        }
        if (this.shouldCache && this.indexTypes != null) {
            this.elementCache.put(elt, AnnotatedTypes.deepCopy(type2));
        }
        return type2;
    }

    private void addFromByteCode(Element elt) {
        if (this.indexDeclAnnos == null) {
            return;
        }
        if (elt instanceof Symbol.MethodSymbol && ElementUtils.isElementFromByteCode(elt)) {
            Set<AnnotationMirror> annos = this.indexDeclAnnos.get(ElementUtils.getVerboseName(elt));
            if (annos == null) {
                annos = AnnotationUtils.createAnnotationSet();
                this.indexDeclAnnos.put(ElementUtils.getVerboseName(elt), annos);
            }
            if (!annos.contains(AnnotationUtils.fromClass(this.elements, FromStubFile.class))) {
                annos.add(this.fromByteCode);
            }
        }
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType fromClass(ClassTree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType result2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTreeWithVisitor(TypeFromTree.TypeFromClassINSTANCE, tree);
        return result2;
    }

    public AnnotatedTypeMirror fromMember(Tree tree) {
        if (!(tree instanceof MethodTree) && !(tree instanceof VariableTree)) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.fromMember: not a method or variable declaration: " + tree);
            return null;
        }
        if (this.fromTreeCache.containsKey(tree) && this.shouldReadCache) {
            return AnnotatedTypes.deepCopy(this.fromTreeCache.get(tree));
        }
        AnnotatedTypeMirror result2 = this.fromTreeWithVisitor(TypeFromTree.TypeFromMemberINSTANCE, tree);
        this.annotateInheritedFromClass(result2);
        if (this.shouldCache) {
            this.fromTreeCache.put(tree, AnnotatedTypes.deepCopy(result2));
        }
        return result2;
    }

    public AnnotatedTypeMirror fromExpression(ExpressionTree tree) {
        if (this.fromTreeCache.containsKey(tree) && this.shouldReadCache) {
            return AnnotatedTypes.deepCopy(this.fromTreeCache.get(tree));
        }
        AnnotatedTypeMirror result2 = this.fromTreeWithVisitor(TypeFromTree.TypeFromExpressionINSTANCE, tree);
        this.annotateInheritedFromClass(result2);
        if (this.shouldCache) {
            this.fromTreeCache.put(tree, AnnotatedTypes.deepCopy(result2));
        }
        return result2;
    }

    public AnnotatedTypeMirror fromTypeTree(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType dt;
        if (this.fromTreeCache.containsKey(tree) && this.shouldReadCache) {
            return AnnotatedTypes.deepCopy(this.fromTreeCache.get(tree));
        }
        AnnotatedTypeMirror result2 = this.fromTreeWithVisitor(TypeFromTree.TypeFromTypeTreeINSTANCE, tree);
        if (result2.getKind() == TypeKind.DECLARED && (dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)result2).wasRaw()) {
            List<Object> typeArgs;
            Pair<Tree, AnnotatedTypeMirror> ctx = this.visitorState.getAssignmentContext();
            if (ctx != null) {
                typeArgs = ((AnnotatedTypeMirror)ctx.second).getKind() == TypeKind.DECLARED && this.types.isSameType(this.types.erasure(((AnnotatedTypeMirror)ctx.second).actualType), this.types.erasure(dt.actualType)) ? ((AnnotatedTypeMirror.AnnotatedDeclaredType)ctx.second).getTypeArguments() : null;
            } else {
                typeArgs = new ArrayList();
                AnnotatedTypeMirror.AnnotatedDeclaredType declaration = this.fromElement((TypeElement)dt.getUnderlyingType().asElement());
                for (AnnotatedTypeMirror typeParam : declaration.getTypeArguments()) {
                    AnnotatedTypeMirror.AnnotatedWildcardType wct = this.getUninferredWildcardType((AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam, false);
                    typeArgs.add(wct);
                }
            }
            dt.setTypeArguments(typeArgs);
        }
        this.annotateInheritedFromClass(result2);
        if (this.shouldCache) {
            this.fromTreeCache.put(tree, AnnotatedTypes.deepCopy(result2));
        }
        return result2;
    }

    private AnnotatedTypeMirror fromTreeWithVisitor(TypeFromTree converter, Tree tree) {
        if (tree == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.fromTreeWithVisitor: null tree");
        }
        if (converter == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.fromTreeWithVisitor: null visitor");
        }
        AnnotatedTypeMirror result2 = (AnnotatedTypeMirror)converter.visit(tree, this);
        this.checkRep(result2);
        return result2;
    }

    public void annotateImplicit(Tree tree, AnnotatedTypeMirror type2) {
    }

    protected void annotateImplicit(Element elt, AnnotatedTypeMirror type2) {
    }

    protected void postDirectSuperTypes(AnnotatedTypeMirror type2, List<? extends AnnotatedTypeMirror> supertypes2) {
        Set<AnnotationMirror> annotations2 = type2.getEffectiveAnnotations();
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes2) {
            if (annotations2.equals(annotatedTypeMirror.getEffectiveAnnotations())) continue;
            annotatedTypeMirror.clearAnnotations();
            annotatedTypeMirror.addAnnotations(annotations2);
        }
    }

    public void postAsMemberOf(AnnotatedTypeMirror type2, AnnotatedTypeMirror owner, Element element) {
        this.annotateImplicit(element, type2);
    }

    public List<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVariablesFromUse(AnnotatedTypeMirror.AnnotatedDeclaredType type2, TypeElement element) {
        AnnotatedTypeMirror.AnnotatedDeclaredType generic = this.getAnnotatedType(element);
        List<AnnotatedTypeMirror> targs = type2.getTypeArguments();
        List<AnnotatedTypeMirror> tvars = generic.getTypeArguments();
        assert (targs.size() == tvars.size()) : "Mismatch in type argument size between " + type2 + " and " + generic;
        HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> mapping = new HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror>();
        for (int i = 0; i < targs.size(); ++i) {
            mapping.put((AnnotatedTypeMirror.AnnotatedTypeVariable)tvars.get(i), targs.get(i));
        }
        LinkedList<AnnotatedTypeMirror.AnnotatedTypeVariable> res = new LinkedList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (AnnotatedTypeMirror atm : tvars) {
            AnnotatedTypeMirror.AnnotatedTypeVariable atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)atm;
            atv.setUpperBound(atv.getUpperBound().substitute(mapping));
            atv.setLowerBound(atv.getLowerBound().substitute(mapping));
            res.add(atv);
        }
        return res;
    }

    protected void annotateInheritedFromClass(AnnotatedTypeMirror type2) {
        InheritedFromClassAnnotator.INSTANCE.visit(type2, this);
    }

    protected void annotateInheritedFromClass(AnnotatedTypeMirror type2, Set<AnnotationMirror> fromClass) {
        type2.addMissingAnnotations(fromClass);
    }

    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(ExpressionTree tree) {
        assert (tree.getKind() == Tree.Kind.IDENTIFIER || tree.getKind() == Tree.Kind.MEMBER_SELECT || tree.getKind() == Tree.Kind.METHOD_INVOCATION || tree.getKind() == Tree.Kind.NEW_CLASS) : "Unexpected tree kind: " + (Object)((Object)tree.getKind());
        Element element = InternalUtils.symbol(tree);
        assert (element != null) : "Unexpected null element for tree: " + tree;
        if (!ElementUtils.hasReceiver(element)) {
            return null;
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(tree);
        if (receiver == null) {
            if (this.isMostEnclosingThisDeref(tree)) {
                return this.getSelfType(tree);
            }
            TreePath path = this.getPath(tree);
            if (path == null) {
                return null;
            }
            TypeElement typeElt = ElementUtils.enclosingClass(element);
            if (typeElt == null) {
                ErrorReporter.errorAbort("AnnotatedTypeFactory.getImplicitReceiver: enclosingClass()==null for element: " + element);
            }
            return this.getEnclosingType(typeElt, tree);
        }
        Element rcvelem = InternalUtils.symbol(receiver);
        assert (rcvelem != null) : "Unexpected null element for receiver: " + receiver;
        if (!ElementUtils.hasReceiver(rcvelem)) {
            return null;
        }
        if (receiver.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)receiver).getName().contentEquals("this")) {
            return this.getSelfType(tree);
        }
        TypeElement typeElt = ElementUtils.enclosingClass(rcvelem);
        if (typeElt == null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.getImplicitReceiver: enclosingClass()==null for element: " + rcvelem);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType type2 = this.getAnnotatedType(typeElt);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.getCurrentMethodReceiver(tree);
        if (methodReceiver != null && (methodReceiver.getAnnotations().size() != 1 || methodReceiver.getAnnotation(Unqualified.class) == null)) {
            type2.clearAnnotations();
            type2.addAnnotations(methodReceiver.getAnnotations());
        }
        return type2;
    }

    public final boolean isMostEnclosingThisDeref(ExpressionTree tree) {
        if (!this.isAnyEnclosingThisDeref(tree)) {
            return false;
        }
        Element element = TreeUtils.elementFromUse(tree);
        TypeElement typeElt = ElementUtils.enclosingClass(element);
        ClassTree enclosingClass = this.getCurrentClassTree(tree);
        return enclosingClass != null && this.isSubtype(TreeUtils.elementFromDeclaration(enclosingClass), typeElt);
    }

    private final boolean isExplicitThisDereference(ExpressionTree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)tree).getName().contentEquals("this")) {
            return true;
        }
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree memSelTree = (MemberSelectTree)tree;
        return memSelTree.getIdentifier().contentEquals("this");
    }

    public final boolean isAnyEnclosingThisDeref(ExpressionTree tree) {
        if (!TreeUtils.isUseOfElement(tree)) {
            return false;
        }
        ExpressionTree recv = TreeUtils.getReceiverTree(tree);
        if (recv == null) {
            Name n;
            Element element = TreeUtils.elementFromUse(tree);
            if (!ElementUtils.hasReceiver(element)) {
                return false;
            }
            return (tree = TreeUtils.skipParens(tree)).getKind() != Tree.Kind.IDENTIFIER || !"this".contentEquals(n = ((IdentifierTree)tree).getName()) && !"super".contentEquals(n);
        }
        if (!TreeUtils.isUseOfElement(recv)) {
            return false;
        }
        Element element = TreeUtils.elementFromUse(recv);
        if (!ElementUtils.hasReceiver(element)) {
            return false;
        }
        return this.isExplicitThisDereference(recv);
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type2 = this.getCurrentClassType(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.getCurrentMethodReceiver(tree);
        if (!(methodReceiver == null || methodReceiver.getAnnotations().size() == 1 && methodReceiver.hasAnnotation(Unqualified.class))) {
            type2.clearAnnotations();
            type2.addAnnotations(methodReceiver.getAnnotations());
        }
        return type2;
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getEnclosingType(TypeElement element, Tree tree) {
        for (Element enclosingElt = this.getMostInnerClassOrMethod(tree); enclosingElt != null; enclosingElt = enclosingElt.getEnclosingElement()) {
            if (enclosingElt instanceof ExecutableElement) {
                ExecutableElement method = (ExecutableElement)enclosingElt;
                if (method.asType() == null || !this.isSubtype((TypeElement)method.getEnclosingElement(), element)) continue;
                if (ElementUtils.isStatic(method)) {
                    return null;
                }
                return this.getAnnotatedType(method).getReceiverType();
            }
            if (!(enclosingElt instanceof TypeElement) || !this.isSubtype((TypeElement)enclosingElt, element)) continue;
            return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(enclosingElt);
        }
        return null;
    }

    private boolean isSubtype(TypeElement a1, TypeElement a2) {
        return a1.equals(a2) || this.types.isSubtype(this.types.erasure(a1.asType()), this.types.erasure(a2.asType()));
    }

    public final AnnotatedTypeMirror getReceiverType(ExpressionTree expression) {
        if (this.isAnyEnclosingThisDeref(expression)) {
            return this.getImplicitReceiverType(expression);
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(expression);
        if (receiver != null) {
            return this.getAnnotatedType(receiver);
        }
        return null;
    }

    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        ExecutableElement methodElt = TreeUtils.elementFromUse(tree);
        AnnotatedTypeMirror receiverType = this.getReceiverType(tree);
        AnnotatedTypeMirror methodType = AnnotatedTypes.asMemberOf(this.types, this, receiverType, methodElt);
        LinkedList<AnnotatedTypeMirror> typeargs = new LinkedList<AnnotatedTypeMirror>();
        Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeVarMapping = AnnotatedTypes.findTypeArguments(this.processingEnv, this, tree);
        if (!typeVarMapping.isEmpty()) {
            for (AnnotatedTypeMirror.AnnotatedTypeVariable tv : ((AnnotatedTypeMirror.AnnotatedExecutableType)methodType).getTypeVariables()) {
                if (typeVarMapping.get(tv) == null) {
                    System.err.println("Detected a mismatch between the declared method type variables and the inferred method type arguments. Something is going wrong!");
                    System.err.println("Method type variables: " + ((AnnotatedTypeMirror.AnnotatedExecutableType)methodType).getTypeVariables());
                    System.err.println("Inferred method type arguments: " + typeVarMapping);
                    ErrorReporter.errorAbort("AnnotatedTypeFactory.methodFromUse: mismatch between declared method type variables and the inferred method type arguments!");
                }
                typeargs.add(typeVarMapping.get(tv));
            }
            methodType = ((AnnotatedTypeMirror.AnnotatedExecutableType)methodType).substitute(typeVarMapping);
        }
        return Pair.of(methodType, typeargs);
    }

    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        ExecutableElement ctor = InternalUtils.constructor(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType type2 = this.fromNewClass(tree);
        this.annotateImplicit(tree.getIdentifier(), (AnnotatedTypeMirror)type2);
        AnnotatedTypeMirror con = AnnotatedTypes.asMemberOf(this.types, this, (AnnotatedTypeMirror)type2, ctor);
        if (tree.getArguments().size() == ((AnnotatedTypeMirror.AnnotatedExecutableType)con).getParameterTypes().size() + 1 && this.isSyntheticArgument(tree.getArguments().get(0))) {
            ArrayList<AnnotatedTypeMirror> actualParams = new ArrayList<AnnotatedTypeMirror>();
            actualParams.add(this.getAnnotatedType(tree.getArguments().get(0)));
            actualParams.addAll(((AnnotatedTypeMirror.AnnotatedExecutableType)con).getParameterTypes());
            ((AnnotatedTypeMirror.AnnotatedExecutableType)con).setParameterTypes(actualParams);
        }
        LinkedList<AnnotatedTypeMirror> typeargs = new LinkedList<AnnotatedTypeMirror>();
        Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeVarMapping = AnnotatedTypes.findTypeArguments(this.processingEnv, this, tree);
        if (!typeVarMapping.isEmpty()) {
            for (AnnotatedTypeMirror.AnnotatedTypeVariable tv : ((AnnotatedTypeMirror.AnnotatedExecutableType)con).getTypeVariables()) {
                typeargs.add(typeVarMapping.get(tv));
            }
            con = ((AnnotatedTypeMirror.AnnotatedExecutableType)con).substitute(typeVarMapping);
        }
        return Pair.of(con, typeargs);
    }

    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3, ReturnTree r) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.getAnnotatedType(m3);
        AnnotatedTypeMirror ret = methodType.getReturnType();
        return ret;
    }

    private boolean isSyntheticArgument(Tree tree) {
        return tree.toString().contains("<*nullchk*>");
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType fromNewClass(NewClassTree tree) {
        AnnotatedTypeMirror ctxtype;
        Pair<Tree, AnnotatedTypeMirror> ctx;
        if (!TreeUtils.isDiamondTree(tree)) {
            return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTypeTree(tree.getIdentifier());
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType type2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.toAnnotatedType(((JCTree)((Object)tree)).type);
        if (tree.getIdentifier().getKind() == Tree.Kind.ANNOTATED_TYPE) {
            type2.addAnnotations(InternalUtils.annotationsFromTree((AnnotatedTypeTree)((Object)tree)));
        }
        if ((ctx = this.visitorState.getAssignmentContext()) != null && (ctxtype = (AnnotatedTypeMirror)ctx.second).getKind() == TypeKind.DECLARED && this.types.isSameType(this.types.erasure(ctxtype.actualType), this.types.erasure(type2.actualType))) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adctx = (AnnotatedTypeMirror.AnnotatedDeclaredType)ctxtype;
            assert (type2.getTypeArguments().size() == adctx.getTypeArguments().size()) : "Strange type argument size mismatch";
            type2.setTypeArguments(adctx.getTypeArguments());
        }
        return type2;
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getBoxedType(AnnotatedTypeMirror.AnnotatedPrimitiveType type2) {
        TypeElement typeElt = this.types.boxedClass(type2.getUnderlyingType());
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = this.fromElement(typeElt);
        dt.addAnnotations(type2.getAnnotations());
        return dt;
    }

    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type2) throws IllegalArgumentException {
        PrimitiveType primitiveType = this.types.unboxedType(type2.getUnderlyingType());
        AnnotatedTypeMirror.AnnotatedPrimitiveType pt = (AnnotatedTypeMirror.AnnotatedPrimitiveType)AnnotatedTypeMirror.createType(primitiveType, this);
        pt.addAnnotations(type2.getAnnotations());
        return pt;
    }

    public VisitorState getVisitorState() {
        return this.visitorState;
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(ClassTree tree) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(NewClassTree tree) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedArrayType getAnnotatedType(NewArrayTree tree) {
        return (AnnotatedTypeMirror.AnnotatedArrayType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType getAnnotatedType(MethodTree tree) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(TypeElement elt) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType getAnnotatedType(ExecutableElement elt) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.getAnnotatedType((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType fromElement(TypeElement elt) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromElement((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType fromElement(ExecutableElement elt) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.fromElement((Element)elt);
    }

    public boolean isSupportedQualifier(AnnotationMirror a) {
        if (a == null) {
            return false;
        }
        return AnnotationUtils.containsSameIgnoringValues(this.getQualifierHierarchy().getTypeQualifiers(), a);
    }

    protected void addAliasedAnnotation(Class<?> alias, AnnotationMirror type2) {
        this.aliases.put(alias.getCanonicalName(), type2);
    }

    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        TypeElement elem = (TypeElement)a.getAnnotationType().asElement();
        String qualName = elem.getQualifiedName().toString();
        return this.aliases.get(qualName);
    }

    protected void addAliasedDeclAnnotation(Class<? extends Annotation> alias, Class<? extends Annotation> annotation, AnnotationMirror annotationToUse) {
        String aliasName = alias.getCanonicalName();
        String annotationName = annotation.getCanonicalName();
        HashSet<String> set = new HashSet<String>();
        if (this.declAliases.containsKey(annotationName)) {
            set.addAll((Collection)this.declAliases.get((Object)annotationName).second);
        }
        set.add(aliasName.intern());
        this.declAliases.put(annotationName, Pair.of(annotationToUse, set));
    }

    public final AnnotatedTypeMirror toAnnotatedType(TypeMirror t) {
        return AnnotatedTypeMirror.createType(t, this);
    }

    public AnnotatedTypeMirror type(Tree node) {
        if (((JCTree)node).type != null) {
            AnnotatedTypeMirror result2 = this.toAnnotatedType(((JCTree)node).type);
            return result2;
        }
        TreePath path = this.getPath(node);
        assert (path != null) : "No path or type in tree: " + node;
        TypeMirror t = this.trees.getTypeMirror(path);
        assert (AnnotatedTypeFactory.validType(t)) : "Invalid type " + t + " for node " + t;
        return this.toAnnotatedType(t);
    }

    protected final Tree declarationFromElement(Element elt) {
        Tree fromElt;
        if (this.root == null) {
            return null;
        }
        if (this.elementToTreeCache.containsKey(elt) && this.shouldReadCache) {
            return this.elementToTreeCache.get(elt);
        }
        if (elt instanceof DetachedVarSymbol) {
            return ((DetachedVarSymbol)elt).getDeclaration();
        }
        switch (elt.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case FIELD: 
            case ENUM_CONSTANT: 
            case METHOD: 
            case CONSTRUCTOR: {
                fromElt = this.trees.getTree(elt);
                break;
            }
            default: {
                fromElt = TreeInfo.declarationFor((Symbol)elt, (JCTree)((Object)this.root));
            }
        }
        if (this.shouldCache) {
            this.elementToTreeCache.put(elt, fromElt);
        }
        return fromElt;
    }

    protected final ClassTree getCurrentClassTree(Tree tree) {
        if (this.visitorState.getClassTree() != null) {
            return this.visitorState.getClassTree();
        }
        return TreeUtils.enclosingClass(this.getPath(tree));
    }

    protected final AnnotatedTypeMirror.AnnotatedDeclaredType getCurrentClassType(Tree tree) {
        return this.getAnnotatedType(this.getCurrentClassTree(tree));
    }

    protected final AnnotatedTypeMirror.AnnotatedDeclaredType getCurrentMethodReceiver(Tree tree) {
        MethodTree enclosingMethod;
        AnnotatedTypeMirror.AnnotatedDeclaredType res = this.visitorState.getMethodReceiver();
        if (res == null && (enclosingMethod = TreeUtils.enclosingMethod(this.getPath(tree))) != null) {
            AnnotatedTypeMirror.AnnotatedExecutableType method = this.getAnnotatedType(enclosingMethod);
            res = method.getReceiverType();
        }
        return res;
    }

    protected final boolean isWithinConstructor(Tree tree) {
        if (this.visitorState.getClassType() != null) {
            return this.visitorState.getMethodTree() != null && TreeUtils.isConstructor(this.visitorState.getMethodTree());
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getPath(tree));
        return enclosingMethod != null && TreeUtils.isConstructor(enclosingMethod);
    }

    private final Element getMostInnerClassOrMethod(Tree tree) {
        if (this.visitorState.getMethodTree() != null) {
            return TreeUtils.elementFromDeclaration(this.visitorState.getMethodTree());
        }
        if (this.visitorState.getClassTree() != null) {
            return TreeUtils.elementFromDeclaration(this.visitorState.getClassTree());
        }
        TreePath path = this.getPath(tree);
        if (path == null) {
            ErrorReporter.errorAbort(String.format("AnnotatedTypeFactory.getMostInnerClassOrMethod: getPath(tree)=>null%n  TreePath.getPath(root, tree)=>%s\n  for tree (%s) = %s%n  root=%s", TreePath.getPath(this.root, tree), tree.getClass(), tree, this.root));
        }
        for (Tree pathTree : path) {
            if (pathTree instanceof MethodTree) {
                return TreeUtils.elementFromDeclaration((MethodTree)pathTree);
            }
            if (!(pathTree instanceof ClassTree)) continue;
            return TreeUtils.elementFromDeclaration((ClassTree)pathTree);
        }
        ErrorReporter.errorAbort("AnnotatedTypeFactory.getMostInnerClassOrMethod: cannot be here!");
        return null;
    }

    public final void setPathHack(Tree node, Element enclosing) {
        this.pathHack.put(node, enclosing);
    }

    public final TreePath getPath(Tree node) {
        assert (this.root != null) : "AnnotatedTypeFactory.getPath: root needs to be set when used on trees; factory: " + this.getClass();
        if (node == null) {
            return null;
        }
        TreePath currentPath = this.visitorState.getPath();
        if (currentPath == null) {
            return TreePath.getPath(this.root, node);
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        if (currentPath.getParentPath() != null) {
            currentPath = currentPath.getParentPath();
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        if (currentPath.getParentPath() != null) {
            currentPath = currentPath.getParentPath();
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        TreePath pathWithinSubtree = TreePath.getPath(currentPath, node);
        if (pathWithinSubtree != null) {
            return pathWithinSubtree;
        }
        for (TreePath current = currentPath; current != null; current = current.getParentPath()) {
            if (current.getLeaf() != node) continue;
            return current;
        }
        return TreePath.getPath(this.root, node);
    }

    public final Element getEnclosingMethod(Tree node) {
        return this.pathHack.get(node);
    }

    private void checkRep(AnnotatedTypeMirror type2) {
        new AnnotatedTypeScanner<Void, Void>(){

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, Void p) {
                return (Void)super.visitDeclared(type2, p);
            }

            @Override
            public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type2, Void p) {
                assert (type2.getElement() != null) : "Unexpected null executable type.";
                return (Void)super.visitExecutable(type2, p);
            }
        }.visit(type2);
    }

    static final boolean validAnnotatedType(AnnotatedTypeMirror type2) {
        if (type2 == null) {
            return false;
        }
        if (type2.getUnderlyingType() == null) {
            return true;
        }
        return AnnotatedTypeFactory.validType(type2.getUnderlyingType());
    }

    private static final boolean validType(TypeMirror type2) {
        if (type2 == null) {
            return false;
        }
        switch (type2.getKind()) {
            case ERROR: 
            case OTHER: 
            case PACKAGE: {
                return false;
            }
        }
        return true;
    }

    protected static <K, V> Map<K, V> createLRUCache(final int size2) {
        return new LinkedHashMap<K, V>(){
            private static final long serialVersionUID = 5261489276168775084L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > size2;
            }
        };
    }

    protected void buildIndexTypes() {
        String[] stubArray;
        StubFiles sfanno;
        InputStream input;
        StubParser stubParser;
        if (this.indexTypes != null || this.indexDeclAnnos != null) {
            ErrorReporter.errorAbort("AnnotatedTypeFactory.buildIndexTypes called more than once");
        }
        HashMap<Element, AnnotatedTypeMirror> indexTypes = new HashMap<Element, AnnotatedTypeMirror>();
        HashMap<String, Set<AnnotationMirror>> indexDeclAnnos = new HashMap<String, Set<AnnotationMirror>>();
        if (!this.checker.hasOption("ignorejdkastub")) {
            InputStream in = null;
            if (this.checker != null) {
                in = this.checker.getClass().getResourceAsStream("jdk.astub");
            }
            if (in != null) {
                stubParser = new StubParser("jdk.astub", in, this, this.processingEnv);
                stubParser.parse(indexTypes, indexDeclAnnos);
            }
        }
        if ((input = BaseTypeChecker.class.getResourceAsStream("flow.astub")) != null) {
            stubParser = new StubParser("flow.astub", input, this, this.processingEnv);
            stubParser.parse(indexTypes, indexDeclAnnos);
        }
        String allstubFiles = "";
        String stubFiles = this.checker.getOption("stubs");
        if (stubFiles != null) {
            allstubFiles = allstubFiles + File.pathSeparator + stubFiles;
        }
        if ((stubFiles = System.getProperty("stubs")) != null) {
            allstubFiles = allstubFiles + File.pathSeparator + stubFiles;
        }
        if ((stubFiles = System.getenv("stubs")) != null) {
            allstubFiles = allstubFiles + File.pathSeparator + stubFiles;
        }
        if ((sfanno = this.checker.getClass().getAnnotation(StubFiles.class)) != null) {
            String[] sfarr = sfanno.value();
            stubFiles = "";
            String[] stringArray = sfarr;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String sf = stringArray[i];
                stubFiles = stubFiles + File.pathSeparator + sf;
            }
            allstubFiles = allstubFiles + stubFiles;
        }
        if (allstubFiles.isEmpty()) {
            this.indexTypes = indexTypes;
            this.indexDeclAnnos = indexDeclAnnos;
            return;
        }
        for (String stubPath : stubArray = allstubFiles.split(File.pathSeparator)) {
            List<StubResource> stubs;
            if (stubPath == null || stubPath.isEmpty()) continue;
            String base = System.getProperty("test.src");
            if (base != null) {
                stubPath = base + "/" + stubPath;
            }
            if ((stubs = StubUtil.allStubFiles(stubPath)).size() == 0) {
                InputStream in = null;
                if (this.checker != null) {
                    in = this.checker.getClass().getResourceAsStream(stubPath);
                }
                if (in != null) {
                    StubParser stubParser2 = new StubParser(stubPath, in, this, this.processingEnv);
                    stubParser2.parse(indexTypes, indexDeclAnnos);
                    continue;
                }
                System.err.println("Did not find stub file or files within directory: " + stubPath);
            }
            for (StubResource resource2 : stubs) {
                InputStream stubStream;
                try {
                    stubStream = resource2.getInputStream();
                }
                catch (IOException e) {
                    System.err.println("Could not read stub resource: " + resource2.getDescription());
                    continue;
                }
                StubParser stubParser3 = new StubParser(resource2.getDescription(), stubStream, this, this.processingEnv);
                stubParser3.parse(indexTypes, indexDeclAnnos);
            }
        }
        this.indexTypes = indexTypes;
        this.indexDeclAnnos = indexDeclAnnos;
    }

    @Override
    public AnnotationMirror getDeclAnnotation(Element elt, Class<? extends Annotation> anno) {
        String annoName = anno.getCanonicalName().intern();
        String eltName = ElementUtils.getVerboseName(elt);
        List<? extends AnnotationMirror> annotationMirrors = elt.getAnnotationMirrors();
        return this.getDeclAnnotation(eltName, annoName, annotationMirrors, true);
    }

    public boolean isFromStubFile(Element element) {
        return this.getDeclAnnotation(element, FromStubFile.class) != null;
    }

    public boolean isFromByteCode(Element element) {
        if (this.isFromStubFile(element)) {
            return false;
        }
        return this.getDeclAnnotation(element, FromByteCode.class) != null;
    }

    private AnnotationMirror getDeclAnnotation(String eltName, String annoName, List<? extends AnnotationMirror> annotationMirrors, boolean checkAliases) {
        Set<AnnotationMirror> stubAnnos;
        Pair<AnnotationMirror, Set<String>> aliases;
        Pair<AnnotationMirror, Set<String>> pair = aliases = checkAliases ? this.declAliases.get(annoName) : null;
        if (this.indexDeclAnnos != null && (stubAnnos = this.indexDeclAnnos.get(eltName)) != null) {
            for (AnnotationMirror am : stubAnnos) {
                if (!AnnotationUtils.areSameByName(am, annoName)) continue;
                return am;
            }
        }
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!AnnotationUtils.areSameByName(annotationMirror, annoName)) continue;
            return annotationMirror;
        }
        if (aliases != null) {
            for (String string : (Set)aliases.second) {
                AnnotationMirror declAnnotation = this.getDeclAnnotation(eltName, string, annotationMirrors, false);
                if (declAnnotation == null) continue;
                return (AnnotationMirror)aliases.first;
            }
        }
        return null;
    }

    public Set<AnnotationMirror> getDeclAnnotations(Element elt) {
        HashSet<AnnotationMirror> results = new HashSet<AnnotationMirror>();
        String eltName = ElementUtils.getVerboseName(elt);
        Set<AnnotationMirror> stubAnnos = this.indexDeclAnnos.get(eltName);
        if (stubAnnos != null) {
            results.addAll(stubAnnos);
        }
        results.addAll(elt.getAnnotationMirrors());
        return results;
    }

    public List<Pair<AnnotationMirror, AnnotationMirror>> getDeclAnnotationWithMetaAnnotation(Element element, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Pair<AnnotationMirror, AnnotationMirror>> result2 = new ArrayList<Pair<AnnotationMirror, AnnotationMirror>>();
        ArrayList<? extends AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();
        annotationMirrors.addAll(element.getAnnotationMirrors());
        String eltName = ElementUtils.getVerboseName(element);
        Set<AnnotationMirror> stubAnnos = this.indexDeclAnnos.get(eltName);
        if (stubAnnos != null) {
            annotationMirrors.addAll(stubAnnos);
        }
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            List<? extends AnnotationMirror> annotationsOnAnnotation = annotationMirror.getAnnotationType().asElement().getAnnotationMirrors();
            for (AnnotationMirror annotationMirror2 : annotationsOnAnnotation) {
                if (!AnnotationUtils.areSameByClass(annotationMirror2, metaAnnotation)) continue;
                result2.add(Pair.of(annotationMirror, annotationMirror2));
            }
        }
        return result2;
    }

    public List<Pair<AnnotationMirror, AnnotationMirror>> getAnnotationWithMetaAnnotation(Element element, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Pair<AnnotationMirror, AnnotationMirror>> result2 = new ArrayList<Pair<AnnotationMirror, AnnotationMirror>>();
        ArrayList<AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();
        annotationMirrors.addAll(this.getAnnotatedType(element).getAnnotations());
        String eltName = ElementUtils.getVerboseName(element);
        Set<AnnotationMirror> stubAnnos = this.indexDeclAnnos.get(eltName);
        if (stubAnnos != null) {
            annotationMirrors.addAll(stubAnnos);
        }
        for (AnnotationMirror annotation : annotationMirrors) {
            List<? extends AnnotationMirror> annotationsOnAnnotation = annotation.getAnnotationType().asElement().getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationsOnAnnotation) {
                if (!AnnotationUtils.areSameByClass(annotationMirror, metaAnnotation)) continue;
                result2.add(Pair.of(annotation, annotationMirror));
            }
        }
        return result2;
    }

    public AnnotatedTypeMirror.AnnotatedWildcardType getUninferredMethodTypeArgument(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
        return this.getUninferredWildcardType(typeVar, true);
    }

    protected AnnotatedTypeMirror.AnnotatedWildcardType getUninferredWildcardType(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar, boolean useHack) {
        AnnotatedTypeMirror upperBound = typeVar.getEffectiveUpperBound();
        while (upperBound.getKind() == TypeKind.TYPEVAR) {
            upperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)upperBound).getEffectiveUpperBound();
        }
        if (upperBound.getKind() == TypeKind.INTERSECTION) {
            upperBound = ((AnnotatedTypeMirror.AnnotatedIntersectionType)upperBound).directSuperTypes().get(0);
        }
        WildcardType wc = this.types.getWildcardType(upperBound.getUnderlyingType(), null);
        AnnotatedTypeMirror.AnnotatedWildcardType wctype = (AnnotatedTypeMirror.AnnotatedWildcardType)AnnotatedTypeMirror.createType(wc, this);
        wctype.setExtendsBound(upperBound);
        wctype.addAnnotations(typeVar.getAnnotations());
        if (useHack) {
            wctype.setMethodTypeArgHack();
        }
        return wctype;
    }

    public AnnotatedTypeMirror.AnnotatedWildcardType getWildcardBoundedBy(AnnotatedTypeMirror upper) {
        WildcardType wc = this.types.getWildcardType(upper.getUnderlyingType(), null);
        AnnotatedTypeMirror.AnnotatedWildcardType wctype = (AnnotatedTypeMirror.AnnotatedWildcardType)AnnotatedTypeMirror.createType(wc, this);
        wctype.setExtendsBound(upper);
        return wctype;
    }

    public Elements getElementUtils() {
        return this.elements;
    }

    public Trees getTreeUtils() {
        return this.trees;
    }

    public ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    protected static class InheritedFromClassAnnotator
    extends AnnotatedTypeScanner<Void, AnnotatedTypeFactory> {
        public static final InheritedFromClassAnnotator INSTANCE = new InheritedFromClassAnnotator();
        private final Map<TypeParameterElement, AnnotatedTypeMirror.AnnotatedTypeVariable> visited = new HashMap<TypeParameterElement, AnnotatedTypeMirror.AnnotatedTypeVariable>();

        private InheritedFromClassAnnotator() {
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type2, AnnotatedTypeFactory p) {
            this.scan(type2.getReturnType(), p);
            this.scanAndReduce(type2.getParameterTypes(), p, null);
            this.scanAndReduce(type2.getThrownTypes(), p, null);
            this.scanAndReduce(type2.getTypeVariables(), p, null);
            return null;
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, AnnotatedTypeFactory p) {
            Element classElt = type2.getUnderlyingType().asElement();
            if (classElt != null) {
                AnnotatedTypeMirror classType = p.fromElement(classElt);
                assert (classType != null) : "Unexpected null type for class element: " + classElt;
                p.annotateInheritedFromClass(type2, classType.getAnnotations());
            }
            return (Void)super.visitDeclared(type2, p);
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, AnnotatedTypeFactory p) {
            TypeParameterElement tpelt = (TypeParameterElement)type2.getUnderlyingType().asElement();
            if (!this.visited.containsKey(tpelt)) {
                this.visited.put(tpelt, type2);
                if (type2.getAnnotations().isEmpty() && type2.getUpperBound().getAnnotations().isEmpty() && tpelt.getEnclosingElement().getKind() != ElementKind.TYPE_PARAMETER) {
                    TypeFromElement.annotate((AnnotatedTypeMirror)type2, tpelt);
                }
                super.visitTypeVariable(type2, p);
                this.visited.remove(tpelt);
            }
            return null;
        }

        @Override
        public void reset() {
            this.visited.clear();
            super.reset();
        }
    }
}

