/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.initialization.quals.FBCBottom;
import checkers.initialization.quals.Initialized;
import checkers.quals.InvisibleQualifier;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeFromElement;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.AnnotatedTypeVisitor;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.AnnotatedTypes;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import dataflow.quals.Pure;
import dataflow.quals.SideEffectFree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.ErrorReporter;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class AnnotatedTypeMirror {
    protected final AnnotatedTypeFactory atypeFactory;
    protected final TypeMirror actualType;
    protected final Set<AnnotationMirror> annotations = AnnotationUtils.createAnnotationSet();
    private static SuperTypeFinder superTypeFinder;
    private static Replacer replacer;

    public static AnnotatedTypeMirror createType(TypeMirror type2, AnnotatedTypeFactory atypeFactory) {
        if (type2 == null) {
            return null;
        }
        if (replacer == null) {
            replacer = new Replacer(atypeFactory.types);
        }
        type2 = ((Type)type2).unannotatedType();
        switch (type2.getKind()) {
            case ARRAY: {
                return new AnnotatedArrayType((ArrayType)type2, atypeFactory);
            }
            case DECLARED: {
                return new AnnotatedDeclaredType((DeclaredType)type2, atypeFactory);
            }
            case ERROR: {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: input should type-check already! Found error type: " + type2);
                return null;
            }
            case EXECUTABLE: {
                return new AnnotatedExecutableType((ExecutableType)type2, atypeFactory);
            }
            case VOID: 
            case PACKAGE: 
            case NONE: {
                return new AnnotatedNoType((NoType)type2, atypeFactory);
            }
            case NULL: {
                return new AnnotatedNullType((NullType)type2, atypeFactory);
            }
            case TYPEVAR: {
                return new AnnotatedTypeVariable((TypeVariable)type2, atypeFactory);
            }
            case WILDCARD: {
                return new AnnotatedWildcardType((WildcardType)type2, atypeFactory);
            }
            case INTERSECTION: {
                return new AnnotatedIntersectionType((IntersectionType)type2, atypeFactory);
            }
            case UNION: {
                return new AnnotatedUnionType((UnionType)type2, atypeFactory);
            }
        }
        if (type2.getKind().isPrimitive()) {
            return new AnnotatedPrimitiveType((PrimitiveType)type2, atypeFactory);
        }
        ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: unidentified type " + type2 + " (" + (Object)((Object)type2.getKind()) + ")");
        return null;
    }

    private AnnotatedTypeMirror(TypeMirror type2, AnnotatedTypeFactory atypeFactory) {
        this.actualType = type2;
        assert (atypeFactory != null);
        this.atypeFactory = atypeFactory;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotatedTypeMirror)) {
            return false;
        }
        AnnotatedTypeMirror t = (AnnotatedTypeMirror)o;
        return this.atypeFactory.types.isSameType(this.actualType, t.actualType) && AnnotationUtils.areSame(this.getAnnotations(), t.getAnnotations());
    }

    @Pure
    public int hashCode() {
        return this.annotations.toString().hashCode() * 17 + this.actualType.toString().hashCode() * 13;
    }

    public abstract <R, P> R accept(AnnotatedTypeVisitor<R, P> var1, P var2);

    public TypeKind getKind() {
        return this.actualType.getKind();
    }

    public TypeMirror getUnderlyingType() {
        return this.actualType;
    }

    public boolean isAnnotatedInHierarchy(AnnotationMirror p) {
        return this.getAnnotationInHierarchy(p) != null;
    }

    public AnnotationMirror getAnnotationInHierarchy(AnnotationMirror p) {
        QualifierHierarchy qualHier;
        AnnotationMirror anno;
        AnnotationMirror aliased = p;
        if (!this.atypeFactory.isSupportedQualifier(aliased)) {
            aliased = this.atypeFactory.aliasedAnnotation(p);
        }
        if (this.atypeFactory.isSupportedQualifier(aliased) && (anno = (qualHier = this.atypeFactory.getQualifierHierarchy()).findCorrespondingAnnotation(aliased, this.annotations)) != null) {
            return anno;
        }
        return null;
    }

    public AnnotationMirror getEffectiveAnnotationInHierarchy(AnnotationMirror p) {
        QualifierHierarchy qualHier;
        AnnotationMirror anno;
        AnnotationMirror aliased = p;
        if (!this.atypeFactory.isSupportedQualifier(aliased)) {
            aliased = this.atypeFactory.aliasedAnnotation(p);
        }
        if (this.atypeFactory.isSupportedQualifier(aliased) && (anno = (qualHier = this.atypeFactory.getQualifierHierarchy()).findCorrespondingAnnotation(aliased, this.getEffectiveAnnotations())) != null) {
            return anno;
        }
        return null;
    }

    public Set<AnnotationMirror> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public Set<AnnotationMirror> getEffectiveAnnotations() {
        Set<AnnotationMirror> effectiveAnnotations = this.getErased().getAnnotations();
        return effectiveAnnotations;
    }

    public AnnotationMirror getAnnotation(Name annotationName) {
        assert (annotationName != null) : "Null annotationName in getAnnotation";
        return this.getAnnotation(annotationName.toString().intern());
    }

    public AnnotationMirror getAnnotation(String annotationStr) {
        assert (annotationStr != null) : "Null annotationName in getAnnotation";
        for (AnnotationMirror anno : this.getAnnotations()) {
            if (!AnnotationUtils.areSameByName(anno, annotationStr)) continue;
            return anno;
        }
        return null;
    }

    public AnnotationMirror getAnnotation(Class<? extends Annotation> annoClass) {
        for (AnnotationMirror annoMirror : this.getAnnotations()) {
            if (!AnnotationUtils.areSameByClass(annoMirror, annoClass)) continue;
            return annoMirror;
        }
        return null;
    }

    public Set<AnnotationMirror> getExplicitAnnotations() {
        Set<AnnotationMirror> explicitAnnotations = AnnotationUtils.createAnnotationSet();
        List<? extends AnnotationMirror> typeAnnotations = this.getUnderlyingType().getAnnotationMirrors();
        Set<? extends AnnotationMirror> validAnnotations = this.atypeFactory.getQualifierHierarchy().getTypeQualifiers();
        for (AnnotationMirror annotationMirror : typeAnnotations) {
            for (AnnotationMirror annotationMirror2 : validAnnotations) {
                if (!AnnotationUtils.areSameIgnoringValues(annotationMirror, annotationMirror2)) continue;
                explicitAnnotations.add(annotationMirror);
            }
        }
        return explicitAnnotations;
    }

    public boolean hasAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getAnnotations(), a);
    }

    public boolean hasAnnotation(Name a) {
        return this.getAnnotation(a) != null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public boolean hasEffectiveAnnotation(Class<? extends Annotation> a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getEffectiveAnnotations(), AnnotationUtils.fromClass(this.atypeFactory.elements, a));
    }

    public boolean hasEffectiveAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getEffectiveAnnotations(), a);
    }

    public boolean hasExplicitAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getExplicitAnnotations(), a);
    }

    public boolean hasAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getAnnotations(), a);
    }

    public boolean hasEffectiveAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getEffectiveAnnotations(), a);
    }

    public boolean hasExplicitAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getExplicitAnnotations(), a);
    }

    public boolean hasExplicitAnnotation(Class<? extends Annotation> a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getExplicitAnnotations(), this.getAnnotation(a));
    }

    public void addAnnotation(AnnotationMirror a) {
        if (a == null) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.addAnnotation: null is not a valid annotation.");
        }
        if (this.atypeFactory.isSupportedQualifier(a)) {
            this.annotations.add(a);
        } else {
            AnnotationMirror aliased = this.atypeFactory.aliasedAnnotation(a);
            if (this.atypeFactory.isSupportedQualifier(aliased)) {
                this.addAnnotation(aliased);
            }
        }
    }

    public void replaceAnnotation(AnnotationMirror a) {
        this.removeAnnotationInHierarchy(a);
        this.addAnnotation(a);
    }

    public void addAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = AnnotationUtils.fromClass(this.atypeFactory.elements, a);
        this.addAnnotation(anno);
    }

    public void addAnnotations(Iterable<? extends AnnotationMirror> annotations2) {
        for (AnnotationMirror annotationMirror : annotations2) {
            this.addAnnotation(annotationMirror);
        }
    }

    public void addMissingAnnotations(Iterable<? extends AnnotationMirror> annotations2) {
        for (AnnotationMirror annotationMirror : annotations2) {
            if (this.isAnnotatedInHierarchy(annotationMirror)) continue;
            this.addAnnotation(annotationMirror);
        }
    }

    public void replaceAnnotations(Iterable<? extends AnnotationMirror> replAnnos) {
        for (AnnotationMirror annotationMirror : replAnnos) {
            this.removeAnnotationInHierarchy(annotationMirror);
            this.addAnnotation(annotationMirror);
        }
    }

    public boolean removeAnnotation(AnnotationMirror a) {
        AnnotationMirror anno = this.getAnnotation(AnnotationUtils.annotationName(a));
        if (anno != null) {
            return this.annotations.remove(anno);
        }
        return false;
    }

    public boolean removeAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = AnnotationUtils.fromClass(this.atypeFactory.elements, a);
        if (anno == null || !this.atypeFactory.isSupportedQualifier(anno)) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.removeAnnotation called with un-supported class: " + a);
        }
        return this.removeAnnotation(anno);
    }

    public boolean removeAnnotationInHierarchy(AnnotationMirror a) {
        AnnotationMirror prev = this.getAnnotationInHierarchy(a);
        if (prev != null) {
            return this.removeAnnotation(prev);
        }
        return false;
    }

    public boolean removeNonTopAnnotationInHierarchy(AnnotationMirror a) {
        AnnotationMirror prev = this.getAnnotationInHierarchy(a);
        QualifierHierarchy qualHier = this.atypeFactory.getQualifierHierarchy();
        if (prev != null && !prev.equals(qualHier.getTopAnnotation(a))) {
            return this.removeAnnotation(prev);
        }
        return false;
    }

    public boolean removeAnnotations(Iterable<? extends AnnotationMirror> annotations2) {
        boolean changed = false;
        for (AnnotationMirror annotationMirror : annotations2) {
            changed |= this.removeAnnotation(annotationMirror);
        }
        return changed;
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public static boolean isUnqualified(AnnotationMirror anno) {
        String aname = Unqualified.class.getCanonicalName();
        return ((TypeElement)anno.getAnnotationType().asElement()).getQualifiedName().contentEquals(aname);
    }

    private static boolean isInvisibleQualified(AnnotationMirror anno) {
        return ((TypeElement)anno.getAnnotationType().asElement()).getAnnotation(InvisibleQualifier.class) != null;
    }

    @SideEffectFree
    protected static final String formatAnnotationString(Collection<? extends AnnotationMirror> lst, boolean printInvisible) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationMirror annotationMirror : lst) {
            if (annotationMirror == null) {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.formatAnnotationString: found null AnnotationMirror!");
            }
            if (AnnotatedTypeMirror.isInvisibleQualified(annotationMirror) && !printInvisible) continue;
            AnnotatedTypeMirror.formatAnnotationMirror(annotationMirror, sb);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected static final void formatAnnotationMirror(AnnotationMirror am, StringBuilder sb) {
        sb.append("@");
        sb.append(am.getAnnotationType().asElement().getSimpleName());
        Map<? extends ExecutableElement, ? extends AnnotationValue> args2 = am.getElementValues();
        if (!args2.isEmpty()) {
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> first2;
            sb.append("(");
            boolean oneValue = false;
            if (args2.size() == 1 && (first2 = args2.entrySet().iterator().next()).getKey().getSimpleName().contentEquals("value")) {
                AnnotatedTypeMirror.formatAnnotationMirrorArg(first2.getValue(), sb);
                oneValue = true;
            }
            if (!oneValue) {
                boolean notfirst = false;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> arg : args2.entrySet()) {
                    if (notfirst) {
                        sb.append(", ");
                    }
                    notfirst = true;
                    sb.append(arg.getKey().getSimpleName() + "=");
                    AnnotatedTypeMirror.formatAnnotationMirrorArg(arg.getValue(), sb);
                }
            }
            sb.append(")");
        }
    }

    public static final String formatAnnotationMirror(AnnotationMirror am) {
        StringBuilder sb = new StringBuilder();
        AnnotatedTypeMirror.formatAnnotationMirror(am, sb);
        return sb.toString();
    }

    protected static final void formatAnnotationMirrorArg(AnnotationValue av, StringBuilder sb) {
        Object val = av.getValue();
        if (List.class.isAssignableFrom(val.getClass())) {
            List vallist = (List)val;
            if (vallist.size() == 1) {
                AnnotatedTypeMirror.formatAnnotationMirrorArg((AnnotationValue)vallist.get(0), sb);
            } else {
                sb.append('{');
                boolean notfirst = false;
                for (AnnotationValue nav : vallist) {
                    if (notfirst) {
                        sb.append(", ");
                    }
                    notfirst = true;
                    AnnotatedTypeMirror.formatAnnotationMirrorArg(nav, sb);
                }
                sb.append('}');
            }
        } else if (VariableElement.class.isAssignableFrom(val.getClass())) {
            VariableElement ve = (VariableElement)val;
            sb.append(ve.getEnclosingElement().getSimpleName() + "." + ve.getSimpleName());
        } else {
            sb.append(av.toString());
        }
    }

    @SideEffectFree
    public final String toString() {
        return this.toString(this.atypeFactory.checker.hasOption("printAllQualifiers"));
    }

    @SideEffectFree
    public String toString(boolean invisible) {
        return AnnotatedTypeMirror.formatAnnotationString(this.getAnnotations(), invisible) + this.actualType;
    }

    @SideEffectFree
    public String toStringDebug() {
        return this.toString(true) + " " + this.getClass().getSimpleName();
    }

    public AnnotatedTypeMirror getErased() {
        return this;
    }

    public abstract AnnotatedTypeMirror getCopy(boolean var1);

    protected static AnnotatedDeclaredType createTypeOfObject(AnnotatedTypeFactory atypeFactory) {
        AnnotatedDeclaredType objectType = atypeFactory.fromElement(atypeFactory.elements.getTypeElement(Object.class.getCanonicalName()));
        return objectType;
    }

    public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
        if (mappings.containsKey(this)) {
            return mappings.get(this).getCopy(true);
        }
        return this.getCopy(true);
    }

    public List<? extends AnnotatedTypeMirror> directSuperTypes() {
        return this.directSuperTypes(this);
    }

    protected final List<AnnotatedDeclaredType> directSuperTypes(AnnotatedDeclaredType type2) {
        AnnotatedTypeMirror.setSuperTypeFinder(type2.atypeFactory);
        List<AnnotatedDeclaredType> supertypes2 = superTypeFinder.visitDeclared(type2, null);
        this.atypeFactory.postDirectSuperTypes(type2, supertypes2);
        return supertypes2;
    }

    private final List<? extends AnnotatedTypeMirror> directSuperTypes(AnnotatedTypeMirror type2) {
        AnnotatedTypeMirror.setSuperTypeFinder(type2.atypeFactory);
        List supertypes2 = (List)superTypeFinder.visit(type2, null);
        this.atypeFactory.postDirectSuperTypes(type2, supertypes2);
        return supertypes2;
    }

    private static void setSuperTypeFinder(AnnotatedTypeFactory factory) {
        if (superTypeFinder == null || superTypeFinder.atypeFactory != factory) {
            superTypeFinder = new SuperTypeFinder(factory);
        }
    }

    private static void fixupBoundAnnotationsImpl(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror lowerBound, AnnotatedTypeMirror upperBound, Collection<AnnotationMirror> allAnnotations, AnnotationMirror top, AnnotationMirror lAnno, AnnotationMirror uAnno) {
        if (lAnno == null) {
            AnnotationMirror a = qualifierHierarchy.getAnnotationInHierarchy(allAnnotations, top);
            if (a != null) {
                lowerBound.replaceAnnotation(a);
                return;
            }
            lAnno = qualifierHierarchy.getBottomAnnotation(top);
            lowerBound.replaceAnnotation(lAnno);
        }
        if (lAnno != null && uAnno != null && AnnotationUtils.areSameByClass(lAnno, FBCBottom.class) && AnnotationUtils.areSameByClass(uAnno, Initialized.class)) {
            lowerBound.replaceAnnotation(uAnno);
            return;
        }
        if (uAnno != null && !qualifierHierarchy.isSubtype(lAnno, uAnno)) {
            if (qualifierHierarchy.isSubtype(uAnno, lAnno)) {
                lowerBound.replaceAnnotation(uAnno);
            } else {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.fixupBoundAnnotations: default annotation on lower bound ( " + lAnno + ") is inconsistent with explicit upper bound: " + upperBound);
            }
        }
    }

    private static class Replacer
    extends AnnotatedTypeScanner<Void, Map<TypeParameterElement, AnnotatedTypeMirror>> {
        final Types types;

        public Replacer(Types types) {
            this.types = types;
        }

        @Override
        public Void visitDeclared(AnnotatedDeclaredType type2, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
            ArrayList<AnnotatedTypeMirror> args2 = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror arg : type2.getTypeArguments()) {
                Element elem = this.types.asElement(arg.getUnderlyingType());
                if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                    AnnotatedTypeMirror other = mapping.get(elem);
                    other.replaceAnnotations(arg.annotations);
                    args2.add(other);
                    continue;
                }
                args2.add(arg);
            }
            type2.setTypeArguments(args2);
            return (Void)super.visitDeclared(type2, mapping);
        }

        @Override
        public Void visitArray(AnnotatedArrayType type2, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
            AnnotatedTypeMirror comptype = type2.getComponentType();
            Element elem = this.types.asElement(comptype.getUnderlyingType());
            if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                AnnotatedTypeMirror other = mapping.get(elem);
                other.replaceAnnotations(comptype.annotations);
                type2.setComponentType(other);
            }
            return (Void)super.visitArray(type2, mapping);
        }
    }

    private static class SuperTypeFinder
    extends SimpleAnnotatedTypeVisitor<List<? extends AnnotatedTypeMirror>, Void> {
        private final Types types;
        private final AnnotatedTypeFactory atypeFactory;

        SuperTypeFinder(AnnotatedTypeFactory atypeFactory) {
            this.atypeFactory = atypeFactory;
            this.types = atypeFactory.types;
        }

        @Override
        public List<AnnotatedTypeMirror> defaultAction(AnnotatedTypeMirror t, Void p) {
            return new ArrayList<AnnotatedTypeMirror>();
        }

        @Override
        public List<AnnotatedTypeMirror> visitPrimitive(AnnotatedPrimitiveType type2, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes2 = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations2 = type2.getAnnotations();
            TypeElement boxed = this.types.boxedClass(type2.getUnderlyingType());
            AnnotatedDeclaredType boxedType = this.atypeFactory.getAnnotatedType(boxed);
            boxedType.replaceAnnotations(annotations2);
            superTypes2.add(boxedType);
            TypeKind superPrimitiveType = null;
            if (type2.getKind() != TypeKind.BOOLEAN) {
                if (type2.getKind() == TypeKind.BYTE) {
                    superPrimitiveType = TypeKind.SHORT;
                } else if (type2.getKind() == TypeKind.CHAR) {
                    superPrimitiveType = TypeKind.INT;
                } else if (type2.getKind() != TypeKind.DOUBLE) {
                    if (type2.getKind() == TypeKind.FLOAT) {
                        superPrimitiveType = TypeKind.DOUBLE;
                    } else if (type2.getKind() == TypeKind.INT) {
                        superPrimitiveType = TypeKind.LONG;
                    } else if (type2.getKind() == TypeKind.LONG) {
                        superPrimitiveType = TypeKind.FLOAT;
                    } else if (type2.getKind() == TypeKind.SHORT) {
                        superPrimitiveType = TypeKind.INT;
                    } else assert (false) : "Forgot the primitive " + type2;
                }
            }
            if (superPrimitiveType != null) {
                AnnotatedPrimitiveType superPrimitive = (AnnotatedPrimitiveType)this.atypeFactory.toAnnotatedType(this.types.getPrimitiveType(superPrimitiveType));
                superPrimitive.addAnnotations(annotations2);
                superTypes2.add(superPrimitive);
            }
            return superTypes2;
        }

        @Override
        public List<AnnotatedDeclaredType> visitDeclared(AnnotatedDeclaredType type2, Void p) {
            ArrayList<AnnotatedDeclaredType> supertypes2 = new ArrayList<AnnotatedDeclaredType>();
            TypeElement typeElement = (TypeElement)type2.getUnderlyingType().asElement();
            HashMap<TypeParameterElement, AnnotatedTypeMirror> mapping = new HashMap<TypeParameterElement, AnnotatedTypeMirror>();
            for (int i = 0; i < typeElement.getTypeParameters().size() && i < type2.getTypeArguments().size(); ++i) {
                mapping.put(typeElement.getTypeParameters().get(i), type2.getTypeArguments().get(i));
            }
            ClassTree classTree = this.atypeFactory.trees.getTree(typeElement);
            if (classTree != null) {
                supertypes2.addAll(this.supertypesFromTree(type2, classTree));
            } else {
                supertypes2.addAll(this.supertypesFromElement(type2, typeElement));
            }
            for (AnnotatedDeclaredType dt : supertypes2) {
                replacer.visit(dt, mapping);
            }
            return supertypes2;
        }

        private List<AnnotatedDeclaredType> supertypesFromElement(AnnotatedDeclaredType type2, TypeElement typeElement) {
            ArrayList<AnnotatedDeclaredType> supertypes2 = new ArrayList<AnnotatedDeclaredType>();
            if (typeElement.getKind() == ElementKind.ENUM) {
                DeclaredType dt = (DeclaredType)typeElement.getSuperclass();
                AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(dt);
                List<AnnotatedTypeMirror> tas = annotatedDeclaredType.getTypeArguments();
                ArrayList<AnnotatedTypeMirror> newtas = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror t : tas) {
                    if (!this.atypeFactory.types.isSameType(t.getUnderlyingType(), type2.getUnderlyingType())) continue;
                    t.addAnnotations(type2.getAnnotations());
                    newtas.add(t);
                }
                annotatedDeclaredType.setTypeArguments(newtas);
                supertypes2.add(annotatedDeclaredType);
            } else if (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
                DeclaredType superClass = (DeclaredType)typeElement.getSuperclass();
                AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(superClass);
                supertypes2.add(annotatedDeclaredType);
            } else if (!ElementUtils.isObject(typeElement)) {
                supertypes2.add(AnnotatedTypeMirror.createTypeOfObject(this.atypeFactory));
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                AnnotatedDeclaredType ast = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(typeMirror);
                supertypes2.add(ast);
            }
            TypeFromElement.annotateSupers(supertypes2, typeElement);
            return supertypes2;
        }

        private List<AnnotatedDeclaredType> supertypesFromTree(AnnotatedDeclaredType type2, ClassTree classTree) {
            AnnotatedDeclaredType adt;
            ArrayList<AnnotatedDeclaredType> supertypes2 = new ArrayList<AnnotatedDeclaredType>();
            if (classTree.getExtendsClause() != null) {
                AnnotatedDeclaredType adt2 = (AnnotatedDeclaredType)this.atypeFactory.fromTypeTree(classTree.getExtendsClause());
                supertypes2.add(adt2);
            } else if (!ElementUtils.isObject(TreeUtils.elementFromDeclaration(classTree))) {
                supertypes2.add(AnnotatedTypeMirror.createTypeOfObject(this.atypeFactory));
            }
            for (Tree tree : classTree.getImplementsClause()) {
                adt = (AnnotatedDeclaredType)this.atypeFactory.getAnnotatedTypeFromTypeTree(tree);
                supertypes2.add(adt);
            }
            TypeElement elem = TreeUtils.elementFromDeclaration(classTree);
            if (elem.getKind() == ElementKind.ENUM) {
                DeclaredType declaredType = (DeclaredType)elem.getSuperclass();
                adt = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(declaredType);
                List<AnnotatedTypeMirror> tas = adt.getTypeArguments();
                ArrayList<AnnotatedTypeMirror> newtas = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror t : tas) {
                    if (!this.atypeFactory.types.isSameType(t.getUnderlyingType(), type2.getUnderlyingType())) continue;
                    t.addAnnotations(type2.getAnnotations());
                    newtas.add(t);
                }
                adt.setTypeArguments(newtas);
                supertypes2.add(adt);
            }
            return supertypes2;
        }

        @Override
        public List<AnnotatedTypeMirror> visitArray(AnnotatedArrayType type2, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes2 = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations2 = type2.getAnnotations();
            Elements elements = this.atypeFactory.elements;
            AnnotatedDeclaredType objectType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Object"));
            objectType.addAnnotations(annotations2);
            superTypes2.add(objectType);
            AnnotatedDeclaredType cloneableType2 = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Cloneable"));
            cloneableType2.addAnnotations(annotations2);
            superTypes2.add(cloneableType2);
            AnnotatedDeclaredType serializableType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.io.Serializable"));
            serializableType.addAnnotations(annotations2);
            superTypes2.add(serializableType);
            if (type2.getComponentType() instanceof AnnotatedReferenceType) {
                for (AnnotatedTypeMirror annotatedTypeMirror : type2.getComponentType().directSuperTypes()) {
                    ArrayType arrType = this.atypeFactory.types.getArrayType(annotatedTypeMirror.getUnderlyingType());
                    AnnotatedArrayType aarrType = (AnnotatedArrayType)this.atypeFactory.toAnnotatedType(arrType);
                    aarrType.setComponentType(annotatedTypeMirror);
                    aarrType.addAnnotations(annotations2);
                    superTypes2.add(aarrType);
                }
            }
            return superTypes2;
        }

        @Override
        public List<AnnotatedTypeMirror> visitTypeVariable(AnnotatedTypeVariable type2, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes2 = new ArrayList<AnnotatedTypeMirror>();
            if (type2.getEffectiveUpperBound() != null) {
                superTypes2.add(AnnotatedTypes.deepCopy(type2.getEffectiveUpperBound()));
            }
            return superTypes2;
        }

        @Override
        public List<AnnotatedTypeMirror> visitWildcard(AnnotatedWildcardType type2, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes2 = new ArrayList<AnnotatedTypeMirror>();
            if (type2.getEffectiveExtendsBound() != null) {
                superTypes2.add(AnnotatedTypes.deepCopy(type2.getEffectiveExtendsBound()));
            }
            return superTypes2;
        }
    }

    public static class AnnotatedUnionType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedDeclaredType> alternatives;

        private AnnotatedUnionType(UnionType type2, AnnotatedTypeFactory atypeFactory) {
            super(type2, atypeFactory);
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (AnnotatedDeclaredType adt : this.getAlternatives()) {
                if (!isFirst) {
                    sb.append(" | ");
                }
                sb.append(adt.toString(printInvisible));
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }

        @Override
        public AnnotatedUnionType getCopy(boolean copyAnnotations) {
            AnnotatedUnionType type2 = new AnnotatedUnionType((UnionType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            type2.alternatives = this.alternatives;
            return type2;
        }

        public List<AnnotatedDeclaredType> getAlternatives() {
            if (this.alternatives == null) {
                List<? extends TypeMirror> ualts = ((UnionType)this.actualType).getAlternatives();
                ArrayList<AnnotatedDeclaredType> res = new ArrayList<AnnotatedDeclaredType>(ualts.size());
                for (TypeMirror typeMirror : ualts) {
                    res.add((AnnotatedDeclaredType)AnnotatedUnionType.createType(typeMirror, this.atypeFactory));
                }
                this.alternatives = Collections.unmodifiableList(res);
            }
            return this.alternatives;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedUnionType type2 = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type2);
            if (this.alternatives != null) {
                ArrayList<AnnotatedDeclaredType> alternatives = new ArrayList<AnnotatedDeclaredType>();
                for (AnnotatedDeclaredType t : this.getAlternatives()) {
                    alternatives.add((AnnotatedDeclaredType)t.substitute(newMappings));
                }
                type2.alternatives = alternatives;
            }
            return type2;
        }
    }

    public static class AnnotatedIntersectionType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedDeclaredType> supertypes;

        private AnnotatedIntersectionType(IntersectionType type2, AnnotatedTypeFactory atypeFactory) {
            super(type2, atypeFactory);
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (AnnotatedDeclaredType adt : this.directSuperTypes()) {
                if (!isFirst) {
                    sb.append(" & ");
                }
                sb.append(adt.toString(printInvisible));
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }

        @Override
        public AnnotatedIntersectionType getCopy(boolean copyAnnotations) {
            AnnotatedIntersectionType type2 = new AnnotatedIntersectionType((IntersectionType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            type2.supertypes = this.supertypes;
            return type2;
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                List<? extends TypeMirror> ubounds = ((IntersectionType)this.actualType).getBounds();
                ArrayList<AnnotatedDeclaredType> res = new ArrayList<AnnotatedDeclaredType>(ubounds.size());
                for (TypeMirror typeMirror : ubounds) {
                    res.add((AnnotatedDeclaredType)AnnotatedIntersectionType.createType(typeMirror, this.atypeFactory));
                }
                this.supertypes = Collections.unmodifiableList(res);
            }
            return this.supertypes;
        }

        public List<AnnotatedDeclaredType> directSuperTypesField() {
            return this.supertypes;
        }

        void setDirectSuperTypes(List<AnnotatedDeclaredType> supertypes2) {
            this.supertypes = new ArrayList<AnnotatedDeclaredType>(supertypes2);
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedIntersectionType type2 = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type2);
            if (this.supertypes != null) {
                ArrayList<AnnotatedDeclaredType> supertypes2 = new ArrayList<AnnotatedDeclaredType>();
                for (AnnotatedDeclaredType t : this.directSuperTypes()) {
                    supertypes2.add((AnnotatedDeclaredType)t.substitute(newMappings));
                }
                type2.supertypes = supertypes2;
            }
            return type2;
        }
    }

    public static class AnnotatedWildcardType
    extends AnnotatedTypeMirror {
        private AnnotatedTypeMirror superBound;
        private AnnotatedTypeMirror extendsBound;
        boolean isPrintingBound = false;
        private boolean methodTypeArgHack = false;

        private AnnotatedWildcardType(WildcardType type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
        }

        void setSuperBound(AnnotatedTypeMirror type2) {
            this.superBound = type2;
        }

        public AnnotatedTypeMirror getSuperBoundField() {
            return this.superBound;
        }

        public AnnotatedTypeMirror getSuperBound() {
            if (this.superBound == null && ((WildcardType)this.actualType).getSuperBound() != null) {
                AnnotatedTypeMirror annosupertype = AnnotatedWildcardType.createType(((WildcardType)this.actualType).getSuperBound(), this.atypeFactory);
                this.setSuperBound(annosupertype);
                this.fixupBoundAnnotations();
            }
            return this.superBound;
        }

        public AnnotatedTypeMirror getEffectiveSuperBound() {
            AnnotatedTypeMirror spb = this.getSuperBound();
            if (spb == null) {
                return null;
            }
            AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(spb);
            effbnd.replaceAnnotations(this.annotations);
            return effbnd;
        }

        void setExtendsBound(AnnotatedTypeMirror type2) {
            this.extendsBound = type2;
        }

        public AnnotatedTypeMirror getExtendsBoundField() {
            return this.extendsBound;
        }

        public AnnotatedTypeMirror getExtendsBound() {
            if (this.extendsBound == null) {
                TypeMirror extType = ((WildcardType)this.actualType).getExtendsBound();
                if (extType == null) {
                    Type.WildcardType wct = (Type.WildcardType)this.actualType;
                    Context ctx = ((JavacProcessingEnvironment)this.atypeFactory.processingEnv).getContext();
                    extType = com.sun.tools.javac.code.Types.instance(ctx).upperBound(wct);
                }
                AnnotatedTypeMirror annoexttype = AnnotatedWildcardType.createType(extType, this.atypeFactory);
                this.setExtendsBound(annoexttype);
                this.fixupBoundAnnotations();
            }
            return this.extendsBound;
        }

        private void fixupBoundAnnotations() {
        }

        public AnnotatedTypeMirror getEffectiveExtendsBound() {
            AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(this.getExtendsBound());
            effbnd.replaceAnnotations(this.annotations);
            return effbnd;
        }

        public Set<AnnotationMirror> getEffectiveExtendsBoundAnnotations() {
            Set<AnnotationMirror> result2 = this.annotations;
            if (result2.isEmpty()) {
                AnnotatedTypeMirror ub = this.getExtendsBound();
                if (ub != null) {
                    return ub.getEffectiveAnnotations();
                }
                return Collections.unmodifiableSet(result2);
            }
            result2 = AnnotationUtils.createAnnotationSet();
            result2.addAll(this.annotations);
            Set<Object> boundAnnotations = Collections.emptySet();
            AnnotatedTypeMirror ub = this.getExtendsBound();
            if (ub != null) {
                boundAnnotations = ub.getEffectiveAnnotations();
            }
            Iterator iterator2 = boundAnnotations.iterator();
            while (iterator2.hasNext()) {
                QualifierHierarchy qualHierarchy = this.atypeFactory.qualHierarchy;
                AnnotationMirror boundAnnotation = (AnnotationMirror)iterator2.next();
                AnnotationMirror top = qualHierarchy.getTopAnnotation(boundAnnotation);
                if (qualHierarchy.getAnnotationInHierarchy(result2, top) != null) continue;
                result2.add(boundAnnotation);
            }
            return Collections.unmodifiableSet(result2);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public WildcardType getUnderlyingType() {
            return (WildcardType)this.actualType;
        }

        @Override
        public AnnotatedWildcardType getCopy(boolean copyAnnotations) {
            AnnotatedWildcardType type2 = new AnnotatedWildcardType((WildcardType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            type2.setExtendsBound(this.getExtendsBound());
            type2.setSuperBound(this.getSuperBound());
            type2.methodTypeArgHack = this.methodTypeArgHack;
            return type2;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedWildcardType type2 = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMapping.put(this, type2);
            if (this.extendsBound != null) {
                type2.setExtendsBound(this.extendsBound.substitute(newMapping));
            }
            if (this.superBound != null) {
                type2.setSuperBound(this.superBound.substitute(newMapping));
            }
            if (type2.getExtendsBound() != null && type2.getSuperBound() != null && AnnotatedTypes.areSame(type2.getExtendsBound(), type2.getSuperBound())) {
                return type2.getExtendsBound();
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getEffectiveExtendsBound().getErased();
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            sb.append(AnnotatedWildcardType.formatAnnotationString(this.annotations, printInvisible));
            sb.append("?");
            if (!this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    if (this.getSuperBoundField() != null && this.getSuperBoundField().getKind() != TypeKind.NULL) {
                        sb.append(" super ");
                        sb.append(this.getSuperBoundField().toString(printInvisible));
                    }
                    if (this.getExtendsBoundField() != null && this.getExtendsBoundField().getKind() != TypeKind.NONE) {
                        sb.append(" extends ");
                        sb.append(this.getExtendsBoundField().toString(printInvisible));
                    }
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return sb.toString();
        }

        void setMethodTypeArgHack() {
            this.methodTypeArgHack = true;
        }

        boolean isMethodTypeArgHack() {
            return this.methodTypeArgHack;
        }
    }

    public static class AnnotatedPrimitiveType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private AnnotatedPrimitiveType(PrimitiveType type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public PrimitiveType getUnderlyingType() {
            return (PrimitiveType)this.actualType;
        }

        @Override
        public AnnotatedPrimitiveType getCopy(boolean copyAnnotations) {
            AnnotatedPrimitiveType type2 = new AnnotatedPrimitiveType((PrimitiveType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            return this.getCopy(true);
        }
    }

    public static class AnnotatedNullType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private AnnotatedNullType(NullType type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public NullType getUnderlyingType() {
            return (NullType)this.actualType;
        }

        @Override
        public AnnotatedNullType getCopy(boolean copyAnnotations) {
            AnnotatedNullType type2 = new AnnotatedNullType((NullType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            return this.getCopy(true);
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            if (printInvisible) {
                return AnnotatedNullType.formatAnnotationString(this.getAnnotations(), printInvisible) + "null";
            }
            return "null";
        }
    }

    public static class AnnotatedNoType
    extends AnnotatedTypeMirror {
        private AnnotatedNoType(NoType type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public NoType getUnderlyingType() {
            return (NoType)this.actualType;
        }

        @Override
        public AnnotatedNoType getCopy(boolean copyAnnotations) {
            AnnotatedNoType type2 = new AnnotatedNoType((NoType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            return this.getCopy(true);
        }
    }

    public static class AnnotatedTypeVariable
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private AnnotatedTypeMirror lowerBound;
        private AnnotatedTypeMirror upperBound;
        private boolean inUpperBounds = false;
        boolean isPrintingBound = false;

        private AnnotatedTypeVariable(TypeVariable type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }

        @Override
        public TypeVariable getUnderlyingType() {
            return (TypeVariable)this.actualType;
        }

        void setLowerBound(AnnotatedTypeMirror type2) {
            this.lowerBound = type2;
        }

        public AnnotatedTypeMirror getLowerBoundField() {
            return this.lowerBound;
        }

        public AnnotatedTypeMirror getLowerBound() {
            if (this.lowerBound == null && ((TypeVariable)this.actualType).getLowerBound() != null) {
                this.setLowerBound(AnnotatedTypeVariable.createType(((TypeVariable)this.actualType).getLowerBound(), this.atypeFactory));
                this.fixupBoundAnnotations();
            }
            return this.lowerBound;
        }

        public AnnotatedTypeMirror getEffectiveLowerBound() {
            AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(this.getLowerBound());
            effbnd.replaceAnnotations(this.annotations);
            return effbnd;
        }

        private void fixupBoundAnnotations() {
            if (!this.annotations.isEmpty() && this.upperBound != null) {
                this.upperBound = this.upperBound.getCopy(true);
                this.upperBound.replaceAnnotations(this.annotations);
            }
            if (this.upperBound == null || this.upperBound.getAnnotations().isEmpty()) {
                // empty if block
            }
            if (((TypeVariable)this.actualType).getLowerBound() instanceof NullType && this.lowerBound != null && this.upperBound != null) {
                Set<AnnotationMirror> lAnnos = this.lowerBound.getEffectiveAnnotations();
                Set<AnnotationMirror> uAnnos = this.upperBound.getEffectiveAnnotations();
                QualifierHierarchy qualifierHierarchy = this.atypeFactory.getQualifierHierarchy();
                for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
                    AnnotationMirror lAnno = qualifierHierarchy.getAnnotationInHierarchy(lAnnos, annotationMirror);
                    AnnotationMirror uAnno = qualifierHierarchy.getAnnotationInHierarchy(uAnnos, annotationMirror);
                    AnnotatedTypeMirror.fixupBoundAnnotationsImpl(qualifierHierarchy, this.lowerBound, this.upperBound, this.annotations, annotationMirror, lAnno, uAnno);
                }
            }
        }

        void setUpperBound(AnnotatedTypeMirror type2) {
            this.upperBound = type2;
        }

        public AnnotatedTypeMirror getUpperBoundField() {
            return this.upperBound;
        }

        public AnnotatedTypeMirror getUpperBound() {
            if (this.upperBound == null && ((TypeVariable)this.actualType).getUpperBound() != null) {
                this.setUpperBound(AnnotatedTypeVariable.createType(((TypeVariable)this.actualType).getUpperBound(), this.atypeFactory));
                this.fixupBoundAnnotations();
            }
            return this.upperBound;
        }

        public AnnotatedTypeMirror getEffectiveUpperBound() {
            AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(this.getUpperBound());
            effbnd.replaceAnnotations(this.annotations);
            return effbnd;
        }

        @Override
        public AnnotatedTypeVariable getCopy(boolean copyAnnotations) {
            AnnotatedTypeVariable type2 = new AnnotatedTypeVariable((TypeVariable)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            if (!this.inUpperBounds) {
                this.inUpperBounds = true;
                type2.inUpperBounds = true;
                type2.setUpperBound(this.getUpperBound());
                this.inUpperBounds = false;
                type2.inUpperBounds = false;
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getEffectiveUpperBound().getErased();
        }

        private static <K extends AnnotatedTypeMirror, V extends AnnotatedTypeMirror> V mapGetHelper(Map<K, V> mappings, AnnotatedTypeVariable key) {
            for (Map.Entry<K, V> entry : mappings.entrySet()) {
                AnnotatedTypeMirror possible = (AnnotatedTypeMirror)entry.getKey();
                AnnotatedTypeMirror possValue = (AnnotatedTypeMirror)entry.getValue();
                if (possible == key) {
                    return (V)possValue;
                }
                if (!(possible instanceof AnnotatedTypeVariable)) continue;
                AnnotatedTypeVariable other = (AnnotatedTypeVariable)possible;
                Element oElt = other.getUnderlyingType().asElement();
                if (!key.getUnderlyingType().asElement().equals(oElt)) continue;
                if (!key.annotations.isEmpty() && !AnnotationUtils.areSame(key.annotations, other.annotations)) {
                    AnnotatedTypeMirror found = possValue.getCopy(false);
                    found.addAnnotations(possValue.getAnnotations());
                    found.replaceAnnotations(key.annotations);
                    return (V)found;
                }
                return (V)possValue;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            AnnotatedTypeMirror found = AnnotatedTypeVariable.mapGetHelper(mappings, this);
            if (found != null) {
                return found;
            }
            AnnotatedTypeVariable type2 = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type2);
            if (this.lowerBound != null) {
                type2.setLowerBound(this.lowerBound.substitute(newMappings));
            }
            if (this.upperBound != null) {
                type2.setUpperBound(this.upperBound.substitute(newMappings));
            }
            return type2;
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            sb.append(AnnotatedTypeVariable.formatAnnotationString(this.annotations, printInvisible));
            sb.append(this.actualType);
            if (!this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    if (this.getLowerBoundField() != null && this.getLowerBoundField().getKind() != TypeKind.NULL) {
                        sb.append(" super ");
                        sb.append(this.getLowerBoundField().toString(printInvisible));
                    }
                    if (this.getUpperBoundField() != null && this.getUpperBoundField().getKind() != TypeKind.NULL) {
                        sb.append(" extends ");
                        sb.append(this.getUpperBoundField().toString(printInvisible));
                    }
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return sb.toString();
        }

        @Override
        @Pure
        public int hashCode() {
            return this.getUnderlyingType().hashCode();
        }
    }

    public static class AnnotatedArrayType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private final ArrayType actualType;
        private AnnotatedTypeMirror componentType;

        private AnnotatedArrayType(ArrayType type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
            this.actualType = type2;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }

        @Override
        public ArrayType getUnderlyingType() {
            return this.actualType;
        }

        public void setComponentType(AnnotatedTypeMirror type2) {
            this.componentType = type2;
        }

        public AnnotatedTypeMirror getComponentType() {
            if (this.componentType == null) {
                this.setComponentType(AnnotatedArrayType.createType(this.actualType.getComponentType(), this.atypeFactory));
            }
            return this.componentType;
        }

        @Override
        public AnnotatedArrayType getCopy(boolean copyAnnotations) {
            AnnotatedArrayType type2 = new AnnotatedArrayType(this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            type2.setComponentType(this.getComponentType());
            return type2;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedArrayType type2 = this.getCopy(true);
            AnnotatedTypeMirror c = this.getComponentType();
            AnnotatedTypeMirror cs = c.substitute(mappings);
            type2.setComponentType(cs);
            return type2;
        }

        @Override
        public AnnotatedArrayType getErased() {
            AnnotatedArrayType at2 = this.getCopy(true);
            AnnotatedTypeMirror ct = at2.getComponentType().getErased();
            at2.setComponentType(ct);
            return at2;
        }

        public String toStringAsCanonical(boolean printInvisible) {
            AnnotatedTypeMirror component;
            StringBuilder sb = new StringBuilder();
            AnnotatedArrayType array = this;
            while (true) {
                component = array.getComponentType();
                if (array.getAnnotations().size() > 0) {
                    sb.append(' ');
                    sb.append(AnnotatedArrayType.formatAnnotationString(array.getAnnotations(), printInvisible));
                }
                sb.append("[]");
                if (!(component instanceof AnnotatedArrayType)) break;
                array = (AnnotatedArrayType)component;
            }
            sb.insert(0, component.toString(printInvisible));
            return sb.toString();
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            return this.toStringAsCanonical(printInvisible);
        }
    }

    public static class AnnotatedExecutableType
    extends AnnotatedTypeMirror {
        private final ExecutableType actualType;
        private ExecutableElement element;
        private final List<AnnotatedTypeMirror> paramTypes = new ArrayList<AnnotatedTypeMirror>();
        private AnnotatedDeclaredType receiverType;
        private AnnotatedTypeMirror returnType;
        private final List<AnnotatedTypeMirror> throwsTypes = new ArrayList<AnnotatedTypeMirror>();
        private final List<AnnotatedTypeVariable> typeVarTypes = new ArrayList<AnnotatedTypeVariable>();

        private AnnotatedExecutableType(ExecutableType type2, AnnotatedTypeFactory factory) {
            super(type2, factory);
            this.actualType = type2;
        }

        public boolean isVarArgs() {
            return this.element.isVarArgs();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public ExecutableType getUnderlyingType() {
            return this.actualType;
        }

        void setParameterTypes(List<? extends AnnotatedTypeMirror> params2) {
            this.paramTypes.clear();
            this.paramTypes.addAll(params2);
        }

        public List<AnnotatedTypeMirror> getParameterTypes() {
            if (this.paramTypes.isEmpty() && !this.actualType.getParameterTypes().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getParameterTypes()) {
                    this.paramTypes.add(AnnotatedExecutableType.createType(typeMirror, this.atypeFactory));
                }
            }
            return Collections.unmodifiableList(this.paramTypes);
        }

        void setReturnType(AnnotatedTypeMirror returnType) {
            this.returnType = returnType;
        }

        public AnnotatedTypeMirror getReturnType() {
            if (this.returnType == null && this.actualType.getReturnType() != null) {
                this.returnType = AnnotatedExecutableType.createType(this.actualType.getReturnType(), this.atypeFactory);
            }
            return this.returnType;
        }

        void setReceiverType(AnnotatedDeclaredType receiverType) {
            this.receiverType = receiverType;
        }

        public AnnotatedDeclaredType getReceiverType() {
            if (this.receiverType == null) {
                TypeElement encl = ElementUtils.enclosingClass(this.getElement());
                AnnotatedTypeMirror type2 = AnnotatedExecutableType.createType(encl.asType(), this.atypeFactory);
                assert (type2 instanceof AnnotatedDeclaredType);
                this.receiverType = (AnnotatedDeclaredType)type2;
            }
            return this.receiverType;
        }

        void setThrownTypes(List<? extends AnnotatedTypeMirror> thrownTypes) {
            this.throwsTypes.clear();
            this.throwsTypes.addAll(thrownTypes);
        }

        public List<AnnotatedTypeMirror> getThrownTypes() {
            if (this.throwsTypes.isEmpty() && !this.actualType.getThrownTypes().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getThrownTypes()) {
                    this.throwsTypes.add(AnnotatedExecutableType.createType(typeMirror, this.atypeFactory));
                }
            }
            return Collections.unmodifiableList(this.throwsTypes);
        }

        void setTypeVariables(List<AnnotatedTypeVariable> types) {
            this.typeVarTypes.clear();
            this.typeVarTypes.addAll(types);
        }

        public List<AnnotatedTypeVariable> getTypeVariables() {
            if (this.typeVarTypes.isEmpty() && !this.actualType.getTypeVariables().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getTypeVariables()) {
                    this.typeVarTypes.add((AnnotatedTypeVariable)AnnotatedExecutableType.createType(typeMirror, this.atypeFactory));
                }
            }
            return Collections.unmodifiableList(this.typeVarTypes);
        }

        @Override
        public AnnotatedExecutableType getCopy(boolean copyAnnotations) {
            AnnotatedExecutableType type2 = new AnnotatedExecutableType(this.getUnderlyingType(), this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            type2.setElement(this.getElement());
            type2.setParameterTypes(this.getParameterTypes());
            type2.setReceiverType(this.getReceiverType());
            type2.setReturnType(this.getReturnType());
            type2.setThrownTypes(this.getThrownTypes());
            type2.setTypeVariables(this.getTypeVariables());
            return type2;
        }

        public ExecutableElement getElement() {
            return this.element;
        }

        public void setElement(ExecutableElement elem) {
            this.element = elem;
        }

        @Override
        public AnnotatedExecutableType getErased() {
            Types types = this.atypeFactory.types;
            AnnotatedExecutableType type2 = new AnnotatedExecutableType((ExecutableType)types.erasure(this.getUnderlyingType()), this.atypeFactory);
            type2.addAnnotations(this.annotations);
            type2.setElement(this.getElement());
            type2.setParameterTypes(this.erasureList(this.getParameterTypes()));
            type2.setReceiverType(this.getReceiverType().getErased());
            type2.setReturnType(this.getReturnType().getErased());
            type2.setThrownTypes(this.erasureList(this.getThrownTypes()));
            return type2;
        }

        private List<AnnotatedTypeMirror> erasureList(List<? extends AnnotatedTypeMirror> lst) {
            ArrayList<AnnotatedTypeMirror> erased = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : lst) {
                erased.add(annotatedTypeMirror.getErased());
            }
            return erased;
        }

        @Override
        public AnnotatedExecutableType substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            AnnotatedExecutableType type2 = this.getCopy(true);
            ArrayList<AnnotatedTypeMirror> params2 = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : this.getParameterTypes()) {
                params2.add(annotatedTypeMirror.substitute(mappings));
            }
            type2.setParameterTypes(params2);
            if (this.getReceiverType() != null) {
                type2.setReceiverType((AnnotatedDeclaredType)this.getReceiverType().substitute(mappings));
            }
            type2.setReturnType(this.getReturnType().substitute(mappings));
            ArrayList<AnnotatedTypeMirror> throwns = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : this.getThrownTypes()) {
                throwns.add(annotatedTypeMirror.substitute(mappings));
            }
            type2.setThrownTypes(throwns);
            ArrayList<AnnotatedTypeVariable> mtvs = new ArrayList<AnnotatedTypeVariable>();
            for (AnnotatedTypeVariable annotatedTypeVariable : this.getTypeVariables()) {
                AnnotatedTypeVariable newtv = AnnotatedTypes.deepCopy(annotatedTypeVariable);
                AnnotatedTypeMirror bnd = newtv.getUpperBoundField();
                if (bnd != null) {
                    bnd = bnd.substitute(mappings);
                    newtv.setUpperBound(bnd);
                }
                if ((bnd = newtv.getLowerBoundField()) != null) {
                    bnd = bnd.substitute(mappings);
                    newtv.setLowerBound(bnd);
                }
                mtvs.add(newtv);
            }
            type2.setTypeVariables(mtvs);
            return type2;
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            if (!this.getTypeVariables().isEmpty()) {
                sb.append('<');
                for (AnnotatedTypeVariable atv : this.getTypeVariables()) {
                    sb.append(atv.toString(printInvisible));
                }
                sb.append("> ");
            }
            sb.append(this.getReturnType().toString(printInvisible));
            sb.append(' ');
            if (this.element != null) {
                sb.append(this.element.getSimpleName());
            } else {
                sb.append("METHOD");
            }
            sb.append('(');
            AnnotatedDeclaredType rcv = this.getReceiverType();
            if (rcv != null) {
                sb.append(rcv.toString(printInvisible));
            } else {
                sb.append("THIS");
            }
            sb.append(" this");
            if (!this.getParameterTypes().isEmpty()) {
                int p = 0;
                for (AnnotatedTypeMirror atm : this.getParameterTypes()) {
                    sb.append(", ");
                    sb.append(atm.toString(printInvisible));
                    sb.append(" p");
                    sb.append(p++);
                }
            }
            sb.append(')');
            if (!this.getThrownTypes().isEmpty()) {
                sb.append(" throws ");
                for (AnnotatedTypeMirror atm : this.getThrownTypes()) {
                    sb.append(atm.toString(printInvisible));
                }
            }
            return sb.toString();
        }
    }

    public static class AnnotatedDeclaredType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        protected List<AnnotatedTypeMirror> typeArgs;
        protected final boolean wasRaw;
        protected AnnotatedDeclaredType enclosingType;
        protected List<AnnotatedDeclaredType> supertypes = null;

        private AnnotatedDeclaredType(DeclaredType type2, AnnotatedTypeFactory atypeFactory) {
            super(type2, atypeFactory);
            TypeElement typeelem = (TypeElement)type2.asElement();
            DeclaredType declty = (DeclaredType)typeelem.asType();
            this.wasRaw = !declty.getTypeArguments().isEmpty() && type2.getTypeArguments().isEmpty();
            TypeMirror encl = type2.getEnclosingType();
            if (encl.getKind() == TypeKind.DECLARED) {
                this.enclosingType = (AnnotatedDeclaredType)AnnotatedDeclaredType.createType(encl, atypeFactory);
            } else if (encl.getKind() != TypeKind.NONE) {
                ErrorReporter.errorAbort("AnnotatedDeclaredType: unsupported enclosing type: " + type2.getEnclosingType() + " (" + (Object)((Object)encl.getKind()) + ")");
            }
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            Element typeElt = this.getUnderlyingType().asElement();
            String smpl = typeElt.getSimpleName().toString();
            if (smpl.isEmpty()) {
                smpl = typeElt.toString();
            }
            sb.append(AnnotatedDeclaredType.formatAnnotationString(this.getAnnotations(), printInvisible));
            sb.append(smpl);
            if (!this.getTypeArguments().isEmpty()) {
                sb.append("<");
                boolean isFirst = true;
                for (AnnotatedTypeMirror typeArg : this.getTypeArguments()) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(typeArg.toString(printInvisible));
                    isFirst = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }

        public void setTypeArguments(List<? extends AnnotatedTypeMirror> ts) {
            this.typeArgs = ts == null || ts.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<AnnotatedTypeMirror>(ts));
        }

        public List<AnnotatedTypeMirror> getTypeArguments() {
            if (this.typeArgs == null) {
                this.typeArgs = new ArrayList<AnnotatedTypeMirror>();
                if (!((DeclaredType)this.actualType).getTypeArguments().isEmpty()) {
                    for (TypeMirror typeMirror : ((DeclaredType)this.actualType).getTypeArguments()) {
                        this.typeArgs.add(AnnotatedDeclaredType.createType(typeMirror, this.atypeFactory));
                    }
                }
                this.typeArgs = Collections.unmodifiableList(this.typeArgs);
            }
            return this.typeArgs;
        }

        public boolean wasRaw() {
            return this.wasRaw;
        }

        @Override
        public DeclaredType getUnderlyingType() {
            return (DeclaredType)this.actualType;
        }

        void setDirectSuperTypes(List<AnnotatedDeclaredType> supertypes2) {
            this.supertypes = new ArrayList<AnnotatedDeclaredType>(supertypes2);
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                this.supertypes = Collections.unmodifiableList(this.directSuperTypes(this));
            }
            return this.supertypes;
        }

        public List<AnnotatedDeclaredType> directSuperTypesField() {
            return this.supertypes;
        }

        @Override
        public AnnotatedDeclaredType getCopy(boolean copyAnnotations) {
            AnnotatedDeclaredType type2 = new AnnotatedDeclaredType(this.getUnderlyingType(), this.atypeFactory);
            if (copyAnnotations) {
                type2.addAnnotations(this.annotations);
            }
            type2.setEnclosingType(this.getEnclosingType());
            type2.setTypeArguments(this.getTypeArguments());
            return type2;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedDeclaredType type2 = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type2);
            ArrayList<AnnotatedTypeMirror> typeArgs = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror t : this.getTypeArguments()) {
                typeArgs.add(t.substitute(newMappings));
            }
            type2.setTypeArguments(typeArgs);
            return type2;
        }

        @Override
        public AnnotatedDeclaredType getErased() {
            if (!this.getTypeArguments().isEmpty()) {
                Types types = this.atypeFactory.types;
                AnnotatedDeclaredType rType = (AnnotatedDeclaredType)AnnotatedTypeMirror.createType(types.erasure(this.actualType), this.atypeFactory);
                rType.addAnnotations(this.getAnnotations());
                rType.setTypeArguments(Collections.emptyList());
                return rType.getErased();
            }
            if (this.getEnclosingType() != null && this.getEnclosingType().getKind() != TypeKind.NONE) {
                AnnotatedDeclaredType rType = this.getCopy(true);
                AnnotatedDeclaredType et = this.getEnclosingType();
                rType.setEnclosingType(et.getErased());
                return rType;
            }
            return this;
        }

        void setEnclosingType(AnnotatedDeclaredType enclosingType) {
            this.enclosingType = enclosingType;
        }

        public AnnotatedDeclaredType getEnclosingType() {
            return this.enclosingType;
        }
    }

    public static interface AnnotatedReferenceType {
    }
}

