/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.PolyAll;
import checkers.quals.TypeQualifier;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.QualifierPolymorphism;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.ErrorReporter;
import javacutils.InternalUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javacutils.TypesUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AnnotatedTypes {
    private static AsSuperTypeVisitor asSuper;
    private static Map<TypeElement, Boolean> isTypeAnnotationCache;

    private AnnotatedTypes() {
        throw new AssertionError((Object)"Class AnnotatedTypes cannot be instantiated.");
    }

    public static AnnotatedTypeMirror asSuper(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, AnnotatedTypeMirror superType) {
        if (asSuper == null || asSuper.types != types || asSuper.atypeFactory != atypeFactory) {
            asSuper = new AsSuperTypeVisitor(types, atypeFactory);
        }
        AnnotatedTypeMirror result2 = (AnnotatedTypeMirror)asSuper.visit(t, superType);
        return result2;
    }

    private static AnnotatedTypeMirror asOuterSuper(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, AnnotatedTypeMirror elem) {
        switch (t.getKind()) {
            case DECLARED: {
                AnnotatedTypeMirror.AnnotatedDeclaredType dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)t;
                do {
                    AnnotatedTypeMirror s2;
                    if ((s2 = AnnotatedTypes.asSuper(types, atypeFactory, dt, elem)) == null) continue;
                    return s2;
                } while ((dt = dt.getEnclosingType()) != null);
                return null;
            }
            case ARRAY: 
            case TYPEVAR: 
            case WILDCARD: {
                return AnnotatedTypes.asSuper(types, atypeFactory, t, elem);
            }
        }
        return null;
    }

    private static boolean shouldStop(AnnotatedTypeMirror sup, AnnotatedTypeMirror sub) {
        if (sup.getKind().isPrimitive() && !sub.getKind().isPrimitive()) {
            return true;
        }
        if (sup.getKind().isPrimitive() && sub.getKind().isPrimitive()) {
            return sup.getKind() == sub.getKind();
        }
        if (sup.getKind() == TypeKind.DECLARED && sub.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType supdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)sup;
            AnnotatedTypeMirror.AnnotatedDeclaredType subdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)sub;
            return supdt.getUnderlyingType().asElement().equals(subdt.getUnderlyingType().asElement());
        }
        if (sup.getKind() == TypeKind.ARRAY && sub.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType supat = (AnnotatedTypeMirror.AnnotatedArrayType)sup;
            AnnotatedTypeMirror.AnnotatedArrayType subat = (AnnotatedTypeMirror.AnnotatedArrayType)sub;
            return AnnotatedTypes.shouldStop(supat.getComponentType(), subat.getComponentType());
        }
        return sup.getUnderlyingType().toString().equals(sub.getUnderlyingType().toString());
    }

    private static boolean isErased(Types types, AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        return types.isSameType(types.erasure(t1.getUnderlyingType()), t2.getUnderlyingType());
    }

    public static AnnotatedTypeMirror.AnnotatedExecutableType asMemberOf(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, ExecutableElement elem) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)AnnotatedTypes.asMemberOf(types, atypeFactory, t, (Element)elem);
    }

    public static AnnotatedTypeMirror asMemberOf(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, Element elem) {
        switch (elem.getKind()) {
            case PACKAGE: 
            case INSTANCE_INIT: 
            case OTHER: 
            case STATIC_INIT: 
            case TYPE_PARAMETER: {
                return atypeFactory.fromElement(elem);
            }
        }
        AnnotatedTypeMirror type2 = AnnotatedTypes.asMemberOfImpl(types, atypeFactory, t, elem);
        if (!ElementUtils.isStatic(elem)) {
            atypeFactory.postAsMemberOf(type2, t, elem);
        }
        return type2;
    }

    private static AnnotatedTypeMirror asMemberOfImpl(Types types, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror t, Element elem) {
        if (ElementUtils.isStatic(elem)) {
            return atypeFactory.getAnnotatedType(elem);
        }
        if (t.getKind() == TypeKind.TYPEVAR && ((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getUpperBound() != null) {
            return AnnotatedTypes.asMemberOf(types, atypeFactory, ((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getEffectiveUpperBound(), elem);
        }
        if (t.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)t).getExtendsBound() != null) {
            return AnnotatedTypes.asMemberOf(types, atypeFactory, ((AnnotatedTypeMirror.AnnotatedWildcardType)t).getEffectiveExtendsBound(), elem);
        }
        if (t.getKind() == TypeKind.ARRAY && elem.getKind() == ElementKind.METHOD && elem.getSimpleName().contentEquals("clone")) {
            AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)atypeFactory.getAnnotatedType(elem);
            return method.substitute(Collections.singletonMap(method.getReturnType(), t));
        }
        AnnotatedTypeMirror elemType = atypeFactory.getAnnotatedType(elem);
        if (t.getKind() != TypeKind.DECLARED) {
            return elemType;
        }
        TypeElement owner = ElementUtils.enclosingClass(elem);
        boolean ownerGeneric = false;
        TypeElement encl = owner;
        while (encl != null) {
            if (!encl.getTypeParameters().isEmpty()) {
                ownerGeneric = true;
                break;
            }
            encl = ElementUtils.enclosingClass(encl.getEnclosingElement());
        }
        if (!ownerGeneric) {
            return elemType;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = atypeFactory.getAnnotatedType(owner);
        AnnotatedTypeMirror.AnnotatedDeclaredType base = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asOuterSuper(types, atypeFactory, t, ownerType);
        if (base == null) {
            return elemType;
        }
        List<AnnotatedTypeMirror> ownerParams = ownerType.getTypeArguments();
        List<AnnotatedTypeMirror> baseParams = base.getTypeArguments();
        if (!ownerParams.isEmpty()) {
            if (baseParams.isEmpty()) {
                ArrayList<AnnotatedTypeMirror> baseParamsEr = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror arg : ownerParams) {
                    baseParamsEr.add(arg.getErased());
                }
                return AnnotatedTypes.subst(elemType, ownerParams, baseParamsEr);
            }
            return AnnotatedTypes.subst(elemType, ownerParams, baseParams);
        }
        return elemType;
    }

    public static AnnotatedTypeMirror subst(AnnotatedTypeMirror t, List<? extends AnnotatedTypeMirror> from, List<? extends AnnotatedTypeMirror> to) {
        HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
        for (int i = 0; i < from.size(); ++i) {
            mappings.put(from.get(i), to.get(i));
        }
        return t.substitute(mappings);
    }

    public static <ATM extends AnnotatedTypeMirror> ATM deepCopy(ATM type2) {
        AnnotatedTypeMirror result2 = type2.substitute(Collections.emptyMap());
        return (ATM)result2;
    }

    public static AnnotatedTypeMirror getIteratedType(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror iterableType) {
        if (iterableType.getKind() == TypeKind.ARRAY) {
            return ((AnnotatedTypeMirror.AnnotatedArrayType)iterableType).getComponentType();
        }
        if (iterableType.getKind() == TypeKind.WILDCARD) {
            return AnnotatedTypes.getIteratedType(processingEnv, atypeFactory, ((AnnotatedTypeMirror.AnnotatedWildcardType)iterableType).getEffectiveExtendsBound());
        }
        if (iterableType.getKind() == TypeKind.TYPEVAR) {
            return AnnotatedTypes.getIteratedType(processingEnv, atypeFactory, ((AnnotatedTypeMirror.AnnotatedTypeVariable)iterableType).getEffectiveUpperBound());
        }
        if (iterableType.getKind() != TypeKind.DECLARED) {
            ErrorReporter.errorAbort("AnnotatedTypes.getIteratedType: not iterable type: " + iterableType);
            return null;
        }
        TypeElement iterableElement = processingEnv.getElementUtils().getTypeElement("java.lang.Iterable");
        AnnotatedTypeMirror.AnnotatedDeclaredType iterableElmType = atypeFactory.getAnnotatedType(iterableElement);
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(processingEnv.getTypeUtils(), atypeFactory, iterableType, iterableElmType);
        if (dt == null) {
            ErrorReporter.errorAbort("AnnotatedTypes.getIteratedType: not an iterable type: " + iterableType);
            return null;
        }
        if (dt.getTypeArguments().isEmpty()) {
            TypeElement e = processingEnv.getElementUtils().getTypeElement("java.lang.Object");
            AnnotatedTypeMirror.AnnotatedDeclaredType t = atypeFactory.getAnnotatedType(e);
            return t;
        }
        return dt.getTypeArguments().get(0);
    }

    public static Set<AnnotatedTypeMirror.AnnotatedDeclaredType> getSuperTypes(AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
        HashSet<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes2 = new HashSet<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        if (type2 == null) {
            return supertypes2;
        }
        ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType> stack = new ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        stack.push(type2);
        while (!stack.isEmpty()) {
            AnnotatedTypeMirror.AnnotatedDeclaredType current = (AnnotatedTypeMirror.AnnotatedDeclaredType)stack.pop();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : current.directSuperTypes()) {
                if (supertypes2.contains(supertype)) continue;
                stack.push(supertype);
                supertypes2.add(supertype);
            }
        }
        return Collections.unmodifiableSet(supertypes2);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(Elements elements, AnnotatedTypeFactory atypeFactory, ExecutableElement method) {
        TypeElement elem = (TypeElement)method.getEnclosingElement();
        AnnotatedTypeMirror.AnnotatedDeclaredType type2 = atypeFactory.getAnnotatedType(elem);
        Set<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes2 = AnnotatedTypes.getSuperTypes(type2);
        return AnnotatedTypes.overriddenMethods(elements, method, supertypes2);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(Elements elements, ExecutableElement method, Collection<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes2) {
        HashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overrides = new HashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement>();
        block0: for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : supertypes2) {
            TypeElement superElement = (TypeElement)supertype.getUnderlyingType().asElement();
            assert (superElement != null);
            for (ExecutableElement supermethod : ElementFilter.methodsIn(superElement.getEnclosedElements())) {
                if (!elements.overrides(method, supermethod, superElement)) continue;
                overrides.put(supertype, supermethod);
                continue block0;
            }
        }
        return Collections.unmodifiableMap(overrides);
    }

    public static Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> findTypeArguments(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, ExpressionTree expr) {
        List<? extends Tree> targs;
        ExecutableElement elt;
        HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeArguments = new HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror>();
        if (expr instanceof MethodInvocationTree || expr instanceof NewClassTree) {
            elt = (ExecutableElement)TreeUtils.elementFromUse(expr);
        } else {
            ErrorReporter.errorAbort("AnnotatedTypes.findTypeArguments: unexpected tree: " + expr);
            elt = null;
        }
        if (elt.getTypeParameters().isEmpty()) {
            return typeArguments;
        }
        if (expr instanceof MethodInvocationTree) {
            targs = ((MethodInvocationTree)expr).getTypeArguments();
        } else if (expr instanceof NewClassTree) {
            targs = ((NewClassTree)expr).getTypeArguments();
        } else {
            ErrorReporter.errorAbort("AnnotatedTypes.findTypeArguments: unexpected tree: " + expr);
            targs = null;
        }
        if (!targs.isEmpty()) {
            List<? extends TypeParameterElement> tvars = elt.getTypeParameters();
            for (int i = 0; i < elt.getTypeParameters().size(); ++i) {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)atypeFactory.getAnnotatedType(tvars.get(i));
                AnnotatedTypeMirror typeArg = atypeFactory.getAnnotatedTypeFromTypeTree(targs.get(i));
                typeArguments.put(typeVar, typeArg);
            }
            return typeArguments;
        }
        return AnnotatedTypes.inferTypeArguments(processingEnv, atypeFactory, expr, elt);
    }

    private static Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> inferTypeArguments(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, ExpressionTree expr, ExecutableElement elt) {
        Types types = processingEnv.getTypeUtils();
        HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeArguments = new HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror>();
        AnnotatedTypeMirror returnType = atypeFactory.type(expr);
        atypeFactory.annotateImplicit(expr, returnType);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = expr instanceof MethodInvocationTree ? AnnotatedTypes.asMemberOf(types, atypeFactory, atypeFactory.getReceiverType(expr), elt) : (expr instanceof NewClassTree ? AnnotatedTypes.asMemberOf(types, atypeFactory, returnType, elt) : null);
        AnnotatedTypeMirror assigned = AnnotatedTypes.assignedTo(types, atypeFactory, atypeFactory.getPath(expr));
        for (TypeParameterElement typeParameterElement : elt.getTypeParameters()) {
            AnnotatedTypeMirror rettype;
            AnnotatedTypeMirror returnTypeBase;
            List lst;
            AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)atypeFactory.getAnnotatedType(typeParameterElement);
            AnnotatedTypeMirror argument = null;
            argument = AnnotatedTypes.inferTypeArgsUsingArgs(processingEnv, atypeFactory, typeVar, returnType, methodType, expr);
            if (assigned != null && (lst = (List)new TypeResolutionFinder(processingEnv, atypeFactory, typeVar).visit(returnTypeBase = AnnotatedTypes.asSuper(types, atypeFactory, rettype = methodType.getReturnType(), assigned), assigned)) != null && !lst.isEmpty()) {
                AnnotatedTypeMirror retinf = (AnnotatedTypeMirror)lst.get(0);
                TypeHierarchy typeHierarchy = atypeFactory.getTypeHierarchy();
                if (argument == null || retinf != null && types.isSubtype(argument.getUnderlyingType(), retinf.getUnderlyingType()) && typeHierarchy.isSubtype(argument, retinf)) {
                    argument = retinf;
                }
            }
            if (argument == null && assigned != null) {
                AnnotatedTypeMirror.AnnotatedTypeVariable atvrettype;
                rettype = methodType.getReturnType();
                if (rettype.getKind() == TypeKind.TYPEVAR && (atvrettype = (AnnotatedTypeMirror.AnnotatedTypeVariable)rettype).getUnderlyingType().asElement() == typeParameterElement) {
                    if (!atypeFactory.getQualifierHierarchy().isSubtype(assigned.getAnnotations(), rettype.getEffectiveAnnotations())) {
                        assigned = AnnotatedTypes.deepCopy(assigned);
                        assigned.clearAnnotations();
                        assigned.addAnnotations(rettype.getEffectiveAnnotations());
                    }
                    argument = assigned;
                }
                if (argument == null) {
                    argument = AnnotatedTypes.inferTypeArgsUsingArgs(processingEnv, atypeFactory, typeVar, returnType, methodType, expr);
                }
            }
            if (argument == null) {
                argument = atypeFactory.getUninferredMethodTypeArgument(typeVar);
            }
            if (argument == null) continue;
            typeArguments.put(typeVar, argument);
        }
        return typeArguments;
    }

    private static AnnotatedTypeMirror inferTypeArgsUsingArgs(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror.AnnotatedTypeVariable typeVar, AnnotatedTypeMirror returnType, AnnotatedTypeMirror.AnnotatedExecutableType exeType, ExpressionTree expr) {
        Types types = processingEnv.getTypeUtils();
        TypeResolutionFinder finder = new TypeResolutionFinder(processingEnv, atypeFactory, typeVar);
        List lubForVar = (List)finder.visit(exeType.getReturnType(), returnType);
        if (lubForVar.isEmpty()) {
            return null;
        }
        List<? extends ExpressionTree> args2 = expr instanceof MethodInvocationTree ? ((MethodInvocationTree)expr).getArguments() : (expr instanceof NewClassTree ? ((NewClassTree)expr).getArguments() : null);
        List<AnnotatedTypeMirror> requiredParams = AnnotatedTypes.expandVarArgs(atypeFactory, exeType, args2);
        ArrayList<AnnotatedTypeMirror> passedArgs = new ArrayList<AnnotatedTypeMirror>();
        boolean tvOnlyAsTypeArg = true;
        for (int i = 0; i < requiredParams.size(); ++i) {
            AnnotatedTypeMirror pasAsSuper;
            AnnotatedTypeMirror passedArg = atypeFactory.getAnnotatedType(args2.get(i));
            AnnotatedTypeMirror requiredArg = requiredParams.get(i);
            if (types.isSameType(requiredArg.getUnderlyingType(), typeVar.getUnderlyingType())) {
                tvOnlyAsTypeArg = false;
            }
            if ((pasAsSuper = AnnotatedTypes.asSuper(types, atypeFactory, passedArg, requiredArg)) != null) {
                passedArg = pasAsSuper;
            }
            passedArgs.addAll((Collection)finder.visit(requiredArg, passedArg));
        }
        if (passedArgs.isEmpty()) {
            return null;
        }
        AnnotatedTypes.annotateAsLub(processingEnv, atypeFactory, (AnnotatedTypeMirror)lubForVar.get(0), passedArgs);
        if (tvOnlyAsTypeArg && ((AnnotatedTypeMirror)lubForVar.get(0)).getKind() == TypeKind.DECLARED && (returnType.getKind() == TypeKind.DECLARED || returnType.getKind() == TypeKind.TYPEVAR)) {
            AnnotatedTypeMirror.AnnotatedWildcardType res = atypeFactory.getWildcardBoundedBy((AnnotatedTypeMirror)lubForVar.get(0));
            if (atypeFactory.getTypeHierarchy().isSubtype(res, returnType)) {
                return res;
            }
        }
        return (AnnotatedTypeMirror)lubForVar.get(0);
    }

    private static AnnotatedTypeMirror assignedTo(Types types, AnnotatedTypeFactory atypeFactory, TreePath path) {
        Tree assignmentContext = TreeUtils.getAssignmentContext(path);
        if (assignmentContext == null) {
            return null;
        }
        if (assignmentContext instanceof AssignmentTree) {
            ExpressionTree variable = ((AssignmentTree)assignmentContext).getVariable();
            return atypeFactory.getAnnotatedType(variable);
        }
        if (assignmentContext instanceof CompoundAssignmentTree) {
            ExpressionTree variable = ((CompoundAssignmentTree)assignmentContext).getVariable();
            return atypeFactory.getAnnotatedType(variable);
        }
        if (assignmentContext instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)assignmentContext;
            if (methodInvocation.getMethodSelect() instanceof MemberSelectTree && ((MemberSelectTree)methodInvocation.getMethodSelect()).getExpression() == path.getLeaf()) {
                return null;
            }
            ExecutableElement methodElt = TreeUtils.elementFromUse(methodInvocation);
            AnnotatedTypeMirror receiver = atypeFactory.getReceiverType(methodInvocation);
            AnnotatedTypeMirror.AnnotatedExecutableType method = AnnotatedTypes.asMemberOf(types, atypeFactory, receiver, methodElt);
            int treeIndex = -1;
            for (int i = 0; i < method.getParameterTypes().size(); ++i) {
                if (TreeUtils.skipParens(methodInvocation.getArguments().get(i)) != path.getLeaf()) continue;
                treeIndex = i;
                break;
            }
            if (treeIndex == -1) {
                return null;
            }
            return method.getParameterTypes().get(treeIndex);
        }
        if (assignmentContext instanceof NewArrayTree) {
            AnnotatedTypeMirror type2 = atypeFactory.getAnnotatedType((NewArrayTree)assignmentContext);
            type2 = AnnotatedTypes.innerMostType(type2);
            return type2;
        }
        if (assignmentContext instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)assignmentContext;
            ExecutableElement constructorElt = InternalUtils.constructor(newClassTree);
            AnnotatedTypeMirror.AnnotatedExecutableType constructor = atypeFactory.getAnnotatedType(constructorElt);
            int treeIndex = -1;
            for (int i = 0; i < constructor.getParameterTypes().size(); ++i) {
                if (TreeUtils.skipParens(newClassTree.getArguments().get(i)) != path.getLeaf()) continue;
                treeIndex = i;
                break;
            }
            if (treeIndex == -1) {
                return null;
            }
            return constructor.getParameterTypes().get(treeIndex);
        }
        if (assignmentContext instanceof ReturnTree) {
            MethodTree method = TreeUtils.enclosingMethod(path);
            return atypeFactory.getAnnotatedType(method).getReturnType();
        }
        if (assignmentContext instanceof VariableTree) {
            return atypeFactory.getAnnotatedType(assignmentContext);
        }
        ErrorReporter.errorAbort("AnnotatedTypes.assignedTo: shouldn't be here!");
        return null;
    }

    public static void annotateAsLub(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror lub, Collection<AnnotatedTypeMirror> types) {
        Types typeutils = processingEnv.getTypeUtils();
        Elements elements = processingEnv.getElementUtils();
        if (lub.getKind() == TypeKind.INTERSECTION) {
            AnnotatedTypeMirror.AnnotatedIntersectionType adt = (AnnotatedTypeMirror.AnnotatedIntersectionType)lub;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType adts : adt.directSuperTypes()) {
                ArrayList<AnnotatedTypeMirror> subtypes = new ArrayList<AnnotatedTypeMirror>(types.size());
                for (AnnotatedTypeMirror type2 : types) {
                    AnnotatedTypeMirror sup = AnnotatedTypes.asSuper(typeutils, atypeFactory, type2, adts);
                    if (sup == null) continue;
                    subtypes.add(sup);
                }
                if (subtypes.size() > 0) {
                    adts.clearAnnotations();
                }
                AnnotatedTypes.addAnnotations(elements, atypeFactory, adts, subtypes.toArray(new AnnotatedTypeMirror[0]));
                AnnotatedTypes.addAnnotations(elements, atypeFactory, lub, adts);
            }
        } else {
            ArrayList<AnnotatedTypeMirror> subtypes = new ArrayList<AnnotatedTypeMirror>(types.size());
            if (lub.getKind() == TypeKind.WILDCARD) {
                subtypes.add(AnnotatedTypes.deepCopy(lub));
            } else {
                for (AnnotatedTypeMirror type3 : types) {
                    if (type3 == null) continue;
                    AnnotatedTypeMirror ass = AnnotatedTypes.asSuper(typeutils, atypeFactory, type3, lub);
                    if (ass == null) {
                        subtypes.add(AnnotatedTypes.deepCopy(type3));
                        continue;
                    }
                    subtypes.add(ass);
                }
            }
            if (subtypes.size() > 0) {
                lub.clearAnnotations();
            }
            AnnotatedTypes.addAnnotations(elements, atypeFactory, lub, subtypes.toArray(new AnnotatedTypeMirror[0]));
        }
    }

    private static void addAnnotations(Elements elements, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror alub, AnnotatedTypeMirror ... types) {
        HashSet<TypeMirror> visited = new HashSet<TypeMirror>();
        AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, alub, visited, types);
    }

    private static void addAnnotationsImpl(Elements elements, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror alub, Set<TypeMirror> visited, AnnotatedTypeMirror ... types) {
        AnnotatedTypeMirror origalub = alub;
        boolean shouldAnnoOrig = false;
        if (alub.getKind() == TypeKind.WILDCARD) {
            alub = ((AnnotatedTypeMirror.AnnotatedWildcardType)alub).getExtendsBound();
        }
        while (alub.getKind() == TypeKind.TYPEVAR) {
            alub = ((AnnotatedTypeMirror.AnnotatedTypeVariable)alub).getUpperBound();
        }
        if (visited.contains(alub.getUnderlyingType())) {
            return;
        }
        visited.add(alub.getUnderlyingType());
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getAnnotations().isEmpty() && !AnnotatedTypes.bottomsOnly(elements, atypeFactory, types[i].getAnnotations())) {
                shouldAnnoOrig = true;
            }
            if (types[i].getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)types[i];
                if (wildcard.getExtendsBound() != null) {
                    types[i] = wildcard.getEffectiveExtendsBound();
                } else if (wildcard.getSuperBound() != null) {
                    types[i] = wildcard.getEffectiveSuperBound();
                }
            }
            if (types[i].getKind() != TypeKind.TYPEVAR) continue;
            AnnotatedTypeMirror.AnnotatedTypeVariable typevar = (AnnotatedTypeMirror.AnnotatedTypeVariable)types[i];
            if (typevar.getUpperBound() != null) {
                types[i] = typevar.getEffectiveUpperBound();
                continue;
            }
            if (typevar.getLowerBound() == null) continue;
            types[i] = typevar.getEffectiveLowerBound();
        }
        Set<Object> unification = Collections.emptySet();
        boolean isFirst = true;
        for (AnnotatedTypeMirror type2 : types) {
            if (type2.getKind() == TypeKind.NULL && type2.getAnnotations().isEmpty() || type2.getAnnotations().isEmpty()) continue;
            unification = isFirst ? type2.getAnnotations() : atypeFactory.getQualifierHierarchy().leastUpperBounds(unification, type2.getAnnotations());
            isFirst = false;
        }
        alub.replaceAnnotations(unification);
        if (alub.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)alub;
            for (int i = 0; i < adt.getTypeArguments().size(); ++i) {
                AnnotatedTypeMirror adtArg = adt.getTypeArguments().get(i);
                ArrayList<AnnotatedTypeMirror> dTypesArg = new ArrayList<AnnotatedTypeMirror>();
                for (int j = 0; j < types.length; ++j) {
                    AnnotatedTypeMirror.AnnotatedDeclaredType adtypej;
                    if (types[j].getKind() != TypeKind.DECLARED || (adtypej = (AnnotatedTypeMirror.AnnotatedDeclaredType)types[j]).getTypeArguments().size() != adt.getTypeArguments().size()) continue;
                    dTypesArg.add(adtypej.getTypeArguments().get(i));
                }
                AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, adtArg, visited, dTypesArg.toArray(new AnnotatedTypeMirror[0]));
            }
        } else if (alub.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType aat = (AnnotatedTypeMirror.AnnotatedArrayType)alub;
            ArrayList<AnnotatedTypeMirror> compTypes = new ArrayList<AnnotatedTypeMirror>();
            for (int i = 0; i < types.length; ++i) {
                if (types[i].getKind() == TypeKind.NULL) continue;
                compTypes.add(((AnnotatedTypeMirror.AnnotatedArrayType)types[i]).getComponentType());
            }
            AnnotatedTypes.addAnnotationsImpl(elements, atypeFactory, aat.getComponentType(), visited, compTypes.toArray(new AnnotatedTypeMirror[0]));
        }
        if (alub != origalub && shouldAnnoOrig) {
            origalub.replaceAnnotations(alub.getAnnotations());
        }
    }

    private static boolean bottomsOnly(Elements elements, AnnotatedTypeFactory atypeFactory, Set<AnnotationMirror> annotations2) {
        Set<AnnotationMirror> bots = AnnotationUtils.createAnnotationSet();
        bots.addAll(atypeFactory.getQualifierHierarchy().getBottomAnnotations());
        boolean allbot = true;
        for (AnnotationMirror am : annotations2) {
            if (bots.remove(am)) continue;
            allbot = false;
        }
        return allbot;
    }

    public static List<AnnotatedTypeMirror> expandVarArgs(AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror.AnnotatedExecutableType method, List<? extends ExpressionTree> args2) {
        AnnotatedTypeMirror lastArg;
        List<AnnotatedTypeMirror> parameters2 = method.getParameterTypes();
        if (!method.getElement().isVarArgs()) {
            return parameters2;
        }
        AnnotatedTypeMirror.AnnotatedArrayType varargs = (AnnotatedTypeMirror.AnnotatedArrayType)parameters2.get(parameters2.size() - 1);
        if (parameters2.size() == args2.size() && (lastArg = atypeFactory.getAnnotatedType(args2.get(args2.size() - 1))).getKind() == TypeKind.ARRAY && AnnotatedTypes.getArrayDepth(varargs) == AnnotatedTypes.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArg)) {
            return parameters2;
        }
        parameters2 = new ArrayList<AnnotatedTypeMirror>(parameters2.subList(0, parameters2.size() - 1));
        for (int i = args2.size() - parameters2.size(); i > 0; --i) {
            parameters2.add(varargs.getComponentType());
        }
        return parameters2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AnnotatedTypeMirror> getAnnotatedTypes(AnnotatedTypeFactory atypeFactory, List<AnnotatedTypeMirror> paramTypes, List<? extends ExpressionTree> trees) {
        assert (paramTypes.size() == trees.size()) : "AnnotatedTypes.getAnnotatedTypes: size mismatch! Parameter types: " + paramTypes + " Arguments: " + trees;
        ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = atypeFactory.getVisitorState().getAssignmentContext();
        try {
            for (int i = 0; i < trees.size(); ++i) {
                AnnotatedTypeMirror param = paramTypes.get(i);
                atypeFactory.getVisitorState().setAssignmentContext(Pair.of(null, param));
                ExpressionTree arg = trees.get(i);
                types.add(atypeFactory.getAnnotatedType(arg));
            }
        }
        finally {
            atypeFactory.getVisitorState().setAssignmentContext(preAssCtxt);
        }
        return types;
    }

    public static boolean areSame(AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        return t1.toString().equals(t2.toString());
    }

    public static int getArrayDepth(AnnotatedTypeMirror.AnnotatedArrayType array) {
        int counter = 0;
        AnnotatedTypeMirror type2 = array;
        while (type2.getKind() == TypeKind.ARRAY) {
            ++counter;
            type2 = type2.getComponentType();
        }
        return counter;
    }

    public static AnnotatedTypeMirror innerMostType(AnnotatedTypeMirror t) {
        AnnotatedTypeMirror inner = t;
        while (inner.getKind() == TypeKind.ARRAY) {
            inner = ((AnnotatedTypeMirror.AnnotatedArrayType)inner).getComponentType();
        }
        return inner;
    }

    public static boolean containsModifier(AnnotatedTypeMirror type2, AnnotationMirror modifier) {
        return AnnotatedTypes.containsModifierImpl(type2, modifier, new LinkedList<AnnotatedTypeMirror>());
    }

    private static boolean containsModifierImpl(AnnotatedTypeMirror type2, AnnotationMirror modifier, List<AnnotatedTypeMirror> visited) {
        boolean found = type2.hasAnnotation(modifier);
        boolean vis = visited.contains(type2);
        visited.add(type2);
        if (!found && !vis) {
            if (type2.getKind() == TypeKind.DECLARED) {
                AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)type2;
                for (AnnotatedTypeMirror typeMirror : declaredType.getTypeArguments()) {
                    if (found |= AnnotatedTypes.containsModifierImpl(typeMirror, modifier, visited)) break;
                }
            } else if (type2.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)type2;
                found = AnnotatedTypes.containsModifierImpl(arrayType.getComponentType(), modifier, visited);
            } else if (type2.getKind() == TypeKind.TYPEVAR) {
                AnnotatedTypeMirror.AnnotatedTypeVariable atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)type2;
                if (atv.getUpperBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(atv.getUpperBound(), modifier, visited);
                }
                if (!found && atv.getLowerBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(atv.getLowerBound(), modifier, visited);
                }
            } else if (type2.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType awc = (AnnotatedTypeMirror.AnnotatedWildcardType)type2;
                if (awc.getExtendsBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(awc.getExtendsBound(), modifier, visited);
                }
                if (!found && awc.getSuperBound() != null) {
                    found = AnnotatedTypes.containsModifierImpl(awc.getSuperBound(), modifier, visited);
                }
            }
        }
        return found;
    }

    public static boolean isTypeAnnotation(AnnotationMirror anno) {
        TypeElement elem = (TypeElement)anno.getAnnotationType().asElement();
        if (isTypeAnnotationCache.containsKey(elem)) {
            return isTypeAnnotationCache.get(elem);
        }
        boolean result2 = AnnotatedTypes.isTypeAnnotationImpl(elem);
        isTypeAnnotationCache.put(elem, result2);
        return result2;
    }

    private static boolean isTypeAnnotationImpl(TypeElement type2) {
        return type2.getAnnotation(TypeQualifier.class) != null;
    }

    public static boolean containsTypeAnnotation(Collection<? extends AnnotationMirror> annos) {
        for (AnnotationMirror annotationMirror : annos) {
            if (!AnnotatedTypes.isTypeAnnotation(annotationMirror)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type2) {
        return AnnotatedTypes.isValidType(qualifierHierarchy, type2, Collections.<AnnotatedTypeMirror>emptySet());
    }

    private static boolean isValidType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type2, Set<AnnotatedTypeMirror> v) {
        boolean canHaveEmptyAnnotationSet;
        if (type2 == null) {
            return false;
        }
        HashSet<AnnotatedTypeMirror> visited = new HashSet<AnnotatedTypeMirror>(v);
        if (visited.contains(type2)) {
            return true;
        }
        visited.add(type2);
        Set<AnnotationMirror> annotations2 = type2.getAnnotations();
        Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
        int n = 0;
        for (AnnotationMirror anno : annotations2) {
            if (QualifierPolymorphism.isPolyAll(anno)) continue;
            ++n;
            AnnotationMirror top = qualifierHierarchy.getTopAnnotation(anno);
            if (seenTops.contains(top)) {
                return false;
            }
            seenTops.add(top);
        }
        int expectedN = qualifierHierarchy.getWidth();
        if (n > expectedN) {
            return false;
        }
        boolean hasPolyAll = type2.hasAnnotation(PolyAll.class);
        boolean bl = canHaveEmptyAnnotationSet = QualifierHierarchy.canHaveEmptyAnnotationSet(type2) || hasPolyAll;
        if (!canHaveEmptyAnnotationSet && n != expectedN) {
            return false;
        }
        if (type2 instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            AnnotatedTypeMirror.AnnotatedArrayType at2 = (AnnotatedTypeMirror.AnnotatedArrayType)type2;
            if (!AnnotatedTypes.isValidType(qualifierHierarchy, at2.getComponentType(), visited)) {
                return false;
            }
        } else if (type2 instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            AnnotatedTypeMirror.AnnotatedTypeVariable at3 = (AnnotatedTypeMirror.AnnotatedTypeVariable)type2;
            AnnotatedTypeMirror lowerBound = at3.getLowerBound();
            AnnotatedTypeMirror upperBound = at3.getUpperBound();
            if (lowerBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, lowerBound, visited)) {
                return false;
            }
            if (upperBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, upperBound, visited)) {
                return false;
            }
        } else if (type2 instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
            AnnotatedTypeMirror.AnnotatedWildcardType at4 = (AnnotatedTypeMirror.AnnotatedWildcardType)type2;
            AnnotatedTypeMirror extendsBound = at4.getExtendsBound();
            AnnotatedTypeMirror superBound = at4.getSuperBound();
            if (extendsBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, extendsBound, visited)) {
                return false;
            }
            if (superBound != null && !AnnotatedTypes.isValidType(qualifierHierarchy, superBound, visited)) {
                return false;
            }
        }
        return true;
    }

    static {
        isTypeAnnotationCache = new IdentityHashMap<TypeElement, Boolean>();
    }

    private static class TypeResolutionFinder
    extends SimpleAnnotatedTypeVisitor<List<AnnotatedTypeMirror>, AnnotatedTypeMirror> {
        private final ProcessingEnvironment processingEnv;
        private final AnnotatedTypeFactory atypeFactory;
        private final AnnotatedTypeMirror.AnnotatedTypeVariable typeToFind;

        public TypeResolutionFinder(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, AnnotatedTypeMirror.AnnotatedTypeVariable typeToFind) {
            this.processingEnv = processingEnv;
            this.atypeFactory = atypeFactory;
            this.typeToFind = typeToFind;
        }

        List<AnnotatedTypeMirror> visit(List<AnnotatedTypeMirror> types, List<AnnotatedTypeMirror> other) {
            ArrayList<AnnotatedTypeMirror> found = new ArrayList<AnnotatedTypeMirror>();
            assert (types.size() == other.size());
            for (int i = 0; i < types.size(); ++i) {
                List foundHere = (List)this.visit(types.get(i), other.get(i));
                found.addAll(foundHere);
            }
            return found;
        }

        @Override
        public List<AnnotatedTypeMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type2, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.NULL) {
                return Collections.emptyList();
            }
            if (p.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror bound = ((AnnotatedTypeMirror.AnnotatedWildcardType)p).getExtendsBound();
                if (bound != null) assert (TypesUtils.isObject(bound.getUnderlyingType()));
                return Collections.emptyList();
            }
            assert (type2.getKind() == p.getKind());
            AnnotatedTypeMirror.AnnotatedArrayType pArray = (AnnotatedTypeMirror.AnnotatedArrayType)p;
            AnnotatedTypeMirror typeToLookIn = pArray.getComponentType().getKind().isPrimitive() ? pArray : pArray.getComponentType();
            return (List)this.visit(type2.getComponentType(), typeToLookIn);
        }

        @Override
        public List<AnnotatedTypeMirror> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.NULL) {
                Element elem;
                if (type2.getKind() == TypeKind.TYPEVAR && (elem = type2.getUnderlyingType().asElement()).equals(this.typeToFind.getUnderlyingType().asElement())) {
                    return Collections.singletonList(p);
                }
                return Collections.emptyList();
            }
            if (p.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror bound = ((AnnotatedTypeMirror.AnnotatedWildcardType)p).getExtendsBound();
                if (bound == null) {
                    return Collections.emptyList();
                }
                return this.visitDeclared(type2, bound);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType pDeclared = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(this.processingEnv.getTypeUtils(), this.atypeFactory, p, type2);
            if (type2.getTypeArguments().isEmpty() || pDeclared == null || pDeclared.getTypeArguments().isEmpty()) {
                return Collections.emptyList();
            }
            return this.visit(type2.getTypeArguments(), pDeclared.getTypeArguments());
        }

        @Override
        public List<AnnotatedTypeMirror> visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type2, AnnotatedTypeMirror p) {
            assert (type2.getKind() == p.getKind());
            AnnotatedTypeMirror.AnnotatedExecutableType pExecutable = (AnnotatedTypeMirror.AnnotatedExecutableType)p;
            return this.visit(type2.getParameterTypes(), pExecutable.getParameterTypes());
        }

        @Override
        public List<AnnotatedTypeMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, AnnotatedTypeMirror p) {
            Element elem = type2.getUnderlyingType().asElement();
            if (elem.equals(this.typeToFind.getUnderlyingType().asElement())) {
                return Collections.singletonList(p);
            }
            return Collections.emptyList();
        }

        @Override
        public List<AnnotatedTypeMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, AnnotatedTypeMirror p) {
            ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
            if (type2.getExtendsBound() != null) {
                types.addAll((Collection)this.visit(type2.getExtendsBound(), p));
            }
            if (type2.getSuperBound() != null) {
                types.addAll((Collection)this.visit(type2.getSuperBound(), p));
            }
            return types;
        }

        @Override
        public List<AnnotatedTypeMirror> defaultAction(AnnotatedTypeMirror type2, AnnotatedTypeMirror p) {
            return Collections.emptyList();
        }
    }

    private static class AsSuperTypeVisitor
    extends SimpleAnnotatedTypeVisitor<AnnotatedTypeMirror, AnnotatedTypeMirror> {
        private final Types types;
        private final AnnotatedTypeFactory atypeFactory;

        AsSuperTypeVisitor(Types types, AnnotatedTypeFactory atypeFactory) {
            this.types = types;
            this.atypeFactory = atypeFactory;
        }

        @Override
        protected AnnotatedTypeMirror defaultAction(AnnotatedTypeMirror type2, AnnotatedTypeMirror p) {
            return type2;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type2, AnnotatedTypeMirror p) {
            if (!p.getKind().isPrimitive()) {
                return (AnnotatedTypeMirror)this.visit(this.atypeFactory.getBoxedType(type2), p);
            }
            AnnotatedTypeMirror.AnnotatedPrimitiveType pt = (AnnotatedTypeMirror.AnnotatedPrimitiveType)p;
            AnnotatedTypeMirror.AnnotatedPrimitiveType st = pt.getCopy(false);
            st.addAnnotations(type2.getAnnotations());
            return st;
        }

        @Override
        public AnnotatedTypeMirror visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.TYPEVAR) {
                return type2;
            }
            AnnotatedTypeMirror res = AnnotatedTypes.asSuper(this.types, this.atypeFactory, type2.getEffectiveUpperBound(), p);
            if (res != null) {
                res.addMissingAnnotations(this.atypeFactory.getQualifierHierarchy().getTopAnnotations());
            }
            return res;
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.WILDCARD) {
                return type2;
            }
            return AnnotatedTypes.asSuper(this.types, this.atypeFactory, type2.getEffectiveExtendsBound(), p);
        }

        @Override
        public AnnotatedTypeMirror visitArray(AnnotatedTypeMirror.AnnotatedArrayType type2, AnnotatedTypeMirror p) {
            if (AnnotatedTypes.shouldStop(p, type2)) {
                return type2;
            }
            for (AnnotatedTypeMirror annotatedTypeMirror : type2.directSuperTypes()) {
                AnnotatedTypeMirror x = AnnotatedTypes.asSuper(this.types, this.atypeFactory, annotatedTypeMirror, p);
                if (x == null) continue;
                return AnnotatedTypes.isErased(this.types, x, p) ? x.getErased() : x;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, AnnotatedTypeMirror p) {
            if (p.getKind().isPrimitive()) {
                if (TypesUtils.isBoxedPrimitive(type2.getUnderlyingType())) {
                    return (AnnotatedTypeMirror)this.visit(this.atypeFactory.getUnboxedType(type2), p);
                }
                return null;
            }
            if (AnnotatedTypes.shouldStop(p, type2)) {
                return type2;
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType st : type2.directSuperTypes()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType x;
                if (st.getKind() != TypeKind.DECLARED || (x = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(this.types, this.atypeFactory, st, p)) == null) continue;
                return x;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type2, AnnotatedTypeMirror p) {
            if (AnnotatedTypes.shouldStop(p, type2)) {
                return type2;
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType st : type2.directSuperTypes()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType x = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(this.types, this.atypeFactory, st, p);
                if (x == null) continue;
                return x;
            }
            return null;
        }
    }
}

