/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.PolyAll;
import checkers.quals.PolymorphicQualifier;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.AnnotatedTypes;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ErrorReporter;
import javacutils.TreeUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class QualifierPolymorphism {
    private final Types types;
    private final AnnotatedTypeFactory atypeFactory;
    private final Completer completer;
    protected final Map<AnnotationMirror, AnnotationMirror> polyQuals;
    protected final Set<? extends AnnotationMirror> topQuals;
    protected final QualifierHierarchy qualhierarchy;
    private final AnnotationMirror POLYALL;
    private final AnnotatedTypeScanner<Void, Map<AnnotationMirror, Set<? extends AnnotationMirror>>> replacer = new AnnotatedTypeScanner<Void, Map<AnnotationMirror, Set<? extends AnnotationMirror>>>(){

        @Override
        public Void scan(AnnotatedTypeMirror type2, Map<AnnotationMirror, Set<? extends AnnotationMirror>> matches) {
            if (type2 != null) {
                for (Map.Entry<AnnotationMirror, Set<? extends AnnotationMirror>> pqentry : matches.entrySet()) {
                    AnnotationMirror poly = pqentry.getKey();
                    if (poly == null || !type2.hasAnnotation(poly)) continue;
                    type2.removeAnnotation(poly);
                    Set<? extends AnnotationMirror> quals = pqentry.getValue();
                    type2.replaceAnnotations(quals);
                }
            }
            return (Void)super.scan(type2, matches);
        }
    };
    private final PolyCollector collector;

    public QualifierPolymorphism(ProcessingEnvironment env, AnnotatedTypeFactory factory) {
        this.atypeFactory = factory;
        this.types = env.getTypeUtils();
        Elements elements = env.getElementUtils();
        this.POLYALL = AnnotationUtils.fromClass(elements, PolyAll.class);
        this.qualhierarchy = factory.getQualifierHierarchy();
        HashMap<AnnotationMirror, AnnotationMirror> polys = new HashMap<AnnotationMirror, AnnotationMirror>();
        for (AnnotationMirror annotationMirror : this.qualhierarchy.getTypeQualifiers()) {
            if (QualifierPolymorphism.isPolyAll(annotationMirror)) {
                polys.put(null, annotationMirror);
                continue;
            }
            for (AnnotationMirror annotationMirror2 : annotationMirror.getAnnotationType().asElement().getAnnotationMirrors()) {
                AnnotationMirror ttreetop;
                if (!annotationMirror2.getAnnotationType().toString().equals(PolymorphicQualifier.class.getCanonicalName())) continue;
                Name plval = AnnotationUtils.getElementValueClassName(annotationMirror2, "value", true);
                if (PolymorphicQualifier.class.getCanonicalName().contentEquals(plval)) {
                    Set<? extends AnnotationMirror> tops = this.qualhierarchy.getTopAnnotations();
                    if (tops.size() != 1) {
                        ErrorReporter.errorAbort("QualifierPolymorphism: PolymorphicQualifier has to specify type hierarchy, if more than one exist; top types: " + tops);
                    }
                    ttreetop = tops.iterator().next();
                } else {
                    AnnotationMirror ttree = AnnotationUtils.fromName(elements, plval);
                    ttreetop = this.qualhierarchy.getTopAnnotation(ttree);
                }
                if (polys.containsKey(ttreetop)) {
                    ErrorReporter.errorAbort("QualifierPolymorphism: checker has multiple polymorphic qualifiers: " + polys.get(ttreetop) + " and " + annotationMirror);
                }
                polys.put(ttreetop, annotationMirror);
            }
        }
        this.polyQuals = polys;
        this.topQuals = this.qualhierarchy.getTopAnnotations();
        this.collector = new PolyCollector();
        this.completer = new Completer();
    }

    public static AnnotationMirror getPolymorphicQualifier(AnnotationMirror qual) {
        if (qual == null) {
            return null;
        }
        Element qualElt = qual.getAnnotationType().asElement();
        for (AnnotationMirror annotationMirror : qualElt.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(PolymorphicQualifier.class.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isPolymorphicQualified(AnnotationMirror qual) {
        return QualifierPolymorphism.getPolymorphicQualifier(qual) != null;
    }

    public static boolean isPolyAll(AnnotationMirror qual) {
        return AnnotationUtils.areSameByClass(qual, PolyAll.class);
    }

    public static Class<? extends Annotation> getPolymorphicQualifierTop(Elements elements, AnnotationMirror qual) {
        AnnotationMirror poly = QualifierPolymorphism.getPolymorphicQualifier(qual);
        if (poly == null) {
            return null;
        }
        Class<?> ret = AnnotationUtils.getElementValueClass(poly, "value", true);
        return ret;
    }

    public void annotate(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type2) {
        if (this.polyQuals.isEmpty()) {
            return;
        }
        if (TreeUtils.isEnumSuper(tree)) {
            return;
        }
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this.atypeFactory, type2, tree.getArguments());
        List<AnnotatedTypeMirror> arguments2 = AnnotatedTypes.getAnnotatedTypes(this.atypeFactory, requiredArgs, tree.getArguments());
        Map<AnnotationMirror, Set<? extends AnnotationMirror>> matchingMapping = this.collector.visit(arguments2, requiredArgs);
        if ((matchingMapping = this.collector.reduce(matchingMapping, (Map)this.collector.visit(this.atypeFactory.getReceiverType(tree), type2.getReceiverType()))) != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type2, matchingMapping);
        } else {
            this.completer.visit(type2);
        }
    }

    public void annotate(NewClassTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type2) {
        if (this.polyQuals.isEmpty()) {
            return;
        }
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this.atypeFactory, type2, tree.getArguments());
        List<AnnotatedTypeMirror> arguments2 = AnnotatedTypes.getAnnotatedTypes(this.atypeFactory, requiredArgs, tree.getArguments());
        Map<AnnotationMirror, Set<? extends AnnotationMirror>> matchingMapping = this.collector.visit(arguments2, requiredArgs);
        if (matchingMapping != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type2, matchingMapping);
        } else {
            this.completer.visit(type2);
        }
    }

    private class PolyCollector
    extends SimpleAnnotatedTypeVisitor<Map<AnnotationMirror, Set<? extends AnnotationMirror>>, AnnotatedTypeMirror> {
        private final Set<TypeMirror> visited = new HashSet<TypeMirror>();

        private PolyCollector() {
        }

        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> reduce(Map<AnnotationMirror, Set<? extends AnnotationMirror>> r1, Map<AnnotationMirror, Set<? extends AnnotationMirror>> r2) {
            if (r1 == null || r1.isEmpty()) {
                return r2;
            }
            if (r2 == null || r2.isEmpty()) {
                return r1;
            }
            HashMap<AnnotationMirror, Set<? extends AnnotationMirror>> res = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>(r1.size());
            Set<AnnotationMirror> r2remain = AnnotationUtils.createAnnotationSet();
            r2remain.addAll(r2.keySet());
            for (Map.Entry<AnnotationMirror, Set<? extends AnnotationMirror>> kv1 : r1.entrySet()) {
                AnnotationMirror key1 = kv1.getKey();
                Set<? extends AnnotationMirror> a1Annos = kv1.getValue();
                Set<? extends AnnotationMirror> a2Annos = r2.get(key1);
                if (a2Annos != null && !a2Annos.isEmpty()) {
                    r2remain.remove(key1);
                    Set<? extends AnnotationMirror> lubs = QualifierPolymorphism.this.qualhierarchy.leastUpperBounds(a1Annos, a2Annos);
                    res.put(key1, lubs);
                    continue;
                }
                res.put(key1, a1Annos);
            }
            for (AnnotationMirror key2 : r2remain) {
                res.put(key2, r2.get(key2));
            }
            return res;
        }

        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> actualTypes) {
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result2 = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = actualTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type2 = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result2 = this.reduce(result2, (Map)this.visit(type2, actualType));
            }
            return result2;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(actualType.getUnderlyingType());
                Map result2 = (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.visited.remove(actualType.getUnderlyingType());
                return result2;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                AnnotatedTypeMirror.AnnotatedWildcardType wctype = (AnnotatedTypeMirror.AnnotatedWildcardType)actualType;
                this.visited.add(actualType.getUnderlyingType());
                Map result3 = wctype.getUnderlyingType().getExtendsBound() != null ? (Map)this.visit(type2, wctype.getExtendsBound()) : (wctype.getUnderlyingType().getSuperBound() != null ? (Map)this.visit(type2, wctype.getSuperBound()) : Collections.emptyMap());
                this.visited.remove(actualType.getUnderlyingType());
                return result3;
            }
            if (actualType.getKind() != type2.getKind() || actualType == type2) {
                return Collections.emptyMap();
            }
            assert (actualType.getKind() == type2.getKind());
            type2 = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(QualifierPolymorphism.this.types, QualifierPolymorphism.this.atypeFactory, type2, actualType);
            if (type2 == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType dcType = (AnnotatedTypeMirror.AnnotatedDeclaredType)actualType;
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result4 = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : QualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = kv.getKey();
                AnnotationMirror poly = kv.getValue();
                if (top == null && dcType.hasAnnotation(QualifierPolymorphism.this.POLYALL)) {
                    result4.put(poly, type2.getAnnotations());
                    continue;
                }
                if (!dcType.hasAnnotation(poly)) continue;
                AnnotationMirror typeQual = type2.getAnnotationInHierarchy(top);
                result4.put(poly, Collections.singleton(typeQual));
            }
            if (!type2.wasRaw() && !dcType.wasRaw()) {
                result4 = this.reduce(result4, this.visit(type2.getTypeArguments(), dcType.getTypeArguments()));
            }
            return result4;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type2, AnnotatedTypeMirror actualType) {
            HashMap<AnnotationMirror, Set<? extends AnnotationMirror>> result2 = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : QualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = kv.getKey();
                AnnotationMirror poly = kv.getValue();
                if (top == null && actualType.hasAnnotation(QualifierPolymorphism.this.POLYALL)) {
                    result2.put(poly, type2.getAnnotations());
                    continue;
                }
                if (!actualType.hasAnnotation(poly)) continue;
                AnnotationMirror typeQual = type2.getAnnotationInHierarchy(top);
                result2.put(poly, Collections.singleton(typeQual));
            }
            return result2;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitNull(AnnotatedTypeMirror.AnnotatedNullType type2, AnnotatedTypeMirror actualType) {
            HashMap<AnnotationMirror, Set<? extends AnnotationMirror>> result2 = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : QualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = kv.getKey();
                AnnotationMirror poly = kv.getValue();
                if (top == null) {
                    result2.put(poly, type2.getAnnotations());
                    continue;
                }
                if (!actualType.hasAnnotation(poly)) continue;
                AnnotationMirror typeQual = type2.getAnnotationInHierarchy(top);
                result2.put(poly, Collections.singleton(typeQual));
            }
            if (!result2.isEmpty()) {
                return result2;
            }
            return (Map)super.visitNull(type2, actualType);
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type2, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.DECLARED) {
                return (Map)this.visit(AnnotatedTypes.asSuper(QualifierPolymorphism.this.types, QualifierPolymorphism.this.atypeFactory, type2, actualType), actualType);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(actualType.getUnderlyingType());
                Map result2 = (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.visited.remove(actualType.getUnderlyingType());
                return result2;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                if (this.visited.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.visited.add(actualType.getUnderlyingType());
                Map result3 = (Map)this.visit(type2, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
                this.visited.remove(actualType.getUnderlyingType());
                return result3;
            }
            assert (type2.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedArrayType arType = (AnnotatedTypeMirror.AnnotatedArrayType)actualType;
            Map<AnnotationMirror, Set<? extends AnnotationMirror>> result4 = new HashMap<AnnotationMirror, Set<? extends AnnotationMirror>>();
            for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : QualifierPolymorphism.this.polyQuals.entrySet()) {
                AnnotationMirror top = kv.getKey();
                AnnotationMirror poly = kv.getValue();
                if (!arType.hasAnnotation(poly)) continue;
                Set<AnnotationMirror> typeQuals = top == null ? type2.getAnnotations() : Collections.singleton(type2.getAnnotationInHierarchy(top));
                result4.put(poly, typeQuals);
            }
            result4 = this.reduce(result4, (Map)this.visit(type2.getComponentType(), arType.getComponentType()));
            return result4;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror typeSuper = this.findType(type2, actualType);
            if (typeSuper.getKind() != TypeKind.TYPEVAR) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            assert (type2.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedTypeVariable tvType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeSuper;
            if (this.visited.contains(actualType.getUnderlyingType())) {
                return Collections.emptyMap();
            }
            this.visited.add(type2.getUnderlyingType());
            Map result2 = (Map)this.visit(type2.getUpperBound(), tvType.getUpperBound());
            this.visited.remove(type2.getUnderlyingType());
            return result2;
        }

        @Override
        public Map<AnnotationMirror, Set<? extends AnnotationMirror>> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror typeSuper = this.findType(type2, actualType);
            if (typeSuper.getKind() != TypeKind.WILDCARD) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind() || actualType.getKind() == TypeKind.TYPEVAR) : "PolyCollector: mismatched type kinds: " + actualType + " (" + (Object)((Object)actualType.getKind()) + ") and " + typeSuper + " (" + (Object)((Object)typeSuper.getKind()) + ")";
            AnnotatedTypeMirror.AnnotatedWildcardType wcType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeSuper;
            if (this.visited.contains(actualType.getUnderlyingType())) {
                return Collections.emptyMap();
            }
            this.visited.add(type2.getUnderlyingType());
            Map result2 = type2.getExtendsBound() != null && wcType.getExtendsBound() != null ? (Map)this.visit(type2.getExtendsBound(), wcType.getExtendsBound()) : (type2.getSuperBound() != null && wcType.getSuperBound() != null ? (Map)this.visit(type2.getSuperBound(), wcType.getSuperBound()) : new HashMap());
            this.visited.remove(type2.getUnderlyingType());
            return result2;
        }

        private AnnotatedTypeMirror findType(AnnotatedTypeMirror type2, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror result2 = AnnotatedTypes.asSuper(QualifierPolymorphism.this.types, QualifierPolymorphism.this.atypeFactory, type2, actualType);
            return result2 != null ? result2 : type2;
        }
    }

    class Completer
    extends AnnotatedTypeScanner<Void, Void> {
        Completer() {
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type2, Void p) {
            if (type2 != null) {
                for (Map.Entry<AnnotationMirror, AnnotationMirror> pqentry : QualifierPolymorphism.this.polyQuals.entrySet()) {
                    AnnotationMirror top = pqentry.getKey();
                    AnnotationMirror poly = pqentry.getValue();
                    if (!type2.hasAnnotation(poly)) continue;
                    type2.removeAnnotation(poly);
                    if (top == null) {
                        type2.addMissingAnnotations(QualifierPolymorphism.this.topQuals);
                        continue;
                    }
                    if (type2.getKind() == TypeKind.TYPEVAR || type2.getKind() == TypeKind.WILDCARD) continue;
                    type2.addAnnotation(top);
                }
            }
            return (Void)super.scan(type2, p);
        }
    }
}

