/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.count;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AnnotationsCounter
extends AbstractProcessor {
    final Map<javax.lang.model.element.Name, Integer> annotationCount = new HashMap<javax.lang.model.element.Name, Integer>();
    private final TreeScanner<?, ?> scanner = new TreeScanner<Void, Void>(){

        @Override
        public Void visitAnnotation(AnnotationTree node, Void p) {
            JCTree.JCAnnotation anno = (JCTree.JCAnnotation)node;
            Name annoName = anno.annotationType.type.tsym.name;
            AnnotationsCounter.this.incrementCount(annoName);
            return (Void)super.visitAnnotation(node, p);
        }
    };

    protected void incrementCount(javax.lang.model.element.Name annoName) {
        if (!this.annotationCount.containsKey(annoName)) {
            this.annotationCount.put(annoName, 2);
        } else {
            this.annotationCount.put(annoName, this.annotationCount.get(annoName) + 1);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations2, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            System.out.println("Found annotations: ");
            for (Map.Entry<javax.lang.model.element.Name, Integer> entry : this.annotationCount.entrySet()) {
                System.out.println(entry.getKey() + "\t" + entry.getValue());
            }
            return true;
        }
        for (TypeElement elem : ElementFilter.typesIn(roundEnv.getRootElements())) {
            ClassTree tree = Trees.instance(this.processingEnv).getTree(elem);
            if (tree == null) continue;
            tree.accept(this.scanner, null);
        }
        return false;
    }
}

