/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.stub;

import cfjapa.parser.JavaParser;
import cfjapa.parser.ast.CompilationUnit;
import cfjapa.parser.ast.ImportDeclaration;
import cfjapa.parser.ast.IndexUnit;
import cfjapa.parser.ast.PackageDeclaration;
import cfjapa.parser.ast.TypeParameter;
import cfjapa.parser.ast.body.BodyDeclaration;
import cfjapa.parser.ast.body.ClassOrInterfaceDeclaration;
import cfjapa.parser.ast.body.ConstructorDeclaration;
import cfjapa.parser.ast.body.FieldDeclaration;
import cfjapa.parser.ast.body.MethodDeclaration;
import cfjapa.parser.ast.body.Parameter;
import cfjapa.parser.ast.body.TypeDeclaration;
import cfjapa.parser.ast.body.VariableDeclarator;
import cfjapa.parser.ast.expr.AnnotationExpr;
import cfjapa.parser.ast.expr.ArrayInitializerExpr;
import cfjapa.parser.ast.expr.BooleanLiteralExpr;
import cfjapa.parser.ast.expr.Expression;
import cfjapa.parser.ast.expr.FieldAccessExpr;
import cfjapa.parser.ast.expr.MarkerAnnotationExpr;
import cfjapa.parser.ast.expr.MemberValuePair;
import cfjapa.parser.ast.expr.NameExpr;
import cfjapa.parser.ast.expr.NormalAnnotationExpr;
import cfjapa.parser.ast.expr.SingleMemberAnnotationExpr;
import cfjapa.parser.ast.expr.StringLiteralExpr;
import cfjapa.parser.ast.type.ClassOrInterfaceType;
import cfjapa.parser.ast.type.ReferenceType;
import cfjapa.parser.ast.type.Type;
import cfjapa.parser.ast.type.WildcardType;
import checkers.quals.FromStubFile;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.AnnotationBuilder;
import checkers.util.stub.StubUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ElementUtils;
import javacutils.ErrorReporter;
import javacutils.Pair;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public class StubParser {
    private final boolean warnIfNotFound;
    private final boolean debugStubParser;
    private final String filename;
    private final IndexUnit index;
    private final ProcessingEnvironment processingEnv;
    private final AnnotatedTypeFactory atypeFactory;
    private final Elements elements;
    private final Map<String, AnnotationMirror> supportedAnnotations;
    private final List<String> imports;
    private final Map<FieldAccessExpr, VariableElement> faexprcache;
    private final Map<NameExpr, VariableElement> nexprcache;
    private final AnnotationMirror fromStubFile;
    private CompilationUnit theCompilationUnit;
    private static final Set<String> nestedClassWarnings = new HashSet<String>();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator").intern();
    private static Set<String> warnings = new HashSet<String>();

    public StubParser(String filename, InputStream inputStream, AnnotatedTypeFactory factory, ProcessingEnvironment env) {
        IndexUnit parsedindex;
        this.filename = filename;
        try {
            parsedindex = JavaParser.parse(inputStream);
        }
        catch (Exception e) {
            ErrorReporter.errorAbort("StubParser: exception from JavaParser.parse for file " + filename, e);
            parsedindex = null;
        }
        this.index = parsedindex;
        this.atypeFactory = factory;
        this.processingEnv = env;
        this.elements = env.getElementUtils();
        this.imports = new ArrayList<String>();
        Map<String, String> options = env.getOptions();
        this.warnIfNotFound = options.containsKey("stubWarnIfNotFound");
        this.debugStubParser = options.containsKey("stubDebug");
        this.supportedAnnotations = this.getSupportedAnnotations();
        if (this.supportedAnnotations.isEmpty()) {
            StubParser.stubWarning("No supported annotations found! This likely means your stub file doesn't import them correctly.");
        }
        this.faexprcache = new HashMap<FieldAccessExpr, VariableElement>();
        this.nexprcache = new HashMap<NameExpr, VariableElement>();
        this.fromStubFile = AnnotationUtils.fromClass(this.elements, FromStubFile.class);
    }

    private Map<String, AnnotationMirror> annosInPackage(PackageElement packageElement) {
        return this.createImportedAnnotationsMap(ElementFilter.typesIn(packageElement.getEnclosedElements()));
    }

    private Map<String, AnnotationMirror> annosInType(TypeElement typeElement) {
        return this.createImportedAnnotationsMap(ElementFilter.typesIn(typeElement.getEnclosedElements()));
    }

    private Map<String, AnnotationMirror> createImportedAnnotationsMap(List<TypeElement> typeElements) {
        HashMap<String, AnnotationMirror> r = new HashMap<String, AnnotationMirror>();
        for (TypeElement typeElm : typeElements) {
            if (typeElm.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            AnnotationMirror anno = AnnotationUtils.fromName(this.elements, typeElm.getQualifiedName());
            StubParser.putNew(r, typeElm.getSimpleName().toString(), anno);
        }
        return r;
    }

    private static List<String> getImportableMembers(TypeElement typeElement) {
        ArrayList<String> result2 = new ArrayList<String>();
        List<VariableElement> memberElements = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement varElement : memberElements) {
            if (varElement.getConstantValue() == null && varElement.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result2.add(String.format("%s.%s", typeElement.getQualifiedName().toString(), varElement.getSimpleName().toString()));
        }
        return result2;
    }

    private Map<String, AnnotationMirror> getSupportedAnnotations() {
        assert (!this.index.getCompilationUnits().isEmpty());
        CompilationUnit cu = this.index.getCompilationUnits().get(0);
        HashMap<String, AnnotationMirror> result2 = new HashMap<String, AnnotationMirror>();
        if (cu.getImports() == null) {
            return result2;
        }
        for (ImportDeclaration importDecl : cu.getImports()) {
            String imported = importDecl.getName().toString();
            try {
                if (importDecl.isAsterisk()) {
                    QualifiedNameable element;
                    if (importDecl.isStatic()) {
                        element = this.findType(imported, "Imported type not found");
                        if (element == null) continue;
                        StubParser.putAllNew(result2, this.annosInType((TypeElement)element));
                        this.imports.addAll(StubParser.getImportableMembers((TypeElement)element));
                        continue;
                    }
                    element = this.findPackage(imported);
                    if (element == null) continue;
                    StubParser.putAllNew(result2, this.annosInPackage((PackageElement)element));
                    continue;
                }
                TypeElement importType = this.elements.getTypeElement(imported);
                if (importType == null && !importDecl.isStatic()) {
                    if (!this.warnIfNotFound && !this.debugStubParser) continue;
                    StubParser.stubWarning("Imported type not found: " + imported);
                    continue;
                }
                if (importType == null) {
                    Pair<String, String> typeParts = StubUtil.partitionQualifiedName(imported);
                    String type2 = (String)typeParts.first;
                    String fieldName = (String)typeParts.second;
                    TypeElement enclType = this.findType(type2, String.format("Enclosing type of static field %s not found", fieldName));
                    if (enclType == null || this.findFieldElement(enclType, fieldName) == null) continue;
                    this.imports.add(imported);
                    continue;
                }
                if (importType.getKind() == ElementKind.ANNOTATION_TYPE) {
                    AnnotationMirror anno = AnnotationUtils.fromName(this.elements, imported);
                    if (anno != null) {
                        Element annoElt = anno.getAnnotationType().asElement();
                        StubParser.putNew(result2, annoElt.getSimpleName().toString(), anno);
                        continue;
                    }
                    if (!this.warnIfNotFound && !this.debugStubParser) continue;
                    StubParser.stubWarning("Could not load import: " + imported);
                    continue;
                }
                this.imports.add(imported);
            }
            catch (AssertionError error) {
                StubParser.stubWarning("" + error);
            }
        }
        return result2;
    }

    public void parse(Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.parse(this.index, atypes, declAnnos);
    }

    private void parse(IndexUnit index, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        for (CompilationUnit cu : index.getCompilationUnits()) {
            this.parse(cu, atypes, declAnnos);
        }
    }

    private void parse(CompilationUnit cu, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        String packageName;
        this.theCompilationUnit = cu;
        if (cu.getPackage() == null) {
            packageName = null;
        } else {
            packageName = cu.getPackage().getName().toString();
            this.parsePackage(cu.getPackage(), atypes, declAnnos);
        }
        if (cu.getTypes() != null) {
            for (TypeDeclaration typeDecl : cu.getTypes()) {
                this.parse(typeDecl, packageName, atypes, declAnnos);
            }
        }
    }

    private void parsePackage(PackageDeclaration packDecl, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        assert (packDecl != null);
        String packageName = packDecl.getName().toString();
        PackageElement elem = this.elements.getPackageElement(packageName);
        if (elem != null) {
            this.annotateDecl(declAnnos, elem, packDecl.getAnnotations());
        }
    }

    private void parse(TypeDeclaration typeDecl, String packageName, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        String typeName = (packageName == null ? "" : packageName + ".") + typeDecl.getName().replace('$', '.');
        TypeElement typeElt = this.elements.getTypeElement(typeName);
        if (typeElt == null) {
            if (this.warnIfNotFound || this.debugStubParser) {
                StubParser.stubWarning("Type not found: " + typeName);
            }
            return;
        }
        if (typeElt.getKind() == ElementKind.ENUM) {
            if (this.warnIfNotFound || this.debugStubParser) {
                StubParser.stubWarning("Skipping enum type: " + typeName);
            }
        } else if (typeElt.getKind() == ElementKind.ANNOTATION_TYPE) {
            if (this.warnIfNotFound || this.debugStubParser) {
                StubParser.stubWarning("Skipping annotation type: " + typeName);
            }
        } else if (typeDecl instanceof ClassOrInterfaceDeclaration) {
            this.parseType((ClassOrInterfaceDeclaration)typeDecl, typeElt, atypes, declAnnos);
        }
        Map<Element, BodyDeclaration> elementsToDecl = this.getMembers(typeElt, typeDecl);
        for (Map.Entry<Element, BodyDeclaration> entry : elementsToDecl.entrySet()) {
            Element elt = entry.getKey();
            BodyDeclaration decl = entry.getValue();
            if (elt.getKind().isField()) {
                this.parseField((FieldDeclaration)decl, (VariableElement)elt, atypes, declAnnos);
                continue;
            }
            if (elt.getKind() == ElementKind.CONSTRUCTOR) {
                this.parseConstructor((ConstructorDeclaration)decl, (ExecutableElement)elt, atypes, declAnnos);
                continue;
            }
            if (elt.getKind() == ElementKind.METHOD) {
                this.parseMethod((MethodDeclaration)decl, (ExecutableElement)elt, atypes, declAnnos);
                continue;
            }
            System.err.println("StubParser ignoring: " + elt);
        }
    }

    private void parseType(ClassOrInterfaceDeclaration decl, TypeElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedDeclaredType type2 = this.atypeFactory.fromElement(elt);
        this.annotate((AnnotatedTypeMirror)type2, decl.getAnnotations());
        List<AnnotatedTypeMirror> typeArguments = type2.getTypeArguments();
        List<TypeParameter> typeParameters2 = decl.getTypeParameters();
        if (typeParameters2 == null && typeArguments.size() != 0 && this.debugStubParser) {
            System.out.printf(String.format("parseType:  mismatched sizes for params and args%n  decl=%s%n  typeParameters=%s%n  elt=%s (%s)%n  type=%s (%s)%n  typeArguments (size %d)=%s%n  theCompilationUnit=%s%nEnd of Message%n", decl, typeParameters2, elt, elt.getClass(), type2, type2.getClass(), typeArguments.size(), typeArguments, this.theCompilationUnit), new Object[0]);
            System.out.flush();
        }
        if (typeParameters2 != null && typeParameters2.size() != typeArguments.size() && this.debugStubParser) {
            System.out.printf(String.format("parseType:  mismatched sizes for params and args%n  decl=%s%n  typeParameters (size %d)=%s%n  elt=%s (%s)%n  type=%s (%s)%n  typeArguments (size %d)=%s%n  theCompilationUnit=%s%nEnd of Message%n", decl, typeParameters2.size(), typeParameters2, elt, elt.getClass(), type2, type2.getClass(), typeArguments.size(), typeArguments, this.theCompilationUnit), new Object[0]);
            System.out.flush();
        }
        this.annotateParameters(type2.getTypeArguments(), decl.getTypeParameters());
        this.annotateSupertypes(decl, type2);
        StubParser.putNew(atypes, elt, type2);
    }

    private void annotateSupertypes(ClassOrInterfaceDeclaration typeDecl, AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
        AnnotatedTypeMirror.AnnotatedDeclaredType foundType;
        if (typeDecl.getExtends() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getExtends()) {
                foundType = this.findType(superType, type2.directSuperTypes());
                assert (foundType != null) : "StubParser: could not find superclass " + superType + " from type " + type2;
                if (foundType == null) continue;
                this.annotate((AnnotatedTypeMirror)foundType, superType);
            }
        }
        if (typeDecl.getImplements() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getImplements()) {
                foundType = this.findType(superType, type2.directSuperTypes());
                assert (foundType != null || superType.toString().equals("AutoCloseable") || superType.toString().equals("java.io.Closeable") || superType.toString().equals("Closeable")) : "StubParser: could not find superinterface " + superType + " from type " + type2;
                if (foundType == null) continue;
                this.annotate((AnnotatedTypeMirror)foundType, superType);
            }
        }
    }

    private void parseMethod(MethodDeclaration decl, ExecutableElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        this.annotateDecl(declAnnos, elt, decl.getType().getAnnotations());
        this.addDeclAnnotations(declAnnos, elt);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        this.annotateParameters(methodType.getTypeVariables(), decl.getTypeParameters());
        this.annotate(methodType.getReturnType(), decl.getType());
        List<Parameter> params2 = decl.getParameters();
        List<? extends VariableElement> paramElts = elt.getParameters();
        List<AnnotatedTypeMirror> paramTypes = methodType.getParameterTypes();
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            VariableElement paramElt = paramElts.get(i);
            AnnotatedTypeMirror paramType = paramTypes.get(i);
            Parameter param = params2.get(i);
            this.annotateDecl(declAnnos, paramElt, param.getAnnotations());
            this.annotateDecl(declAnnos, paramElt, param.getType().getAnnotations());
            if (param.isVarArgs()) {
                assert (paramType.getKind() == TypeKind.ARRAY);
                this.annotate(((AnnotatedTypeMirror.AnnotatedArrayType)paramType).getComponentType(), param.getType());
                continue;
            }
            this.annotate(paramType, param.getType());
        }
        this.annotate((AnnotatedTypeMirror)methodType.getReceiverType(), decl.getReceiverAnnotations());
        StubParser.putNew(atypes, elt, methodType);
    }

    private void addDeclAnnotations(Map<String, Set<AnnotationMirror>> declAnnos, ExecutableElement elt) {
        if (this.fromStubFile != null) {
            Set<AnnotationMirror> annos = declAnnos.get(ElementUtils.getVerboseName(elt));
            if (annos == null) {
                annos = AnnotationUtils.createAnnotationSet();
                declAnnos.put(ElementUtils.getVerboseName(elt), annos);
            }
            annos.add(this.fromStubFile);
        }
    }

    private List<AnnotatedTypeMirror> arrayAllComponents(AnnotatedTypeMirror.AnnotatedArrayType atype) {
        LinkedList<AnnotatedTypeMirror> arrays = new LinkedList<AnnotatedTypeMirror>();
        AnnotatedTypeMirror type2 = atype;
        while (type2.getKind() == TypeKind.ARRAY) {
            arrays.addFirst(type2);
            type2 = type2.getComponentType();
        }
        arrays.add(type2);
        return arrays;
    }

    private void annotateAsArray(AnnotatedTypeMirror.AnnotatedArrayType atype, ReferenceType typeDef) {
        List<AnnotatedTypeMirror> arrayTypes = this.arrayAllComponents(atype);
        assert (typeDef.getArrayCount() == arrayTypes.size() - 1 || typeDef.getArrayCount() == 0) : "Mismatched array lengths; typeDef: " + typeDef.getArrayCount() + " vs. arrayTypes: " + (arrayTypes.size() - 1) + "\n  typedef: " + typeDef + "\n  arraytypes: " + arrayTypes;
        for (int i = 0; i < typeDef.getArrayCount(); ++i) {
            List<AnnotationExpr> annotations2 = typeDef.getAnnotationsAtLevel(i);
            if (annotations2 == null) continue;
            this.annotate(arrayTypes.get(i), annotations2);
        }
        this.annotate(arrayTypes.get(arrayTypes.size() - 1), typeDef.getAnnotations());
    }

    private ClassOrInterfaceType unwrapDeclaredType(Type type2) {
        if (type2 instanceof ClassOrInterfaceType) {
            return (ClassOrInterfaceType)type2;
        }
        if (type2 instanceof ReferenceType && ((ReferenceType)type2).getArrayCount() == 0) {
            return this.unwrapDeclaredType(((ReferenceType)type2).getType());
        }
        return null;
    }

    private void annotate(AnnotatedTypeMirror atype, Type typeDef) {
        if (atype.getKind() == TypeKind.ARRAY) {
            this.annotateAsArray((AnnotatedTypeMirror.AnnotatedArrayType)atype, (ReferenceType)typeDef);
            return;
        }
        if (typeDef.getAnnotations() != null) {
            this.annotate(atype, typeDef.getAnnotations());
        }
        ClassOrInterfaceType declType = this.unwrapDeclaredType(typeDef);
        if (atype.getKind() == TypeKind.DECLARED && declType != null) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adeclType = (AnnotatedTypeMirror.AnnotatedDeclaredType)atype;
            if (declType.getTypeArgs() != null && !declType.getTypeArgs().isEmpty() && !adeclType.getTypeArguments().isEmpty()) {
                assert (declType.getTypeArgs().size() == adeclType.getTypeArguments().size());
                for (int i = 0; i < declType.getTypeArgs().size(); ++i) {
                    this.annotate(adeclType.getTypeArguments().get(i), declType.getTypeArgs().get(i));
                }
            }
        } else if (atype.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)atype;
            WildcardType wildcardDef = (WildcardType)typeDef;
            if (wildcardDef.getExtends() != null) {
                this.annotate(wildcardType.getExtendsBound(), wildcardDef.getExtends());
            } else if (wildcardDef.getSuper() != null) {
                this.annotate(wildcardType.getSuperBound(), wildcardDef.getSuper());
            }
        }
    }

    private void parseConstructor(ConstructorDeclaration decl, ExecutableElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        this.addDeclAnnotations(declAnnos, elt);
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            AnnotatedTypeMirror paramType = methodType.getParameterTypes().get(i);
            Parameter param = decl.getParameters().get(i);
            this.annotate(paramType, param.getType());
        }
        this.annotate((AnnotatedTypeMirror)methodType.getReceiverType(), decl.getReceiverAnnotations());
        StubParser.putNew(atypes, elt, methodType);
    }

    private void parseField(FieldDeclaration decl, VariableElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        this.annotateDecl(declAnnos, elt, decl.getType().getAnnotations());
        AnnotatedTypeMirror fieldType = this.atypeFactory.fromElement(elt);
        this.annotate(fieldType, decl.getType());
        StubParser.putNew(atypes, elt, fieldType);
    }

    private void annotate(AnnotatedTypeMirror type2, List<AnnotationExpr> annotations2) {
        if (annotations2 == null) {
            return;
        }
        for (AnnotationExpr annotation : annotations2) {
            AnnotationMirror annoMirror = this.getAnnotation(annotation, this.supportedAnnotations);
            if (annoMirror == null) continue;
            type2.replaceAnnotation(annoMirror);
        }
    }

    private void annotateDecl(Map<String, Set<AnnotationMirror>> declAnnos, Element elt, List<AnnotationExpr> annotations2) {
        if (annotations2 == null) {
            return;
        }
        Set<AnnotationMirror> annos = AnnotationUtils.createAnnotationSet();
        for (AnnotationExpr annotation : annotations2) {
            AnnotationMirror annoMirror = this.getAnnotation(annotation, this.supportedAnnotations);
            if (annoMirror == null) continue;
            annos.add(annoMirror);
        }
        String key = ElementUtils.getVerboseName(elt);
        declAnnos.put(key, annos);
    }

    private void annotateParameters(List<? extends AnnotatedTypeMirror> typeArguments, List<TypeParameter> typeParameters2) {
        if (typeParameters2 == null) {
            return;
        }
        if (typeParameters2.size() != typeArguments.size()) {
            System.out.printf("annotateParameters: mismatched sizes%n  typeParameters (size %d)=%s%n  typeArguments (size %d)=%s%n", typeParameters2.size(), typeParameters2, typeArguments.size(), typeArguments);
        }
        for (int i = 0; i < typeParameters2.size(); ++i) {
            TypeParameter param = typeParameters2.get(i);
            AnnotatedTypeMirror.AnnotatedTypeVariable paramType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeArguments.get(i);
            if (param.getTypeBound() == null || param.getTypeBound().size() != 1) continue;
            this.annotate(paramType.getUpperBound(), param.getTypeBound().get(0));
        }
    }

    private Map<Element, BodyDeclaration> getMembers(TypeElement typeElt, TypeDeclaration typeDecl) {
        assert (typeElt.getSimpleName().contentEquals(typeDecl.getName()) || typeDecl.getName().endsWith("$" + typeElt.getSimpleName().toString())) : String.format("%s  %s", typeElt.getSimpleName(), typeDecl.getName());
        HashMap<Element, BodyDeclaration> result2 = new HashMap<Element, BodyDeclaration>();
        for (BodyDeclaration member : typeDecl.getMembers()) {
            ExecutableElement elt;
            if (member instanceof MethodDeclaration) {
                elt = this.findElement(typeElt, (MethodDeclaration)member);
                StubParser.putNew(result2, elt, member);
                continue;
            }
            if (member instanceof ConstructorDeclaration) {
                elt = this.findElement(typeElt, (ConstructorDeclaration)member);
                StubParser.putNew(result2, elt, member);
                continue;
            }
            if (member instanceof FieldDeclaration) {
                FieldDeclaration fieldDecl = (FieldDeclaration)member;
                for (VariableDeclarator var : fieldDecl.getVariables()) {
                    StubParser.putNew(result2, this.findElement(typeElt, var), fieldDecl);
                }
                continue;
            }
            if (member instanceof ClassOrInterfaceDeclaration) {
                ClassOrInterfaceDeclaration ciDecl = (ClassOrInterfaceDeclaration)member;
                String nestedClass = typeDecl.getName() + "." + ciDecl.getName();
                if (!nestedClassWarnings.add(nestedClass)) continue;
                System.err.printf("Warning: ignoring nested class in %s at line %d:%n    class %s { class %s { ... } }%n", this.filename, ciDecl.getBeginLine(), typeDecl.getName(), ciDecl.getName());
                System.err.printf("  Instead, write the nested class as a top-level class:%n    class %s { ... }%n    class %s$%s { ... }%n", typeDecl.getName(), typeDecl.getName(), ciDecl.getName());
                continue;
            }
            if (!this.warnIfNotFound && !this.debugStubParser) continue;
            System.out.printf("StubParser: Ignoring element of type %s in getMembers", member.getClass());
        }
        return result2;
    }

    private AnnotatedTypeMirror.AnnotatedDeclaredType findType(ClassOrInterfaceType type2, List<AnnotatedTypeMirror.AnnotatedDeclaredType> types) {
        String typeString = type2.getName();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
            if (!superType.getUnderlyingType().asElement().getSimpleName().contentEquals(typeString)) continue;
            return superType;
        }
        if (this.warnIfNotFound || this.debugStubParser) {
            StubParser.stubWarning("Type " + typeString + " not found");
        }
        if (this.debugStubParser) {
            for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
                System.err.printf("  %s%n", superType);
            }
        }
        return null;
    }

    public ExecutableElement findElement(TypeElement typeElt, MethodDeclaration methodDecl) {
        String wantedMethodName = methodDecl.getName();
        int wantedMethodParams = methodDecl.getParameters() == null ? 0 : methodDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(methodDecl);
        for (ExecutableElement method : ElementUtils.getAllMethodsIn(typeElt)) {
            if (wantedMethodParams != method.getParameters().size() || !wantedMethodName.contentEquals(method.getSimpleName()) || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        if (this.warnIfNotFound || this.debugStubParser) {
            StubParser.stubWarning("Method " + wantedMethodString + " not found in type " + typeElt);
        }
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                System.err.printf("  %s%n", method);
            }
        }
        return null;
    }

    public ExecutableElement findElement(TypeElement typeElt, ConstructorDeclaration methodDecl) {
        int wantedMethodParams = methodDecl.getParameters() == null ? 0 : methodDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(methodDecl);
        for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
            if (wantedMethodParams != method.getParameters().size() || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        if (this.warnIfNotFound || this.debugStubParser) {
            StubParser.stubWarning("Constructor " + wantedMethodString + " not found in type " + typeElt);
        }
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
                System.err.printf("  %s%n", method);
            }
        }
        return null;
    }

    public VariableElement findElement(TypeElement typeElt, VariableDeclarator variable) {
        String fieldName = variable.getId().getName();
        return this.findFieldElement(typeElt, fieldName);
    }

    public VariableElement findFieldElement(TypeElement typeElt, String fieldName) {
        for (VariableElement field : ElementUtils.getAllFieldsIn(typeElt)) {
            if (!fieldName.equals(field.getSimpleName().toString())) continue;
            return field;
        }
        if (this.warnIfNotFound || this.debugStubParser) {
            StubParser.stubWarning("Field " + fieldName + " not found in type " + typeElt);
        }
        if (this.debugStubParser) {
            for (VariableElement field : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                System.err.printf("  %s%n", field);
            }
        }
        return null;
    }

    private TypeElement findType(String typeName, String ... msg) {
        TypeElement classElement = this.elements.getTypeElement(typeName);
        if (classElement == null && (this.warnIfNotFound || this.debugStubParser)) {
            if (msg.length == 0) {
                StubParser.stubWarning("Type not found: " + typeName);
            } else {
                StubParser.stubWarning(msg[0] + ": " + typeName);
            }
        }
        return classElement;
    }

    private PackageElement findPackage(String packageName) {
        PackageElement packageElement = this.elements.getPackageElement(packageName);
        if (packageElement == null && (this.warnIfNotFound || this.debugStubParser)) {
            StubParser.stubWarning("Imported package not found: " + packageName);
        }
        return packageElement;
    }

    private static <K, V> void putNew(Map<K, V> m3, K key, V value2) {
        if (key == null) {
            return;
        }
        if (m3.containsKey(key) && !m3.get(key).equals(value2)) {
            ErrorReporter.errorAbort("StubParser: key is already in map: " + LINE_SEPARATOR + "  " + key + " => " + m3.get(key) + LINE_SEPARATOR + "while adding: " + LINE_SEPARATOR + "  " + key + " => " + value2);
        }
        m3.put(key, value2);
    }

    private static void putNew(Map<Element, AnnotatedTypeMirror> m3, Element key, AnnotatedTypeMirror value2) {
        if (key == null) {
            return;
        }
        if (m3.containsKey(key)) {
            AnnotatedTypeMirror value22 = m3.get(key);
            if (AnnotationUtils.areSame(value2.getAnnotations(), value22.getAnnotations())) {
                return;
            }
            AnnotatedTypeMirror prev = m3.get(key);
            StubParser.mergeATM(value2, prev);
        }
        m3.put(key, value2);
    }

    private static void mergeATM(AnnotatedTypeMirror into, AnnotatedTypeMirror from) {
        AnnotatedTypeMirror cfrom;
        AnnotatedTypeMirror cinto;
        assert (into.getClass() == from.getClass());
        for (AnnotationMirror afrom : from.getAnnotations()) {
            if (into.isAnnotatedInHierarchy(afrom) && !AnnotationUtils.areSame(into.getAnnotationInHierarchy(afrom), afrom)) {
                ErrorReporter.errorAbort("StubParser: key is already in map: " + LINE_SEPARATOR + " existing: " + into + " new: " + from);
                return;
            }
            into.addAnnotation(afrom);
        }
        if (from instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            cinto = (AnnotatedTypeMirror.AnnotatedArrayType)into;
            cfrom = (AnnotatedTypeMirror.AnnotatedArrayType)from;
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedArrayType)cinto).getComponentType(), ((AnnotatedTypeMirror.AnnotatedArrayType)cfrom).getComponentType());
        } else if (from instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
            cinto = (AnnotatedTypeMirror.AnnotatedDeclaredType)into;
            cfrom = (AnnotatedTypeMirror.AnnotatedDeclaredType)from;
            StubParser.mergeATMs(((AnnotatedTypeMirror.AnnotatedDeclaredType)cinto).getTypeArguments(), ((AnnotatedTypeMirror.AnnotatedDeclaredType)cfrom).getTypeArguments());
        } else if (from instanceof AnnotatedTypeMirror.AnnotatedExecutableType) {
            cinto = (AnnotatedTypeMirror.AnnotatedExecutableType)into;
            cfrom = (AnnotatedTypeMirror.AnnotatedExecutableType)from;
            StubParser.mergeATMs(((AnnotatedTypeMirror.AnnotatedExecutableType)cinto).getTypeVariables(), ((AnnotatedTypeMirror.AnnotatedExecutableType)cinto).getTypeVariables());
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedExecutableType)cinto).getReturnType(), ((AnnotatedTypeMirror.AnnotatedExecutableType)cfrom).getReturnType());
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedExecutableType)cinto).getReceiverType(), ((AnnotatedTypeMirror.AnnotatedExecutableType)cfrom).getReceiverType());
            StubParser.mergeATMs(((AnnotatedTypeMirror.AnnotatedExecutableType)cinto).getParameterTypes(), ((AnnotatedTypeMirror.AnnotatedExecutableType)cfrom).getParameterTypes());
            StubParser.mergeATMs(((AnnotatedTypeMirror.AnnotatedExecutableType)cinto).getThrownTypes(), ((AnnotatedTypeMirror.AnnotatedExecutableType)cfrom).getThrownTypes());
        } else if (from instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            cinto = (AnnotatedTypeMirror.AnnotatedTypeVariable)into;
            cfrom = (AnnotatedTypeMirror.AnnotatedTypeVariable)from;
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedTypeVariable)cinto).getLowerBound(), ((AnnotatedTypeMirror.AnnotatedTypeVariable)cfrom).getLowerBound());
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedTypeVariable)cinto).getUpperBound(), ((AnnotatedTypeMirror.AnnotatedTypeVariable)cfrom).getUpperBound());
        } else if (from instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
            cinto = (AnnotatedTypeMirror.AnnotatedWildcardType)into;
            cfrom = (AnnotatedTypeMirror.AnnotatedWildcardType)from;
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedWildcardType)cinto).getSuperBound(), ((AnnotatedTypeMirror.AnnotatedWildcardType)cfrom).getSuperBound());
            StubParser.mergeATM(((AnnotatedTypeMirror.AnnotatedWildcardType)cinto).getExtendsBound(), ((AnnotatedTypeMirror.AnnotatedWildcardType)cfrom).getExtendsBound());
        }
    }

    private static void mergeATMs(List<? extends AnnotatedTypeMirror> into, List<? extends AnnotatedTypeMirror> from) {
        assert (into.size() == from.size());
        for (int i = 0; i < into.size(); ++i) {
            StubParser.mergeATM(into.get(i), from.get(i));
        }
    }

    private static <K, V> void putAllNew(Map<K, V> m3, Map<K, V> m22) {
        for (Map.Entry<K, V> e2 : m22.entrySet()) {
            StubParser.putNew(m3, e2.getKey(), e2.getValue());
        }
    }

    private static void stubWarning(String warning) {
        if (warnings.add(warning)) {
            System.err.println("StubParser: " + warning);
        }
    }

    private AnnotationMirror getAnnotation(AnnotationExpr annotation, Map<String, AnnotationMirror> supportedAnnotations) {
        AnnotationMirror annoMirror;
        if (annotation instanceof MarkerAnnotationExpr) {
            String annoName = ((MarkerAnnotationExpr)annotation).getName().getName();
            annoMirror = supportedAnnotations.get(annoName);
        } else {
            if (annotation instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr nrmanno = (NormalAnnotationExpr)annotation;
                String annoName = nrmanno.getName().getName();
                AnnotationMirror annoMirror2 = supportedAnnotations.get(annoName);
                if (annoMirror2 == null) {
                    return null;
                }
                AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoMirror2);
                List<MemberValuePair> pairs = nrmanno.getPairs();
                if (pairs != null) {
                    for (MemberValuePair mvp : pairs) {
                        String meth = mvp.getName();
                        Expression exp = mvp.getValue();
                        this.handleExpr(builder, meth, exp);
                    }
                }
                return builder.build();
            }
            if (annotation instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr sglanno = (SingleMemberAnnotationExpr)annotation;
                String annoName = sglanno.getName().getName();
                AnnotationMirror annoMirror3 = supportedAnnotations.get(annoName);
                if (annoMirror3 == null) {
                    return null;
                }
                AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoMirror3);
                Expression valexpr = sglanno.getMemberValue();
                this.handleExpr(builder, "value", valexpr);
                return builder.build();
            }
            ErrorReporter.errorAbort("StubParser: unknown annotation type: " + annotation);
            annoMirror = null;
        }
        return annoMirror;
    }

    private void handleExpr(AnnotationBuilder builder, String name, Expression expr) {
        if (expr instanceof FieldAccessExpr || expr instanceof NameExpr) {
            VariableElement elem = expr instanceof FieldAccessExpr ? this.findVariableElement((FieldAccessExpr)expr) : this.findVariableElement((NameExpr)expr);
            if (elem == null) {
                return;
            }
            ExecutableElement var = builder.findElement(name);
            TypeMirror expected = var.getReturnType();
            if (expected.getKind() == TypeKind.DECLARED) {
                if (elem.getConstantValue() != null) {
                    builder.setValue((CharSequence)name, (String)elem.getConstantValue());
                } else {
                    builder.setValue((CharSequence)name, elem);
                }
            } else if (expected.getKind() == TypeKind.ARRAY) {
                if (elem.getConstantValue() != null) {
                    Object[] arr = new String[]{(String)elem.getConstantValue()};
                    builder.setValue((CharSequence)name, arr);
                } else {
                    VariableElement[] arr = new VariableElement[]{elem};
                    builder.setValue((CharSequence)name, arr);
                }
            } else {
                ErrorReporter.errorAbort("StubParser: unhandled annotation attribute type: " + expr + " and expected: " + expected);
            }
        } else if (expr instanceof StringLiteralExpr) {
            StringLiteralExpr slexpr = (StringLiteralExpr)expr;
            ExecutableElement var = builder.findElement(name);
            TypeMirror expected = var.getReturnType();
            if (expected.getKind() == TypeKind.DECLARED) {
                builder.setValue((CharSequence)name, slexpr.getValue());
            } else if (expected.getKind() == TypeKind.ARRAY) {
                Object[] arr = new String[]{slexpr.getValue()};
                builder.setValue((CharSequence)name, arr);
            } else {
                ErrorReporter.errorAbort("StubParser: unhandled annotation attribute type: " + slexpr + " and expected: " + expected);
            }
        } else if (expr instanceof ArrayInitializerExpr) {
            ExecutableElement var = builder.findElement(name);
            TypeMirror expected = var.getReturnType();
            if (expected.getKind() != TypeKind.ARRAY) {
                ErrorReporter.errorAbort("StubParser: unhandled annotation attribute type: " + expr + " and expected: " + expected);
            }
            ArrayInitializerExpr aiexpr = (ArrayInitializerExpr)expr;
            List<Expression> aiexprvals = aiexpr.getValues();
            Object[] elemarr = new Object[aiexprvals.size()];
            for (int i = 0; i < aiexprvals.size(); ++i) {
                Expression anaiexpr = aiexprvals.get(i);
                if (anaiexpr instanceof FieldAccessExpr || anaiexpr instanceof NameExpr) {
                    elemarr[i] = anaiexpr instanceof FieldAccessExpr ? this.findVariableElement((FieldAccessExpr)anaiexpr) : this.findVariableElement((NameExpr)anaiexpr);
                    if (elemarr[i] == null) {
                        return;
                    }
                    String constval = (String)((VariableElement)elemarr[i]).getConstantValue();
                    if (constval == null) continue;
                    elemarr[i] = constval;
                    continue;
                }
                if (anaiexpr instanceof StringLiteralExpr) {
                    elemarr[i] = ((StringLiteralExpr)anaiexpr).getValue();
                    continue;
                }
                ErrorReporter.errorAbort("StubParser: unhandled annotation attribute type: " + anaiexpr);
            }
            builder.setValue((CharSequence)name, elemarr);
        } else if (expr instanceof BooleanLiteralExpr) {
            BooleanLiteralExpr blexpr = (BooleanLiteralExpr)expr;
            ExecutableElement var = builder.findElement(name);
            TypeMirror expected = var.getReturnType();
            if (expected.getKind() == TypeKind.BOOLEAN) {
                builder.setValue((CharSequence)name, blexpr.getValue());
            } else if (expected.getKind() == TypeKind.ARRAY) {
                Object[] arr = new Boolean[]{blexpr.getValue()};
                builder.setValue((CharSequence)name, arr);
            } else {
                ErrorReporter.errorAbort("StubParser: unhandled annotation attribute type: " + blexpr + " and expected: " + expected);
            }
        } else {
            ErrorReporter.errorAbort("StubParser: unhandled annotation attribute type: " + expr + " class: " + expr.getClass());
        }
    }

    private VariableElement findVariableElement(NameExpr nexpr) {
        if (this.nexprcache.containsKey(nexpr)) {
            return this.nexprcache.get(nexpr);
        }
        VariableElement res = null;
        boolean importFound = false;
        for (String imp : this.imports) {
            Pair<String, String> partitionedName = StubUtil.partitionQualifiedName(imp);
            String typeName = (String)partitionedName.first;
            String fieldName = (String)partitionedName.second;
            if (!fieldName.equals(nexpr.getName())) continue;
            TypeElement enclType = this.findType(typeName, String.format("Enclosing type of static import %s not found", fieldName));
            if (enclType == null) {
                return null;
            }
            importFound = true;
            res = this.findFieldElement(enclType, fieldName);
            break;
        }
        if (res == null && !importFound && (this.warnIfNotFound || this.debugStubParser)) {
            StubParser.stubWarning("Static field " + nexpr.getName() + " is not imported");
        }
        this.nexprcache.put(nexpr, res);
        return res;
    }

    private VariableElement findVariableElement(FieldAccessExpr faexpr) {
        if (this.faexprcache.containsKey(faexpr)) {
            return this.faexprcache.get(faexpr);
        }
        TypeElement rcvElt = this.elements.getTypeElement(faexpr.getScope().toString());
        if (rcvElt == null) {
            for (String imp : this.imports) {
                String[] import_delimited = imp.split("\\.");
                if (!import_delimited[import_delimited.length - 1].equals(faexpr.getScope().toString())) continue;
                StringBuilder full_annotation = new StringBuilder();
                for (int i = 0; i < import_delimited.length - 1; ++i) {
                    full_annotation.append(import_delimited[i]);
                    full_annotation.append('.');
                }
                full_annotation.append(faexpr.getScope().toString());
                rcvElt = this.elements.getTypeElement(full_annotation);
                break;
            }
            if (rcvElt == null) {
                if (this.warnIfNotFound || this.debugStubParser) {
                    StubParser.stubWarning("Type " + faexpr.getScope().toString() + " not found");
                }
                return null;
            }
        }
        VariableElement res = this.findFieldElement(rcvElt, faexpr.getField());
        this.faexprcache.put(faexpr, res);
        return res;
    }
}

