/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;

public final class TestUtilities {
    private TestUtilities() {
        throw new AssertionError((Object)"not instantiated class");
    }

    public static boolean isJavaFile(File file2) {
        return file2.isFile() && file2.getName().endsWith(".java");
    }

    public static boolean isJavaTestFile(File file2) {
        if (!TestUtilities.isJavaFile(file2)) {
            return false;
        }
        Scanner in = null;
        try {
            in = new Scanner(file2);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        while (in.hasNext()) {
            String nextLine = in.nextLine();
            if (!nextLine.contains("@skip-test")) continue;
            in.close();
            return false;
        }
        in.close();
        return true;
    }

    public static boolean shouldSucceed(File expectedFile) {
        if (!expectedFile.exists()) {
            return true;
        }
        try {
            Scanner in = new Scanner(new FileReader(expectedFile));
            while (in.hasNextLine()) {
                if (in.nextLine().contains("warning")) continue;
                in.close();
                return false;
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static List<File> enclosedJavaTestFiles(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException("directory does not exist: " + directory);
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("found file instead of directory: " + directory);
        }
        ArrayList<File> javaFiles = new ArrayList<File>();
        for (File file2 : directory.listFiles()) {
            if (!TestUtilities.isJavaTestFile(file2)) continue;
            javaFiles.add(file2);
        }
        return javaFiles;
    }

    public static List<File> deeplyEnclosedJavaTestFiles(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException("directory does not exist: " + directory);
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("found file instead of directory: " + directory);
        }
        ArrayList<File> javaFiles = new ArrayList<File>();
        File[] in = directory.listFiles();
        Arrays.sort(in, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file2 : in) {
            if (file2.isDirectory()) {
                javaFiles.addAll(TestUtilities.deeplyEnclosedJavaTestFiles(file2));
                continue;
            }
            if (!TestUtilities.isJavaTestFile(file2)) continue;
            javaFiles.add(file2);
        }
        return javaFiles;
    }

    public static List<String> expectedDiagnostics(File file2) {
        ArrayList<String> expected = new ArrayList<String>();
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new FileReader(file2));
            while ((line = reader.readLine()) != null) {
                String[] msgs;
                if (!(line = line.trim()).startsWith("//::")) continue;
                int errorLine = reader.getLineNumber() + 1;
                line = line.substring(4);
                for (String msg : msgs = line.split("::")) {
                    msg = ":" + errorLine + ": " + msg.trim();
                    expected.add(msg);
                }
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return expected;
    }

    public static List<String> expectedDiagnostics(String prefix2, String[] files) {
        ArrayList<String> expected = new ArrayList<String>();
        for (String file2 : files) {
            expected.addAll(TestUtilities.expectedDiagnostics(new File(prefix2 + file2)));
        }
        return expected;
    }

    public static List<String> expectedDiagnostics(File[] files) {
        ArrayList<String> expected = new ArrayList<String>();
        for (File file2 : files) {
            expected.addAll(TestUtilities.expectedDiagnostics(file2));
        }
        return expected;
    }
}

