/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.ValueWriter;
import com.moandjiezana.toml.ValueWriters;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

abstract class ArrayValueWriter
implements ValueWriter {
    ArrayValueWriter() {
    }

    protected static boolean isArrayish(Object value2) {
        return value2 instanceof Collection || value2.getClass().isArray();
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    static boolean isArrayOfPrimitive(Object array) {
        Object first2 = ArrayValueWriter.peek(array);
        if (first2 != null) {
            ValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(first2);
            return valueWriter.isPrimitiveType() || ArrayValueWriter.isArrayish(first2);
        }
        return true;
    }

    protected Collection<?> normalize(Object value2) {
        ArrayList<Object> collection;
        if (value2.getClass().isArray()) {
            collection = new ArrayList<Object>(Array.getLength(value2));
            for (int i = 0; i < Array.getLength(value2); ++i) {
                Object elem = Array.get(value2, i);
                collection.add(elem);
            }
        } else {
            collection = (ArrayList<Object>)value2;
        }
        return collection;
    }

    private static Object peek(Object value2) {
        if (value2.getClass().isArray()) {
            if (Array.getLength(value2) > 0) {
                return Array.get(value2, 0);
            }
            return null;
        }
        Collection collection = (Collection)value2;
        if (collection.size() > 0) {
            return collection.iterator().next();
        }
        return null;
    }
}

