/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.hocon;

import com.typesafe.config.ConfigValue;
import com.uchuhimo.konf.Feature;
import com.uchuhimo.konf.TreeNode;
import com.uchuhimo.konf.source.Source;
import com.uchuhimo.konf.source.SourceInfo;
import com.uchuhimo.konf.source.hocon.HoconSourceKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/uchuhimo/konf/source/hocon/HoconSource;", "Lcom/uchuhimo/konf/source/Source;", "value", "Lcom/typesafe/config/ConfigValue;", "(Lcom/typesafe/config/ConfigValue;)V", "info", "Lcom/uchuhimo/konf/source/SourceInfo;", "getInfo", "()Lcom/uchuhimo/konf/source/SourceInfo;", "tree", "Lcom/uchuhimo/konf/TreeNode;", "getTree", "()Lcom/uchuhimo/konf/TreeNode;", "getValue", "()Lcom/typesafe/config/ConfigValue;", "konf-hocon"})
public final class HoconSource
implements Source {
    @NotNull
    private final SourceInfo info;
    @NotNull
    private final TreeNode tree;
    @NotNull
    private final ConfigValue value;

    @Override
    @NotNull
    public SourceInfo getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public TreeNode getTree() {
        return this.tree;
    }

    @NotNull
    public final ConfigValue getValue() {
        return this.value;
    }

    public HoconSource(@NotNull ConfigValue value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this.value = value2;
        this.info = new SourceInfo(TuplesKt.to("type", "HOCON"));
        this.tree = HoconSourceKt.access$toTree(this.value);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Source.DefaultImpls.getDescription(this);
    }

    @Override
    @NotNull
    public Map<Feature, Boolean> getFeatures() {
        return Source.DefaultImpls.getFeatures(this);
    }

    @Override
    public boolean contains(@NotNull List<String> path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.contains((Source)this, path);
    }

    @Override
    public boolean contains(@NotNull String prefix2) {
        Intrinsics.checkParameterIsNotNull(prefix2, "prefix");
        return Source.DefaultImpls.contains((Source)this, prefix2);
    }

    @Override
    @NotNull
    public Source disabled(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, "feature");
        return Source.DefaultImpls.disabled(this, feature);
    }

    @Override
    @NotNull
    public Source enabled(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, "feature");
        return Source.DefaultImpls.enabled(this, feature);
    }

    @Override
    @NotNull
    public Source get(@NotNull List<String> path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @Override
    @NotNull
    public Source get(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @Override
    @Nullable
    public Source getOrNull(@NotNull List<String> path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Override
    @Nullable
    public Source getOrNull(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Override
    public boolean isEnabled(@NotNull Feature feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, "feature");
        return Source.DefaultImpls.isEnabled(this, feature);
    }

    @Override
    @NotNull
    public Source plus(@NotNull Source facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        return Source.DefaultImpls.plus(this, facade);
    }

    @Override
    @NotNull
    public Source substituted(boolean errorWhenUndefined) {
        return Source.DefaultImpls.substituted(this, errorWhenUndefined);
    }

    @Override
    @NotNull
    public Source withFallback(@NotNull Source fallback) {
        Intrinsics.checkParameterIsNotNull(fallback, "fallback");
        return Source.DefaultImpls.withFallback(this, fallback);
    }

    @Override
    @NotNull
    public Source withPrefix(@NotNull List<String> prefix2) {
        Intrinsics.checkParameterIsNotNull(prefix2, "prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix2);
    }

    @Override
    @NotNull
    public Source withPrefix(@NotNull String prefix2) {
        Intrinsics.checkParameterIsNotNull(prefix2, "prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix2);
    }
}

