/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public class ArrayCreationNode
extends Node {
    protected NewArrayTree tree;
    protected List<Node> dimensions;
    protected List<Node> initializers;

    public ArrayCreationNode(NewArrayTree tree, TypeMirror type2, List<Node> dimensions, List<Node> initializers) {
        super(type2);
        this.tree = tree;
        this.dimensions = dimensions;
        this.initializers = initializers;
    }

    public List<Node> getDimensions() {
        return this.dimensions;
    }

    public Node getDimension(int i) {
        return this.dimensions.get(i);
    }

    public List<Node> getInitializers() {
        return this.initializers;
    }

    public Node getInitializer(int i) {
        return this.initializers.get(i);
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitArrayCreation(this, p);
    }

    public String toString() {
        boolean needComma;
        StringBuffer sb = new StringBuffer();
        sb.append("new " + this.type);
        if (!this.dimensions.isEmpty()) {
            needComma = false;
            sb.append(" (");
            for (Node dim : this.dimensions) {
                if (needComma) {
                    sb.append(", ");
                }
                sb.append(dim);
                needComma = true;
            }
            sb.append(")");
        }
        if (!this.initializers.isEmpty()) {
            needComma = false;
            sb.append(" = {");
            for (Node init : this.initializers) {
                if (needComma) {
                    sb.append(", ");
                }
                sb.append(init);
                needComma = true;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArrayCreationNode)) {
            return false;
        }
        ArrayCreationNode other = (ArrayCreationNode)obj;
        return this.getDimensions().equals(other.getDimensions()) && this.getInitializers().equals(other.getInitializers());
    }

    public int hashCode() {
        int hash2 = 0;
        for (Node dim : this.dimensions) {
            hash2 = HashCodeUtils.hash(hash2, dim.hashCode());
        }
        for (Node init : this.initializers) {
            hash2 = HashCodeUtils.hash(hash2, init.hashCode());
        }
        return hash2;
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list2 = new LinkedList<Node>();
        list2.addAll(this.dimensions);
        list2.addAll(this.initializers);
        return list2;
    }
}

