/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javacutils.InternalUtils;

public class EqualToNode
extends Node {
    protected BinaryTree tree;
    protected Node lhs;
    protected Node rhs;

    public EqualToNode(BinaryTree tree, Node lhs, Node rhs) {
        super(InternalUtils.typeOf(tree));
        assert (tree.getKind().equals((Object)Tree.Kind.EQUAL_TO));
        this.tree = tree;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Node getLeftOperand() {
        return this.lhs;
    }

    public Node getRightOperand() {
        return this.rhs;
    }

    @Override
    public BinaryTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitEqualTo(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " == " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EqualToNode)) {
            return false;
        }
        EqualToNode other = (EqualToNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list2 = new LinkedList<Node>();
        list2.add(this.getLeftOperand());
        list2.add(this.getRightOperand());
        return list2;
    }
}

