/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.Collections;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.ExecutableElement;

public class MethodAccessNode
extends Node {
    protected ExpressionTree tree;
    protected ExecutableElement method;
    protected Node receiver;

    public MethodAccessNode(ExpressionTree tree, Node receiver) {
        super(InternalUtils.typeOf(tree));
        assert (TreeUtils.isMethodAccess(tree));
        this.tree = tree;
        this.method = (ExecutableElement)TreeUtils.elementFromUse(tree);
        this.receiver = receiver;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitMethodAccess(this, p);
    }

    public String toString() {
        return this.getReceiver() + "." + this.method.getSimpleName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MethodAccessNode)) {
            return false;
        }
        MethodAccessNode other = (MethodAccessNode)obj;
        return this.getReceiver().equals(other.getReceiver()) && this.getMethod().equals(other.getMethod());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getReceiver(), this.getMethod());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.receiver);
    }
}

