/*
 * Decompiled with CFR 0.152.
 */
package javacutils;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.model.JavacTypes;
import javacutils.ErrorReporter;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class TypesUtils {
    private TypesUtils() {
        throw new AssertionError((Object)"Class TypesUtils cannot be instantiated.");
    }

    public static Name getQualifiedName(DeclaredType type2) {
        TypeElement element = (TypeElement)type2.asElement();
        return element.getQualifiedName();
    }

    public static boolean isObject(TypeMirror type2) {
        return TypesUtils.isDeclaredOfName(type2, "java.lang.Object");
    }

    public static boolean isClass(TypeMirror type2) {
        return TypesUtils.isDeclaredOfName(type2, "java.lang.Class");
    }

    public static boolean isString(TypeMirror type2) {
        return TypesUtils.isDeclaredOfName(type2, "java.lang.String");
    }

    public static boolean isBooleanType(TypeMirror type2) {
        return TypesUtils.isDeclaredOfName(type2, "java.lang.Boolean") || type2.getKind().equals((Object)TypeKind.BOOLEAN);
    }

    public static boolean isDeclaredOfName(TypeMirror type2, CharSequence qualifiedName2) {
        return (type2 = ((Type)type2).unannotatedType()).getKind() == TypeKind.DECLARED && TypesUtils.getQualifiedName((DeclaredType)type2).contentEquals(qualifiedName2);
    }

    public static boolean isBoxedPrimitive(TypeMirror type2) {
        if (type2.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName2 = TypesUtils.getQualifiedName((DeclaredType)type2).toString();
        return qualifiedName2.equals("java.lang.Boolean") || qualifiedName2.equals("java.lang.Byte") || qualifiedName2.equals("java.lang.Character") || qualifiedName2.equals("java.lang.Short") || qualifiedName2.equals("java.lang.Integer") || qualifiedName2.equals("java.lang.Long") || qualifiedName2.equals("java.lang.Double") || qualifiedName2.equals("java.lang.Float");
    }

    public static boolean isThrowable(TypeMirror type2) {
        while (type2 != null && type2.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type2;
            TypeElement elem = (TypeElement)dt.asElement();
            Name name = elem.getQualifiedName();
            if ("java.lang.Throwable".contentEquals(name)) {
                return true;
            }
            type2 = elem.getSuperclass();
        }
        return false;
    }

    public static boolean isPrimitive(TypeMirror type2) {
        type2 = ((Type)type2).unannotatedType();
        switch (type2.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean areSamePrimitiveTypes(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isPrimitive(left) || !TypesUtils.isPrimitive(right)) {
            return false;
        }
        return left.getKind() == right.getKind();
    }

    public static boolean isNumeric(TypeMirror type2) {
        type2 = ((Type)type2).unannotatedType();
        switch (type2.getKind()) {
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegral(TypeMirror type2) {
        type2 = ((Type)type2).unannotatedType();
        switch (type2.getKind()) {
            case BYTE: 
            case CHAR: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloating(TypeMirror type2) {
        type2 = ((Type)type2).unannotatedType();
        switch (type2.getKind()) {
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public static TypeKind widenedNumericType(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isNumeric(left) || !TypesUtils.isNumeric(right)) {
            return TypeKind.NONE;
        }
        TypeKind leftKind = left.getKind();
        TypeKind rightKind = right.getKind();
        if (leftKind == TypeKind.DOUBLE || rightKind == TypeKind.DOUBLE) {
            return TypeKind.DOUBLE;
        }
        if (leftKind == TypeKind.FLOAT || rightKind == TypeKind.FLOAT) {
            return TypeKind.FLOAT;
        }
        if (leftKind == TypeKind.LONG || rightKind == TypeKind.LONG) {
            return TypeKind.LONG;
        }
        return TypeKind.INT;
    }

    public static TypeMirror upperBound(TypeMirror type2) {
        while (true) {
            WildcardType wc;
            if (type2 instanceof TypeVariable) {
                TypeVariable tvar = (TypeVariable)type2;
                if (tvar.getUpperBound() == null) break;
                type2 = tvar.getUpperBound();
                continue;
            }
            if (!(type2 instanceof WildcardType) || (wc = (WildcardType)type2).getExtendsBound() == null) break;
            type2 = wc.getExtendsBound();
        }
        return type2;
    }

    public static TypeMirror typeFromClass(Types types, Elements elements, Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return types.getNoType(TypeKind.VOID);
        }
        if (clazz.isPrimitive()) {
            String primitiveName = clazz.getName().toUpperCase();
            TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
            return types.getPrimitiveType(primitiveKind);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = TypesUtils.typeFromClass(types, elements, clazz.getComponentType());
            return types.getArrayType(componentType);
        }
        TypeElement element = elements.getTypeElement(clazz.getCanonicalName());
        if (element == null) {
            ErrorReporter.errorAbort("Unrecognized class: " + clazz);
            return null;
        }
        return element.asType();
    }

    public static ArrayType createArrayType(Types types, TypeMirror componentType) {
        JavacTypes t = (JavacTypes)types;
        return t.getArrayType(componentType);
    }
}

