/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.net.URL;
import java.net.URLClassLoader;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

class URLClassLoaderHandler
implements ClassLoaderHandler {
    private URLClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "java.net.URLClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader2, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader2.getParent(), true, log);
        classLoaderOrder.add(classLoader2, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        URL[] urls = ((URLClassLoader)classLoader2).getURLs();
        if (urls != null) {
            for (URL url2 : urls) {
                if (url2 == null) continue;
                classpathOrder.addClasspathEntry((Object)url2, classLoader2, scanSpec, log);
            }
        }
    }
}

